/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.shared.data;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.GregorianCalendar;
import org.biomoby.shared.MobyException;
import org.biomoby.shared.MobyPrefixResolver;
import org.biomoby.shared.MobySecondaryData;
import org.biomoby.shared.data.MobyDataDateTime;
import org.biomoby.shared.data.MobyDataInstance;
import org.biomoby.shared.data.MobyDataObject;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MobyDataSecondaryInstance
extends MobySecondaryData
implements MobyDataInstance,
Comparable {
    protected String dataValue = null;
    protected int xmlMode = 124;
    public static final String ELEMENT_NAME = "Parameter";
    public static final String VALUE_NAME = "Value";

    public MobyDataSecondaryInstance(MobySecondaryData type, String value) {
        this(type);
        this.dataValue = value;
    }

    public MobyDataSecondaryInstance(MobySecondaryData type) {
        super(type.getName());
        this.setId(type.getId());
        try {
            this.setDataType(type.getDataType());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setAllowedValues(type.getAllowedValues());
        this.setDefaultValue(type.getDefaultValue());
        this.setMinValue(type.getMinValue());
        this.setMaxValue(type.getMaxValue());
        this.setDescription(type.getDescription());
    }

    public MobyDataSecondaryInstance(Element objectTag) throws MobyException {
        super(MobyDataObject.getName(objectTag));
        if (this.getName() == null) {
            throw new MobyException("Anonymous secondary parameters are not allowed (need articleName), input was :\n" + objectTag);
        }
        if (this.getName().length() == 0) {
            throw new MobyException("Secondary parameters with blank articleNames are not allowed, input was: " + objectTag);
        }
        try {
            this.setDataType("String");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (objectTag == null) {
            return;
        }
        String objectClass = objectTag.getLocalName();
        if (!ELEMENT_NAME.equals(objectClass)) {
            throw new MobyException("While creating a secondary parameter instance from XML: the passed in element (" + objectClass + ") was not a " + ELEMENT_NAME);
        }
        NodeList values = MobyPrefixResolver.getChildElements(objectTag, VALUE_NAME);
        if (values.getLength() == 0) {
            throw new MobyException("While creating a secondary parameter instance from XML: No Value element in the namespace http://www.biomoby.org/moby was found");
        }
        if (values.getLength() > 1) {
            throw new MobyException("While creating a secondary parameter instance from XML: More than one Value element (" + values.getLength() + ") in the namespace " + "http://www.biomoby.org/moby" + " was found");
        }
        this.setValue(MobyDataObject.getTextContents((Element)values.item(0)));
    }

    public boolean asBoolean() {
        return this.dataValue.equalsIgnoreCase("true") || this.dataValue.equals("1") || this.dataValue.equalsIgnoreCase("T");
    }

    public BigDecimal asFloat() {
        try {
            return new BigDecimal(this.dataValue);
        }
        catch (Exception e) {
            return null;
        }
    }

    public BigInteger asInteger() {
        try {
            return new BigInteger(this.dataValue);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String asString() {
        return this.dataValue;
    }

    public GregorianCalendar asDateTime() {
        try {
            return MobyDataDateTime.parseISO8601(this.dataValue);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object getObject() {
        return this.getValue();
    }

    public void setValue(String value) throws IllegalArgumentException {
        this.dataValue = value;
    }

    public String getValue() {
        return this.dataValue;
    }

    public void setXmlMode(int mode) throws IllegalArgumentException {
        if (mode != 124 && mode != 891) {
            throw new IllegalArgumentException("Value passed to setXmlMode was neither MobyDataInstance.CENTRAL_XML_MODE nor MobyDataInstance.SERVICE_XML_MODE");
        }
        this.xmlMode = mode;
    }

    public int getXmlMode() {
        return this.xmlMode;
    }

    public String toXML() {
        String tmpValue = this.dataValue;
        if (tmpValue != null) {
            tmpValue = tmpValue.replaceAll("&(?!(amp|#x\\d+);)", "&amp;");
            tmpValue = tmpValue.replaceAll("<", "&lt;");
        } else {
            tmpValue = "";
        }
        if (this.xmlMode == 891) {
            return "  <Parameter articleName='" + this.getName() + "'><" + VALUE_NAME + ">" + tmpValue + "</" + VALUE_NAME + "></" + ELEMENT_NAME + ">\n";
        }
        return super.toXML();
    }

    public int compareTo(Object o) {
        if (o == null || !(o instanceof MobyDataSecondaryInstance)) {
            return -1;
        }
        MobyDataSecondaryInstance mdsi = (MobyDataSecondaryInstance)o;
        if (this.getName() == null && mdsi.getName() != null) {
            return 1;
        }
        if (this.getName() != null && this.getName().compareTo(mdsi.getName()) != 0) {
            return this.getName().compareTo(mdsi.getName());
        }
        return 0;
    }
}

