/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.shared.data;

import org.biomoby.shared.MobyPrefixResolver;
import org.biomoby.shared.data.MobyDataObject;
import org.biomoby.shared.parser.ServiceException;
import org.w3c.dom.Element;

public class MobyServiceException
extends ServiceException {
    public static final int ERROR_CODE_UNKNOWN = -35353;
    public static final int SEVERITY_UNKNOWN = 235823;
    public static final String SEVERITY_ERROR_STR = "error";
    public static final String SEVERITY_WARNING_STR = "warning";
    public static final String SEVERITY_INFO_STR = "info";

    public MobyServiceException(Element e) throws IllegalArgumentException {
        this(MobyServiceException.severityStringToSeverityInt(MobyPrefixResolver.getAttr(e, "severity")), MobyServiceException.codeStringToCodeInt(MobyDataObject.getTextContents(MobyPrefixResolver.getChildElement(e, "exceptionCode"))), MobyPrefixResolver.getAttr(e, "refQueryID"), MobyPrefixResolver.getAttr(e, "refElement"), MobyDataObject.getTextContents(MobyPrefixResolver.getChildElement(e, "exceptionMessage")));
    }

    public static int severityStringToSeverityInt(String severityString) {
        if (severityString == null) {
            return 235823;
        }
        if (severityString.equals(SEVERITY_ERROR_STR)) {
            return 1;
        }
        if (severityString.equals(SEVERITY_WARNING_STR)) {
            return 2;
        }
        if (severityString.equals(SEVERITY_INFO_STR)) {
            return 3;
        }
        return 235823;
    }

    public static int codeStringToCodeInt(String codeString) {
        if (codeString == null || !codeString.matches("\\d\\d\\d")) {
            return -35353;
        }
        int code = Integer.parseInt(codeString);
        switch (code) {
            case 601: {
                break;
            }
            case 226: {
                break;
            }
            case 225: {
                break;
            }
            case 227: {
                break;
            }
            case 222: {
                break;
            }
            case 223: {
                break;
            }
            case 202: {
                break;
            }
            case 221: {
                break;
            }
            case 224: {
                break;
            }
            case 201: {
                break;
            }
            case 600: {
                break;
            }
            case 400: {
                break;
            }
            case 603: {
                break;
            }
            case 300: {
                break;
            }
            case 301: {
                break;
            }
            case 302: {
                break;
            }
            case 700: {
                break;
            }
            case 500: {
                break;
            }
            case 200: {
                break;
            }
            case 602: {
                break;
            }
            default: {
                return -35353;
            }
        }
        return code;
    }

    public MobyServiceException(int severity, int code, String message) {
        super(severity, code, message);
    }

    public MobyServiceException(int severity, int code, String jobId, String dataName) {
        super(severity, code, jobId, dataName);
    }

    public MobyServiceException(int severity, int code, String jobId, String dataName, String msg) {
        super(severity, code, jobId, dataName, msg);
    }
}

