/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.shared.extended;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.ibm.lsid.LSID;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.biomoby.client.rdf.vocabulary.DC_PROTEGE;
import org.biomoby.client.rdf.vocabulary.FetaVocabulary;
import org.biomoby.shared.MobyDataType;
import org.biomoby.shared.MobyException;
import org.biomoby.shared.MobyNamespace;
import org.biomoby.shared.MobyPrimaryDataSet;
import org.biomoby.shared.MobyPrimaryDataSimple;
import org.biomoby.shared.MobySecondaryData;
import org.biomoby.shared.MobyService;
import org.biomoby.shared.MobyServiceType;
import org.biomoby.shared.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceInstanceParser {
    private URL url = null;
    private boolean parsedOkay = false;
    private StringBuffer errors = new StringBuffer();
    private String newline = System.getProperty("line.separator");

    public ServiceInstanceParser() {
        this.url = null;
        this.parsedOkay = false;
        this.errors = new StringBuffer();
    }

    public ServiceInstanceParser(String url) throws MobyException {
        try {
            this.url = new URL(url);
        }
        catch (MalformedURLException e) {
            this.url = null;
            throw new MobyException("Invalid url specified by " + url + ".\n" + e.getLocalizedMessage());
        }
        this.parsedOkay = false;
        this.errors = new StringBuffer();
    }

    public ServiceInstanceParser(URL url) throws MobyException {
        if (url == null) {
            this.url = null;
            throw new MobyException("Invalid url specified by " + url.toExternalForm() + ".");
        }
        this.url = url;
        this.parsedOkay = false;
        this.errors = new StringBuffer();
    }

    public MobyService[] getMobyServicesFromRDF() throws MobyException {
        if (this.url == null) {
            this.parsedOkay = false;
            throw new MobyException("Invalid url specified for the location of the RDF document that describes the Namespace ontology: " + this.url);
        }
        ArrayList<MobyService> list = new ArrayList<MobyService>();
        Model model = ModelFactory.createDefaultModel();
        RDFReader reader = model.getReader();
        try {
            reader.read(model, new StringReader(this.getRdfAsString()), null);
        }
        catch (JenaException e) {
            throw new MobyException(e.getLocalizedMessage());
        }
        this.parsedOkay = this.processModel(list, model);
        return list.toArray(new MobyService[list.size()]);
    }

    public MobyService[] getMobyServicesFromRDF(Model model) throws MobyException {
        ArrayList<MobyService> list = new ArrayList<MobyService>();
        if (model != null) {
            this.parsedOkay = this.processModel(list, model);
            return list.toArray(new MobyService[list.size()]);
        }
        return this.getMobyServicesFromRDF();
    }

    private boolean processModel(ArrayList<MobyService> list, Model model) {
        this.parsedOkay = false;
        this.errors = new StringBuffer();
        boolean success = true;
        ResIterator rIterator = model.listSubjectsWithProperty(FetaVocabulary.hasServiceNameText);
        while (rIterator.hasNext()) {
            Resource hoResource;
            boolean currentlyBad = false;
            Resource resource = rIterator.nextResource();
            if (resource.getURI() == null || resource.getURI().equals(RDFS.comment.getURI()) || resource.getURI().equals(RDFS.label.getURI())) continue;
            String name = "";
            if (resource.hasProperty(FetaVocabulary.hasServiceNameText)) {
                name = ((Object)resource.getProperty(FetaVocabulary.hasServiceNameText).getObject()).toString();
            }
            MobyService service = new MobyService(name);
            String signatureURL = "";
            if (resource.hasProperty(FetaVocabulary.hasServiceDescriptionLocation)) {
                signatureURL = ((Object)resource.getProperty(FetaVocabulary.hasServiceDescriptionLocation).getObject()).toString();
            }
            service.setSignatureURL(signatureURL);
            if (resource.hasProperty(FetaVocabulary.hasOperation) && (hoResource = resource.getProperty(FetaVocabulary.hasOperation).getResource()).hasProperty(FetaVocabulary.performsTask)) {
                Resource ptResource = hoResource.getProperty(FetaVocabulary.performsTask).getResource();
                StmtIterator stmtIterator = ptResource.listProperties(RDF.type);
                while (stmtIterator.hasNext()) {
                    RDFNode typeNode = stmtIterator.nextStatement().getObject();
                    if (((Object)typeNode).toString().equals(FetaVocabulary.operationTask.toString())) continue;
                    String serviceType = ((Object)typeNode).toString();
                    try {
                        LSID serviceTypeLsid = new LSID(serviceType);
                        MobyServiceType mst = new MobyServiceType(serviceTypeLsid.getObject());
                        mst.setLSID(serviceTypeLsid.toString());
                        service.setServiceType(mst);
                    }
                    catch (Exception e) {
                        String[] parsedServiceType = serviceType.split("#");
                        if (parsedServiceType.length == 2) {
                            service.setType(parsedServiceType[1]);
                            continue;
                        }
                        if (serviceType.lastIndexOf("/Services/") > 0) {
                            service.setType(serviceType.substring(serviceType.lastIndexOf("/Services/") + "/Services/".length()));
                            continue;
                        }
                        service.setType(parsedServiceType[0]);
                    }
                }
            }
            if (resource.hasProperty(DC_PROTEGE.format)) {
                String category = ((Object)resource.getProperty(DC_PROTEGE.format).getObject()).toString();
                service.setCategory(category);
            }
            if (resource.hasProperty(DC_PROTEGE.identifier)) {
                service.setLSID(((Object)resource.getProperty(DC_PROTEGE.identifier).getObject()).toString());
            }
            if (resource.hasProperty(FetaVocabulary.providedBy)) {
                Resource org = (Resource)resource.getProperty(FetaVocabulary.providedBy).getObject();
                if (org.hasProperty(DC_PROTEGE.publisher)) {
                    String authorityURI = ((Object)org.getProperty(DC_PROTEGE.publisher).getObject()).toString();
                    service.setAuthority(authorityURI);
                }
                if (org.hasProperty(DC_PROTEGE.creator)) {
                    String email = ((Object)org.getProperty(DC_PROTEGE.creator).getObject()).toString();
                    service.setEmailContact(email);
                }
                if (org.hasProperty(FetaVocabulary.authoritative)) {
                    String authoritative = ((Object)org.getProperty(FetaVocabulary.authoritative).getObject()).toString().trim();
                    if (authoritative.equalsIgnoreCase("true")) {
                        service.setAuthoritative(true);
                    } else {
                        service.setAuthoritative(false);
                    }
                }
            }
            if (resource.hasProperty(FetaVocabulary.locationURI)) {
                String serviceUrl = ((Object)resource.getProperty(FetaVocabulary.locationURI).getObject()).toString();
                service.setURL(serviceUrl);
            }
            if (resource.hasProperty(FetaVocabulary.hasServiceDescriptionText)) {
                String description = ((Object)resource.getProperty(FetaVocabulary.hasServiceDescriptionText).getObject()).toString();
                service.setDescription(description);
            }
            if (resource.hasProperty(FetaVocabulary.isAlive)) {
                String bool = ((Object)resource.getProperty(FetaVocabulary.isAlive).getObject()).toString();
                service.setStatus(2, "true".equals(bool));
            }
            StmtIterator arguements = resource.listProperties(FetaVocabulary.hasOperation);
            while (arguements.hasNext()) {
                Statement s = arguements.nextStatement();
                Resource r = (Resource)s.getObject();
                StmtIterator inputs = r.listProperties(FetaVocabulary.inputParameter);
                HashMap<String, MobyPrimaryDataSet> inputCollectionMap = new HashMap<String, MobyPrimaryDataSet>();
                HashMap<String, MobyPrimaryDataSet> outputCollectionMap = new HashMap<String, MobyPrimaryDataSet>();
                while (inputs.hasNext()) {
                    String articlename;
                    String ns3;
                    StmtIterator typeIterator;
                    RDFNode namespace;
                    StmtIterator namespaceIterator;
                    ArrayList<String> namespaces;
                    String articlename2;
                    String datatype;
                    RDFNode rdfDatatype;
                    Resource parameter = (Resource)inputs.nextStatement().getObject();
                    if (!parameter.getProperty(FetaVocabulary.hasParameterType).getResource().hasProperty(RDF.type)) {
                        success = false;
                        currentlyBad = true;
                        this.errors.append(service.getName() + "," + service.getAuthority() + "{Input for service " + service.getName() + " did not have a parameter type of type RDF:type}");
                        this.errors.append(this.newline);
                        continue;
                    }
                    if (((Object)parameter.getProperty(FetaVocabulary.hasParameterType).getResource().getProperty(RDF.type).getObject()).toString().endsWith("simpleParameter")) {
                        if (!parameter.hasProperty(FetaVocabulary.object_type)) {
                            success = false;
                            currentlyBad = true;
                            this.errors.append(service.getName() + "," + service.getAuthority() + "{Input for service " + service.getName() + " was missing an object type}");
                            this.errors.append(this.newline);
                            continue;
                        }
                        if (!parameter.hasProperty(FetaVocabulary.hasParameterNameText)) {
                            currentlyBad = true;
                            success = false;
                            this.errors.append(service.getName() + "," + service.getAuthority() + "{Input for service " + service.getName() + " was missing an article name}");
                            this.errors.append(this.newline);
                            continue;
                        }
                        rdfDatatype = parameter.getProperty(FetaVocabulary.object_type).getObject();
                        datatype = "";
                        if (rdfDatatype instanceof Resource) {
                            if (((Resource)rdfDatatype).hasProperty(RDF.type)) {
                                datatype = ((Object)((Resource)rdfDatatype).getProperty(RDF.type).getObject()).toString();
                            } else {
                                success = false;
                                currentlyBad = true;
                                this.errors.append(service.getName() + "," + service.getAuthority() + "{Input for service " + service.getName() + " was missing an object type}");
                                this.errors.append(this.newline);
                                continue;
                            }
                        }
                        if (datatype.indexOf("#") > 0) {
                            datatype = datatype.substring(datatype.indexOf("#") + 1);
                        } else if (datatype.lastIndexOf("/Objects/") > 0) {
                            datatype = datatype.substring(datatype.lastIndexOf("/Objects/") + "/Objects/".length());
                        }
                        articlename2 = ((Object)parameter.getProperty(FetaVocabulary.hasParameterNameText).getObject()).toString();
                        if (articlename2.equals("")) {
                            success = false;
                            currentlyBad = true;
                            this.errors.append(service.getName() + "," + service.getAuthority() + "{Input for service " + service.getName() + " was missing a non empty article name}");
                            this.errors.append(this.newline);
                            continue;
                        }
                        namespaces = new ArrayList<String>();
                        if (parameter.hasProperty(FetaVocabulary.inNamespaces)) {
                            namespaceIterator = parameter.listProperties(FetaVocabulary.inNamespaces);
                            while (namespaceIterator.hasNext()) {
                                namespace = namespaceIterator.nextStatement().getObject();
                                if (!(namespace instanceof Resource)) continue;
                                typeIterator = ((Resource)namespace).listProperties(RDF.type);
                                while (typeIterator.hasNext()) {
                                    ns3 = ((Object)typeIterator.nextStatement().getObject()).toString();
                                    if (ns3.equals(FetaVocabulary.parameterNamespace.toString())) continue;
                                    if (ns3.indexOf("#") > 0) {
                                        ns3 = ns3.substring(ns3.indexOf("#") + 1);
                                    } else if (ns3.lastIndexOf("/Namespaces/") > 0) {
                                        ns3 = ns3.substring(ns3.lastIndexOf("/Namespaces/") + "/Namespaces/".length());
                                    }
                                    namespaces.add(ns3);
                                }
                            }
                        }
                        MobyPrimaryDataSimple primaryInput = new MobyPrimaryDataSimple();
                        primaryInput.setDataType(new MobyDataType(datatype));
                        primaryInput.setName(articlename2);
                        if (!namespaces.isEmpty()) {
                            for (String ns2 : namespaces) {
                                primaryInput.addNamespace(new MobyNamespace(ns2));
                            }
                        }
                        service.addInput(primaryInput);
                        continue;
                    }
                    if (((Object)parameter.getProperty(FetaVocabulary.hasParameterType).getResource().getProperty(RDF.type).getObject()).toString().endsWith("collectionParameter")) {
                        if (!parameter.hasProperty(FetaVocabulary.object_type)) {
                            currentlyBad = true;
                            success = false;
                            this.errors.append(service.getName() + "," + service.getAuthority() + "{Collection input for service " + service.getName() + " was missing an object type.}");
                            this.errors.append(this.newline);
                            continue;
                        }
                        if (!parameter.hasProperty(FetaVocabulary.hasParameterNameText)) {
                            success = false;
                            currentlyBad = true;
                            this.errors.append(service.getName() + "," + service.getAuthority() + "{Collection for service " + service.getName() + " was missing an article name.}");
                            this.errors.append(this.newline);
                            continue;
                        }
                        rdfDatatype = parameter.getProperty(FetaVocabulary.object_type).getObject();
                        datatype = "";
                        if (rdfDatatype instanceof Resource) {
                            if (((Resource)rdfDatatype).hasProperty(RDF.type)) {
                                datatype = ((Object)((Resource)rdfDatatype).getProperty(RDF.type).getObject()).toString();
                            } else {
                                success = false;
                                currentlyBad = true;
                                this.errors.append(service.getName() + "," + service.getAuthority() + "{Input collection for service " + service.getName() + " was missing an object type}");
                                this.errors.append(this.newline);
                                continue;
                            }
                        }
                        if (datatype.indexOf("#") > 0) {
                            datatype = datatype.substring(datatype.indexOf("#") + 1);
                        } else if (datatype.lastIndexOf("/Objects/") > 0) {
                            datatype = datatype.substring(datatype.lastIndexOf("/Objects/") + "/Objects/".length());
                        }
                        articlename2 = ((Object)parameter.getProperty(FetaVocabulary.hasParameterNameText).getObject()).toString();
                        if (articlename2.equals("")) {
                            success = false;
                            currentlyBad = true;
                            this.errors.append(service.getName() + "," + service.getAuthority() + "{Collection input for service " + service.getName() + " was missing a non empty article name.}");
                            this.errors.append(this.newline);
                            continue;
                        }
                        namespaces = new ArrayList();
                        if (parameter.hasProperty(FetaVocabulary.inNamespaces)) {
                            namespaceIterator = parameter.listProperties(FetaVocabulary.inNamespaces);
                            while (namespaceIterator.hasNext()) {
                                namespace = namespaceIterator.nextStatement().getObject();
                                if (!(namespace instanceof Resource)) continue;
                                typeIterator = ((Resource)namespace).listProperties(RDF.type);
                                while (typeIterator.hasNext()) {
                                    ns3 = ((Object)typeIterator.nextStatement().getObject()).toString();
                                    if (ns3.equals(FetaVocabulary.parameterNamespace.toString())) continue;
                                    if (ns3.indexOf("#") > 0) {
                                        ns3 = ns3.substring(ns3.indexOf("#") + 1);
                                    } else if (ns3.lastIndexOf("/Namespaces/") > 0) {
                                        ns3 = ns3.substring(ns3.lastIndexOf("/Namespaces/") + "/Namespaces/".length());
                                    }
                                    namespaces.add(ns3);
                                }
                            }
                        }
                        MobyPrimaryDataSet collection = null;
                        collection = inputCollectionMap.containsKey(articlename2) ? (MobyPrimaryDataSet)inputCollectionMap.get(articlename2) : new MobyPrimaryDataSet(articlename2);
                        MobyPrimaryDataSimple input = new MobyPrimaryDataSimple("");
                        input.setDataType(new MobyDataType(datatype));
                        if (!namespaces.isEmpty()) {
                            for (String ns3 : namespaces) {
                                input.addNamespace(new MobyNamespace(ns3));
                            }
                        }
                        collection.addElement(input);
                        inputCollectionMap.put(articlename2, collection);
                        continue;
                    }
                    if (!((Object)parameter.getProperty(FetaVocabulary.hasParameterType).getResource().getProperty(RDF.type).getObject()).toString().endsWith("secondaryParameter")) continue;
                    if (!parameter.hasProperty(FetaVocabulary.datatype)) {
                        currentlyBad = true;
                        success = false;
                        this.errors.append(service.getName() + "," + service.getAuthority() + "{Invalid secondary input found. Missing moby datatype" + " (one of String, Float, Integer, DateTime).}");
                        this.errors.append(this.newline);
                        continue;
                    }
                    if (!parameter.hasProperty(FetaVocabulary.hasParameterNameText)) {
                        success = false;
                        currentlyBad = true;
                        this.errors.append(service.getName() + "," + service.getAuthority() + "{Invalid secondary input found. Missing an article name.}");
                        this.errors.append(this.newline);
                        continue;
                    }
                    String datatype2 = parameter.getProperty(FetaVocabulary.datatype).getLiteral().getValue().toString();
                    if (datatype2.indexOf("#") > 0) {
                        datatype2 = datatype2.substring(datatype2.indexOf("#") + 1);
                    }
                    if (datatype2.indexOf(":") > 0) {
                        datatype2 = datatype2.substring(datatype2.lastIndexOf(":") + 1);
                    }
                    if ((articlename = parameter.getProperty(FetaVocabulary.hasParameterNameText).getLiteral().getValue().toString()).equals("")) {
                        success = false;
                        currentlyBad = true;
                        this.errors.append(service.getName() + "," + service.getAuthority() + "{Invalid secondary input found. Missing a non empty article name.}");
                        this.errors.append(this.newline);
                        continue;
                    }
                    MobySecondaryData secondary = new MobySecondaryData(articlename);
                    try {
                        secondary.setDataType(datatype2);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (parameter.hasProperty(FetaVocabulary.hasDefaultValue)) {
                        secondary.setDefaultValue(parameter.getProperty(FetaVocabulary.hasDefaultValue).getLiteral().getValue().toString());
                    }
                    if (parameter.hasProperty(FetaVocabulary.hasParameterDescriptionText)) {
                        secondary.setDescription(parameter.getProperty(FetaVocabulary.hasParameterDescriptionText).getLiteral().getValue().toString());
                    }
                    if (parameter.hasProperty(FetaVocabulary.max)) {
                        try {
                            secondary.setMaxValue(parameter.getProperty(FetaVocabulary.max).getLiteral().getValue().toString());
                        }
                        catch (NumberFormatException e) {
                            success = false;
                            currentlyBad = true;
                            this.errors.append(service.getName() + "," + service.getAuthority() + "{Invalid maximum value for secondary input.}");
                            this.errors.append(this.newline);
                            continue;
                        }
                    }
                    if (parameter.hasProperty(FetaVocabulary.min)) {
                        try {
                            secondary.setMinValue(parameter.getProperty(FetaVocabulary.min).getLiteral().getValue().toString());
                        }
                        catch (NumberFormatException e) {
                            success = false;
                            currentlyBad = true;
                            this.errors.append(service.getName() + "," + service.getAuthority() + "{Invalid minimum value for secondary input.}");
                            this.errors.append(this.newline);
                            continue;
                        }
                    }
                    if (parameter.hasProperty(FetaVocabulary.enumeration)) {
                        StmtIterator enumerations = parameter.listProperties(FetaVocabulary.enumeration);
                        while (enumerations.hasNext()) {
                            secondary.addAllowedValue(enumerations.nextStatement().getLiteral().getValue().toString());
                        }
                    }
                    service.addInput(secondary);
                }
                StmtIterator outputs = r.listProperties(FetaVocabulary.outputParameter);
                while (outputs.hasNext()) {
                    String ns4;
                    StmtIterator typeIterator;
                    RDFNode namespace;
                    StmtIterator namespaceIterator;
                    ArrayList<String> namespaces;
                    String articlename;
                    String datatype;
                    RDFNode rdfDatatype;
                    Resource parameter = (Resource)outputs.nextStatement().getObject();
                    if (!parameter.getProperty(FetaVocabulary.hasParameterType).getResource().hasProperty(RDF.type)) {
                        success = false;
                        currentlyBad = true;
                        this.errors.append(service.getName() + "," + service.getAuthority() + "{Output for service " + service.getName() + " did not have a parameter type of type RDF:type}");
                        this.errors.append(this.newline);
                        continue;
                    }
                    if (((Object)parameter.getProperty(FetaVocabulary.hasParameterType).getResource().getProperty(RDF.type).getObject()).toString().endsWith("simpleParameter")) {
                        if (!parameter.hasProperty(FetaVocabulary.object_type)) {
                            currentlyBad = true;
                            success = false;
                            this.errors.append(service.getName() + "," + service.getAuthority() + "{Output for service " + service.getName() + " was missing an object type.}");
                            this.errors.append(this.newline);
                            continue;
                        }
                        if (!parameter.hasProperty(FetaVocabulary.hasParameterNameText)) {
                            success = false;
                            currentlyBad = true;
                            this.errors.append(service.getName() + "," + service.getAuthority() + "{Output for service " + service.getName() + " was missing an article name}");
                            this.errors.append(this.newline);
                            continue;
                        }
                        rdfDatatype = parameter.getProperty(FetaVocabulary.object_type).getObject();
                        datatype = "";
                        if (rdfDatatype instanceof Resource) {
                            if (((Resource)rdfDatatype).hasProperty(RDF.type)) {
                                datatype = ((Object)((Resource)rdfDatatype).getProperty(RDF.type).getObject()).toString();
                            } else {
                                success = false;
                                currentlyBad = true;
                                this.errors.append(service.getName() + "," + service.getAuthority() + "{Output for service " + service.getName() + " was missing an object type}");
                                this.errors.append(this.newline);
                                continue;
                            }
                        }
                        if (datatype.indexOf("#") > 0) {
                            datatype = datatype.substring(datatype.indexOf("#") + 1);
                        } else if (datatype.lastIndexOf("/Objects/") > 0) {
                            datatype = datatype.substring(datatype.lastIndexOf("/Objects/") + "/Objects/".length());
                        }
                        articlename = ((Object)parameter.getProperty(FetaVocabulary.hasParameterNameText).getObject()).toString();
                        if (articlename.equals("")) {
                            // empty if block
                        }
                        namespaces = new ArrayList<String>();
                        if (parameter.hasProperty(FetaVocabulary.inNamespaces)) {
                            namespaceIterator = parameter.listProperties(FetaVocabulary.inNamespaces);
                            while (namespaceIterator.hasNext()) {
                                namespace = namespaceIterator.nextStatement().getObject();
                                if (!(namespace instanceof Resource)) continue;
                                typeIterator = ((Resource)namespace).listProperties(RDF.type);
                                while (typeIterator.hasNext()) {
                                    ns4 = ((Object)typeIterator.nextStatement().getObject()).toString();
                                    if (ns4.equals(FetaVocabulary.parameterNamespace.toString())) continue;
                                    if (ns4.indexOf("#") > 0) {
                                        ns4 = ns4.substring(ns4.indexOf("#") + 1);
                                    } else if (ns4.lastIndexOf("/Namespaces/") > 0) {
                                        ns4 = ns4.substring(ns4.lastIndexOf("/Namespaces/") + "/Namespaces/".length());
                                    }
                                    namespaces.add(ns4);
                                }
                            }
                        }
                        MobyPrimaryDataSimple primaryOutput = new MobyPrimaryDataSimple();
                        primaryOutput.setDataType(new MobyDataType(datatype));
                        primaryOutput.setName(articlename);
                        if (!namespaces.isEmpty()) {
                            for (String ns3 : namespaces) {
                                primaryOutput.addNamespace(new MobyNamespace(ns3));
                            }
                        }
                        service.addOutput(primaryOutput);
                        continue;
                    }
                    if (!((Object)parameter.getProperty(FetaVocabulary.hasParameterType).getResource().getProperty(RDF.type).getObject()).toString().endsWith("collectionParameter")) continue;
                    if (!parameter.hasProperty(FetaVocabulary.object_type)) {
                        success = false;
                        currentlyBad = true;
                        this.errors.append(service.getName() + "," + service.getAuthority() + "{Collection Output for service " + service.getName() + " was missing an object type.}");
                        this.errors.append(this.newline);
                        continue;
                    }
                    if (!parameter.hasProperty(FetaVocabulary.hasParameterNameText)) {
                        success = false;
                        currentlyBad = true;
                        this.errors.append(service.getName() + "," + service.getAuthority() + "{Collection for service " + service.getName() + " was missing an article name.}");
                        this.errors.append(this.newline);
                        continue;
                    }
                    rdfDatatype = parameter.getProperty(FetaVocabulary.object_type).getObject();
                    datatype = "";
                    if (rdfDatatype instanceof Resource) {
                        if (((Resource)rdfDatatype).hasProperty(RDF.type)) {
                            datatype = ((Object)((Resource)rdfDatatype).getProperty(RDF.type).getObject()).toString();
                        } else {
                            success = false;
                            currentlyBad = true;
                            this.errors.append(service.getName() + "," + service.getAuthority() + "{Output collection for service " + service.getName() + " was missing an object type}");
                            this.errors.append(this.newline);
                            continue;
                        }
                    }
                    if (datatype.indexOf("#") > 0) {
                        datatype = datatype.substring(datatype.indexOf("#") + 1);
                    } else if (datatype.lastIndexOf("/Objects/") > 0) {
                        datatype = datatype.substring(datatype.lastIndexOf("/Objects/") + "/Objects/".length());
                    }
                    articlename = ((Object)parameter.getProperty(FetaVocabulary.hasParameterNameText).getObject()).toString();
                    if (articlename.equals("")) {
                        success = false;
                        currentlyBad = true;
                        this.errors.append(service.getName() + "," + service.getAuthority() + "{Collection output for service " + service.getName() + " was missing a non empty article name.}");
                        this.errors.append(this.newline);
                        continue;
                    }
                    namespaces = new ArrayList();
                    if (parameter.hasProperty(FetaVocabulary.inNamespaces)) {
                        namespaceIterator = parameter.listProperties(FetaVocabulary.inNamespaces);
                        while (namespaceIterator.hasNext()) {
                            namespace = namespaceIterator.nextStatement().getObject();
                            if (!(namespace instanceof Resource)) continue;
                            typeIterator = ((Resource)namespace).listProperties(RDF.type);
                            while (typeIterator.hasNext()) {
                                ns4 = ((Object)typeIterator.nextStatement().getObject()).toString();
                                if (ns4.equals(FetaVocabulary.parameterNamespace.toString())) continue;
                                if (ns4.indexOf("#") > 0) {
                                    ns4 = ns4.substring(ns4.indexOf("#") + 1);
                                } else if (ns4.lastIndexOf("/Namespaces/") > 0) {
                                    ns4 = ns4.substring(ns4.lastIndexOf("/Namespaces/") + "/Namespaces/".length());
                                }
                                namespaces.add(ns4);
                            }
                        }
                    }
                    MobyPrimaryDataSet collection = null;
                    collection = outputCollectionMap.containsKey(articlename) ? (MobyPrimaryDataSet)outputCollectionMap.get(articlename) : new MobyPrimaryDataSet(articlename);
                    MobyPrimaryDataSimple output = new MobyPrimaryDataSimple("");
                    output.setDataType(new MobyDataType(datatype));
                    if (!namespaces.isEmpty()) {
                        for (String ns4 : namespaces) {
                            output.addNamespace(new MobyNamespace(ns4));
                        }
                    }
                    collection.addElement(output);
                    outputCollectionMap.put(articlename, collection);
                }
                for (String key : inputCollectionMap.keySet()) {
                    service.addInput((MobyPrimaryDataSet)inputCollectionMap.get(key));
                }
                for (String key : outputCollectionMap.keySet()) {
                    service.addOutput((MobyPrimaryDataSet)outputCollectionMap.get(key));
                }
            }
            if (currentlyBad) continue;
            list.add(service);
        }
        return success;
    }

    public MobyService[] getMobyServicesFromRDF(String rdf) throws MobyException {
        ArrayList<MobyService> list = new ArrayList<MobyService>();
        Model model = ModelFactory.createDefaultModel();
        RDFReader reader = model.getReader();
        try {
            reader.read(model, new StringReader(rdf), null);
        }
        catch (JenaException e) {
            this.parsedOkay = false;
            throw new MobyException(e.getLocalizedMessage());
        }
        this.parsedOkay = this.processModel(list, model);
        return list.toArray(new MobyService[list.size()]);
    }

    public void setUrl(URL url) throws MobyException {
        if (url == null) {
            this.url = null;
            throw new MobyException("Invalid url specified by " + url.toExternalForm() + ".");
        }
        this.url = url;
    }

    public void setUrl(String url) throws MobyException {
        try {
            this.url = new URL(url);
        }
        catch (MalformedURLException e) {
            this.url = null;
            throw new MobyException("Invalid url specified by " + url + ".\n" + e.getLocalizedMessage());
        }
    }

    public URL getUrl() {
        return this.url;
    }

    private String getRdfAsString() {
        String s = null;
        StringBuffer sb = new StringBuffer();
        try {
            BufferedReader in = null;
            in = new BufferedReader(new InputStreamReader(this.url.openStream()));
            while ((s = in.readLine()) != null) {
                sb.append(s + System.getProperty("line.separator"));
            }
        }
        catch (IOException e) {
            this.parsedOkay = false;
            e.printStackTrace();
            return null;
        }
        return sb.toString();
    }

    public boolean isRDFValid() {
        return this.parsedOkay;
    }

    public String getErrors() {
        return this.errors.toString();
    }

    public static void main(String[] args) throws MobyException, MalformedURLException, IOException {
        ServiceInstanceParser p = new ServiceInstanceParser("http://biomoby.org/RESOURCES/MOBY-S/ServiceInstances");
        MobyService[] services = p.getMobyServicesFromRDF();
        System.out.println(services.length);
        if (!p.isRDFValid()) {
            System.out.println("One or more services in the RDF were invalid");
            System.out.println("The errors are the following:");
            System.out.println(Utils.format((Object)p.getErrors(), (int)2));
        }
        System.out.println("The valid services are:");
        for (int i = 0; i < services.length; ++i) {
            System.out.println(services[i].toString());
        }
    }
}

