/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.shared.extended;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.biomoby.client.rdf.vocabulary.DC_PROTEGE;
import org.biomoby.shared.MobyException;
import org.biomoby.shared.MobyServiceType;

public class ServiceTypeParser {
    private URL url = null;

    public ServiceTypeParser() {
        this.url = null;
    }

    public ServiceTypeParser(String url) throws MobyException {
        try {
            this.url = new URL(url);
        }
        catch (MalformedURLException e) {
            this.url = null;
            throw new MobyException("Invalid url specified by " + url + ".\n" + e.getLocalizedMessage());
        }
    }

    public ServiceTypeParser(URL url) throws MobyException {
        if (url == null) {
            this.url = null;
            throw new MobyException("Invalid url specified by " + url.toExternalForm() + ".");
        }
        this.url = url;
    }

    public void setUrl(URL url) throws MobyException {
        if (url == null) {
            this.url = null;
            throw new MobyException("Invalid url specified by " + url.toExternalForm() + ".");
        }
        this.url = url;
    }

    public void setUrl(String url) throws MobyException {
        try {
            this.url = new URL(url);
        }
        catch (MalformedURLException e) {
            this.url = null;
            throw new MobyException("Invalid url specified by " + url + ".\n" + e.getLocalizedMessage());
        }
    }

    public URL getUrl() {
        return this.url;
    }

    public MobyServiceType[] getMobyServiceTypesFromRDF() throws MobyException {
        if (this.url == null) {
            throw new MobyException("Invalid url specified for the location of the RDF document that describes the Service Type ontology: " + this.url);
        }
        ArrayList<MobyServiceType> list = new ArrayList<MobyServiceType>();
        Model model = ModelFactory.createDefaultModel();
        RDFReader reader = model.getReader();
        reader.read(model, new StringReader(this.getRdfAsString()), null);
        ResIterator iterator = model.listSubjects();
        while (iterator.hasNext()) {
            RDFNode lsidNode;
            Resource resource = iterator.nextResource();
            if (resource.getURI().equals(RDFS.comment.getURI()) || resource.getURI().equals(RDFS.label.getURI())) continue;
            String uri = resource.getURI();
            String name = "";
            if (uri.indexOf("#") > 0) {
                name = uri.substring(uri.indexOf("#") + 1);
            } else if (uri.lastIndexOf("/Services/") > 0) {
                name = uri.substring(uri.lastIndexOf("/Services/") + "/Services/".length());
            }
            MobyServiceType servicetype = new MobyServiceType(name);
            if (resource.hasProperty(DC_PROTEGE.identifier) && (lsidNode = resource.getProperty(DC_PROTEGE.identifier).getObject()) != null) {
                servicetype.setLSID(((Object)lsidNode).toString());
            }
            if (!resource.hasProperty(RDFS.subClassOf)) continue;
            String parent = ((Object)resource.getProperty(RDFS.subClassOf).getObject()).toString();
            if (parent.indexOf("#") > 0) {
                parent = parent.substring(parent.indexOf("#") + 1);
            } else if (parent.lastIndexOf("/Services/") > 0) {
                parent = parent.substring(parent.lastIndexOf("/Services/") + "/Services/".length());
            }
            servicetype.setParentNames(new String[]{parent});
            String description = resource.getProperty(RDFS.comment).getLiteral().getString();
            servicetype.setDescription(description);
            if (resource.hasProperty(DC_PROTEGE.creator)) {
                servicetype.setEmailContact(((Object)resource.getProperty(DC_PROTEGE.creator).getObject()).toString());
            }
            if (resource.hasProperty(DC_PROTEGE.publisher)) {
                servicetype.setAuthority(((Object)resource.getProperty(DC_PROTEGE.publisher).getObject()).toString());
            }
            list.add(servicetype);
        }
        return list.toArray(new MobyServiceType[list.size()]);
    }

    private String getRdfAsString() {
        String s = null;
        StringBuffer sb = new StringBuffer();
        try {
            BufferedReader in = null;
            in = new BufferedReader(new InputStreamReader(this.url.openStream()));
            while ((s = in.readLine()) != null) {
                sb.append(s);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return sb.toString();
    }

    public static void main(String[] args) throws MobyException {
        ServiceTypeParser p = new ServiceTypeParser("http://biomoby.org/RESOURCES/MOBY-S/Services");
        MobyServiceType[] types = p.getMobyServiceTypesFromRDF();
        for (int i = 0; i < types.length; ++i) {
            System.out.println(types[i]);
        }
    }
}

