/*
 * Decompiled with CFR 0.152.
 */
package org.omg.lsae.notifications;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.omg.lsae.notifications.AnalysisEvent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StateEvent
extends AnalysisEvent {
    private String newState = "";
    private String previousState = "";
    private final String created = "created";
    private final String running = "running";
    private final String completed = "completed";
    private final String terminated_by_request = "terminated_by_request";
    private final String terminated_by_error = "terminated_by_error";
    public static final int CREATED = 100;
    public static final int RUNNING = 101;
    public static final int COMPLETED = 102;
    public static final int TERMINATED_BY_REQUEST = 103;
    public static final int TERMINATED_BY_ERROR = 104;

    public boolean isCompleted() {
        return this.newState.equals("completed") || this.newState.equals("terminated_by_error") || this.newState.equals("terminated_by_request");
    }

    public String toString() {
        return "State Changed Event (" + this.getNewState() + ") - " + this.getMessage();
    }

    public String getNewState() {
        return this.newState;
    }

    public void setNewState(int newState) {
        this.newState = this.getState(newState);
    }

    private String getState(int state) {
        String val = "";
        switch (state) {
            case 100: {
                val = "created";
                break;
            }
            case 102: {
                val = "completed";
                break;
            }
            case 101: {
                val = "running";
                break;
            }
            case 104: {
                val = "terminated_by_error";
                break;
            }
            case 103: {
                val = "terminated_by_request";
                break;
            }
            default: {
                val = "created";
            }
        }
        return val;
    }

    public int getState(String state) {
        if (state.equals("created")) {
            return 100;
        }
        if (state.equals("completed")) {
            return 102;
        }
        if (state.equals("running")) {
            return 101;
        }
        if (state.equals("terminated_by_error")) {
            return 104;
        }
        if (state.equals("terminated_by_request")) {
            return 103;
        }
        return 100;
    }

    public String getPreviousState() {
        return this.previousState;
    }

    public void setPreviousState(int previousState) {
        this.previousState = this.getState(previousState);
    }

    public String toXMLString() {
        Document doc = this.createDomDocument();
        Element root = doc.createElement("analysis_event");
        root.setAttribute("timestamp", this.getTimestamp());
        root.setAttribute("id", this.getQueryId());
        Element msg = doc.createElement("message");
        msg.setTextContent(this.getMessage());
        root.appendChild(msg);
        msg = doc.createElement("state_changed");
        msg.setAttribute("previous_state", this.getPreviousState());
        msg.setAttribute("new_state", this.getNewState());
        root.appendChild(msg);
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        TransformerFactory tFactory = TransformerFactory.newInstance();
        StreamSource stylesource = new StreamSource(new ByteArrayInputStream(new String("<!DOCTYPE stylesheet [\r\n  <!ENTITY cr \"<xsl:text>\r\n</xsl:text>\">\r\n]>\r\n \r\n<xsl:stylesheet\r\n    xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" \r\n    xmlns:xalan=\"http://xml.apache.org/xslt\" \r\n    version=\"1.0\">\r\n    \r\n    <xsl:output method=\"xml\" indent=\"yes\" xalan:indent-amount=\"4\"/> \r\n      \r\n    <!-- copy out the xml -->\r\n    <xsl:template match=\"* | @*\">\r\n        <xsl:copy><xsl:copy-of select=\"@*\"/><xsl:apply-templates/></xsl:copy>\r\n    </xsl:template>\r\n \r\n</xsl:stylesheet>").getBytes()));
        try {
            Transformer transformer = tFactory.newTransformer(stylesource);
            DOMSource source = new DOMSource(root);
            StreamResult result = new StreamResult(buf);
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException e1) {
            System.err.println("Couldnt print out DOM " + e1.getLocalizedMessage());
        }
        catch (TransformerException e) {
            System.err.println("Couldnt print out DOM " + e.getLocalizedMessage());
        }
        return buf.toString();
    }
}

