/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.graph;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import javax.swing.JPanel;

public abstract class Drawable
extends JPanel {
    protected abstract void controlPaint(Graphics var1);

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.controlPaint(graphics);
    }

    public void setCursor(int n) {
        this.setCursor(Cursor.getPredefinedCursor(n));
    }

    public void drawPoint(Graphics2D graphics2D, Point point, Color color) {
        this.drawPoint(graphics2D, point.x, point.y, color);
    }

    public void drawPoint(Graphics2D graphics2D, int n, int n2, Color color) {
        graphics2D.setColor(color);
        graphics2D.drawLine(n, n2, n, n2);
    }

    public void drawPoint(Graphics2D graphics2D, Point point) {
        this.drawPoint(graphics2D, point, this.getBackground());
    }

    public void drawPoint(Graphics2D graphics2D, int n, int n2) {
        this.drawPoint(graphics2D, n, n2, this.getBackground());
    }

    public void drawLine(Graphics2D graphics2D, int n, int n2, int n3, int n4, Color color) {
        graphics2D.setColor(color);
        graphics2D.drawLine(n, n2, n3, n4);
    }

    public void drawLine(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        this.drawLine(graphics2D, n, n2, n3, n4, this.getBackground());
    }

    public void drawRect(Graphics2D graphics2D, int n, int n2, int n3, int n4, Color color) {
        graphics2D.setColor(color);
        graphics2D.drawRect(n, n2, n3, n4);
    }

    public void fillRect(Graphics2D graphics2D, int n, int n2, int n3, int n4, Color color) {
        graphics2D.setColor(color);
        graphics2D.fillRect(n, n2, n3, n4);
    }

    public void drawString(Graphics2D graphics2D, String string, int n, int n2, Color color, Font font) {
        graphics2D.setFont(font);
        graphics2D.setColor(color);
        graphics2D.drawString(string, n, n2);
    }

    public void drawString(Graphics2D graphics2D, String string, int n, int n2, Color color) {
        graphics2D.setColor(color);
        graphics2D.drawString(string, n, n2);
    }
}

