/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.util.awt;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;

public abstract class Viewer
extends JPanel
implements Serializable,
Printable {
    public static final long serialVersionUID = 100010301010001L;
    protected JFrame frame;
    protected Vector palette;
    protected int xOldEvent;
    protected int yOldEvent;
    public boolean mouseInside = false;

    public Viewer(JFrame jFrame) {
        this.frame = jFrame;
    }

    public Viewer() {
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        return 0;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (this.frame != null) {
            this.frame.setVisible(bl);
        }
    }

    public boolean hasFrame() {
        return this.frame != null;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public void setCursor(int n) {
        this.setCursor(Cursor.getPredefinedCursor(n));
    }

    public void setXOldEvent(int n) {
        this.xOldEvent = n;
    }

    public int getXOldEvent() {
        return this.xOldEvent;
    }

    public void setYOldEvent(int n) {
        this.yOldEvent = n;
    }

    public int getYOldEvent() {
        return this.yOldEvent;
    }

    public Vector buildPalette() {
        this.palette = new Vector(256);
        Color color = new Color(0, 0, 0);
        this.palette.addElement(color);
        for (int i = 1; i < 256; ++i) {
            i = 255 - i;
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            if (i < 33) {
                d = 255.0;
            } else if (i > 32 && i < 108) {
                d = Math.abs(255.0 * Math.cos((double)(i - 32) * Math.PI / 151.0));
            } else if (i > 107) {
                d = 0.0;
            }
            if (i < 5) {
                d2 = 0.0;
            } else if (i > 4 && i < 101) {
                d2 = Math.abs(255.0 * Math.cos((double)(i - 100) * Math.PI / 189.0));
            } else if (i > 100 && i < 229) {
                d2 = Math.abs(255.0 * Math.cos((double)(i - 100) * Math.PI / 294.0));
            } else if (i > 230) {
                d2 = 0.0;
            }
            if (i < 72) {
                d3 = 0.0;
            } else if (i > 71 && i < 200) {
                d3 = Math.abs(255.0 * Math.cos((double)(i - 199) * Math.PI / 256.0));
            } else if (i > 199) {
                d3 = Math.abs(255.0 * Math.cos((double)(i - 199) * Math.PI / 175.0));
            }
            color = new Color((float)d / 255.0f, (float)d2 / 255.0f, (float)d3 / 255.0f);
            this.palette.addElement(color);
            i = 255 - i;
        }
        return this.palette;
    }
}

