/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.data;

import java.io.File;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.tigr.midas.util.mevFileParser.MevParser;

public class MevFileDataModel
extends AbstractTableModel {
    private static final int STRING = 0;
    private static final int INT = 1;
    private static final int FLOAT = 2;
    private static final int DOUBLE = 3;
    private static final int BOOLEAN = 4;
    private Object[][] comments;
    private Object[] columnNames;
    private Object[][] data;

    public MevFileDataModel(File mevFile) {
        MevParser mfp = new MevParser();
        mfp.loadFile(mevFile);
        if (mfp.isMevFileLoaded()) {
            Object[] a = mfp.getCommentLineArray();
            this.comments = new Object[a.length][1];
            int i = 0;
            while (i < a.length) {
                this.comments[i][0] = a[i];
                ++i;
            }
            Vector headers = mfp.getColumnHeaders();
            this.columnNames = headers.toArray();
            this.data = mfp.getDataMatrix();
            this.data = this.smartize(this.data, this.columnNames);
        }
    }

    private Object[][] addNdx(Object[][] oldObj) {
        Object[] newColumnNames = new Object[this.columnNames.length + 1];
        newColumnNames[0] = "";
        System.arraycopy(this.columnNames, 0, newColumnNames, 1, this.columnNames.length);
        this.columnNames = newColumnNames;
        Object[][] newObj = new Object[oldObj.length][oldObj[0].length + 1];
        int i = 0;
        while (i < newObj.length) {
            newObj[i][0] = new Integer(i + 1);
            System.arraycopy(oldObj[i], 0, newObj[i], 1, oldObj[i].length);
            ++i;
        }
        return newObj;
    }

    private Object[][] smartize(Object[][] oldObj, Object[] colNames) {
        Object[][] newObj = new Object[oldObj.length][oldObj[0].length];
        int[] objType = new int[colNames.length];
        int i = 0;
        while (i < colNames.length) {
            objType[i] = colNames[i].equals("") ? 1 : (colNames[i].equals("UID") ? 0 : (colNames[i].equals("IA") ? 1 : (colNames[i].equals("IB") ? 1 : (colNames[i].equals("R") ? 1 : (colNames[i].equals("C") ? 1 : (colNames[i].equals("MR") ? 1 : (colNames[i].equals("MC") ? 1 : (colNames[i].equals("SR") ? 1 : (colNames[i].equals("SC") ? 1 : (colNames[i].equals("FlagA") ? 0 : (colNames[i].equals("FlagB") ? 0 : (colNames[i].equals("SA") ? 1 : (colNames[i].equals("SF") ? 2 : (colNames[i].equals("QSCORE") ? 2 : (colNames[i].equals("QCA") ? 2 : (colNames[i].equals("QCB") ? 2 : (colNames[i].equals("BGA") ? 1 : (colNames[i].equals("BGB") ? 1 : 0))))))))))))))))));
            ++i;
        }
        int i2 = 0;
        while (i2 < oldObj.length) {
            int j = 0;
            while (j < oldObj[0].length) {
                newObj[i2][j] = this.convType(oldObj[i2][j], objType[j]);
                ++j;
            }
            ++i2;
        }
        return newObj;
    }

    private Object convType(Object obj, int type) {
        switch (type) {
            case 0: {
                break;
            }
            case 1: {
                obj = new Integer(obj.toString());
                break;
            }
            case 2: {
                obj = new Float(obj.toString());
                break;
            }
            case 3: {
                obj = new Double(obj.toString());
                break;
            }
            case 4: {
                obj = new Boolean(obj.toString());
            }
        }
        return obj;
    }

    public Object[][] getComments() {
        return this.comments;
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public int getRowCount() {
        return this.data.length;
    }

    public String getColumnName(int col) {
        return this.columnNames[col].toString();
    }

    public Object getValueAt(int row, int col) {
        return this.data[row][col];
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public void setValueAt(Object value, int row, int col) {
        this.data[row][col] = value;
        this.fireTableCellUpdated(row, col);
    }
}

