/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.display;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.geom.Rectangle2D;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.tigr.midas.util.GBA;

public class AcknowlegementDialog
extends JDialog
implements Printable {
    private String text;
    private JEditorPane ed;

    public AcknowlegementDialog(Frame parent) {
        this(parent, "");
    }

    public AcknowlegementDialog(Frame parent, String labelText) {
        super(parent, "Contribution Acknowledgement :)", false);
        EventListener listener = new EventListener();
        this.text = labelText;
        GBA gba = new GBA();
        Font font = new Font("serif", 0, 12);
        this.ed = new JEditorPane("text/html", labelText);
        this.ed.setEditable(false);
        this.ed.setMargin(new Insets(10, 10, 10, 10));
        this.ed.setBackground(new Color(234, 233, 191));
        this.ed.setCaretPosition(0);
        JScrollPane scrollPane = new JScrollPane(this.ed, 20, 31);
        JPanel referencesPanel = new JPanel(new GridBagLayout());
        referencesPanel.setBackground(new Color(234, 233, 191));
        gba.add(referencesPanel, scrollPane, 0, 0, 1, 1, 1, 1, 1, 10);
        JButton printButton = new JButton("Print");
        printButton.setBorder(BorderFactory.createBevelBorder(0));
        printButton.setFocusPainted(false);
        printButton.setActionCommand("print-command");
        printButton.addActionListener(listener);
        JButton closeButton = new JButton("  Close  ");
        closeButton.setBorder(BorderFactory.createBevelBorder(0));
        closeButton.setFocusPainted(false);
        closeButton.setActionCommand("close-command");
        closeButton.addActionListener(listener);
        closeButton.setSize(120, 30);
        closeButton.setPreferredSize(new Dimension(120, 30));
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        gba.add(buttonPanel, closeButton, 0, 0, 1, 1, 1, 1, 0, 10);
        this.getContentPane().setLayout(new GridBagLayout());
        gba.add(this.getContentPane(), referencesPanel, 0, 0, 1, 2, 1, 1, 1, 10);
        gba.add(this.getContentPane(), buttonPanel, 0, 2, 1, 1, 0, 0, 0, 10);
        this.setSize(750, 500);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
    }

    public static String createAcknowlegementText() {
        String html = "";
        html = html + "<html><body><center>";
        html = html + "<br><i><font size=5><b>The Institute for Genomic Research Microarray Software Team expresses sincere thanks for the contributions of those listed below.</font></b></i><br>";
        html = html + "<table border=2 >";
        html = html + "<font size=3><tr><th><b>Contributor</th><th><b>Affiliation</th><th><b>Contribution</th></tr></font>";
        html = html + "<tr valign=top><td>Wei Liang, John Quackenbush</td><td>The Institute for Genomic Research</td><td>System design, core and module development and implementation, project coordination, documentation, optimization, and usability assurance</td></tr>";
        html = html + "<tr valign=top><td>Vasily Sharov &#185, Tracey Currier <BR>Gary Churchill &#178, Hao Wu &#178</td><td>&#185 The Institute for Genomic Research <BR> &#178 The Jackson Laboratory</td><td>MA-ANOVA module development and implementation</td></tr>";
        html = html + "<tr valign=top><td>Nirmal Bhagabati</td><td>The Institute for Genomic Research</td><td>Cross-slide t-test module implementation <BR>Cross-slide one-class SAM module implementation</td></tr>";
        html = html + "<tr valign=top><td>Alexander Saeed, Vasily Sharov, Jerry Li, Joe White, Nirmal Bhagabati, John Braisted, Tracey Currier, Mathangi Thiagarajan, Eleanor Howe </td><td>The Institute for Genomic Research</td><td>Additional development, software testing, documentation, support</td></tr>";
        html = html + "<tr valign=top><td>Jim Johnson, Ernest Retzel</td><td>Center for Computational Genomics and Bioinformatics, University of Minnesota</td><td>Java WebStart configuration</td></tr>";
        html = html + "</table>";
        html = html + "</center></body></html>";
        return html;
    }

    public static void main(String[] args) {
        AcknowlegementDialog acknowlegementDialog = new AcknowlegementDialog(new Frame(), AcknowlegementDialog.createAcknowlegementText());
    }

    public int print(Graphics g, PageFormat format, int page) throws PrinterException {
        if (page > 2) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.clip(new Rectangle2D.Double(0.0, 0.0, format.getImageableWidth(), format.getImageableHeight()));
        g2d.translate(format.getImageableX(), (double)(-page) * format.getImageableHeight());
        g2d.scale(1.0, 1.0);
        g2d.drawString("Test String", 0, 20);
        this.ed.paint(g);
        return 0;
    }

    private Book makeBook(PageFormat page, int numPages) {
        Book book = new Book();
        book.append(this, page, numPages);
        return book;
    }

    private class EventListener
    implements ActionListener,
    KeyListener {
        private EventListener() {
        }

        public void actionPerformed(ActionEvent event) {
            block4: {
                String command;
                block3: {
                    command = event.getActionCommand();
                    if (!command.equals("close-command")) break block3;
                    AcknowlegementDialog.this.dispose();
                    break block4;
                }
                if (!command.equals("print-command")) break block4;
                PrinterJob pj = PrinterJob.getPrinterJob();
                pj.setPrintable(AcknowlegementDialog.this, pj.defaultPage());
                int numPages = AcknowlegementDialog.this.ed.getHeight();
                numPages = (int)((double)numPages / pj.defaultPage().getImageableY());
                pj.setPageable(AcknowlegementDialog.this.makeBook(pj.defaultPage(), numPages));
                if (pj.printDialog()) {
                    try {
                        pj.print();
                    }
                    catch (PrinterException pe) {
                        System.out.println(pe);
                    }
                }
            }
        }

        public void keyPressed(KeyEvent event) {
            if (event.getKeyCode() == 10) {
                AcknowlegementDialog.this.dispose();
            }
        }

        public void keyReleased(KeyEvent event) {
        }

        public void keyTyped(KeyEvent event) {
        }
    }
}

