/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.display;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.tigr.midas.Constant;
import org.tigr.midas.display.AlertDialogPane;
import org.tigr.midas.display.FileChooserPane;
import org.tigr.midas.display.HelpWindow;
import org.tigr.midas.display.Midas;
import org.tigr.midas.engine.Parameter;
import org.tigr.midas.util.FileBrowser;
import org.tigr.midas.util.GBA;
import org.tigr.midas.util.swing.FileChooserEditor;

public class FileChooserPane
extends JDialog {
    public static final ImageIcon ICON_COMPUTER = new ImageIcon(Toolkit.getDefaultToolkit().getImage((class$org$tigr$midas$display$FileChooserPane == null ? (class$org$tigr$midas$display$FileChooserPane = FileChooserPane.class$("org.tigr.midas.display.FileChooserPane")) : class$org$tigr$midas$display$FileChooserPane).getClassLoader().getResource("org/tigr/midas/images/computer.gif")));
    public static final ImageIcon ICON_DISK = new ImageIcon(Toolkit.getDefaultToolkit().getImage((class$org$tigr$midas$display$FileChooserPane == null ? (class$org$tigr$midas$display$FileChooserPane = FileChooserPane.class$("org.tigr.midas.display.FileChooserPane")) : class$org$tigr$midas$display$FileChooserPane).getClassLoader().getResource("org/tigr/midas/images/disk.gif")));
    public static final ImageIcon ICON_FOLDER = new ImageIcon(Toolkit.getDefaultToolkit().getImage((class$org$tigr$midas$display$FileChooserPane == null ? (class$org$tigr$midas$display$FileChooserPane = FileChooserPane.class$("org.tigr.midas.display.FileChooserPane")) : class$org$tigr$midas$display$FileChooserPane).getClassLoader().getResource("org/tigr/midas/images/folder.gif")));
    public static final ImageIcon ICON_EXPANDEDFOLDER = new ImageIcon(Toolkit.getDefaultToolkit().getImage((class$org$tigr$midas$display$FileChooserPane == null ? (class$org$tigr$midas$display$FileChooserPane = FileChooserPane.class$("org.tigr.midas.display.FileChooserPane")) : class$org$tigr$midas$display$FileChooserPane).getClassLoader().getResource("org/tigr/midas/images/expandedfolder.gif")));
    private JLabel fileFilterLabel;
    private JComboBox fileFilterComboBox;
    private JComboBox annFileFilterComboBox;
    private FileTreePane fileTree;
    private FileTreePane annFileTree;
    private JButton infoButton;
    private JButton okButton;
    private JButton refreshButton;
    private JButton cancelButton;
    private JButton selectButton;
    private JButton deSelectButton;
    private EventListener el;
    protected int fType = 11100;
    protected int annType;
    protected int fSelectionAction;
    protected int selectedCount;
    protected String selectedSingleFile;
    protected Vector selectedPairsVec;
    protected Vector selectedFilesVec;
    protected String fPath;
    protected String annPath;
    private Vector flaggedPairsVec;
    public boolean abort;
    private GBA gba = new GBA();
    static /* synthetic */ Class class$org$tigr$midas$display$FileChooserPane;

    public FileChooserPane(int choice, String thePath) {
        this(choice, thePath, null);
    }

    public FileChooserPane(int choice, String thePath, Vector theFilesVec) {
        super((Frame)Midas.frame, true);
        this.fSelectionAction = choice;
        this.flaggedPairsVec = new Vector();
        this.selectedFilesVec = theFilesVec;
        JLabel fileFilterLabel = new JLabel(" Load expression files of type:  ");
        fileFilterLabel.setForeground(new Color(82, 82, 133));
        this.initFileFilterComboBox();
        this.fileTree = new FileTreePane(choice, this.fType);
        if (thePath != null) {
            this.fileTree.openDataPath(thePath);
            this.fPath = thePath.substring(0, thePath.lastIndexOf(FileBrowser.fsep) + 1);
        }
        System.out.println("fPath = " + this.fPath);
        ConfirmPane confirmPane = new ConfirmPane(this.fType);
        this.getContentPane().setLayout(new GridBagLayout());
        switch (choice) {
            case 0: {
                this.setTitle("Please specify a raw data file ...");
                break;
            }
            case 1: {
                this.setTitle("Please specify raw data file pair(s) ...");
                break;
            }
            case 2: {
                this.setTitle("Please specify raw data files ...");
            }
        }
        this.gba.add(this.getContentPane(), fileFilterLabel, 0, 0, 1, 1, 0, 0, 1, 17, 0, 0, 0, 0);
        this.gba.add(this.getContentPane(), this.fileFilterComboBox, 1, 0, 1, 1, 1, 0, 1, 17, 2, 2, 2, 2);
        this.gba.add(this.getContentPane(), this.fileTree, 0, 1, 2, 1, 1, 1, 1, 17, 0, 0, 0, 0);
        this.gba.add(this.getContentPane(), confirmPane, 0, 2, 2, 1, 1, 0, 0, 10, 0, 0, 0, 0);
        this.fPath = this.fileTree.getSelection();
    }

    private void initFileFilterComboBox() {
        this.fileFilterComboBox = new JComboBox();
        this.fileFilterComboBox.setForeground(new Color(82, 82, 133));
        this.fileFilterComboBox.addItem("TIGR MeV Expression Files (.mev)");
        this.fileFilterComboBox.addItem("TIGR ArrayViewer Expression Files (.tav)");
        this.fileFilterComboBox.addItem("Affymetrix Data Files (.txt) ( ...underdevelopment )");
        this.fileFilterComboBox.addItem("GenePix Files (.gpr) -- ( ...underdevelopment )");
        this.fileFilterComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                FileChooserPane.this.changeSelectedFileType(FileChooserPane.this.fileFilterComboBox.getSelectedIndex());
            }
        });
    }

    private void changeSelectedFileType(int ndx) {
        switch (ndx) {
            case 0: {
                this.fType = 11100;
                break;
            }
            case 1: {
                this.fType = 11102;
                break;
            }
            case 2: {
                this.fType = 11104;
                break;
            }
            case 3: {
                this.fType = 11105;
            }
        }
        this.setFileType();
        this.getContentPane().remove(this.fileTree);
        this.fileTree = new FileTreePane(this.fSelectionAction, this.fType);
        this.fileTree.openDataPath(this.fPath);
        this.fileTree.repaint();
        this.gba.add(this.getContentPane(), this.fileTree, 0, 1, 2, 1, 1, 1, 1, 17, 0, 0, 0, 0);
        this.getContentPane().repaint();
        this.setVisible(true);
    }

    private void setFileType() {
        Parameter.pFileType = this.fType;
    }

    public String getSelectedFile() {
        if (this.selectedSingleFile != null) {
            if (this.selectedSingleFile.equalsIgnoreCase("Please specify a raw data file")) {
                return this.selectedSingleFile;
            }
            return this.fPath + this.selectedSingleFile;
        }
        return "Please specify a raw data file";
    }

    public void setSelectedFile(String s) {
        this.selectedSingleFile = s.substring(s.lastIndexOf(FileBrowser.fsep) + 1);
    }

    public Vector getSelectedPairs() {
        return this.selectedPairsVec;
    }

    public void setSelectedPairs(Vector vec) {
        this.selectedPairsVec = vec;
    }

    public String getSelectedFolder() {
        return this.fPath;
    }

    public void setSelectedFolder(String dirStr) {
        this.fPath = dirStr;
    }

    public Vector getSelectedFilesVecLong() {
        Vector<String> v = new Vector<String>(this.selectedFilesVec.size());
        int i = 0;
        while (i < this.selectedFilesVec.size()) {
            String s = this.selectedFilesVec.elementAt(i).toString();
            if (s.indexOf(FileBrowser.fsep) > 0) {
                v.addElement(this.fPath + s.substring(s.lastIndexOf(FileBrowser.fsep) + 1, s.length()));
            } else {
                v.addElement(this.fPath + s);
            }
            ++i;
        }
        return v;
    }

    public void setSelectedFilesVec(Vector vec) {
        this.selectedFilesVec = vec;
    }

    private void refresh() {
        this.getContentPane().remove(this.fileTree);
        this.fileTree = new FileTreePane(this.fSelectionAction, this.fType);
        this.gba.add(this.getContentPane(), this.fileTree, 0, 1, 2, 1, 1, 1, 1, 17, 0, 0, 0, 0);
        this.getContentPane().repaint();
        this.setVisible(true);
    }

    private void launchAnnLoaderPane() {
        JOptionPane ifLoadAnnPane = new JOptionPane();
        int retVal = JOptionPane.showConfirmDialog(this, "Do you have an annotation file to load?", "Annotation loader", 0);
        if (retVal == 0) {
            // empty if block
        }
    }

    public void onInfo() {
        HelpWindow hw = new HelpWindow(this, "File Loader");
        if (hw.getWindowContent()) {
            hw.setSize(450, 650);
            hw.setLocation();
            hw.show();
        } else {
            hw.setVisible(false);
            hw.dispose();
        }
    }

    public static void main(String[] s) {
        JFrame frame = new JFrame("FileChooserPane Test");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        Container container = frame.getContentPane();
        FileChooserPane rPane = new FileChooserPane(2, "c:\\DataFiles0\\mev files\\BryanData\\");
        System.out.println("----" + rPane.getSelectedFilesVecLong().toString());
        rPane.pack();
        rPane.setVisible(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class FileNode {
        protected File m_file;

        public FileNode(File file) {
            this.m_file = file;
        }

        public File getFile() {
            return this.m_file;
        }

        public String toString() {
            return this.m_file.getName().length() > 0 ? this.m_file.getName() : this.m_file.getPath();
        }

        public boolean expand(DefaultMutableTreeNode parent) {
            DefaultMutableTreeNode flag = (DefaultMutableTreeNode)parent.getFirstChild();
            if (flag == null) {
                return false;
            }
            Object obj = flag.getUserObject();
            if (!(obj instanceof Boolean)) {
                return false;
            }
            parent.removeAllChildren();
            File[] files = this.listFiles();
            if (files == null) {
                return true;
            }
            Vector<FileNode> v = new Vector<FileNode>();
            int k = 0;
            while (k < files.length) {
                File f = files[k];
                if (f.isDirectory()) {
                    FileNode newNode = new FileNode(f);
                    boolean isAdded = false;
                    int i = 0;
                    while (i < v.size()) {
                        FileNode nd = (FileNode)v.elementAt(i);
                        if (newNode.compareTo(nd) < 0) {
                            v.insertElementAt(newNode, i);
                            isAdded = true;
                            break;
                        }
                        ++i;
                    }
                    if (!isAdded) {
                        v.addElement(newNode);
                    }
                }
                ++k;
            }
            int i = 0;
            while (i < v.size()) {
                FileNode nd = (FileNode)v.elementAt(i);
                IconData idata = new IconData(Constant.ICON_FOLDER, Constant.ICON_EXPANDEDFOLDER, nd);
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(idata);
                parent.add(node);
                if (nd.hasSubDirs()) {
                    node.add(new DefaultMutableTreeNode(new Boolean(true)));
                }
                ++i;
            }
            return true;
        }

        public boolean hasSubDirs() {
            File[] files = this.listFiles();
            if (files == null) {
                return false;
            }
            int k = 0;
            while (k < files.length) {
                if (files[k].isDirectory()) {
                    return true;
                }
                ++k;
            }
            return false;
        }

        public int compareTo(FileNode toCompare) {
            return this.m_file.getName().compareToIgnoreCase(toCompare.m_file.getName());
        }

        protected File[] listFiles() {
            if (!this.m_file.isDirectory()) {
                return null;
            }
            try {
                return this.m_file.listFiles();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, "Error reading directory " + this.m_file.getAbsolutePath(), "Warning", 2);
                return null;
            }
        }
    }

    class IconData {
        protected Icon m_icon;
        protected Icon m_expandedIcon;
        protected Object m_data;

        public IconData(Icon icon, Object data) {
            this.m_icon = icon;
            this.m_expandedIcon = null;
            this.m_data = data;
        }

        public IconData(Icon icon, Icon expandedIcon, Object data) {
            this.m_icon = icon;
            this.m_expandedIcon = expandedIcon;
            this.m_data = data;
        }

        public Icon getIcon() {
            return this.m_icon;
        }

        public Icon getExpandedIcon() {
            return this.m_expandedIcon != null ? this.m_expandedIcon : this.m_icon;
        }

        public Object getObject() {
            return this.m_data;
        }

        public String toString() {
            return this.m_data.toString();
        }
    }

    class IconCellRenderer
    extends JLabel
    implements TreeCellRenderer {
        protected Color m_textSelectionColor = UIManager.getColor("Tree.selectionForeground");
        protected Color m_textNonSelectionColor = UIManager.getColor("Tree.textForeground");
        protected Color m_bkSelectionColor = UIManager.getColor("Tree.selectionBackground");
        protected Color m_bkNonSelectionColor = UIManager.getColor("Tree.textBackground");
        protected Color m_borderSelectionColor = UIManager.getColor("Tree.selectionBorderColor");
        protected boolean m_selected;

        public IconCellRenderer() {
            this.setOpaque(false);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object obj = node.getUserObject();
            this.setText(obj.toString());
            if (obj instanceof Boolean) {
                this.setText("Retrieving data...");
            }
            if (obj instanceof IconData) {
                IconData idata = (IconData)obj;
                if (expanded) {
                    this.setIcon(idata.getExpandedIcon());
                } else {
                    this.setIcon(idata.getIcon());
                }
            } else {
                this.setIcon(null);
            }
            this.setFont(tree.getFont());
            this.setForeground(sel ? this.m_textSelectionColor : this.m_textNonSelectionColor);
            this.setBackground(sel ? this.m_bkSelectionColor : this.m_bkNonSelectionColor);
            this.m_selected = sel;
            return this;
        }

        public void paintComponent(Graphics g) {
            Color bColor = this.getBackground();
            Icon icon = this.getIcon();
            g.setColor(bColor);
            int offset = 0;
            if (icon != null && this.getText() != null) {
                offset = icon.getIconWidth() + this.getIconTextGap();
            }
            g.fillRect(offset, 0, this.getWidth() - 1 - offset, this.getHeight() - 1);
            if (this.m_selected) {
                g.setColor(this.m_borderSelectionColor);
                g.drawRect(offset, 0, this.getWidth() - 1 - offset, this.getHeight() - 1);
            }
            super.paintComponent(g);
        }
    }

    class FileTreePane
    extends JPanel {
        protected JTree m_tree;
        protected DefaultTreeModel m_model;
        protected JTextField m_display;
        protected JScrollPane filePane;
        protected JSplitPane readSplitPane;
        protected JList fileList;
        private int splitDivider;
        private JButton selectButton;
        private JButton deSelectButton;
        private JList pairFileList;
        private JList plotFileList;
        private Vector rightListContent;
        private Vector leftListContent;
        private int firstSelectedIndex = -1;
        protected DefaultMutableTreeNode top;
        private String thePath = "";
        private String presetShortFileName;

        public FileTreePane(int x, int fType) {
            int fileType = fType;
            JPanel fillerPane = new JPanel();
            if (FileChooserPane.this.fPath == null) {
                FileChooserPane.this.fPath = "";
            }
            if (x == 0 || x == 2) {
                this.setPreferredSize(new Dimension(550, 400));
                this.splitDivider = 260;
                this.top = new DefaultMutableTreeNode(new IconData(Constant.ICON_COMPUTER, null, "Computer"));
                File[] roots = File.listRoots();
                int k = 0;
                while (k < roots.length) {
                    DefaultMutableTreeNode node = new DefaultMutableTreeNode(new IconData(Constant.ICON_DISK, null, new FileNode(roots[k])));
                    this.top.add(node);
                    node.add(new DefaultMutableTreeNode(new Boolean(true)));
                    ++k;
                }
                this.m_model = new DefaultTreeModel(this.top);
                this.m_tree = new JTree(this.m_model);
                this.m_tree.getSelectionModel().setSelectionMode(1);
                this.m_tree.putClientProperty("JTree.lineStyle", "Angled");
                IconCellRenderer renderer = new IconCellRenderer();
                this.m_tree.setCellRenderer(renderer);
                this.m_tree.addTreeExpansionListener(new DirExpansionListener());
                this.m_tree.addTreeSelectionListener(new DirSelectionListener());
                this.m_tree.setShowsRootHandles(true);
                this.m_tree.setEditable(false);
                JScrollPane s = new JScrollPane();
                s.getViewport().add(this.m_tree);
                this.m_display = new JTextField();
                this.m_display.setEditable(false);
                FileBrowser fBrowser = new FileBrowser(FileChooserPane.this.fPath, fileType);
                Vector retrievedFileNames = fBrowser.getFileNamesVec("short");
                this.fileList = new JList(retrievedFileNames);
                this.filePane = new JScrollPane(this.fileList);
                this.setLayout(new BorderLayout());
                this.readSplitPane = new JSplitPane(1, s, this.filePane);
                this.readSplitPane.setDividerLocation(this.splitDivider);
                this.readSplitPane.setDividerSize(4);
                this.add((Component)this.readSplitPane, "Center");
                this.add((Component)this.m_display, "North");
            } else if (x == 1) {
                this.setPreferredSize(new Dimension(550, 420));
                this.splitDivider = 260;
                this.top = new DefaultMutableTreeNode(new IconData(Constant.ICON_COMPUTER, null, "Computer"));
                File[] roots = File.listRoots();
                int k = 0;
                while (k < roots.length) {
                    DefaultMutableTreeNode node = new DefaultMutableTreeNode(new IconData(Constant.ICON_DISK, null, new FileNode(roots[k])));
                    this.top.add(node);
                    node.add(new DefaultMutableTreeNode(new Boolean(true)));
                    ++k;
                }
                this.m_model = new DefaultTreeModel(this.top);
                this.m_tree = new JTree(this.m_model);
                this.m_tree.getSelectionModel().setSelectionMode(1);
                this.m_tree.putClientProperty("JTree.lineStyle", "Angled");
                IconCellRenderer renderer = new IconCellRenderer();
                this.m_tree.setCellRenderer(renderer);
                this.m_tree.addTreeExpansionListener(new DirExpansionListener());
                this.m_tree.addTreeSelectionListener(new DirSelectionListener());
                this.m_tree.setShowsRootHandles(true);
                this.m_tree.setEditable(false);
                JScrollPane s = new JScrollPane();
                s.getViewport().add(this.m_tree);
                this.m_display = new JTextField();
                this.m_display.setEditable(false);
                String[] emptyList = new String[]{""};
                this.fileList = new JList<String>(emptyList);
                this.filePane = new JScrollPane();
                this.filePane.getViewport().add(this.fileList);
                String[] emptyPairList = new String[]{"Selected file pair(s) are displayed here..."};
                this.rightListContent = new Vector();
                this.pairFileList = new JList<String>(emptyPairList);
                JScrollPane pairFilePane = new JScrollPane();
                pairFilePane.setPreferredSize(new Dimension(300, 200));
                pairFilePane.getViewport().add(this.pairFileList);
                this.setLayout(new BorderLayout());
                this.readSplitPane = new JSplitPane(1, s, this.filePane);
                this.readSplitPane.setDividerLocation(this.splitDivider);
                this.readSplitPane.setDividerSize(4);
                class ArrowButtonPane
                extends JPanel {
                    private final /* synthetic */ FileTreePane this$1;

                    public ArrowButtonPane(FileTreePane this$1) {
                        this.this$1 = this$1;
                        FileTreePane.access$802(this$1, new JButton(Constant.ICON_ARROW_DOWN));
                        FileTreePane.access$902(this$1, new JButton(Constant.ICON_ARROW_UP));
                        FileTreePane.access$800(this$1).setBorder(new BevelBorder(0));
                        FileTreePane.access$900(this$1).setBorder(new BevelBorder(0));
                        this.add(FileTreePane.access$800(this$1));
                        this.add(FileTreePane.access$900(this$1));
                    }
                }
                ArrowButtonPane arrowButtonPane = new ArrowButtonPane(this);
                this.actionHandler(this.selectButton);
                this.actionHandler(this.deSelectButton);
                this.pairFileList.addMouseListener(new MouseAdapter(this){
                    private final /* synthetic */ FileTreePane this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void mouseClicked(MouseEvent me) {
                        FileTreePane.access$1000(this.this$1, me);
                    }
                });
                JPanel tempPane = new JPanel();
                tempPane.setLayout(new GridBagLayout());
                FileChooserPane.this.gba.add(tempPane, this.readSplitPane, 0, 0, 2, 1, 1, 1, 1, 17, 0, 0, 0, 0);
                FileChooserPane.this.gba.add(tempPane, arrowButtonPane, 0, 1, 1, 1, 1, 0, 0, 10, 0, 0, 0, 0);
                FileChooserPane.this.gba.add(tempPane, pairFilePane, 0, 2, 2, 1, 1, 1, 1, 10, 0, 0, 0, 0);
                this.add((Component)tempPane, "Center");
                this.add((Component)this.m_display, "North");
            }
        }

        public void openDataPath(String dataPath) {
            if (dataPath == null) {
                return;
            }
            File file = new File(dataPath);
            if (file.exists()) {
                if (file.isDirectory()) {
                    this.openPath(this.top, dataPath, System.getProperty("file.separator"));
                } else {
                    this.presetShortFileName = dataPath.substring(dataPath.lastIndexOf(FileBrowser.fsep) + 1);
                    dataPath = dataPath.substring(0, dataPath.lastIndexOf(FileBrowser.fsep));
                    this.openPath(this.top, dataPath, System.getProperty("file.separator"));
                }
            }
        }

        protected boolean openPath(DefaultMutableTreeNode root, String dataPath, String sep) {
            TreePath path = new TreePath(root);
            StringTokenizer stok = new StringTokenizer(dataPath, sep);
            String[] nodes = new String[stok.countTokens()];
            String drive = stok.nextToken() + sep;
            DefaultMutableTreeNode subRoot = null;
            int childCount = root.getChildCount();
            DefaultMutableTreeNode tempNode = null;
            FileNode tempFileNode = null;
            int cumul = 0;
            int driveNum = 0;
            int i = 0;
            while (i < childCount) {
                tempNode = (DefaultMutableTreeNode)root.getChildAt(i);
                tempFileNode = this.getFileNode(tempNode);
                if (drive.equalsIgnoreCase(tempFileNode.toString())) {
                    subRoot = (DefaultMutableTreeNode)root.getChildAt(i);
                    this.thePath = this.thePath + subRoot.toString() + sep;
                    driveNum = i;
                    cumul = i;
                    break;
                }
                ++i;
            }
            if (subRoot == null) {
                return false;
            }
            path = path.pathByAddingChild(subRoot);
            boolean stop = false;
            block1: while (!stop && stok.hasMoreTokens()) {
                this.buildOffNode(subRoot);
                childCount = subRoot.getChildCount();
                String nodeName = stok.nextToken();
                int i2 = 0;
                while (i2 < childCount) {
                    tempNode = (DefaultMutableTreeNode)subRoot.getChildAt(i2);
                    tempFileNode = this.getFileNode(tempNode);
                    if (tempFileNode == null) {
                        stop = true;
                        continue block1;
                    }
                    if (nodeName.equalsIgnoreCase(tempFileNode.toString())) {
                        path = path.pathByAddingChild(tempNode);
                        this.thePath = this.thePath + tempNode.toString() + sep;
                        subRoot = (DefaultMutableTreeNode)subRoot.getChildAt(i2);
                        continue block1;
                    }
                    ++i2;
                }
            }
            this.m_tree.expandPath(path);
            this.m_tree.makeVisible(path);
            this.m_tree.scrollPathToVisible(path);
            this.m_tree.setSelectionPath(path);
            this.m_tree.validate();
            this.repaint();
            return true;
        }

        private void buildOffNode(DefaultMutableTreeNode subRoot) {
            FileNode tempFileNode = this.getFileNode(subRoot);
            File[] files = new File(this.thePath).listFiles();
            if (files == null) {
                return;
            }
            Vector<FileNode> v = new Vector<FileNode>();
            if (files == null) {
                return;
            }
            int k = 0;
            while (k < files.length) {
                File f = files[k];
                if (f.isDirectory()) {
                    FileNode newNode = new FileNode(f);
                    boolean isAdded = false;
                    int i = 0;
                    while (i < v.size()) {
                        FileNode nd = (FileNode)v.elementAt(i);
                        if (newNode.compareTo(nd) < 0) {
                            v.insertElementAt(newNode, i);
                            isAdded = true;
                            break;
                        }
                        ++i;
                    }
                    if (!isAdded) {
                        v.addElement(newNode);
                    }
                }
                ++k;
            }
            subRoot.removeAllChildren();
            int i = 0;
            while (i < v.size()) {
                FileNode nd = (FileNode)v.elementAt(i);
                IconData idata = new IconData(ICON_FOLDER, ICON_EXPANDEDFOLDER, nd);
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(idata);
                subRoot.add(node);
                if (nd.hasSubDirs()) {
                    node.add(new DefaultMutableTreeNode(new Boolean(true)));
                }
                ++i;
            }
        }

        public String getSelection() {
            return FileChooserPane.this.fPath;
        }

        private DefaultMutableTreeNode getTreeNode(TreePath path) {
            return (DefaultMutableTreeNode)path.getLastPathComponent();
        }

        private FileNode getFileNode(DefaultMutableTreeNode node) {
            if (node == null) {
                return null;
            }
            Object obj = node.getUserObject();
            if (obj instanceof IconData) {
                obj = ((IconData)obj).getObject();
            }
            if (obj instanceof FileNode) {
                return (FileNode)obj;
            }
            return null;
        }

        private void actionHandler(AbstractButton btn) {
            btn.addActionListener(new ActionListener(this){
                private final /* synthetic */ FileTreePane this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    if (ae.getSource() == FileTreePane.access$800(this.this$1)) {
                        if (FileTreePane.access$1700((FileTreePane)this.this$1).selectedCount != 2) {
                            AlertDialogPane alertDialogPane = new AlertDialogPane(1, "Two files need to be selected for pair setting ");
                        } else {
                            FileTreePane.access$2100(this.this$1, true);
                        }
                    } else if (ae.getSource() == FileTreePane.access$900(this.this$1)) {
                        FileTreePane.access$2100(this.this$1, false);
                    }
                }
            });
        }

        private void setSelectedPairs(MouseEvent evt) {
            if (evt.getClickCount() == 2) {
                if (evt.getSource() == this.pairFileList) {
                    this.setSelectedPairs(true);
                } else {
                    this.setSelectedPairs(false);
                }
            }
        }

        private void setSelectedPairs(boolean upBtn) {
            Vector sel = null;
            Vector<Vector> pairListVec = new Vector<Vector>();
            this.leftListContent = this.getListContents(this.fileList);
            if (upBtn) {
                sel = this.getSelectedPairs(this.fileList, upBtn);
                if (sel.size() == 2) {
                    pairListVec.add(sel);
                    if (this.rightListContent.size() == 1 && this.rightListContent.elementAt(0).toString().equalsIgnoreCase("Selected file pairs will be displayed ...")) {
                        this.rightListContent.clear();
                    }
                    FileChooserPane.this.flaggedPairsVec = this.rightListContent;
                    this.rightListContent = this.unionTwo(this.rightListContent, pairListVec, upBtn, true);
                    this.pairFileList.setFont(new Font("dialog.plain", 0, 12));
                    this.pairFileList.setListData(this.rightListContent);
                    int i = 0;
                    while (i < sel.size()) {
                        String s = (String)sel.elementAt(i);
                        s = s.substring(s.lastIndexOf(FileBrowser.fsep) + 1, s.length());
                        this.leftListContent.remove(s);
                        ++i;
                    }
                    this.fileList.setListData(this.leftListContent);
                }
            } else {
                sel = this.getSelectedPairs(this.pairFileList, upBtn);
                this.leftListContent = this.unionTwo(this.leftListContent, sel, upBtn, true);
                this.fileList.setListData(this.leftListContent);
                ListModel lm = this.pairFileList.getModel();
                int[] selIndex = this.pairFileList.getSelectedIndices();
                int size = selIndex.length;
                int i = 0;
                while (i < size) {
                    Vector backVec = (Vector)lm.getElementAt(selIndex[0]);
                    this.rightListContent.remove(backVec);
                    ++i;
                }
                this.pairFileList.setListData(this.rightListContent);
            }
            FileChooserPane.this.selectedPairsVec = this.rightListContent;
        }

        private Vector getListContents(JList list) {
            ListModel lm = null;
            Vector<String> temp = null;
            lm = list.getModel();
            int size = lm.getSize();
            temp = new Vector<String>(size, size / 4);
            int i = 0;
            while (i < size) {
                temp.add((String)lm.getElementAt(i));
                ++i;
            }
            return temp;
        }

        private Vector getSelectedPairs(JList list, boolean upButn) {
            ListModel lm = null;
            Vector<String> temp = null;
            int[] selIndex = new int[2];
            lm = list.getModel();
            selIndex = list.getSelectedIndices();
            int size = selIndex.length;
            temp = new Vector<String>();
            if (upButn) {
                if (selIndex[0] != this.firstSelectedIndex) {
                    int tempNdx = selIndex[0];
                    selIndex[0] = selIndex[1];
                    selIndex[1] = tempNdx;
                }
                int i = 0;
                while (i < size) {
                    temp.add(FileChooserPane.this.fPath + (String)lm.getElementAt(selIndex[i]));
                    ++i;
                }
            } else {
                int i = 0;
                while (i < size) {
                    Vector backVec = (Vector)lm.getElementAt(selIndex[i]);
                    String s1 = (String)backVec.elementAt(0);
                    s1 = s1.substring(s1.lastIndexOf(FileBrowser.fsep) + 1, s1.length());
                    temp.add(s1);
                    String s2 = (String)backVec.elementAt(1);
                    s2 = s2.substring(s2.lastIndexOf(FileBrowser.fsep) + 1, s2.length());
                    temp.add(s2);
                    ++i;
                }
            }
            return temp;
        }

        private Vector getSelectedFiles(JList list, boolean upButn) {
            ListModel lm = null;
            Vector<String> temp = null;
            lm = list.getModel();
            int[] selIndex = list.getSelectedIndices();
            int size = selIndex.length;
            temp = new Vector<String>();
            if (upButn) {
                int i = 0;
                while (i < size) {
                    temp.add((String)lm.getElementAt(selIndex[i]));
                    ++i;
                }
            } else {
                int i = 0;
                while (i < size) {
                    String backStr = (String)lm.getElementAt(selIndex[i]);
                    temp.add(backStr);
                    ++i;
                }
            }
            return temp;
        }

        private Vector unionTwo(Vector first, Vector second, boolean upButn, boolean elementIsVector) {
            Vector temp = first;
            int length = second.size();
            if (upButn) {
                int i = 0;
                while (i < length) {
                    if (elementIsVector) {
                        temp.add((Vector)second.elementAt(i));
                    } else {
                        temp.add((String)second.elementAt(i));
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < length) {
                    temp.add((String)second.elementAt(i));
                    ++i;
                }
            }
            return temp;
        }

        static /* synthetic */ JButton access$802(FileTreePane x0, JButton x1) {
            x0.selectButton = x1;
            return x0.selectButton;
        }

        static /* synthetic */ JButton access$902(FileTreePane x0, JButton x1) {
            x0.deSelectButton = x1;
            return x0.deSelectButton;
        }

        static /* synthetic */ JButton access$800(FileTreePane x0) {
            return x0.selectButton;
        }

        static /* synthetic */ JButton access$900(FileTreePane x0) {
            return x0.deSelectButton;
        }

        static /* synthetic */ void access$1000(FileTreePane x0, MouseEvent x1) {
            x0.setSelectedPairs(x1);
        }

        static /* synthetic */ void access$2100(FileTreePane x0, boolean x1) {
            x0.setSelectedPairs(x1);
        }

        class ListListener
        implements ListSelectionListener {
            ListListener() {
            }

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ((FileTreePane)FileTreePane.this).FileChooserPane.this.selectedCount = FileTreePane.this.fileList.getSelectedValues().length;
                if (((FileTreePane)FileTreePane.this).FileChooserPane.this.fSelectionAction == 0) {
                    if (((FileTreePane)FileTreePane.this).FileChooserPane.this.selectedCount == 0) {
                        AlertDialogPane aPane = new AlertDialogPane(1, "Please select a data file from the right window, \nbecause you are currently using file mode ");
                    } else if (((FileTreePane)FileTreePane.this).FileChooserPane.this.selectedCount > 1) {
                        AlertDialogPane aPane = new AlertDialogPane(1, "Only one file can be selected for single file mode ");
                    } else {
                        ((FileTreePane)FileTreePane.this).FileChooserPane.this.selectedSingleFile = (String)FileTreePane.this.fileList.getSelectedValue();
                    }
                } else if (((FileTreePane)FileTreePane.this).FileChooserPane.this.fSelectionAction == 1) {
                    if (((FileTreePane)FileTreePane.this).FileChooserPane.this.selectedCount == 1) {
                        FileTreePane.this.firstSelectedIndex = FileTreePane.this.fileList.getSelectedIndex();
                    }
                } else if (((FileTreePane)FileTreePane.this).FileChooserPane.this.fSelectionAction == 2) {
                    ((FileTreePane)FileTreePane.this).FileChooserPane.this.selectedFilesVec = new Vector();
                    int i = 0;
                    while (i < ((FileTreePane)FileTreePane.this).FileChooserPane.this.selectedCount) {
                        ((FileTreePane)FileTreePane.this).FileChooserPane.this.selectedFilesVec.add(i, (String)FileTreePane.this.fileList.getSelectedValues()[i]);
                        ++i;
                    }
                }
            }
        }

        class DirSelectionListener
        implements TreeSelectionListener {
            DirSelectionListener() {
            }

            public void valueChanged(TreeSelectionEvent event) {
                DefaultMutableTreeNode node = FileTreePane.this.getTreeNode(event.getPath());
                FileNode fnode = FileTreePane.this.getFileNode(node);
                if (fnode != null) {
                    FileTreePane.this.m_display.setText(fnode.getFile().getAbsolutePath());
                    ((FileTreePane)FileTreePane.this).FileChooserPane.this.fPath = fnode.getFile().getAbsolutePath();
                    if (((FileTreePane)FileTreePane.this).FileChooserPane.this.fPath.charAt(((FileTreePane)FileTreePane.this).FileChooserPane.this.fPath.length() - 1) != FileBrowser.fsep.charAt(0)) {
                        ((FileTreePane)FileTreePane.this).FileChooserPane.this.fPath = ((FileTreePane)FileTreePane.this).FileChooserPane.this.fPath + FileBrowser.fsep;
                    }
                    FileBrowser fBrowser = new FileBrowser(((FileTreePane)FileTreePane.this).FileChooserPane.this.fPath, ((FileTreePane)FileTreePane.this).FileChooserPane.this.fType);
                    Vector retrievedFileNames = fBrowser.getFileNamesVec("short");
                    FileTreePane.this.fileList = new JList(retrievedFileNames);
                    FileTreePane.this.fileList.setFont(new Font("dialog.plain", 0, 12));
                    if (((FileTreePane)FileTreePane.this).FileChooserPane.this.fSelectionAction == 0) {
                        FileTreePane.this.fileList.setSelectedValue(FileTreePane.this.presetShortFileName, true);
                        ((FileTreePane)FileTreePane.this).FileChooserPane.this.selectedSingleFile = FileTreePane.this.presetShortFileName;
                    } else if (((FileTreePane)FileTreePane.this).FileChooserPane.this.fSelectionAction != 1 && ((FileTreePane)FileTreePane.this).FileChooserPane.this.fSelectionAction == 2) {
                        ((FileTreePane)FileTreePane.this).FileChooserPane.this.selectedFilesVec = ((FileTreePane)FileTreePane.this).FileChooserPane.this.selectedFilesVec == null ? new Vector() : ((FileTreePane)FileTreePane.this).FileChooserPane.this.selectedFilesVec;
                        Object[] ob = ((FileTreePane)FileTreePane.this).FileChooserPane.this.selectedFilesVec.toArray();
                        int[] selectedIndices = new int[ob.length];
                        int i = 0;
                        while (i < ob.length) {
                            String s = ((String)ob[i]).substring(((String)ob[i]).lastIndexOf(FileBrowser.fsep) + 1);
                            FileTreePane.this.fileList.setSelectedValue(s, true);
                            selectedIndices[i] = FileTreePane.this.fileList.getSelectedIndex();
                            ++i;
                        }
                        FileTreePane.this.fileList.setSelectedIndices(selectedIndices);
                    }
                    FileTreePane.this.filePane = new JScrollPane(FileTreePane.this.fileList);
                    FileTreePane.this.fileList.setSelectionMode(2);
                    ListListener fileListListener = new ListListener();
                    FileTreePane.this.fileList.addListSelectionListener(fileListListener);
                    FileTreePane.this.readSplitPane.setDividerLocation(FileTreePane.this.splitDivider);
                    FileTreePane.this.readSplitPane.setRightComponent(FileTreePane.this.filePane);
                } else {
                    FileTreePane.this.m_display.setText("");
                    ((FileTreePane)FileTreePane.this).FileChooserPane.this.fPath = "";
                }
            }
        }

        class DirExpansionListener
        implements TreeExpansionListener {
            DirExpansionListener() {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                DefaultMutableTreeNode node = FileTreePane.this.getTreeNode(event.getPath());
                FileNode fnode = FileTreePane.this.getFileNode(node);
                Thread runner = new Thread(this, fnode, node){
                    private final /* synthetic */ FileNode val$fnode;
                    private final /* synthetic */ DefaultMutableTreeNode val$node;
                    private final /* synthetic */ DirExpansionListener this$2;
                    {
                        this.this$2 = this$2;
                        this.val$fnode = val$fnode;
                        this.val$node = val$node;
                    }

                    public void run() {
                        if (this.val$fnode != null && this.val$fnode.expand(this.val$node)) {
                            Runnable runnable = new Runnable(this){
                                private final /* synthetic */ 3 this$3;
                                {
                                    this.this$3 = this$3;
                                }

                                public void run() {
                                    DirExpansionListener.access$1600((DirExpansionListener)3.access$1500(this.this$3)).m_model.reload(3.access$1400(this.this$3));
                                }
                            };
                            SwingUtilities.invokeLater(runnable);
                        }
                    }

                    static /* synthetic */ DefaultMutableTreeNode access$1400(3 x0) {
                        return x0.val$node;
                    }

                    static /* synthetic */ DirExpansionListener access$1500(3 x0) {
                        return x0.this$2;
                    }
                };
                runner.start();
            }

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            static /* synthetic */ FileTreePane access$1600(DirExpansionListener x0) {
                return x0.FileTreePane.this;
            }
        }
    }

    class EventListener
    implements ActionListener {
        EventListener() {
        }

        public void actionPerformed(ActionEvent event) {
            Object source = event.getSource();
            if (source == FileChooserPane.this.infoButton) {
                FileChooserPane.this.onInfo();
            } else if (source == FileChooserPane.this.okButton) {
                if (FileChooserPane.this.fSelectionAction == 0) {
                    if (FileChooserPane.this.selectedSingleFile != null) {
                        Parameter.pSingleFileStr = FileChooserPane.this.fPath + FileChooserPane.this.selectedSingleFile;
                    } else {
                        FileChooserPane.this.selectedSingleFile = "Please specify a raw data file";
                    }
                    FileChooserPane.this.abort = false;
                    FileChooserPane.this.dispose();
                } else if (FileChooserPane.this.fSelectionAction == 1) {
                    FileChooserPane.this.abort = false;
                    FileChooserPane.this.dispose();
                } else if (FileChooserPane.this.fSelectionAction == 2) {
                    Parameter.pFolderFilesVec = FileChooserPane.this.getSelectedFilesVecLong();
                    FileChooserPane.this.selectedFilesVec = FileChooserPane.this.getSelectedFilesVecLong();
                    System.out.println(FileChooserPane.this.selectedFilesVec.toString());
                    if (FileChooserPane.this.selectedFilesVec.size() != 0) {
                        FileChooserPane.this.abort = false;
                        FileChooserPane.this.dispose();
                    } else {
                        AlertDialogPane alertDialogPane = new AlertDialogPane(0, "No input data file(s) specified yet ");
                    }
                }
            } else if (source == FileChooserPane.this.refreshButton) {
                FileChooserPane.this.refresh();
            } else if (source == FileChooserPane.this.cancelButton) {
                FileChooserPane.this.abort = true;
                if (FileChooserPane.this.fSelectionAction == 0) {
                    FileChooserPane.this.setSelectedFile(FileChooserEditor.oldStr);
                } else if (FileChooserPane.this.fSelectionAction == 1) {
                    FileChooserPane.this.setSelectedFolder(Parameter.pFilePairVec != null ? Parameter.pFilePairVec.toString() : "");
                } else if (FileChooserPane.this.fSelectionAction == 2) {
                    FileChooserPane.this.setSelectedFolder(FileChooserEditor.oldStr);
                }
                FileChooserPane.this.dispose();
            }
        }
    }

    class ConfirmPane
    extends JPanel {
        public ConfirmPane(int fora) {
            FileChooserPane.this.infoButton = new JButton(null, new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("org/tigr/midas/images/Information24.gif"))));
            FileChooserPane.this.infoButton.setBorder(BorderFactory.createBevelBorder(0));
            FileChooserPane.this.okButton = new JButton("OK");
            FileChooserPane.this.refreshButton = new JButton("Refresh");
            FileChooserPane.this.cancelButton = new JButton("Cancel");
            FileChooserPane.this.el = new EventListener();
            FileChooserPane.this.infoButton.addActionListener(FileChooserPane.this.el);
            FileChooserPane.this.okButton.addActionListener(FileChooserPane.this.el);
            FileChooserPane.this.refreshButton.addActionListener(FileChooserPane.this.el);
            FileChooserPane.this.cancelButton.addActionListener(FileChooserPane.this.el);
            this.add(FileChooserPane.this.infoButton);
            this.add(FileChooserPane.this.okButton);
            this.add(FileChooserPane.this.cancelButton);
        }
    }
}

