/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.display;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JWindow;
import org.tigr.midas.display.Proface;

public class ProfaceProjector
extends Thread {
    public static boolean faceOn;
    private Dimension screenSize;
    private JWindow jw;
    private Proface face;
    private boolean active;
    private int x;
    private int y;
    private int picX;
    private int picY;

    public ProfaceProjector(Proface face, boolean noEvent) {
        this.face = face;
        this.active = noEvent;
        this.jw = new JWindow();
        this.picX = face.getImageWidth();
        this.picY = face.getImageHeight();
    }

    public void run() {
        this.jw.getContentPane().add(this.face);
        if (!this.active) {
            this.jw.addMouseListener(new MouseListener(){

                public void mousePressed(MouseEvent me) {
                }

                public void mouseReleased(MouseEvent me) {
                }

                public void mouseExited(MouseEvent me) {
                }

                public void mouseEntered(MouseEvent me) {
                }

                public void mouseClicked(MouseEvent me) {
                    ProfaceProjector.this.terminate();
                }
            });
        }
        this.jw.resize(this.picX, this.picY);
        this.screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.x = (this.screenSize.width - this.picX) / 2;
        this.y = (this.screenSize.height - this.picY) / 2;
        this.jw.setLocation(this.x, this.y);
        this.jw.show();
        this.jw.pack();
        faceOn = true;
    }

    public void setInfoText(String text) {
        this.face.setInfoText(text);
    }

    public void setTextColor(Color color) {
        this.face.setTextColor(color);
    }

    public void showFace() {
        if (faceOn) {
            this.jw.show();
        }
    }

    public void terminate() {
        this.jw.disable();
        faceOn = false;
        this.jw.dispose();
    }
}

