/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.display;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.io.File;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.tigr.midas.display.MevDataViewer;
import org.tigr.midas.graph.plot.BoxPlot;
import org.tigr.midas.graph.plot.HistogramPlot;
import org.tigr.midas.graph.plot.IntensityPlot;
import org.tigr.midas.graph.plot.LogIntensityPlot;
import org.tigr.midas.graph.plot.Plot;
import org.tigr.midas.graph.plot.RIPlot;
import org.tigr.midas.graph.plot.RatioRatioPlot;
import org.tigr.midas.graph.plot.SAMPlot;
import org.tigr.midas.util.GBA;

public class ViewHolderPane
extends JPanel {
    private GBA gba = new GBA();
    protected Vector fileVec;
    protected Plot plot;

    public ViewHolderPane() {
        this.setBackground(Color.white);
        this.setForeground(Color.white);
        this.setBorder(new TitledBorder(new EtchedBorder(), " Viewer "));
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(450, 200));
    }

    public void makeDataView(File f) {
        this.setBorder(new TitledBorder(new EtchedBorder(), " Data Viewer "));
        this.removeAll();
        MevDataViewer mevDataViewer = new MevDataViewer(f);
        this.pasteDataView(mevDataViewer);
    }

    public void makeGraphs(Vector fVec, int fType) {
        Object[] fArray = fVec.toArray();
        this.setBorder(new TitledBorder(new EtchedBorder(), " Graph Viewer "));
        this.removeAll();
        switch (fType) {
            case 99901: {
                this.plot = new IntensityPlot(fVec);
                break;
            }
            case 99902: {
                this.plot = new LogIntensityPlot(fVec);
                break;
            }
            case 99903: {
                this.plot = new RIPlot(fVec);
                break;
            }
            case 99904: {
                this.plot = new HistogramPlot(fVec);
                break;
            }
            case 99906: {
                this.plot = new RatioRatioPlot(fVec);
                break;
            }
            case 99905: {
                this.plot = new BoxPlot(fVec);
                break;
            }
            case 99907: {
                this.plot = new SAMPlot(fVec.elementAt(0).toString());
            }
        }
        this.pasteGraphView(this.plot);
    }

    public void pasteDataView(MevDataViewer dataViewer) {
        this.setLayout(new BorderLayout());
        this.add((Component)dataViewer, "Center");
        this.validate();
    }

    public void pasteGraphView(Plot p) {
        if (p == null) {
            // empty if block
        }
        this.setLayout(new BorderLayout());
        this.add((Component)p.getGraph(), "Center");
        this.validate();
    }
}

