/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.engine;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Vector;
import org.tigr.midas.Constant;
import org.tigr.midas.display.AlertDialogPane;
import org.tigr.midas.display.AppRunningIndicator;
import org.tigr.midas.display.IconBar;
import org.tigr.midas.display.MessagePane;
import org.tigr.midas.display.Midas;
import org.tigr.midas.engine.BatchInReplicatesAnalysis;
import org.tigr.midas.engine.BatchIterLinReg;
import org.tigr.midas.engine.BatchIterLogMean;
import org.tigr.midas.engine.BatchLocfit;
import org.tigr.midas.engine.BatchRatioStats;
import org.tigr.midas.engine.BatchSliceAnalysis;
import org.tigr.midas.engine.BatchTotInt;
import org.tigr.midas.engine.BatchVariReg;
import org.tigr.midas.engine.ErrorReport;
import org.tigr.midas.engine.FileBuilder;
import org.tigr.midas.engine.FileOpener;
import org.tigr.midas.engine.FlipDye;
import org.tigr.midas.engine.InReplicatesAnalysis;
import org.tigr.midas.engine.IterativeLinReg;
import org.tigr.midas.engine.IterativeLogMean;
import org.tigr.midas.engine.Locfit;
import org.tigr.midas.engine.MaAnova;
import org.tigr.midas.engine.Module;
import org.tigr.midas.engine.PairsIterLinReg;
import org.tigr.midas.engine.PairsIterLogMean;
import org.tigr.midas.engine.PairsLocfit;
import org.tigr.midas.engine.PairsRatioStats;
import org.tigr.midas.engine.PairsSliceAnalysis;
import org.tigr.midas.engine.PairsTotInt;
import org.tigr.midas.engine.PairsVariReg;
import org.tigr.midas.engine.Parameter;
import org.tigr.midas.engine.Project;
import org.tigr.midas.engine.RatioStats;
import org.tigr.midas.engine.SAM;
import org.tigr.midas.engine.SliceAnalysis;
import org.tigr.midas.engine.TotInt;
import org.tigr.midas.engine.Ttest;
import org.tigr.midas.engine.VariReg;
import org.tigr.midas.exception.BkgdInfoMissingException;
import org.tigr.midas.exception.EmptyPairListException;
import org.tigr.midas.exception.SAInvalidSliceWindowDataPopulation;
import org.tigr.midas.exception.SA_CantComputeSliceMeanSD;
import org.tigr.midas.exception.UnevenSizePairException;
import org.tigr.midas.report.PreparePDFReport;
import org.tigr.midas.report.PrepareTXTReport;
import org.tigr.midas.util.ColumnWorker;
import org.tigr.midas.util.FileBrowser;
import org.tigr.midas.util.StringSplitter;
import org.tigr.midas.util.swing.SwingWorker;

public class Conductor {
    private MessagePane messagePane;
    private ColumnWorker fileCW;
    private ColumnWorker[][] pairsInCW;
    private ColumnWorker[] pairsOutCW;
    private ColumnWorker[] folderCW;
    private Project proj;
    private Vector flowVec;
    private SwingWorker mainWorker;
    private boolean canceled;

    public Conductor(Project prj) {
        this.proj = prj;
        this.messagePane = new MessagePane("Welcome to use TIGR MIDAS.", Color.blue);
        StringSplitter st = new StringSplitter(this.proj.getFlow(), '>');
        this.flowVec = new Vector();
        while (st.hasMoreTokens()) {
            this.flowVec.add(st.nextToken());
        }
    }

    public Conductor() {
        System.out.println("Terminate conductor!");
        IconBar.stopButton.setEnabled(false);
        AlertDialogPane aPane = new AlertDialogPane(0, "Per your request, MIDAS will terminate the running process after the current step is finished. \nPlease wait and let current step be finished. The Execution button will turn clickable when ready ");
        this.refreshMessageHolderPane(2);
        System.gc();
    }

    public void conduct() {
        IconBar.stopButton.addActionListener(new StopListener());
        try {
            IconBar.exeButton.setEnabled(false);
            IconBar.stopButton.setEnabled(true);
            this.mainWorker = new SwingWorker(1){

                public Object construct() {
                    Conductor.this.canceled = false;
                    return Conductor.this.stepRunner();
                }

                public void finished() {
                    IconBar.exeButton.setEnabled(true);
                }
            };
            this.mainWorker.start();
        }
        catch (Exception ex) {
            AlertDialogPane aPane = new AlertDialogPane(1, "Midas can't generate report file ");
            ex.printStackTrace();
        }
    }

    public void refreshMessageHolderPane(final int status) {
        boolean STATUS_INIT = false;
        boolean STATUS_EXECUTION = true;
        int STATUS_INTERRUPT = 2;
        int STATUS_FINISHED = 3;
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                switch (status) {
                    case 0: {
                        Midas.messageHolderPane.pasteMessagePane(Conductor.this.messagePane);
                        Midas.messageHolderPane.pasteIndicatorPane(new AppRunningIndicator(AppRunningIndicator.logoImage));
                        Midas.messageHolderPane.validate();
                        break;
                    }
                    case 1: {
                        Midas.messageHolderPane.removeAll();
                        Conductor.this.messagePane.appendMessage("Process started ...", Color.blue);
                        Midas.messageHolderPane.pasteMessagePane(Conductor.this.messagePane);
                        Midas.messageHolderPane.pasteIndicatorPane(new AppRunningIndicator(AppRunningIndicator.tigerImage));
                        Midas.messageHolderPane.validate();
                        break;
                    }
                    case 2: {
                        Midas.messageHolderPane.removeAll();
                        Conductor.this.messagePane.appendMessage("Process stopped.", Color.blue);
                        Midas.messageHolderPane.pasteMessagePane(Conductor.this.messagePane);
                        Midas.messageHolderPane.pasteIndicatorPane(new AppRunningIndicator(AppRunningIndicator.logoImage));
                        Midas.messageHolderPane.validate();
                        break;
                    }
                    case 3: {
                        Midas.messageHolderPane.removeAll();
                        Conductor.this.messagePane.appendMessage("Process finished.", Color.blue);
                        Conductor.this.messagePane.appendMessage("    Output file(s), report file or error file are saved under -- " + Conductor.this.proj.getProjPath().substring(0, Conductor.this.proj.getProjPath().lastIndexOf(FileBrowser.fsep) + 1) + "\n", Constant.brown);
                        Midas.messageHolderPane.pasteMessagePane(Conductor.this.messagePane);
                        Midas.messageHolderPane.pasteIndicatorPane(new AppRunningIndicator(AppRunningIndicator.logoImage));
                        Midas.messageHolderPane.validate();
                    }
                }
                return "Done with refreshing messageHolderPane.";
            }
        };
        worker.start();
    }

    private void reportError(String errMsg) {
        String errName = this.proj.getProjPath() + this.proj.getProjNameWithoutExt() + ".err";
        try {
            this.canceled = true;
            ErrorReport errRpt = new ErrorReport(errName);
            errRpt.appendError(errMsg);
        }
        catch (Exception ex) {
            System.out.println("Unable to create error report.");
            ex.printStackTrace();
        }
    }

    private Object stepRunner() {
        try {
            this.proj.setMidasVersion("2.19");
            this.proj.setStartDate();
            int fpd = 9999;
            boolean afterFlipDye = false;
            Module.proj = this.proj;
            this.refreshMessageHolderPane(1);
            Thread.sleep(500L);
            int step = 0;
            block84: while (step < this.flowVec.size()) {
                block181: {
                    if (!this.canceled) {
                        PairsTotInt pairsTotInt;
                        BatchTotInt batchTotInt;
                        TotInt totInt;
                        AlertDialogPane aPane;
                        AlertDialogPane aPane2;
                        AlertDialogPane aPane3;
                        AlertDialogPane aPane4;
                        FileOpener fOpener;
                        int currentCall = Integer.parseInt(this.flowVec.elementAt(step).toString());
                        System.out.println("Performing " + currentCall);
                        if (currentCall == 0) {
                            fpd = 0;
                            this.messagePane.appendMessage("    - Reading " + Parameter.pSingleFileStr + " ...", Constant.green_1);
                            try {
                                fOpener = new FileOpener(currentCall);
                                this.fileCW = fOpener.getFileCW();
                                String ext = "";
                                if (Parameter.pSingleFileStr.endsWith(".tav")) {
                                    ext = "_MDS.tav";
                                } else if (Parameter.pSingleFileStr.endsWith(".mev")) {
                                    ext = "_MDS.mev";
                                }
                                Parameter.pOutFileStr = this.proj.getProjPath() + Parameter.pSingleFileStr.substring(Parameter.pSingleFileStr.lastIndexOf(FileBrowser.fsep) + 1, Parameter.pSingleFileStr.length() - 4) + ext;
                                try {
                                    PrintStream testOut = new PrintStream(new FileOutputStream(new File(Parameter.pOutFileStr)));
                                    testOut.close();
                                }
                                catch (FileNotFoundException ex) {
                                    aPane4 = new AlertDialogPane(1, "Midas will generate output file in the format of \"RawDataFile_MDS\". \nCurrently an old version of the output file in your project folder is used by another application. \nPlease close that application first : " + Parameter.pOutFileStr);
                                    break;
                                }
                                this.messagePane.appendMessageInLine(" Done!", Constant.brown);
                                break block181;
                            }
                            catch (OutOfMemoryError ex) {
                                this.messagePane.appendMessage("    Error occurred! Out of memory when reading " + FileOpener.badFileName + ".", Color.red);
                                AlertDialogPane aPane5 = new AlertDialogPane(1, "System out of memory : " + FileOpener.badFileName);
                                this.reportError(ex.toString());
                                ex.printStackTrace();
                                break;
                            }
                            catch (FileNotFoundException ex) {
                                this.messagePane.appendMessage("    Error occurred! " + FileOpener.badFileName + " cannot be found.", Color.red);
                                aPane3 = new AlertDialogPane(1, "The data file you specified does not exisit : " + FileOpener.badFileName);
                                this.reportError(ex.toString());
                                ex.printStackTrace();
                                break;
                            }
                            catch (NumberFormatException ex) {
                                this.messagePane.appendMessage("    Error occurred! " + FileOpener.badFileName + " has illegal format.", Color.red);
                                aPane4 = new AlertDialogPane(1, "Data file has illegal format : " + FileOpener.badFileName);
                                this.reportError(ex.toString());
                                ex.printStackTrace();
                                break;
                            }
                            catch (BkgdInfoMissingException ex) {
                                this.messagePane.appendMessage("    Error occurred! " + FileOpener.badFileName + " Missing background information.", Color.red);
                                aPane2 = new AlertDialogPane(1, "Please specify background columns for both Cy3 and Cy5 : " + FileOpener.badFileName);
                                this.reportError(ex.toString());
                                ex.printStackTrace();
                                break;
                            }
                            catch (Exception ex) {
                                this.messagePane.appendMessage("    Error occurred when reading " + FileOpener.badFileName + " Please check error file under project folder.", Color.red);
                                aPane = new AlertDialogPane(1, "Error occurred : " + FileOpener.badFileName);
                                this.reportError(ex.toString());
                                ex.printStackTrace();
                                break;
                            }
                        }
                        if (currentCall == 1) {
                            fpd = 1;
                            this.messagePane.appendMessage("    - Reading flip-dye pair(s) ...", Constant.green_1);
                            try {
                                fOpener = new FileOpener(currentCall);
                                this.pairsInCW = fOpener.getPairsCW();
                                this.messagePane.appendMessageInLine(" Done!", Constant.brown);
                                break block181;
                            }
                            catch (OutOfMemoryError ex) {
                                this.messagePane.appendMessage("    Error occurred! Out of memory when reading " + FileOpener.badFileName + ".", Color.red);
                                AlertDialogPane aPane6 = new AlertDialogPane(1, "System out of memory : " + FileOpener.badFileName);
                                this.reportError(ex.toString());
                                ex.printStackTrace();
                                break;
                            }
                            catch (EmptyPairListException ex) {
                                this.messagePane.appendMessage("    Error occurred!  File pair(s) not specified yet.", Color.red);
                                aPane3 = new AlertDialogPane(1, "Please specify flip dye file pair(s) ");
                                this.reportError(ex.toString());
                                ex.printStackTrace();
                                break;
                            }
                            catch (UnevenSizePairException ex) {
                                this.messagePane.appendMessage("    Error occurred!  Uneven spots number detected in the two files of pair.\n    " + FileOpener.badFileName, Color.red);
                                aPane4 = new AlertDialogPane(1, "Uneven spots number detected in the two files of a pair : \n" + FileOpener.badFileName);
                                ex.printStackTrace();
                                break;
                            }
                            catch (FileNotFoundException ex) {
                                this.messagePane.appendMessage("    Error occurred! " + FileOpener.badFileName + " cannot be found.", Color.red);
                                aPane2 = new AlertDialogPane(1, "The data file you specified does not exisit : " + FileOpener.badFileName);
                                this.reportError(ex.toString());
                                ex.printStackTrace();
                                break;
                            }
                            catch (NumberFormatException ex) {
                                this.messagePane.appendMessage("    Error occurred! " + FileOpener.badFileName + " has illegal format.", Color.red);
                                aPane = new AlertDialogPane(1, "Data file has illegal format : " + FileOpener.badFileName);
                                this.reportError(ex.toString());
                                ex.printStackTrace();
                                break;
                            }
                            catch (BkgdInfoMissingException ex) {
                                this.messagePane.appendMessage("    Error occurred! " + FileOpener.badFileName + " Missing background information.", Color.red);
                                AlertDialogPane aPane7 = new AlertDialogPane(1, "Please specify background columns for both Cy3 and Cy5 : " + FileOpener.badFileName);
                                this.reportError(ex.toString());
                                ex.printStackTrace();
                                break;
                            }
                            catch (Exception ex) {
                                this.messagePane.appendMessage("    Error occurred when reading " + FileOpener.badFileName + " Please check error file under project folder.", Color.red);
                                AlertDialogPane aPane8 = new AlertDialogPane(1, "Error occurred : " + FileOpener.badFileName);
                                this.reportError(ex.toString());
                                ex.printStackTrace();
                                break;
                            }
                        }
                        if (currentCall == 2) {
                            fpd = 2;
                            this.messagePane.appendMessage("    - Reading files under " + Parameter.pFolderStr + " ...", Constant.green_1);
                            try {
                                fOpener = new FileOpener(currentCall);
                                this.folderCW = fOpener.getFolderCW();
                                int k = 0;
                                while (k < Parameter.pFolderFilesVec.size()) {
                                    String inFileName = Parameter.pFolderFilesVec.elementAt(k).toString();
                                    String s = inFileName.substring(inFileName.lastIndexOf(FileBrowser.fsep) + 1, inFileName.length());
                                    String outFileName = this.proj.getProjPath() + s.substring(0, s.length() - 4) + "_MDS" + s.substring(s.length() - 4, s.length());
                                    try {
                                        PrintStream testOut = new PrintStream(new FileOutputStream(new File(outFileName)));
                                        testOut.close();
                                    }
                                    catch (FileNotFoundException ex) {
                                        AlertDialogPane aPane9 = new AlertDialogPane(1, "Midas will generate output file in the format of \"RawDataFile_MDS\". \nCurrently an old version of the output file in your project folder is used by another application. \nPlease close that application first : " + outFileName);
                                        break block84;
                                    }
                                    ++k;
                                }
                                this.messagePane.appendMessageInLine(" Done!", Constant.brown);
                                break block181;
                            }
                            catch (OutOfMemoryError ex) {
                                this.messagePane.appendMessage("    Error occurred! Out of memory when reading " + FileOpener.badFileName + ".", Color.red);
                                AlertDialogPane aPane10 = new AlertDialogPane(1, "System out of memory : " + FileOpener.badFileName);
                                this.reportError(ex.toString());
                                ex.printStackTrace();
                                break;
                            }
                            catch (FileNotFoundException ex) {
                                this.messagePane.appendMessage("    Error occurred! " + FileOpener.badFileName + " cannot be found.", Color.red);
                                aPane3 = new AlertDialogPane(1, "The data file you specified does not exisit : " + FileOpener.badFileName);
                                this.reportError(ex.toString());
                                ex.printStackTrace();
                                break;
                            }
                            catch (NumberFormatException ex) {
                                this.messagePane.appendMessage("    Error occurred! " + FileOpener.badFileName + " has illegal format.", Color.red);
                                aPane4 = new AlertDialogPane(1, "Data file has illegal format : " + FileOpener.badFileName);
                                this.reportError(ex.toString());
                                ex.printStackTrace();
                                break;
                            }
                            catch (BkgdInfoMissingException ex) {
                                this.messagePane.appendMessage("    Error occurred! " + FileOpener.badFileName + " Missing background information.", Color.red);
                                aPane2 = new AlertDialogPane(1, "Please specify background columns for both Cy3 and Cy5 : " + FileOpener.badFileName);
                                this.reportError(ex.toString());
                                ex.printStackTrace();
                                break;
                            }
                            catch (Exception ex) {
                                this.messagePane.appendMessage("    Error occurred! when reading " + FileOpener.badFileName + " Please check error file under project folder.", Color.red);
                                aPane = new AlertDialogPane(1, "Error occurred : " + FileOpener.badFileName);
                                this.reportError(ex.toString());
                                ex.printStackTrace();
                                break;
                            }
                        }
                        if (currentCall == 12) {
                            this.messagePane.appendMessage("    - Performing Total Intensity Normalization ...", Constant.green_1);
                            try {
                                if (fpd == 0) {
                                    totInt = new TotInt(this.fileCW, Parameter.pRefStr, false);
                                    this.fileCW = totInt.getFileTotIntColumnWorker();
                                } else if (fpd == 1) {
                                    if (afterFlipDye) {
                                        batchTotInt = new BatchTotInt(this.pairsOutCW, Parameter.pRefStr, false);
                                        this.pairsOutCW = batchTotInt.getFolderTotIntColumnWorker();
                                    } else {
                                        pairsTotInt = new PairsTotInt(this.pairsInCW, Parameter.pRefStr, false);
                                        this.pairsInCW = pairsTotInt.getPairsTotIntColumnWorker();
                                    }
                                } else if (fpd == 2) {
                                    batchTotInt = new BatchTotInt(this.folderCW, Parameter.pRefStr, false);
                                    this.folderCW = batchTotInt.getFolderTotIntColumnWorker();
                                }
                                this.messagePane.appendMessageInLine(" Done!", Constant.brown);
                                break block181;
                            }
                            catch (OutOfMemoryError ex) {
                                this.messagePane.appendMessage("    Error occurred! Out of memory when working on " + FileOpener.badFileName + ".", Color.red);
                                AlertDialogPane aPane11 = new AlertDialogPane(1, "System out of memory : " + FileOpener.badFileName);
                                this.reportError(ex.toString());
                                ex.printStackTrace();
                                break;
                            }
                            catch (Exception ex) {
                                this.messagePane.appendMessage("    Error occurred! Please check error file under project folder.", Color.red);
                                aPane3 = new AlertDialogPane(1, "Error occurred when performing Total Intensity normalization : " + FileOpener.badFileName);
                                ex.printStackTrace();
                                break;
                            }
                        }
                        if (currentCall == 11) {
                            this.messagePane.appendMessage("    - Performing Locfit(Lowess) normalization ...", Constant.green_1);
                            try {
                                BatchLocfit batchLocfit;
                                if (fpd == 0) {
                                    Locfit locfit = new Locfit(this.fileCW, Parameter.pSmoothParaVal, Parameter.pLocfitModeStr, Parameter.pRefStr);
                                    this.fileCW = locfit.getFileLocfitColumnWorker();
                                } else if (fpd == 1) {
                                    if (afterFlipDye) {
                                        batchLocfit = new BatchLocfit(this.pairsOutCW, Parameter.pSmoothParaVal, Parameter.pLocfitModeStr, Parameter.pRefStr);
                                        this.pairsOutCW = batchLocfit.getFolderLocfitColumnWorker();
                                    } else {
                                        PairsLocfit pairsLocfit = new PairsLocfit(this.pairsInCW, Parameter.pSmoothParaVal, Parameter.pLocfitModeStr, Parameter.pRefStr);
                                        this.pairsInCW = pairsLocfit.getPairsLocfitColumnWorker();
                                    }
                                } else if (fpd == 2) {
                                    batchLocfit = new BatchLocfit(this.folderCW, Parameter.pSmoothParaVal, Parameter.pLocfitModeStr, Parameter.pRefStr);
                                    this.folderCW = batchLocfit.getFolderLocfitColumnWorker();
                                }
                                this.messagePane.appendMessageInLine(" Done!", Constant.brown);
                                break block181;
                            }
                            catch (OutOfMemoryError ex) {
                                this.messagePane.appendMessage("    Error occurred! Out of memory when working on " + FileOpener.badFileName + ".", Color.red);
                                AlertDialogPane aPane12 = new AlertDialogPane(1, "System out of memory : " + FileOpener.badFileName);
                                this.reportError(ex.toString());
                                ex.printStackTrace();
                                break;
                            }
                            catch (Exception ex) {
                                this.messagePane.appendMessage("    Error occurred! Please check error file under project folder.", Color.red);
                                aPane3 = new AlertDialogPane(1, "Error occurred when performing Locfit(Lowess) normalization : " + FileOpener.badFileName);
                                this.reportError(ex.toString());
                                ex.printStackTrace();
                                break;
                            }
                        }
                        if (currentCall == 15) {
                            this.messagePane.appendMessage("    - Performing Iterative Linear Regression ...", Constant.green_1);
                            try {
                                BatchIterLinReg batchIterLinReg;
                                if (fpd == 0) {
                                    IterativeLinReg iterLinReg = new IterativeLinReg(this.fileCW, Parameter.pIterLinRegSDRangeVal, Parameter.pIterLinRegModeStr, Parameter.pRefStr);
                                    this.fileCW = iterLinReg.getIterLinRegColumnWorker();
                                } else if (fpd == 1) {
                                    if (afterFlipDye) {
                                        batchIterLinReg = new BatchIterLinReg(this.pairsOutCW, Parameter.pIterLinRegSDRangeVal, Parameter.pIterLinRegModeStr, Parameter.pRefStr);
                                    } else {
                                        PairsIterLinReg pairsIterLinReg = new PairsIterLinReg(this.pairsInCW, Parameter.pIterLinRegSDRangeVal, Parameter.pIterLinRegModeStr, Parameter.pRefStr);
                                        this.pairsInCW = pairsIterLinReg.getPairsIterLinRegColumnWorker();
                                    }
                                } else if (fpd == 2) {
                                    batchIterLinReg = new BatchIterLinReg(this.folderCW, Parameter.pIterLinRegSDRangeVal, Parameter.pIterLinRegModeStr, Parameter.pRefStr);
                                    this.folderCW = batchIterLinReg.getFolderIterLinRegColumnWorker();
                                }
                                this.messagePane.appendMessageInLine(" Done!", Constant.brown);
                                break block181;
                            }
                            catch (OutOfMemoryError ex) {
                                this.messagePane.appendMessage("    Error occurred! Out of memory when working on " + FileOpener.badFileName + ".", Color.red);
                                AlertDialogPane aPane13 = new AlertDialogPane(1, "System out of memory : " + FileOpener.badFileName);
                                this.reportError(ex.toString());
                                ex.printStackTrace();
                                break;
                            }
                            catch (Exception ex) {
                                this.messagePane.appendMessage("    Error occurred! Please check error file under project folder.", Color.red);
                                aPane3 = new AlertDialogPane(1, "Error occurred when performing Iterative Log Mean Centering. : " + FileOpener.badFileName);
                                this.reportError(ex.toString());
                                ex.printStackTrace();
                                break;
                            }
                        }
                        if (currentCall == 14) {
                            this.messagePane.appendMessage("    - Performing Iterative Log Mean Centering ...", Constant.green_1);
                            try {
                                BatchIterLogMean batchIterLogMean;
                                if (fpd == 0) {
                                    IterativeLogMean iterLogMean = new IterativeLogMean(this.fileCW, Parameter.pIterLogMeanSDRangeVal, Parameter.pRefStr);
                                    this.fileCW = iterLogMean.getIterLogMeanColumnWorker();
                                } else if (fpd == 1) {
                                    if (afterFlipDye) {
                                        batchIterLogMean = new BatchIterLogMean(this.pairsOutCW, Parameter.pIterLogMeanSDRangeVal, Parameter.pRefStr);
                                        this.pairsOutCW = batchIterLogMean.getFolderIterLogMeanColumnWorker();
                                    } else {
                                        PairsIterLogMean pairsIterLogMean = new PairsIterLogMean(this.pairsInCW, Parameter.pIterLogMeanSDRangeVal, Parameter.pRefStr);
                                        this.pairsInCW = pairsIterLogMean.getPairsIterLogMeanColumnWorker();
                                    }
                                } else if (fpd == 2) {
                                    batchIterLogMean = new BatchIterLogMean(this.folderCW, Parameter.pIterLogMeanSDRangeVal, Parameter.pRefStr);
                                    this.folderCW = batchIterLogMean.getFolderIterLogMeanColumnWorker();
                                }
                                this.messagePane.appendMessageInLine(" Done!", Constant.brown);
                                break block181;
                            }
                            catch (OutOfMemoryError ex) {
                                this.messagePane.appendMessage("    Error occurred! Out of memory when working on " + FileOpener.badFileName + ".", Color.red);
                                AlertDialogPane aPane14 = new AlertDialogPane(1, "System out of memory : " + FileOpener.badFileName);
                                this.reportError(ex.toString());
                                ex.printStackTrace();
                                break;
                            }
                            catch (Exception ex) {
                                this.messagePane.appendMessage("    Error occurred! Please check error file under project folder.", Color.red);
                                aPane3 = new AlertDialogPane(1, "Error occurred when performing Iterative Log Mean Centering. : " + FileOpener.badFileName);
                                this.reportError(ex.toString());
                                ex.printStackTrace();
                                break;
                            }
                        }
                        if (currentCall == 16) {
                            this.messagePane.appendMessage("    - Performing Ratio Statistics ...", Constant.green_1);
                            try {
                                BatchRatioStats batchRatioStats;
                                if (fpd == 0) {
                                    RatioStats ratioStats = new RatioStats(this.fileCW, Parameter.pRatioStatsCIChkOpt, Parameter.pRatioStatsCIVal, Parameter.pRefStr);
                                    this.fileCW = ratioStats.getRatioStatsColumnWorker();
                                } else if (fpd == 1) {
                                    if (afterFlipDye) {
                                        batchRatioStats = new BatchRatioStats(this.pairsOutCW, Parameter.pRatioStatsCIChkOpt, Parameter.pRatioStatsCIVal, Parameter.pRefStr);
                                        this.pairsOutCW = batchRatioStats.getFolderRatioStatsColumnWorker();
                                    } else {
                                        PairsRatioStats pairsRatioStats = new PairsRatioStats(this.pairsInCW, Parameter.pRatioStatsCIChkOpt, Parameter.pRatioStatsCIVal, Parameter.pRefStr);
                                        this.pairsInCW = pairsRatioStats.getPairsRatioStatsColumnWorker();
                                    }
                                } else if (fpd == 2) {
                                    batchRatioStats = new BatchRatioStats(this.folderCW, Parameter.pRatioStatsCIChkOpt, Parameter.pRatioStatsCIVal, Parameter.pRefStr);
                                    this.folderCW = batchRatioStats.getFolderRatioStatsColumnWorker();
                                }
                                this.messagePane.appendMessageInLine(" Done!", Constant.brown);
                                break block181;
                            }
                            catch (OutOfMemoryError ex) {
                                this.messagePane.appendMessage("    Error occurred! Out of memory when working on " + FileOpener.badFileName + ".", Color.red);
                                AlertDialogPane aPane15 = new AlertDialogPane(1, "System out of memory : " + FileOpener.badFileName);
                                this.reportError(ex.toString());
                                ex.printStackTrace();
                                break;
                            }
                            catch (Exception ex) {
                                this.messagePane.appendMessage("    Error occurred! Please check error file under project folder.", Color.red);
                                aPane3 = new AlertDialogPane(1, "Error occurred when performing Intensity Filter : " + FileOpener.badFileName);
                                this.reportError(ex.toString());
                                ex.printStackTrace();
                                break;
                            }
                        }
                        if (currentCall == 13) {
                            this.messagePane.appendMessage("    - Performing SD-regularization ...", Constant.green_1);
                            try {
                                BatchVariReg batchVariReg;
                                if (fpd == 0) {
                                    VariReg variReg = new VariReg(this.fileCW, Parameter.pRefStr);
                                    this.fileCW = variReg.getFileVariRegColumnWorker();
                                } else if (fpd == 1) {
                                    if (afterFlipDye) {
                                        batchVariReg = new BatchVariReg(this.pairsOutCW, Parameter.pBlockSDRegOpt, Parameter.pSlideSDRegOpt, Parameter.pRefStr);
                                        this.pairsOutCW = batchVariReg.getFolderVariRegColumnWorker();
                                    } else {
                                        PairsVariReg pairsVariReg = new PairsVariReg(this.pairsInCW, Parameter.pBlockSDRegOpt, Parameter.pSlideSDRegOpt, Parameter.pRefStr);
                                        this.pairsInCW = pairsVariReg.getPairsVariRegColumnWorker();
                                    }
                                } else if (fpd == 2) {
                                    batchVariReg = new BatchVariReg(this.folderCW, Parameter.pBlockSDRegOpt, Parameter.pSlideSDRegOpt, Parameter.pRefStr);
                                    this.folderCW = batchVariReg.getFolderVariRegColumnWorker();
                                }
                                this.messagePane.appendMessageInLine(" Done!", Constant.brown);
                                break block181;
                            }
                            catch (OutOfMemoryError ex) {
                                this.messagePane.appendMessage("    Error occurred! Out of memory when working on " + FileOpener.badFileName + ".", Color.red);
                                AlertDialogPane aPane16 = new AlertDialogPane(1, "System out of memory : " + FileOpener.badFileName);
                                this.reportError(ex.toString());
                                ex.printStackTrace();
                                break;
                            }
                            catch (Exception ex) {
                                this.messagePane.appendMessage("    Error occurred! Please check error file under project folder.", Color.red);
                                aPane3 = new AlertDialogPane(1, "Error occurred when performing Intensity Filter : " + FileOpener.badFileName);
                                this.reportError(ex.toString());
                                ex.printStackTrace();
                                break;
                            }
                        }
                        if (currentCall == 10) {
                            this.messagePane.appendMessage("    - Performing Low Intensity Filter ...", Constant.green_1);
                            try {
                                if (fpd == 0) {
                                    totInt = new TotInt(this.fileCW, Parameter.pRefStr, true);
                                    this.fileCW = totInt.getFileTotIntColumnWorker();
                                } else if (fpd == 1) {
                                    if (afterFlipDye) {
                                        batchTotInt = new BatchTotInt(this.pairsOutCW, Parameter.pRefStr, true);
                                        this.pairsOutCW = batchTotInt.getFolderTotIntColumnWorker();
                                    } else {
                                        pairsTotInt = new PairsTotInt(this.pairsInCW, Parameter.pRefStr, true);
                                        this.pairsInCW = pairsTotInt.getPairsTotIntColumnWorker();
                                    }
                                } else if (fpd == 2) {
                                    batchTotInt = new BatchTotInt(this.folderCW, Parameter.pRefStr, true);
                                    this.folderCW = batchTotInt.getFolderTotIntColumnWorker();
                                }
                                this.messagePane.appendMessageInLine(" Done!", Constant.brown);
                                break block181;
                            }
                            catch (OutOfMemoryError ex) {
                                this.messagePane.appendMessage("    Error occurred! Out of memory when working on " + FileOpener.badFileName + ".", Color.red);
                                AlertDialogPane aPane17 = new AlertDialogPane(1, "System out of memory : " + FileOpener.badFileName);
                                this.reportError(ex.toString());
                                ex.printStackTrace();
                                break;
                            }
                            catch (Exception ex) {
                                this.messagePane.appendMessage("    Error occurred! Please check error file under project folder.", Color.red);
                                aPane3 = new AlertDialogPane(1, "Error occurred when performing Intensity Filter : " + FileOpener.badFileName);
                                this.reportError(ex.toString());
                                ex.printStackTrace();
                                break;
                            }
                        }
                        if (currentCall == 20) {
                            this.messagePane.appendMessage("    - Performing Slice Analysis ...", Constant.green_1);
                            try {
                                BatchSliceAnalysis batchSA;
                                if (fpd == 0) {
                                    SliceAnalysis sa = new SliceAnalysis(this.fileCW, Parameter.pSliceDataPopVal, Parameter.pSliceDataRangeLtVal, Parameter.pSliceDataRangeGtVal);
                                    this.fileCW = sa.getFileSAColumnWorker();
                                } else if (fpd == 1) {
                                    if (afterFlipDye) {
                                        batchSA = new BatchSliceAnalysis(this.pairsOutCW, Parameter.pSliceDataPopVal, Parameter.pSliceDataRangeLtVal, Parameter.pSliceDataRangeGtVal);
                                        this.pairsOutCW = batchSA.getFolderSAColumnWorker();
                                    } else {
                                        PairsSliceAnalysis pairsSA = new PairsSliceAnalysis(this.pairsInCW, Parameter.pSliceDataPopVal, Parameter.pSliceDataRangeLtVal, Parameter.pSliceDataRangeGtVal);
                                        this.pairsInCW = pairsSA.getPairsSAColumnWorker();
                                    }
                                } else if (fpd == 2) {
                                    batchSA = new BatchSliceAnalysis(this.folderCW, Parameter.pSliceDataPopVal, Parameter.pSliceDataRangeLtVal, Parameter.pSliceDataRangeGtVal);
                                    this.folderCW = batchSA.getFolderSAColumnWorker();
                                }
                                this.messagePane.appendMessageInLine(" Done!", Constant.brown);
                                break block181;
                            }
                            catch (OutOfMemoryError ex) {
                                this.messagePane.appendMessage("    Error occurred! Out of memory when working on " + FileOpener.badFileName + ".", Color.red);
                                AlertDialogPane aPane18 = new AlertDialogPane(1, "System out of memory : " + FileOpener.badFileName);
                                this.reportError(ex.toString());
                                ex.printStackTrace();
                                break;
                            }
                            catch (SAInvalidSliceWindowDataPopulation ex) {
                                this.messagePane.appendMessage("    Error occurred! Please check error file under project folder.", Color.red);
                                aPane3 = new AlertDialogPane(1, "Slice Data Population is too big, try a smaller number : " + FileOpener.badFileName);
                                this.reportError(ex.toString());
                                ex.printStackTrace();
                                break;
                            }
                            catch (SA_CantComputeSliceMeanSD ex) {
                                this.messagePane.appendMessage("    Error occurred! Please check error file under project folder.", Color.red);
                                aPane4 = new AlertDialogPane(1, "Can't compute mean or standard deviation for slices : " + FileOpener.badFileName);
                                this.reportError(ex.toString());
                                ex.printStackTrace();
                                break;
                            }
                            catch (Exception ex) {
                                this.messagePane.appendMessage("    Error occurred! Please check error file under project folder.", Color.red);
                                aPane2 = new AlertDialogPane(1, "Error occurred when performing Slice Analysis : " + FileOpener.badFileName);
                                this.reportError(ex.toString());
                                ex.printStackTrace();
                                break;
                            }
                        }
                        if (currentCall == 30) {
                            this.messagePane.appendMessage("    - Performing In-slide Replicates Analysis ...", Constant.green_1);
                            try {
                                if (fpd == 0) {
                                    InReplicatesAnalysis ra;
                                    if (Parameter.pIdentifierCol instanceof String) {
                                        ra = new InReplicatesAnalysis(this.fileCW, Parameter.pIdentifierCol.toString());
                                        this.fileCW = ra.getFileRAColumnWorker();
                                    } else {
                                        ra = new InReplicatesAnalysis(this.fileCW, (Integer)Parameter.pIdentifierCol);
                                        this.fileCW = ra.getFileRAColumnWorker();
                                    }
                                } else if (fpd == 1) {
                                    System.out.println("This should never happen, Replicates analysis never applies on pairs");
                                } else if (fpd == 2) {
                                    BatchInReplicatesAnalysis batchInRA = new BatchInReplicatesAnalysis(this.folderCW, Parameter.pIdentifierCol);
                                    this.folderCW = batchInRA.getFolderInRAColumnWorker();
                                }
                                this.messagePane.appendMessageInLine(" Done!", Constant.brown);
                                break block181;
                            }
                            catch (OutOfMemoryError ex) {
                                this.messagePane.appendMessage("    Error occurred! Out of memory when working on " + FileOpener.badFileName + ".", Color.red);
                                AlertDialogPane aPane19 = new AlertDialogPane(1, "System out of memory : " + FileOpener.badFileName);
                                this.reportError(ex.toString());
                                ex.printStackTrace();
                                break;
                            }
                            catch (Exception ex) {
                                this.messagePane.appendMessage("    Error occurred! Please check error file under project folder.", Color.red);
                                aPane3 = new AlertDialogPane(1, "Error occurred when performing In-slide Replicates Analysis : " + FileOpener.badFileName);
                                this.reportError(ex.toString());
                                ex.printStackTrace();
                                break;
                            }
                        }
                        if (currentCall == 32) {
                            this.messagePane.appendMessage("    - Performing Cross-Slide Replicates T-test ...", Constant.green_1);
                            try {
                                if (fpd != 0 && fpd != 1) {
                                    Ttest ttest = new Ttest(this.folderCW, Parameter.pTtestHypoMean, Parameter.pTtestPValBase, Parameter.pTtestAlpha, Parameter.pTtestSigMethod);
                                    this.folderCW = ttest.getOneClassTtestColumnWorker();
                                }
                                this.messagePane.appendMessageInLine(" Done!", Constant.brown);
                                break block181;
                            }
                            catch (OutOfMemoryError ex) {
                                this.messagePane.appendMessage("    Error occurred! Out of memory when working on " + FileOpener.badFileName + ".", Color.red);
                                AlertDialogPane aPane20 = new AlertDialogPane(1, "System out of memory : " + FileOpener.badFileName);
                                this.reportError(ex.toString());
                                ex.printStackTrace();
                                break;
                            }
                            catch (Exception ex) {
                                this.messagePane.appendMessage("    Error occurred! Please check error file under project folder.", Color.red);
                                aPane3 = new AlertDialogPane(1, "Error occurred when performing Cross-slide Ttest ");
                                this.reportError(ex.toString());
                                ex.printStackTrace();
                                break;
                            }
                        }
                        if (currentCall == 33) {
                            this.messagePane.appendMessage("    - Performing Cross-Slide one-class SAM...", Constant.green_1);
                            try {
                                if (fpd != 0 && fpd != 1) {
                                    SAM sam = new SAM(this.folderCW, Parameter.pTtestHypoMean, Parameter.pSAMAllUniquePerm, Parameter.pSAMPermutationsNumber, Parameter.pSAMS0Method, Parameter.pSAMImputationEngine, Parameter.pSAMNearestNeighborsNumber);
                                    this.folderCW = sam.getOneClassSAMColumnWorker();
                                }
                                this.messagePane.appendMessageInLine(" Done!", Constant.brown);
                                break block181;
                            }
                            catch (OutOfMemoryError ex) {
                                this.messagePane.appendMessage("    Error occurred! Out of memory when working on " + FileOpener.badFileName + ".", Color.red);
                                AlertDialogPane aPane21 = new AlertDialogPane(1, "System out of memory : " + FileOpener.badFileName);
                                this.reportError(ex.toString());
                                ex.printStackTrace();
                                break;
                            }
                            catch (Exception ex) {
                                this.messagePane.appendMessage("    Error occurred! Please check error file under project folder.", Color.red);
                                aPane3 = new AlertDialogPane(1, "Error occurred when performing Cross-slide One-class SAM ");
                                this.reportError(ex.toString());
                                ex.printStackTrace();
                                break;
                            }
                        }
                        if (currentCall == 41) {
                            this.messagePane.appendMessage("    - Performing MAANOVA ...", Constant.green_1);
                            try {
                                if (fpd != 0 && fpd != 1) {
                                    MaAnova MA = new MaAnova(this.folderCW);
                                }
                                this.messagePane.appendMessageInLine(" Done!", Constant.brown);
                                break block181;
                            }
                            catch (OutOfMemoryError ex) {
                                this.messagePane.appendMessage("    Error occurred! Out of memory when working on " + FileOpener.badFileName + ".", Color.red);
                                AlertDialogPane aPane22 = new AlertDialogPane(1, "System out of memory : " + FileOpener.badFileName);
                                this.reportError(ex.toString());
                                ex.printStackTrace();
                                break;
                            }
                            catch (Exception ex) {
                                this.messagePane.appendMessage("    Error occurred! Please check error file under project folder.", Color.red);
                                aPane3 = new AlertDialogPane(1, "Error occurred when performing MA-ANOVA : \n" + FileOpener.badFileName);
                                this.reportError(ex.toString());
                                ex.printStackTrace();
                                break;
                            }
                        }
                        if (currentCall == 40) {
                            this.messagePane.appendMessage("    - Performing Flip-Dye Consistency Checking ...", Constant.green_1);
                            try {
                                if (fpd != 0 && fpd == 1) {
                                    FlipDye flipDye = new FlipDye(this.pairsInCW, Parameter.pFlipdyeCutOptionStr, Parameter.pFlipdyeDataKeepRangeVal);
                                    this.pairsOutCW = flipDye.getFlipDyeColumnWorker();
                                    afterFlipDye = true;
                                }
                                this.messagePane.appendMessageInLine(" Done!", Constant.brown);
                                break block181;
                            }
                            catch (OutOfMemoryError ex) {
                                this.messagePane.appendMessage("    Error occurred! Out of memory when working on " + FileOpener.badFileName + ".", Color.red);
                                AlertDialogPane aPane23 = new AlertDialogPane(1, "System out of memory : \n" + FileOpener.badFileName);
                                this.reportError(ex.toString());
                                ex.printStackTrace();
                                break;
                            }
                            catch (Exception ex) {
                                this.messagePane.appendMessage("    Error occurred! Please check error file under project folder.", Color.red);
                                aPane3 = new AlertDialogPane(1, "Error occurred when performing Flip Dye Consistency Checking and Trim : \n" + FileOpener.badFileName);
                                this.reportError(ex.toString());
                                ex.printStackTrace();
                                break;
                            }
                        }
                        if (currentCall == 100) {
                            FileBuilder fBuilder;
                            this.messagePane.appendMessage("    - Writing output file(s) ...", Constant.green_1);
                            if (fpd == 0) {
                                try {
                                    fBuilder = new FileBuilder(this.fileCW);
                                    this.messagePane.appendMessageInLine(" Done!", Constant.brown);
                                    break block181;
                                }
                                catch (OutOfMemoryError ex) {
                                    this.messagePane.appendMessage("    Error occurred! Out of memory when writing outputs for " + FileBuilder.badFileName + ".", Color.red);
                                    AlertDialogPane aPane24 = new AlertDialogPane(1, "System out of memory " + FileBuilder.badFileName + ".");
                                    this.reportError(ex.toString());
                                    ex.printStackTrace();
                                    break;
                                }
                                catch (FileNotFoundException ex) {
                                    this.messagePane.appendMessage("    Error occurred! " + FileBuilder.badFileName + " cannot be found.", Color.red);
                                    aPane3 = new AlertDialogPane(1, "The data file you specified does not exisit " + FileBuilder.badFileName + ".");
                                    this.reportError(ex.toString());
                                    ex.printStackTrace();
                                    break block181;
                                }
                                catch (NumberFormatException ex) {
                                    this.messagePane.appendMessage("    Error occurred! " + FileBuilder.badFileName + " has illegal format.", Color.red);
                                    aPane4 = new AlertDialogPane(1, "Data file has illegal format : " + FileBuilder.badFileName);
                                    this.reportError(ex.toString());
                                    ex.printStackTrace();
                                    break;
                                }
                                catch (Exception ex) {
                                    this.messagePane.appendMessage("    Error occurred! Please check error file under project folder.", Color.red);
                                    aPane2 = new AlertDialogPane(1, "Error occurred : " + FileBuilder.badFileName);
                                    this.reportError(ex.toString());
                                    ex.printStackTrace();
                                    break;
                                }
                            }
                            if (fpd == 1) {
                                try {
                                    fBuilder = new FileBuilder(this.pairsOutCW, "dummy");
                                    this.messagePane.appendMessageInLine(" Done!", Constant.brown);
                                    break block181;
                                }
                                catch (OutOfMemoryError ex) {
                                    this.messagePane.appendMessage("    Error occurred! Out of memory when writing outputs for " + FileBuilder.badFileName + ".", Color.red);
                                    AlertDialogPane aPane25 = new AlertDialogPane(1, "System out of memory : " + FileBuilder.badFileName);
                                    this.reportError(ex.toString());
                                    ex.printStackTrace();
                                    break;
                                }
                                catch (FileNotFoundException ex) {
                                    this.messagePane.appendMessage("    Error occurred! " + FileBuilder.badFileName + " cannot be found.", Color.red);
                                    aPane3 = new AlertDialogPane(1, "The data file you specified does not exisit : " + FileBuilder.badFileName);
                                    this.reportError(ex.toString());
                                    ex.printStackTrace();
                                    break block181;
                                }
                                catch (NumberFormatException ex) {
                                    this.messagePane.appendMessage("    Error occurred! " + FileBuilder.badFileName + " has illegal format.", Color.red);
                                    aPane4 = new AlertDialogPane(1, "Data file has illegal format : " + FileBuilder.badFileName);
                                    this.reportError(ex.toString());
                                    ex.printStackTrace();
                                    break;
                                }
                                catch (Exception ex) {
                                    this.messagePane.appendMessage("    Error occurred! Please check error file under project folder.", Color.red);
                                    aPane2 = new AlertDialogPane(1, "Error occurred : " + FileBuilder.badFileName);
                                    this.reportError(ex.toString());
                                    ex.printStackTrace();
                                    break;
                                }
                            }
                            if (fpd == 2) {
                                try {
                                    fBuilder = new FileBuilder(this.folderCW);
                                    this.messagePane.appendMessageInLine(" Done!", Constant.brown);
                                }
                                catch (OutOfMemoryError ex) {
                                    this.messagePane.appendMessage("    Error occurred! Out of memory when writing outputs for " + FileBuilder.badFileName + ".", Color.red);
                                    AlertDialogPane aPane26 = new AlertDialogPane(1, "System out of memory : " + FileBuilder.badFileName);
                                    this.reportError(ex.toString());
                                    ex.printStackTrace();
                                    break;
                                }
                                catch (FileNotFoundException ex) {
                                    this.messagePane.appendMessage("    Error occurred! " + FileBuilder.badFileName + " cannot be found.", Color.red);
                                    aPane3 = new AlertDialogPane(1, "The data file you specified does not exisit : " + FileBuilder.badFileName);
                                    this.reportError(ex.toString());
                                    ex.printStackTrace();
                                }
                                catch (NumberFormatException ex) {
                                    this.messagePane.appendMessage("    Error occurred! " + FileBuilder.badFileName + " has illegal format.", Color.red);
                                    aPane4 = new AlertDialogPane(1, "Data file has illegal format : " + FileBuilder.badFileName);
                                    this.reportError(ex.toString());
                                    ex.printStackTrace();
                                    break;
                                }
                                catch (Exception ex) {
                                    this.messagePane.appendMessage("    Error occurred! Please check error file under project folder.", Color.red);
                                    aPane2 = new AlertDialogPane(1, "Error occurred : " + FileBuilder.badFileName);
                                    this.reportError(ex.toString());
                                    ex.printStackTrace();
                                    break;
                                }
                            }
                        }
                    }
                }
                ++step;
            }
            this.proj.setStopDate();
            if (!this.canceled) {
                if (this.proj.getTxtReportOption()) {
                    this.messagePane.appendMessage("    - Preparing TXT analysis report ...", Constant.green_1);
                    PrepareTXTReport prepareTXTReport = new PrepareTXTReport(this.proj);
                    this.messagePane.appendMessageInLine(" Done!", Constant.brown);
                }
                if (this.proj.getPdfReportOption()) {
                    this.messagePane.appendMessage("    - Preparing PDF analysis report ...", Constant.green_1);
                    PreparePDFReport preparePDFReport = new PreparePDFReport(this.proj);
                    this.messagePane.appendMessageInLine(" Done!", Constant.brown);
                }
                this.refreshMessageHolderPane(3);
                IconBar.stopButton.setEnabled(false);
                System.out.println("*******************************************************");
                System.out.println("                   Process finished                    ");
                System.out.println("*******************************************************");
            }
            System.gc();
        }
        catch (OutOfMemoryError mem) {
            this.messagePane.appendMessage("    Error occurred! Out of memory when creating PDF report.", Color.red);
            Midas.messageHolderPane.pasteMessagePane(this.messagePane);
            Midas.messageHolderPane.pasteIndicatorPane(new AppRunningIndicator(AppRunningIndicator.logoImage));
            Midas.messageHolderPane.validate();
        }
        catch (InterruptedException e) {
            System.out.println("Process interrupted per user request.");
            IconBar.exeButton.setEnabled(true);
        }
        catch (Exception ex) {
            Midas.messageHolderPane.pasteMessagePane(this.messagePane);
            Midas.messageHolderPane.pasteIndicatorPane(new AppRunningIndicator(AppRunningIndicator.logoImage));
            Midas.messageHolderPane.validate();
            ex.printStackTrace();
        }
        if (this.canceled) {
            System.out.println("\nExecution canceled per user's request.\n");
            this.refreshMessageHolderPane(2);
            IconBar.stopButton.setEnabled(true);
            IconBar.exeButton.setEnabled(true);
        }
        return "Good";
    }

    private class StopListener
    implements ActionListener {
        private StopListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            IconBar.stopButton.setEnabled(false);
            Conductor.this.canceled = true;
            AlertDialogPane alertDialogPane = new AlertDialogPane(0, "Per your request, MIDAS will terminate the running process after the current step is finished. \nPlease wait and let current step be finished. The Execution button will turn clickable when ready ");
        }
    }
}

