/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.engine;

import org.tigr.midas.math.MathTools;
import org.tigr.midas.math.QSort;
import org.tigr.midas.math.StatsTools;
import org.tigr.midas.util.ArrayResizer;
import org.tigr.midas.util.BlockFiller;
import org.tigr.midas.util.ColumnWorker;
import org.tigr.midas.util.CyToLogProdRatio;
import org.tigr.midas.util.NegateFlags;

public class DataPrep {
    private int totalRowCount;
    private int nonZeroCount;
    private int zeroCount;
    private boolean[] flag;
    private float[] cy3Column;
    private float[] cy5Column;
    private float[] wholeLogRatio;
    private float[] wholeLogProd;
    private float[] nonZeroLogRatio;
    private float[] nonZeroLogProd;
    private float[] sortedLogProd;
    private float[] newNonZeroLogRatio;
    private int[] nonZeroRawIdx;
    private int[] newNonZeroRawIdx;
    private float[] zScoreVal;
    private CyToLogProdRatio cyTran;
    private float[][] blockLogRatio;

    public DataPrep(ColumnWorker fileCW) {
        this.totalRowCount = fileCW.getRowCounts();
        this.cy3Column = fileCW.getColumnOneArray();
        this.cy5Column = fileCW.getColumnTwoArray();
        this.flag = fileCW.getRowFlagArray();
        this.convert(this.cy3Column, this.cy5Column);
        BlockFiller blockFiller = new BlockFiller(fileCW);
        this.blockLogRatio = new float[blockFiller.getBlockNumber()][];
        int blockNdx = 0;
        while (blockNdx < blockFiller.getBlockNumber()) {
            float[] blockCy3 = blockFiller.getBlockCy3(blockNdx);
            float[] blockCy5 = blockFiller.getBlockCy5(blockNdx);
            int[] rawNdx = blockFiller.getOrigIndex(blockNdx);
            this.blockLogRatio[blockNdx] = new CyToLogProdRatio(blockCy3, blockCy5, rawNdx, this.flag).getLogRatio();
            ++blockNdx;
        }
    }

    public DataPrep(float[] a, float[] b) {
        this.totalRowCount = a.length;
        this.flag = new NegateFlags(new boolean[this.totalRowCount]).getNegateFlag();
        this.convert(a, b);
    }

    private void convert(float[] x, float[] y) {
        this.cyTran = new CyToLogProdRatio(x, y, this.flag);
        this.wholeLogRatio = new float[this.totalRowCount];
        this.nonZeroLogRatio = new float[this.totalRowCount];
        this.wholeLogProd = new float[this.totalRowCount];
        this.nonZeroLogProd = new float[this.totalRowCount];
        this.nonZeroRawIdx = new int[this.totalRowCount];
        this.zScoreVal = new float[this.totalRowCount];
        this.nonZeroCount = 0;
        int rowIndex = 0;
        while (rowIndex < this.totalRowCount) {
            if (x[rowIndex] <= 1.0f || y[rowIndex] <= 1.0f || !this.flag[rowIndex]) {
                x[rowIndex] = 0.0f;
                y[rowIndex] = 0.0f;
                this.wholeLogRatio[rowIndex] = Float.POSITIVE_INFINITY;
                this.wholeLogProd[rowIndex] = 0.0f;
            } else {
                this.wholeLogRatio[rowIndex] = MathTools.log2(y[rowIndex] / x[rowIndex]);
                this.wholeLogProd[rowIndex] = MathTools.log10(y[rowIndex] * x[rowIndex]);
                this.nonZeroLogRatio[this.nonZeroCount] = this.wholeLogRatio[rowIndex];
                this.nonZeroLogProd[this.nonZeroCount] = this.wholeLogProd[rowIndex];
                this.nonZeroRawIdx[this.nonZeroCount] = rowIndex;
                ++this.nonZeroCount;
            }
            ++rowIndex;
        }
        System.out.println("    ---- totalRowCount = " + this.totalRowCount);
        System.out.println("    ---- nonZeroCount = " + this.nonZeroCount);
        StatsTools s = new StatsTools();
        s.computeMeanSD(this.nonZeroLogRatio);
        int goodZCount = 0;
        int rowIndex2 = 0;
        while (rowIndex2 < this.totalRowCount) {
            if (!Float.isInfinite(this.wholeLogRatio[rowIndex2])) {
                this.zScoreVal[goodZCount] = (this.wholeLogRatio[rowIndex2] - s.getXMean()) / s.getXSD();
                ++goodZCount;
            }
            ++rowIndex2;
        }
        System.out.println("    ---- goodZCount = " + goodZCount);
        this.nonZeroLogProd = new ArrayResizer(this.nonZeroLogProd, this.nonZeroCount).getFArray();
        this.nonZeroLogRatio = new ArrayResizer(this.nonZeroLogRatio, this.nonZeroCount).getFArray();
        this.nonZeroRawIdx = new ArrayResizer(this.nonZeroRawIdx, this.nonZeroCount).getIArray();
        this.zScoreVal = new ArrayResizer(this.zScoreVal, goodZCount).getFArray();
        QSort sort = new QSort(this.nonZeroLogProd);
        this.sortedLogProd = sort.getSorted();
        int[] bb = sort.getOrigIndx();
        this.newNonZeroLogRatio = new float[this.sortedLogProd.length];
        this.newNonZeroRawIdx = new int[this.sortedLogProd.length];
        int i = 0;
        while (i < this.sortedLogProd.length) {
            this.newNonZeroLogRatio[i] = this.nonZeroLogRatio[bb[i]];
            this.newNonZeroRawIdx[i] = this.nonZeroRawIdx[bb[i]];
            ++i;
        }
    }

    public int getNonZeroCount() {
        return this.nonZeroCount;
    }

    public float[] getX() {
        return this.cy3Column;
    }

    public float[] getY() {
        return this.cy5Column;
    }

    public float[] getLogX() {
        return this.cyTran.getLogX();
    }

    public float[] getLogY() {
        return this.cyTran.getLogY();
    }

    public float[] getLogProd() {
        return this.sortedLogProd;
    }

    public float[] getLogRatio() {
        return this.newNonZeroLogRatio;
    }

    public int[] getRawNdx() {
        return this.newNonZeroRawIdx;
    }

    public float[] getZscore() {
        return this.zScoreVal;
    }

    public float[][] getBlockLogRatio() {
        return this.blockLogRatio;
    }
}

