/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.engine;

import ExpDesigner.ExpList;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.ObjectInputStream;
import java.io.OptionalDataException;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;
import org.tigr.midas.display.AlertDialogPane;
import org.tigr.midas.display.FlowImagePane;
import org.tigr.midas.display.IconBar;
import org.tigr.midas.display.ParameterPane;
import org.tigr.midas.engine.MaAnovaParameter;
import org.tigr.midas.engine.Parameter;
import org.tigr.midas.util.StringSplitter;

public class ProjOpener {
    private String ver;
    private Vector flowTokenVec = new Vector();
    private Vector paramTokenVec = new Vector();
    private Vector paramPageVec = new Vector();
    private ObjectInputStream s;
    public FlowImagePane flowImagePane = new FlowImagePane();

    public ProjOpener(String prjFileName) throws NumberFormatException, FileNotFoundException, OptionalDataException, Exception {
        this(new File(prjFileName));
    }

    public ProjOpener(File prjFile) throws NumberFormatException, FileNotFoundException, OptionalDataException, Exception {
        try {
            FileInputStream in = new FileInputStream(prjFile);
            this.s = new ObjectInputStream(in);
            String time = "Unkwon";
            String jvm = "Unknown";
            String osn = "Unknown";
            String osv = "Unknown";
            String mem = "Unknown";
            String workingStr = (String)this.s.readObject();
            if (workingStr.startsWith("#MIDAS Project file")) {
                this.s.readObject();
                workingStr = (String)this.s.readObject();
                this.flowUnbundler(workingStr.substring(6));
                this.s.readObject();
                this.s.readObject();
                this.buildFlowAndParamPane();
            } else if (workingStr.startsWith("#MIDAS V")) {
                this.ver = workingStr.substring(8, workingStr.indexOf(" Project"));
                if (workingStr.indexOf("<Date>") > 0) {
                    time = workingStr.substring(workingStr.indexOf("<Date>") + 7, workingStr.indexOf("<JVM>"));
                    jvm = workingStr.substring(workingStr.indexOf("<JVM>") + 6, workingStr.indexOf("<OS>"));
                    osn = workingStr.substring(workingStr.indexOf("<OS>") + 5, workingStr.indexOf("<OS Version>"));
                    osv = workingStr.substring(workingStr.indexOf("<OS Version>") + 13, workingStr.indexOf("<Mem>"));
                    mem = workingStr.substring(workingStr.indexOf("<Mem>") + 6);
                }
                if (Float.parseFloat(this.ver) <= Float.parseFloat("2.19")) {
                    System.out.println("=================================================================");
                    System.out.println("Project Information:");
                    System.out.println("    Created by MIDAS Verison:   " + this.ver);
                    System.out.println("    Created on:                 " + time);
                    System.out.println("    JVM version used:           " + jvm);
                    System.out.println("    OS used:                    " + osn);
                    System.out.println("    OS version used:            " + osv);
                    System.out.println("    Free memory when created:   " + mem);
                    System.out.println("=================================================================");
                    this.s.readObject();
                    workingStr = (String)this.s.readObject();
                    this.flowUnbundler(workingStr.substring(6));
                    this.s.readObject();
                    this.s.readObject();
                    this.buildFlowAndParamPane(this.ver);
                } else {
                    AlertDialogPane aPane = new AlertDialogPane(1, "The project file that you are trying to open was generated by a newer version of MIDAS,\nthan the one you are using. Please upgrade your MIDAS software ");
                }
            } else {
                AlertDialogPane aPane = new AlertDialogPane(1, "Invalid MIDAS prj file. ");
            }
        }
        catch (NullPointerException e) {
        }
        catch (NumberFormatException nex) {
            nex.printStackTrace();
        }
        catch (FileNotFoundException fnex) {
            AlertDialogPane aPane = new AlertDialogPane(1, "The project file you specified does not exisit ");
            throw fnex;
        }
        catch (OptionalDataException opex) {
            throw opex;
        }
        catch (Exception ex) {
            System.out.println("Error occured in ProjOpener.");
            throw ex;
        }
    }

    private void flowUnbundler(String flowStream) {
        StringSplitter st = new StringSplitter(flowStream, '>');
        while (st.hasMoreTokens()) {
            this.flowTokenVec.add(st.nextToken());
        }
    }

    private void buildFlowAndParamPane(String version) throws OptionalDataException, Exception {
        boolean isReadFolder = false;
        try {
            if ((double)Float.parseFloat(this.ver) < 2.18) {
                int i = 0;
                while (i < this.flowTokenVec.size()) {
                    ParameterPane paramPane;
                    int currentToken = Integer.parseInt(this.flowTokenVec.elementAt(i).toString());
                    if (currentToken == 0) {
                        this.flowImagePane.addImage(new ImageIcon(IconBar.readFileImage), i);
                        Parameter.pSingleFileStr = this.s.readObject().toString();
                        Parameter.pOneBadChannelPolicyStr = this.s.readObject().toString();
                        Parameter.pUseCh1FlagOpt = new Boolean(this.s.readBoolean());
                        Parameter.pUseCh2FlagOpt = new Boolean(this.s.readBoolean());
                        if (Parameter.pUseCh1FlagOpt) {
                            Parameter.pUseCh1FlagCol = new Integer(this.s.readInt());
                        }
                        if (Parameter.pUseCh2FlagOpt) {
                            Parameter.pUseCh2FlagCol = new Integer(this.s.readInt());
                        }
                        Parameter.pCh1BkgdOpt = new Boolean(this.s.readBoolean());
                        Parameter.pCh2BkgdOpt = new Boolean(this.s.readBoolean());
                        if (Parameter.pCh1BkgdOpt && Parameter.pCh2BkgdOpt) {
                            Parameter.pCh1BkgdCol = new Integer(this.s.readInt());
                            Parameter.pCh2BkgdCol = new Integer(this.s.readInt());
                            Parameter.pBkgdSNRatioVal = new Double(this.s.readDouble()).floatValue();
                        }
                        paramPane = new ParameterPane(0);
                        this.paramPageVec.add(i, paramPane);
                    } else if (currentToken == 1) {
                        this.flowImagePane.addImage(new ImageIcon(IconBar.readPairImage), i);
                        Parameter.pFilePairVec = (Vector)this.s.readObject();
                        Parameter.pOneBadChannelPolicyStr = this.s.readObject().toString();
                        Parameter.pUseCh1FlagOpt = new Boolean(this.s.readBoolean());
                        Parameter.pUseCh2FlagOpt = new Boolean(this.s.readBoolean());
                        if (Parameter.pUseCh1FlagOpt) {
                            Parameter.pUseCh1FlagCol = new Integer(this.s.readInt());
                        }
                        if (Parameter.pUseCh2FlagOpt) {
                            Parameter.pUseCh2FlagCol = new Integer(this.s.readInt());
                        }
                        Parameter.pCh1BkgdOpt = new Boolean(this.s.readBoolean());
                        Parameter.pCh2BkgdOpt = new Boolean(this.s.readBoolean());
                        if (Parameter.pCh1BkgdOpt && Parameter.pCh2BkgdOpt) {
                            Parameter.pCh1BkgdCol = new Integer(this.s.readInt());
                            Parameter.pCh2BkgdCol = new Integer(this.s.readInt());
                            Parameter.pBkgdSNRatioVal = new Double(this.s.readDouble()).floatValue();
                        }
                        paramPane = new ParameterPane(1);
                        this.paramPageVec.add(i, paramPane);
                    } else if (currentToken == 2) {
                        isReadFolder = true;
                        this.flowImagePane.addImage(new ImageIcon(IconBar.readFolderImage), i);
                        Parameter.pFolderStr = this.s.readObject().toString();
                        Parameter.pFolderFilesVec = (Vector)this.s.readObject();
                        Parameter.pOneBadChannelPolicyStr = this.s.readObject().toString();
                        Parameter.pUseCh1FlagOpt = new Boolean(this.s.readBoolean());
                        Parameter.pUseCh2FlagOpt = new Boolean(this.s.readBoolean());
                        if (Parameter.pUseCh1FlagOpt) {
                            Parameter.pUseCh1FlagCol = new Integer(this.s.readInt());
                        }
                        if (Parameter.pUseCh2FlagOpt) {
                            Parameter.pUseCh2FlagCol = new Integer(this.s.readInt());
                        }
                        Parameter.pCh1BkgdOpt = new Boolean(this.s.readBoolean());
                        Parameter.pCh2BkgdOpt = new Boolean(this.s.readBoolean());
                        if (Parameter.pCh1BkgdOpt && Parameter.pCh2BkgdOpt) {
                            Parameter.pCh1BkgdCol = new Integer(this.s.readInt());
                            Parameter.pCh2BkgdCol = new Integer(this.s.readInt());
                            Parameter.pBkgdSNRatioVal = new Double(this.s.readDouble()).floatValue();
                        }
                        paramPane = new ParameterPane(2);
                        this.paramPageVec.add(i, paramPane);
                    } else if (currentToken == 12) {
                        this.flowImagePane.addImage(new ImageIcon(IconBar.totintImage), i);
                        Parameter.pRefStr = this.s.readObject().toString();
                        paramPane = new ParameterPane(12);
                        this.paramPageVec.add(i, paramPane);
                    } else if (currentToken == 11) {
                        this.flowImagePane.addImage(new ImageIcon(IconBar.locfitImage), i);
                        Parameter.pLocfitModeStr = this.s.readObject().toString();
                        Parameter.pSmoothParaVal = new Double(this.s.readDouble()).floatValue();
                        Parameter.pRefStr = this.s.readObject().toString();
                        paramPane = new ParameterPane(11);
                        this.paramPageVec.add(i, paramPane);
                    } else if (currentToken == 15) {
                        this.flowImagePane.addImage(new ImageIcon(IconBar.iterLinRegImage), i);
                        Parameter.pIterLinRegModeStr = this.s.readObject().toString();
                        Parameter.pIterLinRegSDRangeVal = new Double(this.s.readDouble()).floatValue();
                        Parameter.pRefStr = this.s.readObject().toString();
                        paramPane = new ParameterPane(15);
                        this.paramPageVec.add(i, paramPane);
                    } else if (currentToken == 14) {
                        this.flowImagePane.addImage(new ImageIcon(IconBar.iterLogMeanImage), i);
                        Parameter.pIterLogMeanSDRangeVal = new Double(this.s.readDouble()).floatValue();
                        Parameter.pRefStr = this.s.readObject().toString();
                        paramPane = new ParameterPane(14);
                        this.paramPageVec.add(i, paramPane);
                    } else if (currentToken == 13) {
                        this.flowImagePane.addImage(new ImageIcon(IconBar.sdRegImage), i);
                        Parameter.pBlockSDRegOpt = new Boolean(this.s.readBoolean());
                        Parameter.pSlideSDRegOpt = new Boolean(this.s.readBoolean());
                        Parameter.pRefStr = this.s.readObject().toString();
                        paramPane = new ParameterPane(13);
                        this.paramPageVec.add(i, paramPane);
                    } else if (currentToken == 16) {
                        this.flowImagePane.addImage(new ImageIcon(IconBar.ratioStatsImage), i);
                        Parameter.pRatioStatsCIChkOpt = new Boolean(this.s.readBoolean());
                        Parameter.pRatioStatsCIVal = new Integer(this.s.readInt());
                        Parameter.pRefStr = this.s.readObject().toString();
                        paramPane = new ParameterPane(16);
                        this.paramPageVec.add(i, paramPane);
                    } else if (currentToken == 10) {
                        this.flowImagePane.addImage(new ImageIcon(IconBar.filterImage), i);
                        Parameter.pCy3CutoffVal = new Long(this.s.readLong());
                        Parameter.pCy5CutoffVal = new Long(this.s.readLong());
                        paramPane = new ParameterPane(10);
                        this.paramPageVec.add(i, paramPane);
                    } else if (currentToken == 20) {
                        this.flowImagePane.addImage(new ImageIcon(IconBar.sliceAnalysisImage), i);
                        Parameter.pSliceDataPopVal = new Integer(this.s.readInt());
                        Parameter.pSliceDataRangeLtVal = new Double(this.s.readDouble()).floatValue();
                        Parameter.pSliceDataRangeGtVal = new Double(this.s.readDouble()).floatValue();
                        paramPane = new ParameterPane(20);
                        this.paramPageVec.add(i, paramPane);
                    } else if (currentToken == 30) {
                        this.flowImagePane.addImage(new ImageIcon(IconBar.inSlideReplicaImage), i);
                        Parameter.pIdentifierCol = new Integer(this.s.readInt());
                        paramPane = new ParameterPane(30);
                        this.paramPageVec.add(i, paramPane);
                    } else if (currentToken == 40) {
                        this.flowImagePane.addImage(new ImageIcon(IconBar.flipDyeImage), i);
                        Parameter.pFlipdyeCutOptionStr = this.s.readObject().toString();
                        Parameter.pFlipdyeDataKeepRangeVal = new Double(this.s.readDouble()).floatValue();
                        paramPane = new ParameterPane(40);
                        this.paramPageVec.add(i, paramPane);
                    } else if (currentToken == 100) {
                        this.flowImagePane.addImage(new ImageIcon(IconBar.writeImage), i);
                        Parameter.pOutFileStr = this.s.readObject().toString();
                        Parameter.pVtrimOpt = new Boolean(this.s.readBoolean());
                        Parameter.pReNumberOpt = new Boolean(this.s.readBoolean());
                        Parameter.pOutputTrimmedDataOpt = new Boolean(this.s.readBoolean());
                        if (isReadFolder && (Parameter.pUseCrossFileTrimOpt = new Boolean(this.s.readBoolean()).booleanValue())) {
                            Parameter.pCrossFilePct = new Double(this.s.readDouble()).floatValue();
                        }
                        paramPane = new ParameterPane(100);
                        this.paramPageVec.add(i, paramPane);
                    }
                    ++i;
                }
                this.s.readObject().toString();
            } else {
                int i = 0;
                while (i < this.flowTokenVec.size()) {
                    ParameterPane paramPane;
                    int currentToken = Integer.parseInt(this.flowTokenVec.elementAt(i).toString());
                    if (currentToken == 0) {
                        this.flowImagePane.addImage(new ImageIcon(IconBar.readFileImage), i);
                        Parameter.pSingleFileStr = this.s.readObject().toString();
                        if ((double)Float.parseFloat(this.ver) >= 2.19) {
                            Parameter.pOneBadChannelPolicyStr = this.s.readObject().toString();
                        }
                        Parameter.pUseCh1FlagOpt = new Boolean(this.s.readBoolean());
                        Parameter.pUseCh2FlagOpt = new Boolean(this.s.readBoolean());
                        if (Parameter.pUseCh1FlagOpt) {
                            Parameter.pUseCh1FlagCol = new Integer(this.s.readInt());
                        }
                        if (Parameter.pUseCh2FlagOpt) {
                            Parameter.pUseCh2FlagCol = new Integer(this.s.readInt());
                        }
                        Parameter.pCh1BkgdOpt = new Boolean(this.s.readBoolean());
                        Parameter.pCh2BkgdOpt = new Boolean(this.s.readBoolean());
                        if (Parameter.pCh1BkgdOpt && Parameter.pCh2BkgdOpt) {
                            Parameter.pCh1BkgdCol = new Integer(this.s.readInt());
                            Parameter.pCh2BkgdCol = new Integer(this.s.readInt());
                            Parameter.pBkgdSNRatioVal = new Float(this.s.readFloat()).floatValue();
                        }
                        paramPane = new ParameterPane(0);
                        this.paramPageVec.add(i, paramPane);
                    } else if (currentToken == 1) {
                        this.flowImagePane.addImage(new ImageIcon(IconBar.readPairImage), i);
                        Parameter.pFilePairVec = (Vector)this.s.readObject();
                        if ((double)Float.parseFloat(this.ver) >= 2.19) {
                            Parameter.pOneBadChannelPolicyStr = this.s.readObject().toString();
                        }
                        Parameter.pUseCh1FlagOpt = new Boolean(this.s.readBoolean());
                        Parameter.pUseCh2FlagOpt = new Boolean(this.s.readBoolean());
                        if (Parameter.pUseCh1FlagOpt) {
                            Parameter.pUseCh1FlagCol = new Integer(this.s.readInt());
                        }
                        if (Parameter.pUseCh2FlagOpt) {
                            Parameter.pUseCh2FlagCol = new Integer(this.s.readInt());
                        }
                        Parameter.pCh1BkgdOpt = new Boolean(this.s.readBoolean());
                        Parameter.pCh2BkgdOpt = new Boolean(this.s.readBoolean());
                        if (Parameter.pCh1BkgdOpt && Parameter.pCh2BkgdOpt) {
                            Parameter.pCh1BkgdCol = new Integer(this.s.readInt());
                            Parameter.pCh2BkgdCol = new Integer(this.s.readInt());
                            Parameter.pBkgdSNRatioVal = new Float(this.s.readFloat()).floatValue();
                        }
                        paramPane = new ParameterPane(1);
                        this.paramPageVec.add(i, paramPane);
                    } else if (currentToken == 2) {
                        isReadFolder = true;
                        this.flowImagePane.addImage(new ImageIcon(IconBar.readFolderImage), i);
                        Parameter.pFolderStr = this.s.readObject().toString();
                        Parameter.pFolderFilesVec = (Vector)this.s.readObject();
                        if ((double)Float.parseFloat(this.ver) >= 2.19) {
                            Parameter.pOneBadChannelPolicyStr = this.s.readObject().toString();
                        }
                        Parameter.pUseCh1FlagOpt = new Boolean(this.s.readBoolean());
                        Parameter.pUseCh2FlagOpt = new Boolean(this.s.readBoolean());
                        if (Parameter.pUseCh1FlagOpt) {
                            Parameter.pUseCh1FlagCol = new Integer(this.s.readInt());
                        }
                        if (Parameter.pUseCh2FlagOpt) {
                            Parameter.pUseCh2FlagCol = new Integer(this.s.readInt());
                        }
                        Parameter.pCh1BkgdOpt = new Boolean(this.s.readBoolean());
                        Parameter.pCh2BkgdOpt = new Boolean(this.s.readBoolean());
                        if (Parameter.pCh1BkgdOpt && Parameter.pCh2BkgdOpt) {
                            Parameter.pCh1BkgdCol = new Integer(this.s.readInt());
                            Parameter.pCh2BkgdCol = new Integer(this.s.readInt());
                            Parameter.pBkgdSNRatioVal = new Float(this.s.readFloat()).floatValue();
                        }
                        paramPane = new ParameterPane(2);
                        this.paramPageVec.add(i, paramPane);
                    } else if (currentToken == 12) {
                        this.flowImagePane.addImage(new ImageIcon(IconBar.totintImage), i);
                        Parameter.pRefStr = this.s.readObject().toString();
                        paramPane = new ParameterPane(12);
                        this.paramPageVec.add(i, paramPane);
                    } else if (currentToken == 11) {
                        this.flowImagePane.addImage(new ImageIcon(IconBar.locfitImage), i);
                        Parameter.pLocfitModeStr = this.s.readObject().toString();
                        Parameter.pSmoothParaVal = new Float(this.s.readFloat()).floatValue();
                        Parameter.pRefStr = this.s.readObject().toString();
                        paramPane = new ParameterPane(11);
                        this.paramPageVec.add(i, paramPane);
                    } else if (currentToken == 15) {
                        this.flowImagePane.addImage(new ImageIcon(IconBar.iterLinRegImage), i);
                        Parameter.pIterLinRegModeStr = this.s.readObject().toString();
                        Parameter.pIterLinRegSDRangeVal = new Float(this.s.readFloat()).floatValue();
                        Parameter.pRefStr = this.s.readObject().toString();
                        paramPane = new ParameterPane(15);
                        this.paramPageVec.add(i, paramPane);
                    } else if (currentToken == 14) {
                        this.flowImagePane.addImage(new ImageIcon(IconBar.iterLogMeanImage), i);
                        Parameter.pIterLogMeanSDRangeVal = new Float(this.s.readFloat()).floatValue();
                        Parameter.pRefStr = this.s.readObject().toString();
                        paramPane = new ParameterPane(14);
                        this.paramPageVec.add(i, paramPane);
                    } else if (currentToken == 13) {
                        this.flowImagePane.addImage(new ImageIcon(IconBar.sdRegImage), i);
                        Parameter.pBlockSDRegOpt = new Boolean(this.s.readBoolean());
                        Parameter.pSlideSDRegOpt = new Boolean(this.s.readBoolean());
                        Parameter.pRefStr = this.s.readObject().toString();
                        paramPane = new ParameterPane(13);
                        this.paramPageVec.add(i, paramPane);
                    } else if (currentToken == 16) {
                        this.flowImagePane.addImage(new ImageIcon(IconBar.ratioStatsImage), i);
                        Parameter.pRatioStatsCIChkOpt = new Boolean(this.s.readBoolean());
                        Parameter.pRatioStatsCIVal = new Integer(this.s.readInt());
                        Parameter.pRefStr = this.s.readObject().toString();
                        paramPane = new ParameterPane(16);
                        this.paramPageVec.add(i, paramPane);
                    } else if (currentToken == 10) {
                        this.flowImagePane.addImage(new ImageIcon(IconBar.filterImage), i);
                        Parameter.pCy3CutoffVal = new Long(this.s.readLong());
                        Parameter.pCy5CutoffVal = new Long(this.s.readLong());
                        paramPane = new ParameterPane(10);
                        this.paramPageVec.add(i, paramPane);
                    } else if (currentToken == 20) {
                        this.flowImagePane.addImage(new ImageIcon(IconBar.sliceAnalysisImage), i);
                        Parameter.pSliceDataPopVal = new Integer(this.s.readInt());
                        Parameter.pSliceDataRangeLtVal = new Float(this.s.readFloat()).floatValue();
                        Parameter.pSliceDataRangeGtVal = new Float(this.s.readFloat()).floatValue();
                        paramPane = new ParameterPane(20);
                        this.paramPageVec.add(i, paramPane);
                    } else if (currentToken == 30) {
                        this.flowImagePane.addImage(new ImageIcon(IconBar.inSlideReplicaImage), i);
                        Parameter.pIdentifierCol = (double)Float.parseFloat(this.ver) < 2.19 ? new Integer(this.s.readInt()) : this.s.readObject();
                        paramPane = new ParameterPane(30);
                        this.paramPageVec.add(i, paramPane);
                    } else if (currentToken == 32) {
                        this.flowImagePane.addImage(new ImageIcon(IconBar.crossSlideTtestImage), i);
                        Parameter.pTtestHypoMean = new Float(this.s.readFloat()).floatValue();
                        Parameter.pTtestPValBase = new Integer(this.s.readInt());
                        Parameter.pTtestAlpha = new Float(this.s.readFloat()).floatValue();
                        Parameter.pTtestSigMethod = new Integer(this.s.readInt());
                        paramPane = new ParameterPane(32);
                        this.paramPageVec.add(i, paramPane);
                    } else if (currentToken == 33) {
                        this.flowImagePane.addImage(new ImageIcon(IconBar.crossSlideSAMImage), i);
                        Parameter.pSAMHypoMean = new Float(this.s.readFloat()).floatValue();
                        Parameter.pSAMAllUniquePerm = new Boolean(this.s.readBoolean());
                        Parameter.pSAMPermutationsNumber = new Integer(this.s.readInt());
                        Parameter.pSAMS0Method = new Integer(this.s.readInt());
                        Parameter.pSAMImputationEngine = new Integer(this.s.readInt());
                        Parameter.pSAMNearestNeighborsNumber = new Integer(this.s.readInt());
                        paramPane = new ParameterPane(33);
                        this.paramPageVec.add(i, paramPane);
                    } else if (currentToken == 40) {
                        this.flowImagePane.addImage(new ImageIcon(IconBar.flipDyeImage), i);
                        Parameter.pFlipdyeCutOptionStr = this.s.readObject().toString();
                        Parameter.pFlipdyeDataKeepRangeVal = new Float(this.s.readFloat()).floatValue();
                        paramPane = new ParameterPane(40);
                        this.paramPageVec.add(i, paramPane);
                    } else if (currentToken == 41) {
                        this.flowImagePane.addImage(new ImageIcon(IconBar.maanovaImage), i);
                        MaAnovaParameter.elistSize = new Integer(this.s.readInt());
                        MaAnovaParameter.dim = new Integer(this.s.readInt());
                        MaAnovaParameter.pExpListStr = this.s.readObject().toString();
                        MaAnovaParameter.pFolderStr = this.s.readObject().toString();
                        MaAnovaParameter.setAnovaModelFromVector((Vector)this.s.readObject());
                        MaAnovaParameter.setMatrixFromVector((Vector)this.s.readObject());
                        MaAnovaParameter.setArrayStFromVector((Vector)this.s.readObject());
                        MaAnovaParameter.ExpListObject = (ExpList)this.s.readObject();
                        paramPane = new ParameterPane(41);
                        this.paramPageVec.add(i, paramPane);
                    } else if (currentToken == 100) {
                        this.flowImagePane.addImage(new ImageIcon(IconBar.writeImage), i);
                        Parameter.pOutFileStr = this.s.readObject().toString();
                        Parameter.pVtrimOpt = new Boolean(this.s.readBoolean());
                        Parameter.pReNumberOpt = new Boolean(this.s.readBoolean());
                        Parameter.pOutputTrimmedDataOpt = new Boolean(this.s.readBoolean());
                        if (isReadFolder && (Parameter.pUseCrossFileTrimOpt = new Boolean(this.s.readBoolean()).booleanValue())) {
                            Parameter.pCrossFilePct = new Float(this.s.readFloat()).floatValue();
                        }
                        paramPane = new ParameterPane(100);
                        this.paramPageVec.add(i, paramPane);
                    }
                    ++i;
                }
                this.s.readObject().toString();
            }
        }
        catch (OptionalDataException opex) {
            opex.printStackTrace();
            throw opex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    private void buildFlowAndParamPane() throws OptionalDataException, Exception {
        Hashtable<String, Object> paramHashtable = new Hashtable<String, Object>();
        try {
            paramHashtable.put("pSingleFileStr", this.s.readObject());
            paramHashtable.put("pRefStr", this.s.readObject());
            paramHashtable.put("pFolderStr", this.s.readObject());
            paramHashtable.put("pLocfitModeStr", this.s.readObject());
            paramHashtable.put("pFlipdyeCutOptionStr", this.s.readObject());
            paramHashtable.put("pOutFileStr", this.s.readObject());
            paramHashtable.put("pUseCh1FlagOpt", new Boolean(this.s.readBoolean()));
            paramHashtable.put("pUseCh2FlagOpt", new Boolean(this.s.readBoolean()));
            paramHashtable.put("pCh1BkgdOpt", new Boolean(this.s.readBoolean()));
            paramHashtable.put("pCh2BkgdOpt", new Boolean(this.s.readBoolean()));
            paramHashtable.put("pUseCrossFileTrimOpt", new Boolean(this.s.readBoolean()));
            paramHashtable.put("pVtrimOpt", new Boolean(this.s.readBoolean()));
            paramHashtable.put("pReNumberOpt", new Boolean(this.s.readBoolean()));
            paramHashtable.put("pOutputTrimmedDataOpt", new Boolean(this.s.readBoolean()));
            paramHashtable.put("pCy3CutoffVal", new Long(this.s.readLong()));
            paramHashtable.put("pCy5CutoffVal", new Long(this.s.readLong()));
            paramHashtable.put("pSliceDataPopVal", new Integer(this.s.readInt()));
            paramHashtable.put("pUseCh1FlagCol", new Integer(this.s.readInt()));
            paramHashtable.put("pUseCh2FlagCol", new Integer(this.s.readInt()));
            paramHashtable.put("pCh1BkgdCol", new Integer(this.s.readInt()));
            paramHashtable.put("pCh2BkgdCol", new Integer(this.s.readInt()));
            paramHashtable.put("pIdentifierCol", new Integer(this.s.readInt()));
            paramHashtable.put("pBkgdSNRatioVal", new Float(this.s.readFloat()));
            paramHashtable.put("pSmoothParaVal", new Float(this.s.readFloat()));
            paramHashtable.put("pSliceDataRangeLtVal", new Float(this.s.readFloat()));
            paramHashtable.put("pSliceDataRangeGtVal", new Float(this.s.readFloat()));
            paramHashtable.put("pFlipdyeDataKeepRangeVal", new Float(this.s.readFloat()));
            paramHashtable.put("pCrossFilePct", new Float(this.s.readFloat()));
            paramHashtable.put("pFilePairVec", this.s.readObject());
            this.s.readObject();
            int i = 0;
            while (i < this.flowTokenVec.size()) {
                ParameterPane paramPane;
                int currentToken = Integer.parseInt(this.flowTokenVec.elementAt(i).toString());
                if (currentToken == 0) {
                    this.flowImagePane.addImage(new ImageIcon(IconBar.readFileImage), i);
                    Parameter.pSingleFileStr = paramHashtable.get("pSingleFileStr").toString();
                    Parameter.pUseCh1FlagOpt = new Boolean(paramHashtable.get("pUseCh1FlagOpt").toString());
                    Parameter.pUseCh2FlagOpt = new Boolean(paramHashtable.get("pUseCh2FlagOpt").toString());
                    Parameter.pUseCh1FlagCol = new Integer(paramHashtable.get("pUseCh1FlagCol").toString());
                    Parameter.pUseCh2FlagCol = new Integer(paramHashtable.get("pUseCh2FlagCol").toString());
                    Parameter.pCh1BkgdOpt = new Boolean(paramHashtable.get("pCh1BkgdOpt").toString());
                    Parameter.pCh2BkgdOpt = new Boolean(paramHashtable.get("pCh2BkgdOpt").toString());
                    Parameter.pBkgdSNRatioVal = new Double(paramHashtable.get("pBkgdSNRatioVal").toString()).floatValue();
                    paramPane = new ParameterPane(0);
                    this.paramPageVec.add(i, paramPane);
                } else if (currentToken == 1) {
                    this.flowImagePane.addImage(new ImageIcon(IconBar.readPairImage), i);
                    Parameter.pFilePairVec = (Vector)paramHashtable.get("pFilePairVec");
                    Parameter.pUseCh1FlagOpt = new Boolean(paramHashtable.get("pUseCh1FlagOpt").toString());
                    Parameter.pUseCh2FlagOpt = new Boolean(paramHashtable.get("pUseCh2FlagOpt").toString());
                    Parameter.pUseCh1FlagCol = new Integer(paramHashtable.get("pUseCh1FlagCol").toString());
                    Parameter.pUseCh2FlagCol = new Integer(paramHashtable.get("pUseCh2FlagCol").toString());
                    Parameter.pCh1BkgdOpt = new Boolean(paramHashtable.get("pCh1BkgdOpt").toString());
                    Parameter.pCh2BkgdOpt = new Boolean(paramHashtable.get("pCh2BkgdOpt").toString());
                    Parameter.pBkgdSNRatioVal = new Double(paramHashtable.get("pBkgdSNRatioVal").toString()).floatValue();
                    paramPane = new ParameterPane(1);
                    this.paramPageVec.add(i, paramPane);
                } else if (currentToken == 2) {
                    this.flowImagePane.addImage(new ImageIcon(IconBar.readFolderImage), i);
                    Parameter.pFolderStr = paramHashtable.get("pFolderStr").toString();
                    Parameter.pUseCh1FlagOpt = new Boolean(paramHashtable.get("pUseCh1FlagOpt").toString());
                    Parameter.pUseCh2FlagOpt = new Boolean(paramHashtable.get("pUseCh2FlagOpt").toString());
                    Parameter.pUseCh1FlagCol = new Integer(paramHashtable.get("pUseCh1FlagCol").toString());
                    Parameter.pUseCh2FlagCol = new Integer(paramHashtable.get("pUseCh2FlagCol").toString());
                    Parameter.pCh1BkgdOpt = new Boolean(paramHashtable.get("pCh1BkgdOpt").toString());
                    Parameter.pCh2BkgdOpt = new Boolean(paramHashtable.get("pCh2BkgdOpt").toString());
                    Parameter.pBkgdSNRatioVal = new Double(paramHashtable.get("pBkgdSNRatioVal").toString()).floatValue();
                    Parameter.pUseCrossFileTrimOpt = new Boolean(paramHashtable.get("pUseCrossFileTrimOpt").toString());
                    Parameter.pCrossFilePct = new Double(paramHashtable.get("pCrossFilePct").toString()).floatValue();
                    paramPane = new ParameterPane(2);
                    this.paramPageVec.add(i, paramPane);
                } else if (currentToken == 12) {
                    this.flowImagePane.addImage(new ImageIcon(IconBar.totintImage), i);
                    Parameter.pCy3CutoffVal = new Long(paramHashtable.get("pCy3CutoffVal").toString());
                    Parameter.pCy5CutoffVal = new Long(paramHashtable.get("pCy5CutoffVal").toString());
                    Parameter.pRefStr = paramHashtable.get("pRefStr").toString();
                    paramPane = new ParameterPane(12);
                    this.paramPageVec.add(i, paramPane);
                } else if (currentToken == 11) {
                    this.flowImagePane.addImage(new ImageIcon(IconBar.locfitImage), i);
                    Parameter.pLocfitModeStr = paramHashtable.get("pLocfitModeStr").toString();
                    Parameter.pSmoothParaVal = new Double(paramHashtable.get("pSmoothParaVal").toString()).floatValue();
                    Parameter.pRefStr = paramHashtable.get("pRefStr").toString();
                    paramPane = new ParameterPane(11);
                    this.paramPageVec.add(i, paramPane);
                } else if (currentToken == 13) {
                    this.flowImagePane.addImage(new ImageIcon(IconBar.sdRegImage), i);
                    Parameter.pBlockSDRegOpt = new Boolean(paramHashtable.get("pBlockSDRegOpt").toString());
                    Parameter.pSlideSDRegOpt = new Boolean(paramHashtable.get("pSlideSDRegOpt").toString());
                    Parameter.pRefStr = paramHashtable.get("pRefStr").toString();
                    paramPane = new ParameterPane(13);
                    this.paramPageVec.add(i, paramPane);
                } else if (currentToken == 10) {
                    this.flowImagePane.addImage(new ImageIcon(IconBar.filterImage), i);
                    Parameter.pCy3CutoffVal = new Long(paramHashtable.get("pCy3CutoffVal").toString());
                    Parameter.pCy5CutoffVal = new Long(paramHashtable.get("pCy5CutoffVal").toString());
                    paramPane = new ParameterPane(10);
                    this.paramPageVec.add(i, paramPane);
                } else if (currentToken == 20) {
                    this.flowImagePane.addImage(new ImageIcon(IconBar.sliceAnalysisImage), i);
                    Parameter.pSliceDataPopVal = new Integer(paramHashtable.get("pSliceDataPopVal").toString());
                    Parameter.pSliceDataRangeLtVal = new Double(paramHashtable.get("pSliceDataRangeLtVal").toString()).floatValue();
                    Parameter.pSliceDataRangeGtVal = new Double(paramHashtable.get("pSliceDataRangeGtVal").toString()).floatValue();
                    paramPane = new ParameterPane(20);
                    this.paramPageVec.add(i, paramPane);
                } else if (currentToken == 30) {
                    this.flowImagePane.addImage(new ImageIcon(IconBar.inSlideReplicaImage), i);
                    Parameter.pIdentifierCol = new Integer(paramHashtable.get("pIdentifierCol").toString());
                    paramPane = new ParameterPane(30);
                    this.paramPageVec.add(i, paramPane);
                } else if (currentToken == 40) {
                    this.flowImagePane.addImage(new ImageIcon(IconBar.flipDyeImage), i);
                    Parameter.pFlipdyeCutOptionStr = paramHashtable.get("pFlipdyeCutOptionStr").toString();
                    Parameter.pFlipdyeDataKeepRangeVal = new Double(paramHashtable.get("pFlipdyeDataKeepRangeVal").toString()).floatValue();
                    paramPane = new ParameterPane(40);
                    this.paramPageVec.add(i, paramPane);
                } else if (currentToken == 100) {
                    this.flowImagePane.addImage(new ImageIcon(IconBar.writeImage), i);
                    Parameter.pOutFileStr = paramHashtable.get("pOutFileStr").toString();
                    Parameter.pVtrimOpt = new Boolean(paramHashtable.get("pVtrimOpt").toString());
                    Parameter.pReNumberOpt = new Boolean(paramHashtable.get("pReNumberOpt").toString());
                    Parameter.pOutputTrimmedDataOpt = new Boolean(paramHashtable.get("pOutputTrimmedDataOpt").toString());
                    paramPane = new ParameterPane(100);
                    this.paramPageVec.add(i, paramPane);
                }
                ++i;
            }
        }
        catch (OptionalDataException opex) {
            opex.printStackTrace();
            throw opex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public final Vector getParamPageVec() {
        return this.paramPageVec;
    }

    public static void main(String[] args) {
        try {
            ProjOpener p = new ProjOpener(new File("C:\\test\\test.prj"));
        }
        catch (FileNotFoundException fnex) {
            AlertDialogPane aPane = new AlertDialogPane(1, "The project file you specified does not exisit ");
            fnex.printStackTrace();
        }
        catch (Exception ex) {
            AlertDialogPane aPane = new AlertDialogPane(1, "The project file that you are trying to open is either corrupted or created by \na different version of MIDAS, thus might not be loaded correctly ");
            ex.printStackTrace();
        }
    }
}

