/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.engine;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.tigr.midas.report.PdfControl;
import org.tigr.midas.util.CodeBook;

public class Project {
    public String midasVersion;
    private CodeBook codeBook;
    private File projFile = null;
    private String projPath;
    private String flow;
    private List flowNameList = null;
    private List flowCodeList = null;
    private Date start;
    private Date stop;
    private boolean ifBuildPdfReport;
    private boolean ifBuildTxtReport;
    private PdfControl pdfControl;
    private Hashtable reportItemHash;
    private String fsep = System.getProperty("file.separator");

    public Project() {
        this.reportItemHash = new Hashtable();
    }

    public void setMidasVersion(String s) {
        this.midasVersion = s;
    }

    public void setProjFile(File file) {
        this.projFile = !file.getAbsolutePath().endsWith("prj") ? new File(file.getAbsolutePath() + ".prj") : file;
    }

    public void setFlow(String f) {
        this.flow = f;
        int i = 0;
        this.flowCodeList = new ArrayList();
        this.flowNameList = new ArrayList();
        StringTokenizer st = new StringTokenizer(f, ">");
        while (st.hasMoreTokens()) {
            String o = st.nextToken();
            this.flowCodeList.add(i, o);
            this.flowNameList.add(i, CodeBook.lookup(Integer.parseInt(o.toString())));
            ++i;
        }
    }

    public void setStartDate() {
        this.start = new Date(System.currentTimeMillis());
    }

    public void setStopDate() {
        this.stop = new Date(System.currentTimeMillis());
    }

    public void setPdfReportOption(boolean b) {
        this.ifBuildPdfReport = b;
    }

    public void setPdfControl(PdfControl p) {
        this.pdfControl = p;
    }

    public void setTxtReportOption(boolean b) {
        this.ifBuildTxtReport = b;
    }

    public File getProjFile() {
        return this.projFile;
    }

    public String getProjPath() {
        return this.projFile.getAbsolutePath().substring(0, this.projFile.getAbsolutePath().lastIndexOf(this.fsep) + 1);
    }

    public String getProjFullName() {
        String projName = this.projFile.getAbsolutePath();
        if (!projName.endsWith(".prj")) {
            projName = projName + ".prj";
        }
        return projName;
    }

    public String getProjName() {
        String projName = this.projFile.getAbsolutePath().substring(this.projFile.getAbsolutePath().lastIndexOf(this.fsep) + 1, this.projFile.getAbsolutePath().length());
        if (!projName.endsWith(".prj")) {
            projName = projName + ".prj";
        }
        return projName;
    }

    public String getProjNameWithoutExt() {
        String projName = this.projFile.getAbsolutePath().substring(this.projFile.getAbsolutePath().lastIndexOf(this.fsep) + 1, this.projFile.getAbsolutePath().lastIndexOf(46));
        return projName;
    }

    public String getFlow() {
        return this.flow;
    }

    public List getFlowNameList() {
        return this.flowNameList;
    }

    public List getFlowCodeList() {
        return this.flowCodeList;
    }

    public Date getStartDate() {
        return this.start;
    }

    public Date getStopDate() {
        return this.stop;
    }

    public boolean getPdfReportOption() {
        return this.ifBuildPdfReport;
    }

    public PdfControl getPdfControl() {
        return this.pdfControl;
    }

    public boolean getTxtReportOption() {
        return this.ifBuildTxtReport;
    }

    public Hashtable getReportItemHash() {
        return this.reportItemHash;
    }

    public void insertReportItem(String key, Hashtable h) {
        this.reportItemHash.put(key, h);
    }

    public void insertReportItem(String key, String h) {
        this.reportItemHash.put(key, h);
    }

    public void insertReportItem(String key, Vector h) {
        this.reportItemHash.put(key, h);
    }

    public void insertReportItem(String key, List l) {
        this.reportItemHash.put(key, l);
    }
}

