/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.engine;

import java.util.Hashtable;
import org.tigr.midas.engine.DataPrep;
import org.tigr.midas.engine.DataReporter;
import org.tigr.midas.engine.Module;
import org.tigr.midas.engine.Parameter;
import org.tigr.midas.util.AndFlags;
import org.tigr.midas.util.CodeBook;
import org.tigr.midas.util.ColumnWorker;
import org.tigr.midas.util.FileBrowser;
import org.tigr.midas.util.IndexAdjuster;

public class TotInt
extends Module {
    private ColumnWorker fCW;

    public TotInt(ColumnWorker fileCW, String ref, boolean noNorm) {
        String totintFB;
        FileBrowser projFolderFB;
        boolean[] tempFlag = fileCW.getRowFlagArray();
        boolean[] inputFlag = new boolean[tempFlag.length];
        System.arraycopy(tempFlag, 0, inputFlag, 0, tempFlag.length);
        if (noNorm) {
            projFolderFB = new FileBrowser(Module.proj.getProjPath(), 11199);
            totintFB = projFolderFB.createSubDir("low_intensity_filter");
            fileCW.KeepTwoColumnsAddFlags(Parameter.pCy3CutoffVal, Parameter.pCy5CutoffVal);
            String ityName = Module.proj.getProjPath() + "low_intensity_filter" + FileBrowser.fsep + fileCW.getFileName() + "_lowFilter.ity";
            String ltyName = Module.proj.getProjPath() + "low_intensity_filter" + FileBrowser.fsep + fileCW.getFileName() + "_lowFilter.lty";
            String prcName = Module.proj.getProjPath() + "low_intensity_filter" + FileBrowser.fsep + fileCW.getFileName() + "_lowFilter.prc";
            String hisName = Module.proj.getProjPath() + "low_intensity_filter" + FileBrowser.fsep + fileCW.getFileName() + "_lowFilter.his";
            String boxName = Module.proj.getProjPath() + "low_intensity_filter" + FileBrowser.fsep + fileCW.getFileName() + "_lowFilter_block.box";
            DataPrep dataPrep = new DataPrep(fileCW);
            DataReporter dr = new DataReporter(ityName, dataPrep.getX(), dataPrep.getY());
            dr = new DataReporter(ltyName, dataPrep.getLogX(), dataPrep.getLogY());
            dr = new DataReporter(prcName, dataPrep.getLogProd(), dataPrep.getLogRatio(), new IndexAdjuster().addOne(dataPrep.getRawNdx()));
            dr = new DataReporter(hisName, dataPrep.getZscore(), new IndexAdjuster().addOne(dataPrep.getRawNdx()));
            dr = new DataReporter(boxName, dataPrep.getBlockLogRatio());
            Hashtable<String, Object> hash = new Hashtable<String, Object>();
            hash.put("identity", new Integer(10));
            hash.put(CodeBook.lookup(99901), ityName);
            hash.put(CodeBook.lookup(99902), ltyName);
            hash.put(CodeBook.lookup(99903), prcName);
            hash.put(CodeBook.lookup(99904), hisName);
            hash.put(CodeBook.lookup(99905), boxName);
            hash.put("experiment data file:      ", fileCW.getFileNameWithExtension());
            hash.put("post-filtering data count: ", new Integer(dataPrep.getNonZeroCount()));
            String[] moduleNotes = new String[]{"experiment data file:      ", "post-filtering data count: "};
            hash.put("module_notes", moduleNotes);
            Module.proj.insertReportItem("lowFilter_for_" + fileCW.getFileName(), hash);
        } else {
            projFolderFB = new FileBrowser(Module.proj.getProjPath(), 11199);
            totintFB = projFolderFB.createSubDir("total_intensity");
            if (ref.equalsIgnoreCase("Cy3")) {
                fileCW.resetTwoColumnsAddFlagsRefColOne(1L, 1L);
            } else if (Parameter.pRefStr.equalsIgnoreCase("Cy5")) {
                fileCW.resetTwoColumnsAddFlagsRefColTwo(1L, 1L);
            }
            String ityName = Module.proj.getProjPath() + "total_intensity" + FileBrowser.fsep + fileCW.getFileName() + "_totint.ity";
            String ltyName = Module.proj.getProjPath() + "total_intensity" + FileBrowser.fsep + fileCW.getFileName() + "_totint.lty";
            String prcName = Module.proj.getProjPath() + "total_intensity" + FileBrowser.fsep + fileCW.getFileName() + "_totint.prc";
            String hisName = Module.proj.getProjPath() + "total_intensity" + FileBrowser.fsep + fileCW.getFileName() + "_totint.his";
            String boxName = Module.proj.getProjPath() + "total_intensity" + FileBrowser.fsep + fileCW.getFileName() + "_totint_block.box";
            DataPrep dataPrep = new DataPrep(fileCW);
            DataReporter dr = new DataReporter(ityName, dataPrep.getX(), dataPrep.getY());
            dr = new DataReporter(ltyName, dataPrep.getLogX(), dataPrep.getLogY());
            dr = new DataReporter(prcName, dataPrep.getLogProd(), dataPrep.getLogRatio(), new IndexAdjuster().addOne(dataPrep.getRawNdx()));
            dr = new DataReporter(hisName, dataPrep.getZscore(), new IndexAdjuster().addOne(dataPrep.getRawNdx()));
            dr = new DataReporter(boxName, dataPrep.getBlockLogRatio());
            Hashtable<String, Object> hash = new Hashtable<String, Object>();
            hash.put("identity", new Integer(12));
            hash.put(CodeBook.lookup(99901), ityName);
            hash.put(CodeBook.lookup(99902), ltyName);
            hash.put(CodeBook.lookup(99903), prcName);
            hash.put(CodeBook.lookup(99904), hisName);
            hash.put(CodeBook.lookup(99905), boxName);
            hash.put("experiment data file: ", fileCW.getFileNameWithExtension());
            hash.put("processed data count: ", new Integer(dataPrep.getNonZeroCount()));
            String[] moduleNotes = new String[]{"experiment data file: ", "processed data count: "};
            hash.put("module_notes", moduleNotes);
            Module.proj.insertReportItem("totint_for_" + fileCW.getFileName(), hash);
        }
        boolean[] totintFlag = fileCW.getRowFlagArray();
        boolean[] outputFlag = new AndFlags(inputFlag, totintFlag).getAndFlag();
        fileCW.setRowFlag(outputFlag);
        this.fCW = fileCW;
    }

    public final ColumnWorker getFileTotIntColumnWorker() {
        return this.fCW;
    }
}

