/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.graph;

import com.sun.media.jai.codec.JPEGEncodeParam;
import com.sun.media.jai.codec.TIFFEncodeParam;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.text.DecimalFormat;
import java.util.Hashtable;
import java.util.Vector;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.tigr.midas.display.FileBrowserPane;
import org.tigr.midas.graph.ActionInfoEvent;
import org.tigr.midas.graph.ActionInfoListener;
import org.tigr.midas.graph.Drawable;
import org.tigr.midas.graph.GraphBar;
import org.tigr.midas.graph.GraphBox;
import org.tigr.midas.graph.GraphElement;
import org.tigr.midas.graph.GraphLine;
import org.tigr.midas.graph.GraphPoint;
import org.tigr.midas.graph.GraphPointGroup;
import org.tigr.midas.graph.GraphSettingsDialog;
import org.tigr.midas.graph.GraphTick;
import org.tigr.midas.graph.Viewer;
import org.tigr.midas.util.GBA;
import org.tigr.midas.util.PrintUtilities;

public class GraphViewer
extends Viewer {
    public static final int SYSTEM_QUADRANT1_ONLY = 1000;
    public static final int SYSTEM_QUADRANT12_ONLY = 1001;
    public static final int SYSTEM_ALL_QUADRANTS = 1002;
    public static final int SYSTEM_BOUNDS = 1100;
    public static final int HISTOGRAM_BAR_OUTLINE = 2000;
    public static final int HISTOGRAM_BAR_SOLID = 2001;
    public static final int GRAPH_POINTS_SEPERATE = 3000;
    public static final int GRAPH_POINTS_CONNECT = 3001;
    public static boolean ifShown = true;
    protected int startx;
    protected int stopx;
    protected int starty;
    protected int stopy;
    protected double graphstartx;
    protected double graphstopx;
    protected double graphXstep;
    protected double graphstarty;
    protected double graphstopy;
    protected double graphYstep;
    protected int preXSpacing;
    protected int postXSpacing;
    protected int preYSpacing;
    protected int postYSpacing;
    protected double xAxisValue = 0.0;
    protected double yAxisValue = 0.0;
    protected int pointSize;
    protected Font tickFont;
    protected Font labelFont;
    protected Font titleFont;
    protected int tickFontHeight;
    protected int tickFontWidth;
    protected int labelFontHeight;
    protected int labelFontWidth;
    protected int titleFontHeight;
    protected int titleFontWidth;
    protected String title;
    protected String xLabel;
    protected String yLabel;
    protected Drawable canvas;
    protected GBA gba;
    protected boolean referenceLinesOn;
    protected DecimalFormat coordinateFormat;
    protected boolean showCoordinates = true;
    protected FontMetrics metrics;
    protected boolean[] ifShownForSet;
    protected Color[] colorForSet;
    protected Vector graphElements;
    protected JButton clearButton = new JButton("Clear");
    protected JButton saveButton = new JButton("Save");
    protected JButton toggleButton = new JButton("Toggle");
    protected JButton printButton = new JButton("Print");
    protected JButton settingsButton = new JButton("Settings");
    protected JPanel buttonPane = new JPanel();
    protected BufferedImage image;
    protected EventListener eventListener;

    public GraphViewer(int startx, int stopx, int starty, int stopy, float graphstartx, float graphstopx, float graphXstep, float graphstarty, float graphstopy, float graphYstep, int preXSpacing, int postXSpacing, int preYSpacing, int postYSpacing, String title, String xLabel, String yLabel, Color[] colorForSet, boolean[] ifShownForSet) {
        this.startx = startx;
        this.stopx = stopx;
        this.starty = starty;
        this.stopy = stopy;
        this.graphstartx = graphstartx;
        this.graphstopx = graphstopx;
        this.graphXstep = graphXstep;
        this.graphstarty = graphstarty;
        this.graphstopy = graphstopy;
        this.graphYstep = graphYstep;
        this.preXSpacing = preXSpacing;
        this.postXSpacing = postXSpacing;
        this.preYSpacing = preYSpacing;
        this.postYSpacing = postYSpacing;
        this.title = title;
        this.xLabel = xLabel;
        this.yLabel = yLabel;
        this.colorForSet = colorForSet;
        this.ifShownForSet = ifShownForSet;
        this.initializeViewer();
        this.initializeCanvas();
    }

    public GraphViewer(int startx, int stopx, int starty, int stopy, float graphstartx, float graphstopx, float graphstarty, float graphstopy, int preXSpacing, int postXSpacing, int preYSpacing, int postYSpacing, String title, String xLabel, String yLabel) {
        this.startx = startx;
        this.stopx = stopx;
        this.starty = starty;
        this.stopy = stopy;
        this.graphstartx = graphstartx;
        this.graphstopx = graphstopx;
        this.graphstarty = graphstarty;
        this.graphstopy = graphstopy;
        this.preXSpacing = preXSpacing;
        this.postXSpacing = postXSpacing;
        this.preYSpacing = preYSpacing;
        this.postYSpacing = postYSpacing;
        this.title = title;
        this.xLabel = xLabel;
        this.yLabel = yLabel;
        this.initializeViewer();
        this.initializeCanvas();
    }

    private void initializeViewer() {
        this.setLayout(new GridBagLayout());
        this.eventListener = new EventListener();
        this.gba = new GBA();
        this.graphElements = new Vector();
        this.setBackground(Color.white);
        this.setTickFont("SansSerif", 0, 10);
        this.setLabelFont("SansSerif", 0, 12);
        this.setTitleFont("SansSerif", 0, 12);
        this.setSize(this.stopx - this.startx + this.preXSpacing + this.postXSpacing, this.stopy - this.starty + this.preYSpacing + this.postYSpacing);
        this.coordinateFormat = new DecimalFormat();
        this.coordinateFormat.setMaximumFractionDigits(3);
    }

    private void initializeControls() {
        this.clearButton.addActionListener(this.eventListener);
        this.settingsButton.addActionListener(this.eventListener);
        this.toggleButton.addActionListener(this.eventListener);
        this.saveButton.addActionListener(this.eventListener);
        this.printButton.addActionListener(this.eventListener);
        this.buttonPane.setBackground(Color.white);
        this.buttonPane.add(this.clearButton);
        this.buttonPane.add(this.settingsButton);
        this.buttonPane.add(this.saveButton);
        this.buttonPane.add(this.printButton);
    }

    private void initializeCanvas() {
        this.canvas = new Drawable(this.startx, this.stopx, this.starty, this.stopy){

            public void controlPaint(Graphics g) {
                GraphViewer.this.display(g);
            }
        };
        this.canvas.setBackground(Color.white);
        this.canvas.addMouseListener(this.eventListener);
        this.canvas.addMouseMotionListener(this.eventListener);
        this.initializeControls();
        this.setLayout(new BorderLayout());
        this.add((Component)this.canvas, "Center");
        this.add((Component)this.buttonPane, "South");
    }

    public void display(Graphics g1D) {
        Graphics2D g = (Graphics2D)g1D;
        this.metrics = g.getFontMetrics();
        this.drawGraph(g);
    }

    public void drawGraph(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.drawSystem(g, 1100);
        int i = 0;
        while (i < this.graphElements.size()) {
            GraphElement e = (GraphElement)this.graphElements.elementAt(i);
            if (e instanceof GraphPoint && this.ifShownForSet[e.getBelong()]) {
                ((GraphPoint)e).setColor(this.colorForSet[e.getBelong()]);
                this.drawPoint(g, (GraphPoint)e);
            } else if (e instanceof GraphBar) {
                this.drawBar(g, (GraphBar)e);
            } else if (e instanceof GraphTick) {
                this.drawTick(g, (GraphTick)e);
            } else if (e instanceof GraphLine) {
                if (e.getBelong() == 9999) {
                    this.drawLine(g, (GraphLine)e);
                } else if (this.ifShownForSet[e.getBelong()]) {
                    ((GraphLine)e).setColor(this.colorForSet[e.getBelong()]);
                    this.drawLine(g, (GraphLine)e);
                }
            } else if (e instanceof GraphBox && this.ifShownForSet[e.getBelong()]) {
                ((GraphBox)e).setColor(this.colorForSet[e.getBelong()]);
                this.drawBox(g, (GraphBox)e);
            } else if (e instanceof GraphPointGroup) {
                this.drawPointGroup(g, (GraphPointGroup)e);
            }
            ++i;
        }
        if (this.referenceLinesOn) {
            boolean onGraph;
            int x = this.getXOldEvent();
            int y = this.getYOldEvent();
            double xVal = 0.0;
            double yVal = 0.0;
            boolean bl = onGraph = x <= this.convertX(this.graphstopx) && x >= this.convertX(this.graphstartx) && y >= this.convertY(this.graphstopy) && y <= this.convertY(this.graphstarty);
            if (onGraph) {
                this.setCursor(1);
                xVal = (double)(x - this.convertX(this.graphstartx)) / this.getXScale() + this.graphstartx;
                yVal = (double)(this.convertY(this.graphstarty) - y) / this.getYScale() + this.graphstarty;
                g.setColor(Color.magenta);
                g.drawLine(x, this.convertY(this.graphstarty), x, this.convertY(this.graphstopy));
                g.drawLine(this.convertX(this.graphstartx), y, this.convertX(this.graphstopx), y);
                if (this.showCoordinates) {
                    int coordinateWidth = this.metrics.stringWidth(this.coordinateFormat.format(xVal) + ", " + this.coordinateFormat.format(yVal));
                    Composite comp = g.getComposite();
                    g.setComposite(AlphaComposite.getInstance(3, 0.2f));
                    g.setColor(Color.blue);
                    g.fillRect(x, y - 15, coordinateWidth + 10, 15);
                    g.setComposite(comp);
                    g.setColor(Color.black);
                    g.drawString(this.coordinateFormat.format(xVal) + ", " + this.coordinateFormat.format(yVal), x + 5, y - 3);
                }
            } else {
                this.setCursor(0);
            }
        }
        this.drawXLabel(g, this.xLabel, Color.black);
        this.drawYLabel(g, this.yLabel, Color.black);
        this.drawTitle(g, this.title, Color.black);
    }

    public void printImage() {
        PrintUtilities.printComponent(this.canvas);
    }

    public void saveImage() {
        block8: {
            BufferedImage image;
            File imageFile;
            JFileChooser chooser;
            block11: {
                block10: {
                    block9: {
                        chooser = new JFileChooser(System.getProperty("user.dir"));
                        chooser.setCurrentDirectory(new File(chooser.getCurrentDirectory().getParentFile(), "Data"));
                        chooser.addChoosableFileFilter(new FileFilter(){

                            public boolean accept(File f) {
                                String extension = "";
                                if (f.isDirectory()) {
                                    return true;
                                }
                                int i = f.getName().lastIndexOf(46);
                                if (i > 0) {
                                    extension = f.getName().substring(i + 1).toLowerCase();
                                }
                                return extension.equals("bmp");
                            }

                            public String getDescription() {
                                return "Bitmap Files (*.bmp)";
                            }
                        });
                        chooser.addChoosableFileFilter(new FileFilter(){

                            public boolean accept(File f) {
                                String extension = "";
                                if (f.isDirectory()) {
                                    return true;
                                }
                                int i = f.getName().lastIndexOf(46);
                                if (i > 0) {
                                    extension = f.getName().substring(i + 1).toLowerCase();
                                }
                                return extension.equals("jpg") || extension.equals("jpeg");
                            }

                            public String getDescription() {
                                return "JPEG Files (*.jpg; *.jpeg)";
                            }
                        });
                        chooser.addChoosableFileFilter(new FileFilter(){

                            public boolean accept(File f) {
                                String extension = "";
                                if (f.isDirectory()) {
                                    return true;
                                }
                                int i = f.getName().lastIndexOf(46);
                                if (i > 0) {
                                    extension = f.getName().substring(i + 1).toLowerCase();
                                }
                                return extension.equals("png");
                            }

                            public String getDescription() {
                                return "PNG Files (*.png)";
                            }
                        });
                        chooser.addChoosableFileFilter(new FileFilter(){

                            public boolean accept(File f) {
                                String extension = "";
                                if (f.isDirectory()) {
                                    return true;
                                }
                                int i = f.getName().lastIndexOf(46);
                                if (i > 0) {
                                    extension = f.getName().substring(i + 1).toLowerCase();
                                }
                                return extension.equals("tif") || extension.equals("tiff");
                            }

                            public String getDescription() {
                                return "TIFF Files (*.tif; *.tiff)";
                            }
                        });
                        int chooserState = chooser.showSaveDialog(this.getFrame());
                        if (chooserState != 0) break block8;
                        imageFile = chooser.getSelectedFile();
                        image = new BufferedImage(this.canvas.getWidth(), this.canvas.getHeight(), 5);
                        Graphics2D g = image.createGraphics();
                        g.setColor(Color.white);
                        g.fillRect(0, 0, image.getWidth(), image.getHeight());
                        this.drawGraph(g);
                        if (chooser.getFileFilter().getDescription() != "Bitmap Files (*.bmp)") break block9;
                        try {
                            Thread thread = new Thread(){

                                public void run() {
                                    RenderedOp renderedOp = JAI.create((String)"filestore", (RenderedImage)image, (Object)(imageFile.getPath() + ".bmp"), (Object)"BMP");
                                }
                            };
                            thread.setPriority(1);
                            thread.start();
                        }
                        catch (Exception e) {
                            System.out.println(e);
                        }
                        break block8;
                    }
                    if (chooser.getFileFilter().getDescription() != "JPEG Files (*.jpg; *.jpeg)") break block10;
                    try {
                        Thread thread = new Thread(){

                            public void run() {
                                JPEGEncodeParam encoder = new JPEGEncodeParam();
                                encoder.setQuality(1.0f);
                                RenderedOp renderedOp = JAI.create((String)"filestore", (RenderedImage)image, (Object)(imageFile.getPath() + ".jpg"), (Object)"JPEG", (Object)encoder);
                            }
                        };
                        thread.setPriority(1);
                        thread.start();
                    }
                    catch (Exception e) {
                        System.out.println(e);
                    }
                    break block8;
                }
                if (chooser.getFileFilter().getDescription() != "PNG Files (*.png)") break block11;
                try {
                    Thread thread = new Thread(){

                        public void run() {
                            RenderedOp renderedOp = JAI.create((String)"filestore", (RenderedImage)image, (Object)(imageFile.getPath() + ".png"), (Object)"PNG");
                        }
                    };
                    thread.setPriority(1);
                    thread.start();
                }
                catch (Exception e) {
                    System.out.println(e);
                }
                break block8;
            }
            if (chooser.getFileFilter().getDescription() != "TIFF Files (*.tif; *.tiff)") break block8;
            try {
                Thread thread = new Thread(){

                    public void run() {
                        TIFFEncodeParam encoder = new TIFFEncodeParam();
                        encoder.setCompression(1);
                        RenderedOp renderedOp = JAI.create((String)"filestore", (RenderedImage)image, (Object)(imageFile.getPath() + ".tif"), (Object)"TIFF", (Object)encoder);
                    }
                };
                thread.setPriority(1);
                thread.start();
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
    }

    public void addGraphElement(GraphElement e) {
        this.graphElements.addElement(e);
    }

    public void setTickFont(String fontName, int fontStyle, int fontSize) {
        this.tickFont = new Font(fontName, fontStyle, fontSize);
        this.tickFontWidth = (int)(0.5 * (double)fontSize);
        this.tickFontHeight = fontSize;
    }

    public void setLabelFont(String fontName, int fontStyle, int fontSize) {
        this.labelFont = new Font(fontName, fontStyle, fontSize);
        this.labelFontWidth = (int)(0.5 * (double)fontSize);
        this.labelFontHeight = fontSize;
    }

    public void setTitleFont(String fontName, int fontStyle, int fontSize) {
        this.titleFont = new Font(fontName, fontStyle, fontSize);
        this.titleFontWidth = (int)(0.5 * (double)fontSize);
        this.titleFontHeight = fontSize;
    }

    public void setPointSize(int pointSize) {
        this.pointSize = pointSize;
    }

    public int getPointSize() {
        return this.pointSize;
    }

    public void showAll() {
        this.canvas.repaint();
    }

    public void clearAll(Graphics2D g) {
        this.canvas.fillRect(g, this.startx, this.starty, this.getSize().width, this.getSize().height, Color.white);
    }

    public void drawSystem(Graphics2D g, int systemStyle) {
        switch (systemStyle) {
            case 1000: {
                g.drawLine(this.startx + this.preXSpacing, this.stopy - this.postYSpacing, this.stopx - this.postXSpacing, this.stopy - this.postYSpacing);
                g.drawLine(this.startx + this.preXSpacing, this.stopy - this.postYSpacing, this.startx + this.preXSpacing, this.starty + this.preYSpacing);
                break;
            }
            case 1001: {
                g.drawLine(this.startx + this.preXSpacing, this.stopy - this.postYSpacing, this.stopx - this.postXSpacing, this.stopy - this.postYSpacing);
                g.drawLine(this.startx + this.preXSpacing, this.stopy - this.postYSpacing, this.startx + this.preXSpacing, this.starty + this.preYSpacing);
                g.drawLine((this.stopx - this.postXSpacing - this.startx + this.preXSpacing) / 2, this.stopy - this.postYSpacing, (this.stopx - this.postXSpacing - this.startx + this.preXSpacing) / 2, this.starty + this.preYSpacing);
                break;
            }
            case 1100: {
                break;
            }
        }
    }

    protected double getXScale() {
        return (double)(this.canvas.getSize().width - this.preXSpacing - this.postXSpacing) / (this.graphstopx - this.graphstartx);
    }

    protected double getYScale() {
        return (double)(this.canvas.getSize().height - this.preYSpacing - this.postYSpacing) / (this.graphstopy - this.graphstarty);
    }

    protected int convertX(double x) {
        return (int)((x - this.graphstartx) * this.getXScale() + (double)this.preXSpacing);
    }

    protected int convertY(double y) {
        return (int)((this.graphstopy - y) * this.getYScale() + (double)this.preYSpacing);
    }

    public void drawTick(Graphics2D g, GraphTick e) {
        if (e.getOrientation() == 0) {
            if (e.getLocation() >= this.graphstartx && e.getLocation() <= this.graphstopx) {
                if (e.getLabel() != "") {
                    this.drawVerticalTick(g, e.getLocation(), e.getHeight(), e.getAlignment(), e.getColor(), e.getLabel(), e.getLabelColor());
                } else {
                    this.drawVerticalTick(g, e.getLocation(), e.getHeight(), e.getAlignment(), e.getColor());
                }
            }
        } else if (e.getOrientation() == 1 && e.getLocation() >= this.graphstarty && e.getLocation() <= this.graphstopy) {
            if (e.getLabel() != "") {
                this.drawHorizontalTick(g, e.getLocation(), e.getHeight(), e.getAlignment(), e.getColor(), e.getLabel(), e.getLabelColor());
            } else {
                this.drawHorizontalTick(g, e.getLocation(), e.getHeight(), e.getAlignment(), e.getColor());
            }
        }
    }

    public void drawVerticalTick(Graphics2D g, double x, int length, int alignment, Color color) {
        if (!(x < this.graphstartx) && !(x > this.graphstopx) && length <= this.postYSpacing) {
            switch (alignment) {
                case 0: {
                    this.canvas.drawLine(g, this.convertX(x), this.convertY(this.xAxisValue) - length / 2, this.convertX(x), this.convertY(this.xAxisValue) + length / 2, color);
                    break;
                }
                case 1: {
                    this.canvas.drawLine(g, this.convertX(x), this.convertY(this.xAxisValue), this.convertX(x), this.convertY(this.xAxisValue) - length, color);
                    break;
                }
                case 5: {
                    this.canvas.drawLine(g, this.convertX(x), this.convertY(this.xAxisValue), this.convertX(x), this.convertY(this.xAxisValue) + length, color);
                }
            }
        }
    }

    public void drawVerticalTick(Graphics2D g, double x, int length, int alignment, Color color, String label, Color tickColor) {
        this.drawVerticalTick(g, x, length, alignment, color);
        g.rotate(-1.5707963267948966);
        this.canvas.drawString(g, label, -this.canvas.getSize().height + this.postYSpacing - label.length() * this.tickFontWidth - length, this.convertX(x) + this.tickFontHeight / 2, tickColor, this.tickFont);
        g.rotate(1.5707963267948966);
    }

    public void drawHorizontalTick(Graphics2D g, double y, int length, int alignment, Color color) {
        if (!(y < this.graphstarty) && !(y > this.graphstopy) && length <= this.preXSpacing) {
            switch (alignment) {
                case 0: {
                    this.canvas.drawLine(g, this.convertX(this.yAxisValue) - length / 2, this.convertY(y), this.convertX(this.yAxisValue) + length / 2, this.convertY(y), color);
                    break;
                }
                case 3: {
                    this.canvas.drawLine(g, this.convertX(this.yAxisValue), this.convertY(y), this.convertX(this.yAxisValue) + length, this.convertY(y), color);
                    break;
                }
                case 7: {
                    this.canvas.drawLine(g, this.convertX(this.yAxisValue), this.convertY(y), this.convertX(this.yAxisValue) - length, this.convertY(y), color);
                }
            }
        }
    }

    public void drawHorizontalTick(Graphics2D g, double y, int length, int alignment, Color color, String label, Color tickColor) {
        this.drawHorizontalTick(g, y, length, alignment, color);
        this.canvas.drawString(g, label, this.startx + this.preXSpacing - length - label.length() * this.tickFontWidth, this.convertY(y) + this.tickFontHeight / 2, tickColor, this.tickFont);
    }

    public void drawTitle(Graphics2D g, String title, Color titleColor) {
        this.canvas.drawString(g, title, this.canvas.getSize().width / 2 - title.length() * this.titleFontWidth / 2, this.titleFontHeight * 2, titleColor, this.titleFont);
    }

    public void drawXLabel(Graphics2D g, String label, Color labelColor) {
        this.canvas.drawString(g, label, this.canvas.getSize().width / 2 - label.length() * this.labelFontWidth / 2, this.convertY(this.graphstarty) + this.postYSpacing - this.labelFontHeight, labelColor, this.labelFont);
    }

    public void drawYLabel(Graphics2D g, String label, Color labelColor) {
        g.rotate(-1.5707963267948966);
        this.canvas.drawString(g, label, this.startx - this.postYSpacing + this.preXSpacing - this.canvas.getSize().height / 2 - label.length() * this.labelFontWidth / 2, this.labelFontHeight, labelColor, this.labelFont);
        g.rotate(1.5707963267948966);
    }

    public void drawPoint(Graphics2D g, GraphPoint graphPoint) {
        this.drawPointAt(g, graphPoint.getX(), graphPoint.getY(), graphPoint.getColor(), graphPoint.getPointSize());
    }

    public void drawPointAt(Graphics2D g, double x, double y, Color pointColor, int pointSize) {
        if (!(x < this.graphstartx || x > this.graphstopx || y < this.graphstarty || y > this.graphstopy)) {
            this.canvas.fillRect(g, this.convertX(x) - pointSize / 2, this.convertY(y) - pointSize / 2, pointSize, pointSize, pointColor);
        }
    }

    public void drawPoints(Graphics2D g, Vector graphPoints, int graphPointStyle) {
        GraphPoint graphPoint2 = null;
        switch (graphPointStyle) {
            case 3000: {
                int i = 0;
                while (i < graphPoints.size()) {
                    GraphPoint graphPoint = (GraphPoint)graphPoints.elementAt(i);
                    this.drawPoint(g, graphPoint);
                    ++i;
                }
                break;
            }
            case 3001: {
                int i = 0;
                while (i < graphPoints.size()) {
                    GraphPoint graphPoint = (GraphPoint)graphPoints.elementAt(i);
                    if (i == 0) {
                        graphPoint2 = graphPoint;
                    }
                    this.drawLine(g, graphPoint2, graphPoint, Color.black);
                    this.drawPoint(g, graphPoint2);
                    this.drawPoint(g, graphPoint);
                    graphPoint2 = graphPoint;
                    ++i;
                }
                break;
            }
        }
    }

    public void drawPointGroup(Graphics2D g, GraphPointGroup gpg) {
        double[] x = gpg.getX();
        double[] y = gpg.getY();
        Color pointColor = gpg.getColor();
        int pointSize = gpg.getPointSize();
        int i = 0;
        while (i < Math.min(x.length, y.length)) {
            this.drawPointAt(g, x[i], y[i], pointColor, pointSize);
            ++i;
        }
    }

    public void drawLine(Graphics2D g, GraphLine e) {
        int xFrom = e.getX1() < this.graphstartx ? this.convertX(this.graphstartx) : (e.getX1() > this.graphstopx ? this.convertX(this.graphstopx) : this.convertX(e.getX1()));
        int yFrom = e.getY1() < this.graphstarty ? this.convertY(this.graphstarty) : (e.getY1() > this.graphstopy ? this.convertY(this.graphstopy) : this.convertY(e.getY1()));
        int xTo = e.getX2() < this.graphstartx ? this.convertX(this.graphstartx) : (e.getX2() > this.graphstopx ? this.convertX(this.graphstopx) : this.convertX(e.getX2()));
        int yTo = e.getY2() < this.graphstarty ? this.convertY(this.graphstarty) : (e.getY2() > this.graphstopy ? this.convertY(this.graphstopy) : this.convertY(e.getY2()));
        this.canvas.drawLine(g, xFrom, yFrom, xTo, yTo, e.getColor());
    }

    public void drawLine(Graphics2D g, GraphPoint graphPoint1, GraphPoint graphPoint2, Color lineColor) {
        this.canvas.drawLine(g, this.convertX(graphPoint1.getX()), this.convertY(graphPoint1.getY()), this.convertX(graphPoint2.getX()), this.convertY(graphPoint2.getY()), lineColor);
    }

    public void drawBar(Graphics2D g, GraphBar e) {
        if (e.getStyle() == 0) {
            this.drawVerticalHistogramBar(g, e.getLower(), e.getUpper(), e.getValue(), e.getColor(), e.getStyle());
        } else if (e.getStyle() == 1) {
            // empty if block
        }
    }

    public void drawVerticalHistogramBar(Graphics2D g, double low, double high, double value, Color barColor, int style) {
        if (!(low < this.graphstartx || low > this.graphstopx || high < this.graphstartx || high > this.graphstopx || value < this.graphstarty || value > this.graphstopy)) {
            if (style == 1) {
                this.canvas.drawRect(g, this.convertX(low), this.convertY(value), (int)((high - low) * this.getXScale()), (int)(value * this.getYScale()) - 1, barColor);
            } else if (style == 0) {
                this.canvas.fillRect(g, this.convertX(low), this.convertY(value), (int)((high - low) * this.getXScale()) + 1, (int)(value * this.getYScale()) + 1, barColor);
            }
        }
    }

    public void drawBox(Graphics2D g, GraphBox e) {
        this.drawBox(g, e.getLowX(), e.getLowY(), e.getHighX(), e.getHighY(), e.getColor(), e.getStyle());
    }

    public void drawBox(Graphics2D g, double lowX, double lowY, double highX, double highY, Color boxColor, int style) {
        if (!(lowX < this.graphstartx || lowX > this.graphstopx || lowY < this.graphstarty || lowY > this.graphstopy || highX < this.graphstartx || highX > this.graphstopx || highY < this.graphstarty || highY > this.graphstopy)) {
            if (style == 1) {
                this.canvas.drawRect(g, this.convertX(lowX), this.convertY(highY), (int)((highX - lowX) * this.getXScale()), (int)((highY - lowY) * this.getYScale()) - 1, boxColor);
            } else if (style == 0) {
                this.canvas.fillRect(g, this.convertX(lowX), this.convertY(highY), (int)((highX - lowX) * this.getXScale()) + 1, (int)((highY - lowY) * this.getYScale()) + 1, boxColor);
            }
        }
    }

    private void clear() {
        this.removeAll();
        this.repaint();
        FileBrowserPane.selectedFilesVec = new Vector();
    }

    private void settings() {
        GraphSettingsDialog dialog = new GraphSettingsDialog(this.getFrame(), this.title, this.graphstartx, this.graphstopx, this.graphXstep, this.graphstarty, this.graphstopy, this.graphYstep, this.colorForSet, this.ifShownForSet, this.referenceLinesOn);
        this.ifShownForSet = this.ifShownForSet;
        dialog.addActionInfoListener(new ActionInfoListener(){

            public void actionInfoPerformed(ActionInfoEvent event) {
                Hashtable hash = event.getHashtable();
                GraphViewer.this.title = (String)hash.get("title");
                GraphViewer.this.graphstartx = Double.parseDouble((String)hash.get("lowerx"));
                GraphViewer.this.graphstopx = Double.parseDouble((String)hash.get("upperx"));
                GraphViewer.this.graphXstep = Double.parseDouble((String)hash.get("xStep"));
                GraphViewer.this.graphstarty = Double.parseDouble((String)hash.get("lowery"));
                GraphViewer.this.graphstopy = Double.parseDouble((String)hash.get("uppery"));
                GraphViewer.this.graphYstep = Double.parseDouble((String)hash.get("yStep"));
                int i = 0;
                while (i < GraphViewer.this.ifShownForSet.length) {
                    GraphViewer.this.ifShownForSet[i] = Boolean.valueOf((String)hash.get("ifShownForSet" + i));
                    GraphViewer.this.colorForSet[i] = (Color)hash.get("ColorForSet" + i);
                    ++i;
                }
                GraphViewer.this.referenceLinesOn = Boolean.valueOf((String)hash.get("refLinesOn"));
                GraphViewer.this.repaint();
            }
        });
        dialog.show();
    }

    public void toggle() {
        ifShown = !ifShown;
        this.repaint();
    }

    public BufferedImage ggetImage() {
        this.image = new BufferedImage(800, 600, 5);
        Graphics2D g = this.image.createGraphics();
        g.setColor(Color.white);
        this.canvas.setSize(this.image.getWidth(), this.image.getHeight());
        g.fillRect(0, 0, this.image.getWidth(), this.image.getHeight());
        this.drawGraph(g);
        return this.image;
    }

    private class EventListener
    implements ActionListener,
    KeyListener,
    MouseListener,
    MouseMotionListener {
        private EventListener() {
        }

        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == GraphViewer.this.clearButton) {
                GraphViewer.this.clear();
            } else if (event.getSource() == GraphViewer.this.settingsButton) {
                GraphViewer.this.settings();
            } else if (event.getSource() == GraphViewer.this.toggleButton) {
                GraphViewer.this.toggle();
            } else if (event.getSource() == GraphViewer.this.saveButton) {
                GraphViewer.this.saveImage();
            } else if (event.getSource() == GraphViewer.this.printButton) {
                GraphViewer.this.printImage();
            }
        }

        public void keyPressed(KeyEvent event) {
        }

        public void keyReleased(KeyEvent event) {
        }

        public void keyTyped(KeyEvent event) {
        }

        public void mouseClicked(MouseEvent event) {
        }

        public void mouseDragged(MouseEvent event) {
        }

        public void mouseEntered(MouseEvent event) {
        }

        public void mouseExited(MouseEvent event) {
            GraphViewer.this.setXOldEvent(-1);
            GraphViewer.this.setYOldEvent(-1);
            GraphViewer.this.repaint();
        }

        public void mouseMoved(MouseEvent event) {
            int x = event.getX();
            int y = event.getY();
            GraphViewer.this.setXOldEvent(x);
            GraphViewer.this.setYOldEvent(y);
            GraphViewer.this.repaint();
        }

        public void mousePressed(MouseEvent event) {
        }

        public void mouseReleased(MouseEvent event) {
        }
    }
}

