/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.graph.plot;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.Vector;
import javax.swing.JFrame;
import org.tigr.midas.graph.GraphBox;
import org.tigr.midas.graph.GraphConstant;
import org.tigr.midas.graph.GraphLine;
import org.tigr.midas.graph.GraphTick;
import org.tigr.midas.graph.GraphViewer;
import org.tigr.midas.graph.plot.Plot;
import org.tigr.midas.graph.plot.PlotData;
import org.tigr.midas.math.MathTools;
import org.tigr.midas.math.QSort;
import org.tigr.midas.math.StatsTools;
import org.tigr.midas.util.StringSplitter;

public class BoxPlot
extends Plot {
    private GraphViewer graph;
    protected Image image;
    private GraphBox gb;
    private GraphLine gl;
    private GraphTick gt;
    private float yMin;
    private float yMax;
    private int boxNumber;
    private float[] firstQuartile;
    private float[] secondQuartile;
    private float[] thirdQuartile;
    private float[] loWisker;
    private float[] hiWisker;
    private float[] sd;
    private float[] mean;
    private Vector sdVec;
    private Vector meanVec;
    private Vector loWiskerVec;
    private Vector hiWiskerVec;

    public BoxPlot(String fileName) {
        this.sdVec = new Vector(1);
        this.meanVec = new Vector(1);
        this.loWiskerVec = new Vector(1);
        this.hiWiskerVec = new Vector(1);
        float[][] rowArray = new float[100][];
        this.boxNumber = 0;
        try {
            String line = "";
            BufferedReader inFile = new BufferedReader(new FileReader(fileName));
            do {
                line = inFile.readLine();
                StringSplitter st = new StringSplitter(line, '\t');
                Vector<String> inputRowVec = new Vector<String>();
                while (st.hasMoreTokens()) {
                    inputRowVec.add(st.nextToken());
                }
                rowArray[this.boxNumber] = new float[inputRowVec.size()];
                int i = 0;
                while (i < inputRowVec.size()) {
                    rowArray[this.boxNumber][i] = Float.parseFloat(inputRowVec.elementAt(i).toString());
                    ++i;
                }
                ++this.boxNumber;
            } while (line.length() != 0);
        }
        catch (NullPointerException e) {
        }
        catch (FileNotFoundException nfex) {
            nfex.printStackTrace();
        }
        catch (NumberFormatException nex) {
            nex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.firstQuartile = new float[this.boxNumber];
        this.secondQuartile = new float[this.boxNumber];
        this.thirdQuartile = new float[this.boxNumber];
        this.hiWisker = new float[this.boxNumber];
        this.loWisker = new float[this.boxNumber];
        this.sd = new float[this.boxNumber];
        this.mean = new float[this.boxNumber];
        int boxNdx = 0;
        while (boxNdx < this.boxNumber) {
            QSort qSort = new QSort(rowArray[boxNdx]);
            float[] sortedRowArray = qSort.getSorted();
            if (this.yMin > sortedRowArray[0]) {
                this.yMin = sortedRowArray[0];
            }
            if (this.yMax < sortedRowArray[sortedRowArray.length - 1]) {
                this.yMax = sortedRowArray[sortedRowArray.length - 1];
            }
            this.firstQuartile[boxNdx] = sortedRowArray[new Double(Math.ceil((double)sortedRowArray.length * 0.25)).intValue() - 1];
            this.secondQuartile[boxNdx] = sortedRowArray[new Double(Math.ceil((double)sortedRowArray.length * 0.5)).intValue() - 1];
            this.thirdQuartile[boxNdx] = sortedRowArray[new Double(Math.ceil((double)sortedRowArray.length * 0.75)).intValue() - 1];
            StatsTools l = new StatsTools();
            l.computeMeanSD(sortedRowArray);
            this.mean[boxNdx] = l.getXMean();
            this.sd[boxNdx] = l.getXSD();
            float iqr = this.thirdQuartile[boxNdx] - this.firstQuartile[boxNdx];
            this.hiWisker[boxNdx] = this.mean[boxNdx] + 0.5f * this.sd[boxNdx] + 1.5f * iqr;
            this.loWisker[boxNdx] = this.mean[boxNdx] - 0.5f * this.sd[boxNdx] - 1.5f * iqr;
            ++boxNdx;
        }
        this.sdVec.add(this.sd);
        this.meanVec.add(this.mean);
        this.hiWiskerVec.add(this.hiWisker);
        this.loWiskerVec.add(this.loWisker);
        this.createPlot(1);
        super.setGraph(this.graph);
    }

    public BoxPlot(Vector plotFilesVec) {
        this.sdVec = new Vector();
        this.meanVec = new Vector();
        this.loWiskerVec = new Vector();
        this.hiWiskerVec = new Vector();
        int ndx = 0;
        while (ndx < plotFilesVec.size()) {
            String fileName = (String)plotFilesVec.elementAt(ndx);
            float[][] rowArray = new float[100][];
            this.boxNumber = 0;
            try {
                String line = "";
                BufferedReader inFile = new BufferedReader(new FileReader(fileName));
                do {
                    line = inFile.readLine();
                    StringSplitter st = new StringSplitter(line, '\t');
                    Vector<String> inputRowVec = new Vector<String>();
                    while (st.hasMoreTokens()) {
                        inputRowVec.add(st.nextToken());
                    }
                    rowArray[this.boxNumber] = new float[inputRowVec.size()];
                    int i = 0;
                    while (i < inputRowVec.size()) {
                        rowArray[this.boxNumber][i] = Float.parseFloat(inputRowVec.elementAt(i).toString());
                        ++i;
                    }
                    ++this.boxNumber;
                } while (line.length() != 0);
            }
            catch (NullPointerException e) {
            }
            catch (FileNotFoundException nfex) {
                nfex.printStackTrace();
            }
            catch (NumberFormatException nex) {
                nex.printStackTrace();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.firstQuartile = new float[this.boxNumber];
            this.secondQuartile = new float[this.boxNumber];
            this.thirdQuartile = new float[this.boxNumber];
            this.hiWisker = new float[this.boxNumber];
            this.loWisker = new float[this.boxNumber];
            this.sd = new float[this.boxNumber];
            this.mean = new float[this.boxNumber];
            int boxNdx = 0;
            while (boxNdx < this.boxNumber) {
                QSort qSort = new QSort(rowArray[boxNdx]);
                float[] sortedRowArray = qSort.getSorted();
                if (this.yMin > sortedRowArray[0]) {
                    this.yMin = sortedRowArray[0];
                }
                if (this.yMax < sortedRowArray[sortedRowArray.length - 1]) {
                    this.yMax = sortedRowArray[sortedRowArray.length - 1];
                }
                this.firstQuartile[boxNdx] = sortedRowArray[new Double(Math.ceil((double)sortedRowArray.length * 0.25)).intValue() - 1];
                this.secondQuartile[boxNdx] = sortedRowArray[new Double(Math.ceil((double)sortedRowArray.length * 0.5)).intValue() - 1];
                this.thirdQuartile[boxNdx] = sortedRowArray[new Double(Math.ceil((double)sortedRowArray.length * 0.75)).intValue() - 1];
                StatsTools l = new StatsTools();
                l.computeMeanSD(sortedRowArray);
                this.mean[boxNdx] = l.getXMean();
                this.sd[boxNdx] = l.getXSD();
                float iqr = this.thirdQuartile[boxNdx] - this.firstQuartile[boxNdx];
                this.hiWisker[boxNdx] = this.mean[boxNdx] + 0.5f * this.sd[boxNdx] + 1.5f * iqr;
                this.loWisker[boxNdx] = this.mean[boxNdx] - 0.5f * this.sd[boxNdx] - 1.5f * iqr;
                ++boxNdx;
            }
            this.sdVec.add(this.sd);
            this.meanVec.add(this.mean);
            this.hiWiskerVec.add(this.hiWisker);
            this.loWiskerVec.add(this.loWisker);
            ++ndx;
        }
        this.createPlot(plotFilesVec.size());
        super.setGraph(this.graph);
    }

    protected void createPlot(PlotData plotData) {
    }

    public void createPlot(int m) {
        int intYmin = (int)(this.yMin - 1.0f);
        int intYmax = (int)(this.yMax + 1.0f);
        float absYmax = Math.abs(intYmin) < Math.abs(intYmax) ? (float)Math.abs(intYmax) : (float)Math.abs(intYmin);
        try {
            boolean[] initShown = new boolean[m];
            Color[] initColors = new Color[m];
            int i = 0;
            while (i < initShown.length) {
                initColors[i] = GraphConstant.COLORARRAY[i];
                initShown[i] = !initShown[i];
                ++i;
            }
            this.graph = new GraphViewer(0, 750, 0, 500, 0.0f, (float)this.boxNumber + 1.0f, 0.0f, -1.0f * absYmax, absYmax, 0.0f, 55, 30, 40, 60, "Box Plot", "Block", "", initColors, initShown);
            this.gl = new GraphLine(0.0, -1.0f * absYmax, 0.0, absYmax, this.netColor);
            this.graph.addGraphElement(this.gl);
            this.gl = new GraphLine(this.boxNumber + 1, -1.0f * absYmax, this.boxNumber + 1, absYmax, this.netColor);
            this.graph.addGraphElement(this.gl);
            this.gl = new GraphLine(0.0, -1.0f * absYmax, this.boxNumber + 1, -1.0f * absYmax, this.netColor);
            this.graph.addGraphElement(this.gl);
            this.gl = new GraphLine(0.0, absYmax, this.boxNumber + 1, absYmax, this.netColor);
            this.graph.addGraphElement(this.gl);
            int ndx = 0;
            while (ndx < m) {
                float[] theSD = (float[])this.sdVec.elementAt(ndx);
                float[] theMean = (float[])this.meanVec.elementAt(ndx);
                float[] theHiWisker = (float[])this.hiWiskerVec.elementAt(ndx);
                float[] theLoWisker = (float[])this.loWiskerVec.elementAt(ndx);
                if (initShown[ndx]) {
                    int i2 = 0;
                    while (i2 < this.boxNumber) {
                        this.gb = new GraphBox((double)i2 + 0.75, (double)theMean[i2] - 0.5 * (double)theSD[i2], (double)i2 + 1.25, (double)theMean[i2] + 0.5 * (double)theSD[i2], initColors[ndx], 0);
                        this.gb.setBelong(ndx);
                        this.graph.addGraphElement(this.gb);
                        this.gl = new GraphLine((double)i2 + 0.75, theLoWisker[i2], (double)i2 + 1.25, theLoWisker[i2], initColors[ndx]);
                        this.gl.setBelong(ndx);
                        this.graph.addGraphElement(this.gl);
                        this.gl = new GraphLine((double)i2 + 0.75, theHiWisker[i2], (double)i2 + 1.25, theHiWisker[i2], initColors[ndx]);
                        this.gl.setBelong(ndx);
                        this.graph.addGraphElement(this.gl);
                        this.gl = new GraphLine(i2 + 1, theLoWisker[i2], i2 + 1, theHiWisker[i2], initColors[ndx]);
                        this.gl.setBelong(ndx);
                        this.graph.addGraphElement(this.gl);
                        ++i2;
                    }
                }
                ++ndx;
            }
            this.gl = new GraphLine(0.0, 0.0, this.boxNumber + 1, 0.0, Color.red);
            this.graph.addGraphElement(this.gl);
            float i3 = -1 * intYmax;
            while (i3 <= (float)intYmax) {
                float s = MathTools.roundUpToPlace(i3, 1);
                this.gt = s == 0.0f ? new GraphTick(i3, 8, Color.black, 1, 0, "0", Color.black) : new GraphTick(i3, 8, Color.black, 1, 0, "" + s, Color.black);
                this.graph.addGraphElement(this.gt);
                i3 += absYmax / 5.0f;
            }
            int i4 = 0;
            while (i4 <= this.boxNumber) {
                this.gt = i4 == 0 ? new GraphTick(i4, 8, Color.black, 0, 0, "0", Color.black) : new GraphTick(i4, 8, Color.black, 0, 0, "" + i4, Color.black);
                this.graph.addGraphElement(this.gt);
                ++i4;
            }
            this.graph.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        Vector<String> v = new Vector<String>();
        v.addElement("C:\\2.18Test\\sdtest\\sd_reg\\NFE005d0001_block_pre.box");
        BoxPlot p = new BoxPlot(v);
        JFrame frame = new JFrame("BoxPlot Test");
        frame.getContentPane().add(p.getGraph());
        frame.setSize(new Dimension(800, 600));
        frame.setVisible(true);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
    }
}

