/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.graph.plot;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.util.Vector;
import javax.swing.JFrame;
import org.tigr.midas.graph.GraphConstant;
import org.tigr.midas.graph.GraphLine;
import org.tigr.midas.graph.GraphPoint;
import org.tigr.midas.graph.GraphTick;
import org.tigr.midas.graph.GraphViewer;
import org.tigr.midas.graph.plot.Plot;
import org.tigr.midas.graph.plot.PlotData;
import org.tigr.midas.graph.plot.PlotFileParser;

public class LogIntensityPlot
extends Plot {
    private GraphViewer graph;
    protected Image image;
    private PlotFileParser plotFileParser;
    private int dataCounts;
    private GraphPoint gp;
    private GraphLine gl;
    private GraphTick gt;

    public LogIntensityPlot(String fileName) {
        int[] c = new int[]{0, 1};
        PlotData plotData = new PlotData(1);
        plotData.setTitle("Log ChannelB Intensity vs. Log ChannelA Intensity");
        plotData.setXLabel("log\u2081\u2080I(A)");
        plotData.setYLabel("log\u2081\u2080I(B)");
        try {
            this.plotFileParser = new PlotFileParser(fileName);
            this.dataCounts = this.plotFileParser.getDataCount();
            plotData.addXData(this.plotFileParser.getColArrays(c)[0]);
            plotData.addYData(this.plotFileParser.getColArrays(c)[1]);
            plotData.setXBound(this.plotFileParser.getColArrays(c)[0]);
            plotData.setYBound(this.plotFileParser.getColArrays(c)[1]);
            this.createPlot(plotData);
            super.setGraph(this.graph);
        }
        catch (FileNotFoundException nfex) {
            nfex.printStackTrace();
        }
        catch (NumberFormatException nex) {
            nex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public LogIntensityPlot(Vector plotFilesVec) {
        int[] c = new int[]{0, 1};
        PlotData plotData = new PlotData(plotFilesVec.size());
        plotData.setTitle("Log ChannelB Intensity vs. Log ChannelA Intensity");
        plotData.setXLabel("log\u2081\u2080I(A)");
        plotData.setYLabel("log\u2081\u2080I(B)");
        int ndx = 0;
        while (ndx < plotFilesVec.size()) {
            String fileName = (String)plotFilesVec.elementAt(ndx);
            try {
                this.plotFileParser = new PlotFileParser(fileName);
                this.dataCounts = this.plotFileParser.getDataCount();
                plotData.addXData(this.plotFileParser.getColArrays(c)[0]);
                plotData.addYData(this.plotFileParser.getColArrays(c)[1]);
                plotData.setXBound(this.plotFileParser.getColArrays(c)[0]);
                plotData.setYBound(this.plotFileParser.getColArrays(c)[1]);
            }
            catch (FileNotFoundException nfex) {
                nfex.printStackTrace();
            }
            catch (NumberFormatException nex) {
                nex.printStackTrace();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ++ndx;
        }
        this.createPlot(plotData);
        super.setGraph(this.graph);
    }

    protected void createPlot(PlotData plotData) {
        boolean[] initShown = new boolean[plotData.fNumber];
        Color[] initColors = new Color[plotData.fNumber];
        int i = 0;
        while (i < initShown.length) {
            initColors[i] = GraphConstant.COLORARRAY[i];
            initShown[i] = !initShown[i];
            ++i;
        }
        float xMin = plotData.getXMin();
        float xMax = plotData.getXMax();
        float xGap = xMax - xMin;
        float xStep = new Float(xGap).intValue() / 10;
        float yMin = plotData.getYMin();
        float yMax = plotData.getYMax();
        float yGap = yMax - yMin;
        float yStep = new Float(yGap).intValue() / 10;
        if ((double)xStep <= 0.5) {
            xStep = 0.5f;
        } else if (xStep <= 2.0f) {
            xStep = 1.0f;
        } else if (xStep <= 5.0f) {
            xStep = 2.0f;
        } else if (xStep <= 10.0f) {
            xStep = 5.0f;
        } else if (xStep <= 100.0f) {
            xStep = 10.0f;
        }
        float xLo = new Float(xMin).intValue();
        float xHi = new Float(xMax).intValue() + 1;
        if ((double)yStep <= 0.5) {
            yStep = 0.5f;
        } else if (xStep <= 2.0f) {
            yStep = 1.0f;
        } else if (xStep <= 5.0f) {
            yStep = 2.0f;
        } else if (xStep <= 10.0f) {
            yStep = 5.0f;
        } else if (xStep <= 100.0f) {
            yStep = 10.0f;
        }
        float yLo = new Float(yMin).intValue();
        float yHi = new Float(yMax).intValue() + 1;
        this.graph = new GraphViewer(0, 750, 0, 500, xLo, xHi, xStep, yLo, yHi, yStep, 55, 30, 40, 60, plotData.title, plotData.xLabel, plotData.yLabel, initColors, initShown);
        float i2 = xLo;
        while (i2 <= xHi) {
            this.gl = new GraphLine(i2, yLo, i2, yHi, this.netColor);
            this.graph.addGraphElement(this.gl);
            i2 += xStep;
        }
        this.gl = new GraphLine(xHi, yLo, xHi, yHi, this.netColor);
        this.graph.addGraphElement(this.gl);
        float i3 = yLo;
        while (i3 <= yHi) {
            this.gl = new GraphLine(xLo, i3, xHi, i3, this.netColor);
            this.graph.addGraphElement(this.gl);
            i3 += yStep;
        }
        this.gl = new GraphLine(xLo, yHi, xHi, yHi, this.netColor);
        this.graph.addGraphElement(this.gl);
        float i4 = yLo;
        while (i4 <= yHi) {
            if (i4 == 0.0f) {
                this.gt = new GraphTick(i4, 8, Color.black, 1, 0, "0", Color.black);
            } else {
                String yStepStr = new Float(i4).toString();
                this.gt = new GraphTick(i4, 8, Color.black, 1, 0, "" + yStepStr, Color.black);
            }
            this.graph.addGraphElement(this.gt);
            i4 += yStep;
        }
        float i5 = xLo;
        while (i5 <= xHi) {
            if (i5 == 0.0f) {
                this.gt = new GraphTick(i5, 8, Color.black, 0, 0, "" + i5, Color.black);
            } else {
                String xStepStr = new Float(i5).toString();
                this.gt = new GraphTick(i5, 8, Color.black, 0, 0, "" + xStepStr, Color.black);
            }
            this.graph.addGraphElement(this.gt);
            i5 += xStep;
        }
        int ndx = 0;
        while (ndx < plotData.fNumber) {
            if (initShown[ndx]) {
                float[] x = (float[])plotData.xList.get(ndx);
                float[] y = (float[])plotData.yList.get(ndx);
                int i6 = 0;
                while (i6 < x.length) {
                    this.gp = new GraphPoint(x[i6], y[i6], initColors[ndx], 3);
                    this.gp.setBelong(ndx);
                    this.graph.addGraphElement(this.gp);
                    ++i6;
                }
            }
            ++ndx;
        }
        this.plotFacts = this.plotFacts + "- Total data points:  " + this.dataCounts + "\r";
        this.plotFacts = this.plotFacts + "- log\u2081\u2080I(A) minimum: " + plotData.getXMin() + "\r";
        this.plotFacts = this.plotFacts + "- log\u2081\u2080I(A) maximum: " + plotData.getXMax() + "\r";
        this.plotFacts = this.plotFacts + "- log\u2081\u2080I(B) minimum: " + plotData.getYMin() + "\r";
        this.plotFacts = this.plotFacts + "- log\u2081\u2080I(B) maximum: " + plotData.getYMax();
        this.graph.setVisible(true);
    }

    public static void main(String[] args) {
        Vector<String> v = new Vector<String>();
        v.addElement("C:\\2.19Test\\CGHTest\\raw\\12863866_MaleCY5_FemCY3_raw.lty");
        v.addElement("C:\\2.19Test\\1-PDFtest\\raw\\NFE005d0006_raw.lty");
        LogIntensityPlot p = new LogIntensityPlot(v);
        JFrame frame = new JFrame("LogIntensityPlot Test");
        frame.getContentPane().add(p.getGraph());
        frame.setSize(new Dimension(800, 600));
        frame.setVisible(true);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
    }
}

