/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.graph.plot;

import java.util.ArrayList;
import java.util.Arrays;
import org.tigr.midas.math.QSort;

public class PlotData {
    protected String title;
    protected String xLabel;
    protected String yLabel;
    protected ArrayList xList;
    protected ArrayList yList;
    protected int fNumber;
    protected float xMin;
    protected float xMax;
    protected float yMin;
    protected float yMax;
    protected int xMinI;
    protected int xMaxI;
    protected int yMinI;
    protected int yMaxI;
    boolean isXBoundSet;
    boolean isYBoundSet;

    public PlotData() {
    }

    public PlotData(int dataSets) {
        this.fNumber = dataSets;
        this.xList = new ArrayList(dataSets);
        this.yList = new ArrayList(dataSets);
        this.isXBoundSet = false;
        this.isYBoundSet = false;
    }

    public void setTitle(String s) {
        this.title = s;
    }

    public void setXLabel(String s) {
        this.xLabel = s;
    }

    public void setYLabel(String s) {
        this.yLabel = s;
    }

    public void addXData(float[] x) {
        this.xList.add(x);
        this.setXBound(x);
    }

    public void addXData(int[] x) {
        this.xList.add(x);
    }

    public void addYData(float[] y) {
        this.yList.add(y);
    }

    public void addYData(int[] y) {
        this.yList.add(y);
    }

    public ArrayList getXList() {
        return this.xList;
    }

    public ArrayList getYList() {
        return this.yList;
    }

    public float getXMin() {
        return this.xMin;
    }

    public float getXMax() {
        return this.xMax;
    }

    public float getYMin() {
        return this.yMin;
    }

    public float getYMax() {
        return this.yMax;
    }

    public int getXMinI() {
        return this.xMinI;
    }

    public int getXMaxI() {
        return this.xMaxI;
    }

    public int getYMinI() {
        return this.yMinI;
    }

    public int getYMaxI() {
        return this.yMaxI;
    }

    public void setXBound(float[] x) {
        float[] t = new float[x.length];
        System.arraycopy(x, 0, t, 0, x.length);
        float[] sortedx = new QSort(t).getSorted();
        if (this.isXBoundSet) {
            this.xMin = Math.min(this.xMin, sortedx[0]);
            this.xMax = Math.max(this.xMax, sortedx[x.length - 1]);
        } else {
            this.xMin = sortedx[0];
            this.xMax = sortedx[x.length - 1];
            this.isXBoundSet = true;
        }
    }

    public void setYBound(float[] y) {
        float[] t = new float[y.length];
        System.arraycopy(y, 0, t, 0, y.length);
        float[] sortedy = new QSort(t).getSorted();
        if (this.isYBoundSet) {
            this.yMin = Math.min(this.yMin, sortedy[0]);
            this.yMax = Math.max(this.yMax, sortedy[y.length - 1]);
        } else {
            this.yMin = sortedy[0];
            this.yMax = sortedy[y.length - 1];
            this.isYBoundSet = true;
        }
    }

    public void setXBound(int[] x) {
        int[] t = new int[x.length];
        System.arraycopy(x, 0, t, 0, x.length);
        Arrays.sort(x);
        if (this.isXBoundSet) {
            this.xMinI = Math.min(this.xMinI, t[0]);
            this.xMaxI = Math.max(this.xMaxI, t[t.length - 1]);
        } else {
            this.xMinI = t[0];
            this.xMaxI = t[t.length - 1];
            this.isXBoundSet = true;
        }
    }

    public void setYBound(int[] y) {
        int[] t = new int[y.length];
        System.arraycopy(y, 0, t, 0, y.length);
        Arrays.sort(t);
        if (this.isYBoundSet) {
            this.yMinI = Math.min(this.yMinI, t[0]);
            this.yMaxI = Math.max(this.yMaxI, t[t.length - 1]);
        } else {
            this.yMinI = t[0];
            this.yMaxI = t[t.length - 1];
            this.isYBoundSet = true;
        }
    }
}

