/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.math;

import drasys.or.prob.NormalDistribution;
import drasys.or.prob.StudentsTDistribution;

public class StatsTools {
    private float[] wholeX;
    private float[] wholeY;
    private int dataSize;
    private int validCount;
    private float a;
    private float b;
    private float xMean;
    private float yMean;
    private float xVariance;
    private float xSD;
    private float yVariance;
    private float xyCovariance;
    private float correlationCoeff;
    private float xRegressionCoeff;
    private float yRegressionCoeff;
    private int dF;
    private float tVal;
    private float pVal;

    public void computeMeanSD(float[] wholeX) {
        this.wholeX = wholeX;
        float sumX = 0.0f;
        float sumX2 = 0.0f;
        this.dataSize = wholeX.length;
        int i = 0;
        while (i < this.dataSize) {
            if (!Float.isInfinite(wholeX[i])) {
                sumX += wholeX[i];
                sumX2 += wholeX[i] * wholeX[i];
            }
            ++i;
        }
        this.xMean = sumX / (float)this.dataSize;
        this.xVariance = sumX2 - (float)this.dataSize * this.xMean * this.xMean;
        this.xSD = (float)Math.sqrt(this.xVariance / (float)(this.dataSize - 1));
    }

    public void computeMeanSDforNonZero(float[] wholeX) {
        this.wholeX = wholeX;
        float sumX = 0.0f;
        float sumX2 = 0.0f;
        int nonZeroCount = 0;
        this.dataSize = wholeX.length;
        int i = 0;
        while (i < this.dataSize) {
            if (wholeX[i] != 0.0f) {
                sumX += wholeX[i];
                sumX2 += wholeX[i] * wholeX[i];
                ++nonZeroCount;
            }
            ++i;
        }
        this.dataSize = nonZeroCount;
        this.xMean = sumX / (float)this.dataSize;
        this.xVariance = sumX2 - (float)this.dataSize * this.xMean * this.xMean;
        this.xSD = (float)Math.sqrt(this.xVariance / (float)(this.dataSize - 1));
    }

    public void linearRegression(float[] wholeX, float[] wholeY) {
        this.wholeX = wholeX;
        this.wholeY = wholeY;
        float sumX = 0.0f;
        float sumY = 0.0f;
        float sumX2 = 0.0f;
        float sumY2 = 0.0f;
        float sumXY = 0.0f;
        this.validCount = 0;
        int i = 0;
        while (i < wholeX.length) {
            if (!Float.isNaN(wholeX[i]) && !Float.isNaN(wholeY[i])) {
                sumX += wholeX[i];
                sumX2 += wholeX[i] * wholeX[i];
                sumY += wholeY[i];
                sumY2 += wholeY[i] * wholeY[i];
                sumXY += wholeX[i] * wholeY[i];
                ++this.validCount;
            }
            ++i;
        }
        this.xMean = sumX / (float)this.validCount;
        this.yMean = sumY / (float)this.validCount;
        this.b = (sumXY - sumX * sumY / (float)this.validCount) / (sumX2 - sumX * sumX / (float)this.validCount);
        this.a = this.yMean - this.b * this.xMean;
        this.xVariance = sumX2 - (float)this.validCount * this.xMean * this.xMean;
        this.yVariance = sumY2 - (float)this.validCount * this.yMean * this.yMean;
        this.xyCovariance = sumXY - (float)this.validCount * this.xMean * this.yMean;
        this.correlationCoeff = (float)Math.sqrt(((float)this.validCount * sumXY - sumX * sumY) * ((float)this.validCount * sumXY - sumX * sumY) / (((float)this.validCount * sumX2 - sumX * sumX) * ((float)this.validCount * sumY2 - sumY * sumY)));
        float r = (float)Math.sqrt(this.xyCovariance * this.xyCovariance / (this.xVariance * this.yVariance));
        this.xRegressionCoeff = (float)Math.sqrt(this.xyCovariance / this.yVariance);
        this.yRegressionCoeff = (float)Math.sqrt(this.xyCovariance / this.xVariance);
    }

    public void ttest(float[] wholeX, float nullHypoVal) {
        this.dF = wholeX.length - 1;
        this.computeMeanSD(wholeX);
        this.tVal = (this.xMean - nullHypoVal) * (float)Math.sqrt(wholeX.length) / this.getXSD();
        StudentsTDistribution tDist = new StudentsTDistribution((double)this.dF);
        this.pVal = (float)tDist.pdf((double)this.tVal);
        System.out.println("xMean = " + this.xMean + ", dF = " + this.dF + ", tVal = " + this.tVal + ", pVal = " + this.pVal);
    }

    public float getIntercept() {
        return this.a;
    }

    public float getSlope() {
        return this.b;
    }

    public float getXMean() {
        return this.xMean;
    }

    public float getYMean() {
        return this.yMean;
    }

    public float getXVariance() {
        return this.xVariance;
    }

    public int getDataSize() {
        return this.dataSize;
    }

    public int getValidCount() {
        return this.validCount;
    }

    public float getCorrelationCoeff() {
        return this.correlationCoeff;
    }

    public float getXRegressionCoeff() {
        return this.xRegressionCoeff;
    }

    public float getYRessionCoeff() {
        return this.yRegressionCoeff;
    }

    public float getXSD() {
        return this.xSD;
    }

    public static void main(String[] args) {
        float[] y = new float[]{55.95f, 68.24f, 52.73f, 21.5f, 23.78f};
        StatsTools l = new StatsTools();
        l.ttest(y, 0.0f);
        NormalDistribution normDist = new NormalDistribution();
        System.out.println("Z-distribution, Prob(-1<x<1) = " + normDist.probability(-1.0, 1.0));
        StudentsTDistribution tDist = new StudentsTDistribution(4.0);
        System.out.println("t-distribution, t = 4.7911, p-Value = " + tDist.pdf(4.7911));
        System.out.println("t-distribution, t = 4.7911, p-Value(-4.7911, 4.7911) = " + tDist.probability(-4.7911, 4.7911));
    }
}

