/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.mev;

import java.net.URL;
import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import org.tigr.midas.mev.AnalysisDescription;
import org.tigr.midas.mev.IGUIFactory;

public class GUIFactory
implements IGUIFactory {
    private ResourceBundle bundle;
    private static String BUNDLE_NAME = "org.tigr.microarray.mev.cluster.gui.impl.factory";
    static /* synthetic */ Class class$org$tigr$midas$mev$GUIFactory;

    public GUIFactory() {
        try {
            this.bundle = ResourceBundle.getBundle(BUNDLE_NAME);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public AnalysisDescription[] getAnalysisDescriptions() {
        if (this.bundle == null) {
            return null;
        }
        return this.createAnalysisDescription();
    }

    private AnalysisDescription[] createAnalysisDescription() {
        String names = null;
        try {
            names = this.bundle.getString("gui.names");
        }
        catch (MissingResourceException e) {
            e.printStackTrace();
        }
        if (names == null) {
            return null;
        }
        ArrayList<AnalysisDescription> list = new ArrayList<AnalysisDescription>();
        StringTokenizer tokenizer = new StringTokenizer(names, ":");
        while (tokenizer.hasMoreTokens()) {
            try {
                String key = tokenizer.nextToken();
                if (key.trim().equals("")) continue;
                String name = this.bundle.getString(key + ".name").trim();
                String clazz = this.bundle.getString(key + ".class").trim();
                String tooltip = this.bundle.getString(key + ".tooltip").trim();
                ImageIcon smallIcon = GUIFactory.getIcon(this.bundle.getString(key + ".smallIcon").trim());
                ImageIcon largeIcon = GUIFactory.getIcon(this.bundle.getString(key + ".largeIcon").trim());
                list.add(new AnalysisDescription(name, clazz, smallIcon, largeIcon, tooltip));
            }
            catch (Exception e) {
                System.out.println("Error while reading " + BUNDLE_NAME + ".properties file: ");
                e.printStackTrace();
            }
        }
        return list.toArray(new AnalysisDescription[list.size()]);
    }

    public static ImageIcon getIcon(String name) {
        URL url = (class$org$tigr$midas$mev$GUIFactory == null ? (class$org$tigr$midas$mev$GUIFactory = GUIFactory.class$("org.tigr.midas.mev.GUIFactory")) : class$org$tigr$midas$mev$GUIFactory).getResource("/org/tigr/microarray/mev/cluster/gui/impl/images/" + name);
        if (url == null) {
            return null;
        }
        return new ImageIcon(url);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

