/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.mev;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.tigr.midas.mev.GUIFactory;

public class HelpWindow
extends JDialog {
    String dialogName;
    JEditorPane pane;
    GradientPaint gp;
    Color backgroundColor = new Color(25, 25, 169);
    Color fadeColor = new Color(140, 220, 240);

    public HelpWindow(JDialog parent, String dialogName) {
        super(parent);
        this.dialogName = dialogName;
        int lastIndex = dialogName.indexOf(" ");
        if (lastIndex > 0 && lastIndex <= 4) {
            String abbr = dialogName.substring(0, lastIndex);
            if (abbr != null && abbr.length() > 0) {
                this.setTitle(abbr + ": Parameter Information");
            }
        } else {
            this.setTitle(this.dialogName + ": Parameter Information");
        }
        JPanel iconPanel = new JPanel(new GridBagLayout());
        JLabel iconLabel = new JLabel(GUIFactory.getIcon("dialog_banner2.gif"));
        FillPanel fill = new FillPanel();
        iconPanel.add((Component)iconLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        iconPanel.add((Component)fill, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.pane = new JEditorPane();
        this.pane.setEditable(false);
        this.pane.setForeground(Color.black);
        this.pane.setMinimumSize(new Dimension(100, 100));
        this.getContentPane().setLayout(new GridBagLayout());
        JScrollPane scroll = new JScrollPane();
        scroll.getViewport().setView(this.pane);
        scroll.setPreferredSize(new Dimension(200, 200));
        scroll.setBorder(BorderFactory.createLineBorder(Color.blue, 1));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridBagLayout());
        JButton closeButton = new JButton(" Close Help Window ");
        closeButton.setBorder(BorderFactory.createBevelBorder(0));
        closeButton.requestFocus();
        closeButton.setFocusPainted(false);
        closeButton.setPreferredSize(new Dimension(180, 30));
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HelpWindow.this.dispose();
            }
        });
        buttonPanel.add((Component)new JPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        buttonPanel.add((Component)closeButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 5, 5, 15), 0, 0));
        JPanel mainPanel = new JPanel(new GridBagLayout());
        mainPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        mainPanel.add((Component)iconPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        mainPanel.add((Component)scroll, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        mainPanel.add((Component)buttonPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)mainPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.validate();
        this.pane.setContentType("text/html");
        this.setBackground(new Color(Integer.parseInt("FFFFCC", 16)));
        this.pane.setBackground(new Color(Integer.parseInt("FFFFCC", 16)));
        this.pane.setMargin(new Insets(10, 15, 10, 15));
    }

    public HelpWindow(JFrame parent, String dialogName) {
        super(parent);
        this.dialogName = dialogName;
        int lastIndex = dialogName.indexOf(" ");
        if (lastIndex > 0 && lastIndex <= 4) {
            String abbr = dialogName.substring(0, lastIndex);
            if (abbr != null && abbr.length() > 0) {
                this.setTitle(abbr + ": Parameter Information");
            }
        } else {
            this.setTitle(this.dialogName + ": Parameter Information");
        }
        JPanel iconPanel = new JPanel(new GridBagLayout());
        JLabel iconLabel = new JLabel(GUIFactory.getIcon("dialog_banner2.gif"));
        FillPanel fill = new FillPanel();
        iconPanel.add((Component)iconLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        iconPanel.add((Component)fill, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.pane = new JEditorPane();
        this.pane.setEditable(false);
        this.pane.setForeground(Color.black);
        this.pane.setMinimumSize(new Dimension(100, 100));
        this.getContentPane().setLayout(new GridBagLayout());
        JScrollPane scroll = new JScrollPane();
        scroll.getViewport().setView(this.pane);
        scroll.setPreferredSize(new Dimension(200, 200));
        scroll.setBorder(BorderFactory.createLineBorder(Color.blue, 1));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridBagLayout());
        JButton closeButton = new JButton(" Close Help Window ");
        closeButton.setBorder(BorderFactory.createBevelBorder(0));
        closeButton.requestFocus();
        closeButton.setFocusPainted(false);
        closeButton.setPreferredSize(new Dimension(180, 30));
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HelpWindow.this.dispose();
            }
        });
        buttonPanel.add((Component)new JPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        buttonPanel.add((Component)closeButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 5, 5, 15), 0, 0));
        JPanel mainPanel = new JPanel(new GridBagLayout());
        mainPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        mainPanel.add((Component)iconPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        mainPanel.add((Component)scroll, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        mainPanel.add((Component)buttonPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)mainPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.validate();
        this.pane.setContentType("text/html");
        this.setBackground(new Color(Integer.parseInt("FFFFCC", 16)));
        this.pane.setBackground(new Color(Integer.parseInt("FFFFCC", 16)));
        this.pane.setMargin(new Insets(10, 15, 10, 15));
    }

    public boolean getWindowContent() {
        String fileName = this.getFileName(this.dialogName);
        if (fileName == null) {
            JOptionPane.showMessageDialog(this, this.dialogName + " help page can not be located.");
            return false;
        }
        try {
            URL url = this.getClass().getResource("/org/tigr/microarray/mev/cluster/gui/impl/dialogs/dialogHelpUtil/dialogHelpPages/" + fileName);
            this.pane.setPage(url);
            return true;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, this.dialogName + " help page can not be found.");
            return false;
        }
    }

    public void setLocation() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
    }

    private String getFileName(String key) {
        if (key.equals("KMC Initialization Dialog")) {
            return "kmc_parameters.html";
        }
        if (key.equals("HCL Initialization Dialog")) {
            return "hcl_parameters.html";
        }
        if (key.equals("SOTA Initialization Dialog")) {
            return "sota_parameters.html";
        }
        if (key.equals("CAST Initialization Dialog")) {
            return "cast_parameters.html";
        }
        if (key.equals("PCA Initialization Dialog")) {
            return "pca_parameters.html";
        }
        if (key.equals("RN Initialization Dialog")) {
            return "rn_parameters.html";
        }
        if (key.equals("SOM Initialization Dialog")) {
            return "som_parameters.html";
        }
        if (key.equals("GSH Initialization Dialog")) {
            return "gsh_parameters.html";
        }
        if (key.equals("QTC Initialization Dialog")) {
            return "qtc_parameters.html";
        }
        if (key.equals("FOM Initialization Dialog")) {
            return "fom_parameters.html";
        }
        if (key.equals("KMS Initialization Dialog")) {
            return "kms_parameters.html";
        }
        if (key.equals("PTM Initialization Dialog")) {
            return "ptm_parameters.html";
        }
        if (key.equals("TTEST Initialization Dialog")) {
            return "ttest_parameters.html";
        }
        if (key.equals("SVM Process Initialization Dialog")) {
            return "svm1_parameters.html";
        }
        if (key.equals("SVM Training Initialization Dialog")) {
            return "svm2_parameters.html";
        }
        if (key.equals("ST Initialization Dialog")) {
            return "st_parameters.html";
        }
        if (key.equals("SAM Initialization Dialog")) {
            return "sam_parameters.html";
        }
        if (key.equals("Iterative Log Mean Centering Initialization Dialog")) {
            return "iterativelog_parameters.html";
        }
        if (key.equals("Linear Regression Initialization Dialog")) {
            return "linreg_parameters.html";
        }
        if (key.equals("Ratio Statistics Initialization Dialog")) {
            return "ratiostats_parameters.html";
        }
        if (key.equals("HCL Tree Properties")) {
            return "hcl_tree_config_parameters.html";
        }
        if (key.equals("PCA Result Configuration")) {
            return "pca_result_config.html";
        }
        if (key.equals("PCA Selection Area Configuration")) {
            return "pca_selection_area.html";
        }
        if (key.equals("One Way ANOVA Initialization Dialog")) {
            return "one_way_anova_parameters.html";
        }
        if (key.equals("Cluster Save Dialog")) {
            return "cluster_save_parameters.html";
        }
        if (key.equals("Terrain Map Initialization Dialog")) {
            return "terrain_parameters.html";
        }
        if (key.equals("File Loader")) {
            return "file_loader.html";
        }
        if (key.equals("SOTA Tree Properties")) {
            return "sota_tree_config_parameters.html";
        }
        if (key.equals("GDM Initialization Dialog")) {
            return "gdm_parameters.html";
        }
        if (key.equals("GDM Color Range Dialog")) {
            return "gdm_color_range.html";
        }
        if (key.equals("EASE Initialization Dialog")) {
            return "ease_parameters.html";
        }
        if (key.equals("GDM Result Selection Dialog")) {
            return "result_selection_parameters.html";
        }
        if (key.equals("Set Lower Cutoffs")) {
            return "lower_cutoff_parameters.html";
        }
        if (key.equals("Set Percentage Cutoff")) {
            return "percent_cutoff_parameters.html";
        }
        return null;
    }

    public class FillPanel
    extends JPanel {
        public void paint(Graphics g) {
            super.paint(g);
            Graphics2D g2 = (Graphics2D)g;
            Dimension dim = this.getSize();
            HelpWindow.this.gp = new GradientPaint(0.0f, dim.height / 2, HelpWindow.this.backgroundColor, dim.width, dim.height / 2, HelpWindow.this.fadeColor);
            g2.setPaint(HelpWindow.this.gp);
            g2.fillRect(0, 0, dim.width, dim.height);
            g2.setColor(Color.black);
        }
    }
}

