/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.mev;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.tigr.midas.mev.GUIFactory;
import org.tigr.midas.mev.IViewer;
import org.tigr.midas.mev.LeafInfo;
import org.tigr.midas.mev.data.Experiment;

public class ResultTree
extends JTree
implements Serializable {
    private DefaultMutableTreeNode root;
    private DefaultMutableTreeNode analysisNode;
    Vector dumpVector;

    public ResultTree() {
        this.setCellRenderer(new NodeRenderer());
    }

    public ResultTree(DefaultMutableTreeNode root) {
        super(root);
        this.root = root;
        this.setCellRenderer(new NodeRenderer());
        this.dumpVector = new Vector();
    }

    public DefaultMutableTreeNode getRoot() {
        return this.root;
    }

    public void setRoot(DefaultMutableTreeNode r) {
        this.root = r;
    }

    public DefaultMutableTreeNode getAnalysisNode() {
        return this.analysisNode;
    }

    public void setAnalysisNode(DefaultMutableTreeNode n) {
        this.analysisNode = n;
    }

    public void insertNode(DefaultMutableTreeNode node, DefaultMutableTreeNode parentNode, int locationIndex) {
        if (node == null || parentNode == null) {
            return;
        }
        DefaultTreeModel treeModel = (DefaultTreeModel)this.getModel();
        treeModel.insertNodeInto(node, parentNode, locationIndex);
    }

    public void removeNode(DefaultMutableTreeNode node) {
        DefaultTreeModel treeModel = (DefaultTreeModel)this.getModel();
        treeModel.removeNodeFromParent(node);
    }

    public DefaultMutableTreeNode getNode(Object object) {
        Enumeration<TreeNode> enumeration = this.root.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)enumeration.nextElement();
            if (node.getUserObject() != object) continue;
            return node;
        }
        return null;
    }

    public DefaultMutableTreeNode getNode(String[] nodeNames) {
        DefaultMutableTreeNode node = this.root;
        int i = 0;
        while (i < nodeNames.length) {
            int j = 0;
            while (j < node.getChildCount()) {
                if (node.getChildAt(j).toString().equals(nodeNames[i])) {
                    node = (DefaultMutableTreeNode)node.getChildAt(j);
                }
                ++j;
            }
            ++i;
        }
        if (node.toString().equals(nodeNames[nodeNames.length - 1])) {
            return node;
        }
        return null;
    }

    public void writeResults(ObjectOutputStream oos) throws IOException {
        DefaultTreeModel treeModel;
        DefaultMutableTreeNode timeNode = (DefaultMutableTreeNode)this.analysisNode.getLastChild();
        boolean removedTimeNode = false;
        if (timeNode != null && timeNode.getChildCount() == 0) {
            treeModel = (DefaultTreeModel)this.getModel();
            treeModel.removeNodeFromParent(timeNode);
            removedTimeNode = true;
        }
        this.writeTree(oos, this.analysisNode, 0);
        oos.writeInt(-1);
        if (removedTimeNode) {
            treeModel = (DefaultTreeModel)this.getModel();
            treeModel.insertNodeInto(timeNode, this.analysisNode, this.analysisNode.getChildCount());
        }
    }

    public void writeHistory(ObjectOutputStream oos, DefaultMutableTreeNode historyNode) throws IOException {
        this.writeTree(oos, historyNode, 0);
        oos.writeInt(-1);
    }

    private void writeTree(ObjectOutputStream oos, DefaultMutableTreeNode node, int level) throws IOException {
        int cnt = node.getChildCount();
        oos.writeInt(level);
        Object obj = node.getUserObject();
        oos.writeObject(obj);
        int i = 0;
        while (i < cnt) {
            this.writeTree(oos, (DefaultMutableTreeNode)node.getChildAt(i), level + 1);
            ++i;
        }
    }

    public DefaultMutableTreeNode loadResults(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        int currLevel = 0;
        boolean level = false;
        int prevLevel = -1;
        DefaultMutableTreeNode root = null;
        DefaultMutableTreeNode parent = null;
        DefaultMutableTreeNode child = null;
        int levelChange = 0;
        boolean end = false;
        while (!end) {
            Object obj;
            currLevel = ois.readInt();
            if (currLevel == 0) {
                obj = ois.readObject();
                parent = root = new DefaultMutableTreeNode(obj);
                child = root;
                prevLevel = currLevel;
                continue;
            }
            if (currLevel == -1) {
                end = true;
                continue;
            }
            levelChange = currLevel - prevLevel;
            prevLevel = currLevel;
            if (levelChange > 0) {
                parent = child;
            } else if (levelChange < 0) {
                int i = 0;
                while (i > levelChange) {
                    parent = (DefaultMutableTreeNode)parent.getParent();
                    --i;
                }
            }
            obj = ois.readObject();
            child = new DefaultMutableTreeNode(obj);
            parent.add(child);
        }
        return root;
    }

    public Hashtable getResultHash() {
        Hashtable<String, Object[]> table = new Hashtable<String, Object[]>();
        boolean stop = false;
        int childCount = this.analysisNode.getChildCount();
        String algName = "";
        int i = 0;
        while (i < childCount) {
            DefaultMutableTreeNode analysisRoot = (DefaultMutableTreeNode)this.analysisNode.getChildAt(i);
            Object object = analysisRoot.getUserObject();
            if (object != null) {
                if (object instanceof LeafInfo) {
                    algName = ((LeafInfo)object).toString();
                } else if (object instanceof String) {
                    algName = (String)object;
                }
                Enumeration<TreeNode> enumeration = analysisRoot.depthFirstEnumeration();
                while (!stop && enumeration.hasMoreElements()) {
                    IViewer viewer;
                    DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)enumeration.nextElement();
                    if (!(currentNode.getUserObject() instanceof LeafInfo) || (viewer = ((LeafInfo)currentNode.getUserObject()).getViewer()) == null) continue;
                    Experiment exp = viewer.getExperiment();
                    int[][] clusters = viewer.getClusters();
                    if (exp == null || clusters == null) continue;
                    Object[] vals = new Object[]{exp, clusters};
                    table.put(algName, vals);
                    stop = true;
                }
                stop = false;
            }
            ++i;
        }
        return table;
    }

    private class NodeRenderer
    extends DefaultTreeCellRenderer {
        private Icon defaultLeafIcon;
        private Icon primaryResultIcon = GUIFactory.getIcon("PrimaryResult.gif");
        private Icon expressionImageIcon = GUIFactory.getIcon("ExpressionImageResult.gif");
        private Icon centroidGraphIcon = GUIFactory.getIcon("CentroidResult.gif");
        private Icon expressionGraphIcon = GUIFactory.getIcon("ExpressionGraphResult.gif");
        private Icon hclIcon = GUIFactory.getIcon("HCLResult.gif");
        private Icon nodeHeightIcon = GUIFactory.getIcon("NodeHeightResult.gif");
        private Icon samGraphIcon = GUIFactory.getIcon("SAMGraphResult.gif");
        private Icon volcanoIcon = GUIFactory.getIcon("VolcanoPlotResult.gif");
        private Icon networkIcon = GUIFactory.getIcon("NetworkResult.gif");
        private Icon SOMColorIcon = GUIFactory.getIcon("SOMColorResult.gif");
        private Icon SOMBWIcon = GUIFactory.getIcon("SOMBWResult.gif");
        private Icon gdmMatrixIcon = GUIFactory.getIcon("GDMMatrixResult.gif");
        private Icon clusterInfoIcon = GUIFactory.getIcon("ClusterInformationResult.gif");
        private Icon generalInfoIcon = GUIFactory.getIcon("Information16.gif");
        private Icon tableIcon = GUIFactory.getIcon("TableViewerResult.gif");
        private Icon pca3DIcon = GUIFactory.getIcon("PCA3DResult.gif");
        private Icon trn3DIcon = GUIFactory.getIcon("TerrainResult.gif");
        private Icon mevIcon = GUIFactory.getIcon("mev_mini_splash.gif");
        private Icon mainViewIcon = GUIFactory.getIcon("MainView.gif");
        private Icon analysisIcon = GUIFactory.getIcon("Analysis.gif");
        private Icon clusterManagerIcon = GUIFactory.getIcon("ClusterManager.gif");
        private Icon historyIcon = GUIFactory.getIcon("History.gif");
        private Icon dotTerminalIcon = GUIFactory.getIcon("TerminalDot.gif");
        private Icon scriptManagerIcon = GUIFactory.getIcon("ScriptManager.gif");
        private DefaultMutableTreeNode parent;
        private DefaultMutableTreeNode grandParent;
        private JLabel label;

        public NodeRenderer() {
            this.setIcon(this.closedIcon);
            super.setOpaque(false);
            this.setIconTextGap(2);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean isLeaf, int row, boolean hasFocus) {
            this.selected = selected;
            String text = "";
            String parentText = "";
            String grandParentText = "";
            Object userObj = ((DefaultMutableTreeNode)value).getUserObject();
            this.setBorder(null);
            if (!isLeaf) {
                if (userObj instanceof String) {
                    text = (String)userObj;
                    this.setText(text);
                } else if (userObj instanceof LeafInfo) {
                    text = ((LeafInfo)userObj).toString();
                    this.setText(text);
                }
                if (expanded) {
                    this.setIcon(this.openIcon);
                } else {
                    this.setIcon(this.closedIcon);
                }
                if (text.indexOf("Expression Image") != -1) {
                    this.setIcon(this.expressionImageIcon);
                } else if (text.indexOf("Centroid") != -1) {
                    this.setIcon(this.centroidGraphIcon);
                } else if (text.indexOf("Expression Graph") != -1) {
                    this.setIcon(this.expressionGraphIcon);
                } else if (text.equals("Analysis Results")) {
                    this.setIcon(this.analysisIcon);
                } else if (text.equals("Cluster Manager")) {
                    this.setIcon(this.clusterManagerIcon);
                } else if (text.equals("Script Manager")) {
                    this.setIcon(this.scriptManagerIcon);
                } else if (text.equals("History")) {
                    this.setIcon(this.historyIcon);
                } else if (text.equals("General Information")) {
                    this.setIcon(this.generalInfoIcon);
                } else if (text.indexOf(40) != -1 && ((DefaultMutableTreeNode)value).getParent() == ResultTree.this.root.getChildAt(2)) {
                    this.setIcon(this.primaryResultIcon);
                } else if (text.indexOf("F-Ratio") != -1 || text.indexOf("Statistic") != -1 || text.indexOf("Table") != -1) {
                    this.setIcon(this.tableIcon);
                } else if (text.equals("Cluster Information")) {
                    this.setIcon(this.clusterInfoIcon);
                } else if (text.equals("MultipleExperimentViewer")) {
                    this.setText("");
                    this.setBorder(new EmptyBorder(3, 2, 3, 0));
                    this.setIcon(this.mevIcon);
                } else if (text.equals("Hierarchical Trees")) {
                    this.setIcon(this.hclIcon);
                } else if (text.equals("SOM Visualization")) {
                    this.setIcon(this.SOMColorIcon);
                } else if (text.indexOf("Network") != -1) {
                    this.setIcon(this.networkIcon);
                }
            } else {
                this.setIcon(this.leafIcon);
                if (userObj instanceof String) {
                    text = (String)userObj;
                    this.setText(text);
                    this.setIcon(this.dotTerminalIcon);
                } else if (userObj instanceof LeafInfo) {
                    text = ((LeafInfo)userObj).toString();
                    this.setText(text);
                    this.parent = (DefaultMutableTreeNode)((DefaultMutableTreeNode)value).getParent();
                    if (this.parent.getUserObject() instanceof String) {
                        parentText = (String)this.parent.getUserObject();
                    } else if (this.parent.getUserObject() instanceof LeafInfo) {
                        parentText = ((LeafInfo)this.parent.getUserObject()).toString();
                    }
                    this.grandParent = (DefaultMutableTreeNode)this.parent.getParent();
                    if (this.grandParent != null) {
                        if (this.grandParent.getUserObject() instanceof String) {
                            grandParentText = (String)this.grandParent.getUserObject();
                        } else if (this.grandParent.getUserObject() instanceof LeafInfo) {
                            grandParentText = ((LeafInfo)this.grandParent.getUserObject()).toString();
                        }
                    } else {
                        grandParentText = null;
                    }
                    if (parentText.indexOf("Expression Image") != -1) {
                        this.setIcon(this.expressionImageIcon);
                    } else if (parentText.indexOf("Centroid") != -1) {
                        this.setIcon(this.centroidGraphIcon);
                    } else if (parentText.indexOf("Expression Graph") != -1) {
                        this.setIcon(this.expressionGraphIcon);
                    } else if (parentText.indexOf("Cluster Manager") != -1) {
                        this.setIcon(this.tableIcon);
                    } else if (parentText.indexOf("F-Ratio") != -1 || parentText.indexOf("Statistic") != -1) {
                        this.setIcon(this.tableIcon);
                    } else if (parentText.equals("Cluster Information") || text.equals("Classification Information")) {
                        this.setIcon(this.clusterInfoIcon);
                    } else if (text.equals("MultipleExperimentViewer")) {
                        this.setIcon(this.openIcon);
                    } else if (text.equals("Main View")) {
                        this.setIcon(this.mainViewIcon);
                    } else if (text.equalsIgnoreCase("Analysis Results")) {
                        this.setIcon(this.analysisIcon);
                    } else if (text.equalsIgnoreCase("Cluster Manager")) {
                        this.setIcon(this.clusterManagerIcon);
                    } else if (text.equals("Script Manager")) {
                        this.setIcon(this.scriptManagerIcon);
                    } else if (text.equalsIgnoreCase("History")) {
                        this.setIcon(this.historyIcon);
                    } else if (text.indexOf("able") != -1) {
                        this.setIcon(this.tableIcon);
                    } else if (parentText.indexOf("Hierarchical") != -1 || text.indexOf("Tree") != -1 || text.indexOf("Dendogram") != -1) {
                        this.setIcon(this.hclIcon);
                    } else if (text.equals("Expression Image")) {
                        this.setIcon(this.expressionImageIcon);
                    } else if (text.equals("Expression Graph")) {
                        this.setIcon(this.expressionGraphIcon);
                    } else if (text.equals("Centroid Graph")) {
                        this.setIcon(this.centroidGraphIcon);
                    } else if (parentText.indexOf("Table") != -1 || text.indexOf("SVM") != -1) {
                        this.setIcon(this.tableIcon);
                    } else if (text.indexOf("Height Plot") != -1 || text.indexOf("SOTA Diversity") != -1 || text.indexOf("Graph - FOM") != -1) {
                        this.setIcon(this.nodeHeightIcon);
                    } else if (text.equals("Volcano Plot")) {
                        this.setIcon(this.volcanoIcon);
                    } else if (text.equals("SAM Graph")) {
                        this.setIcon(this.samGraphIcon);
                    } else if (text.indexOf("Network") != -1) {
                        this.setIcon(this.networkIcon);
                    } else if (text.equals("Matrix View")) {
                        this.setIcon(this.gdmMatrixIcon);
                    } else if (text.equals("U-Matrix Color")) {
                        this.setIcon(this.SOMColorIcon);
                    } else if (text.equals("U-Matrix Distance")) {
                        this.setIcon(this.SOMBWIcon);
                    } else if (text.equals("3D view")) {
                        this.setIcon(this.pca3DIcon);
                    } else if (text.equals("Map") && parentText.indexOf("Terrain") != -1) {
                        this.setIcon(this.trn3DIcon);
                    } else if (grandParentText != null) {
                        if (grandParentText.indexOf("Expression Image") != -1) {
                            this.setIcon(this.expressionImageIcon);
                        } else if (grandParentText.indexOf("Centroid") != -1) {
                            this.setIcon(this.centroidGraphIcon);
                        } else if (grandParentText.indexOf("Expression Graph") != -1) {
                            this.setIcon(this.expressionGraphIcon);
                        }
                    }
                }
            }
            if (selected) {
                this.setOpaque(true);
            } else {
                this.setOpaque(false);
            }
            return this;
        }

        public void paint(Graphics g) {
            if (g == null) {
                return;
            }
            Color c = this.selected ? this.getBackgroundSelectionColor() : this.getBackgroundNonSelectionColor();
            g.setColor(c);
            int width = this.getWidth();
            if (this.getIcon() != null) {
                width -= this.getIcon().getIconWidth();
            }
            g.fillRect(this.getWidth() - width + 1, 0, width + 1, this.getHeight());
            super.setOpaque(false);
            super.paint(g);
        }
    }
}

