/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.report;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import org.tigr.midas.Constant;
import org.tigr.midas.display.Midas;
import org.tigr.midas.display.StatusImagePane;
import org.tigr.midas.engine.Project;
import org.tigr.midas.report.PdfControl;
import org.tigr.midas.util.GBA;

public class PdfFormatOptions
extends JDialog {
    private Project proj;
    private PdfControl pdfControl;
    public static final Image INTENSITY_Image = Toolkit.getDefaultToolkit().getImage((class$org$tigr$midas$report$PdfFormatOptions == null ? (class$org$tigr$midas$report$PdfFormatOptions = PdfFormatOptions.class$("org.tigr.midas.report.PdfFormatOptions")) : class$org$tigr$midas$report$PdfFormatOptions).getClassLoader().getResource("org/tigr/midas/images/Intensity_sample0.jpg"));
    public static final Image LOG2_INTENSITY_Image = Toolkit.getDefaultToolkit().getImage((class$org$tigr$midas$report$PdfFormatOptions == null ? (class$org$tigr$midas$report$PdfFormatOptions = PdfFormatOptions.class$("org.tigr.midas.report.PdfFormatOptions")) : class$org$tigr$midas$report$PdfFormatOptions).getClassLoader().getResource("org/tigr/midas/images/logIntensity_sample0.jpg"));
    public static final Image RI_Image = Toolkit.getDefaultToolkit().getImage((class$org$tigr$midas$report$PdfFormatOptions == null ? (class$org$tigr$midas$report$PdfFormatOptions = PdfFormatOptions.class$("org.tigr.midas.report.PdfFormatOptions")) : class$org$tigr$midas$report$PdfFormatOptions).getClassLoader().getResource("org/tigr/midas/images/RI_sample0.jpg"));
    public static final Image HISTOGRAM_Image = Toolkit.getDefaultToolkit().getImage((class$org$tigr$midas$report$PdfFormatOptions == null ? (class$org$tigr$midas$report$PdfFormatOptions = PdfFormatOptions.class$("org.tigr.midas.report.PdfFormatOptions")) : class$org$tigr$midas$report$PdfFormatOptions).getClassLoader().getResource("org/tigr/midas/images/histo_sample0.jpg"));
    public static final Image RR_Image = Toolkit.getDefaultToolkit().getImage((class$org$tigr$midas$report$PdfFormatOptions == null ? (class$org$tigr$midas$report$PdfFormatOptions = PdfFormatOptions.class$("org.tigr.midas.report.PdfFormatOptions")) : class$org$tigr$midas$report$PdfFormatOptions).getClassLoader().getResource("org/tigr/midas/images/RR_sample0.jpg"));
    public static final Image BOX_Image = Toolkit.getDefaultToolkit().getImage((class$org$tigr$midas$report$PdfFormatOptions == null ? (class$org$tigr$midas$report$PdfFormatOptions = PdfFormatOptions.class$("org.tigr.midas.report.PdfFormatOptions")) : class$org$tigr$midas$report$PdfFormatOptions).getClassLoader().getResource("org/tigr/midas/images/box_sample0.jpg"));
    public static final Image SAM_Image = Toolkit.getDefaultToolkit().getImage((class$org$tigr$midas$report$PdfFormatOptions == null ? (class$org$tigr$midas$report$PdfFormatOptions = PdfFormatOptions.class$("org.tigr.midas.report.PdfFormatOptions")) : class$org$tigr$midas$report$PdfFormatOptions).getClassLoader().getResource("org/tigr/midas/images/sam_sample0.jpg"));
    private JTable graphOptionTable;
    private JPanel examplePane;
    private List flowNameList;
    private List flowCodeList;
    private GBA gba;
    private JTextField titleField;
    private JTextField analystField;
    private JButton okButton;
    private JButton loadButton;
    private JButton saveButton;
    private JButton cancelButton;
    private EventListener el;
    static /* synthetic */ Class class$org$tigr$midas$report$PdfFormatOptions;

    public PdfFormatOptions(Project proj) {
        super(Midas.frame, "PDF report layout options", true);
        this.proj = proj;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screenSize.width - 800) / 2;
        int y = (screenSize.height - 600) / 2;
        this.setLocation(x, y);
        this.getContentPane().add(this.optionPane());
        this.pack();
        this.setVisible(true);
    }

    private JPanel optionPane() {
        this.pdfControl = new PdfControl();
        JPanel oPane = new JPanel();
        this.flowNameList = this.proj.getFlowNameList();
        this.flowCodeList = this.proj.getFlowCodeList();
        this.gba = new GBA();
        JPanel formatPane = new JPanel();
        formatPane.setLayout(new GridBagLayout());
        formatPane.setBackground(Color.white);
        formatPane.setForeground(Color.white);
        formatPane.setPreferredSize(new Dimension(500, 80));
        formatPane.setBorder(new TitledBorder(new EtchedBorder(), " Format "));
        formatPane.setForeground(Constant.dark_blue_1);
        String groupByExp = "Analysis results grouped by hybridyzations";
        JRadioButton groupByExpButton = new JRadioButton(groupByExp);
        groupByExpButton.setBackground(Color.white);
        groupByExpButton.setFont(Constant.font);
        groupByExpButton.setActionCommand(groupByExp);
        JButton expExampleButton = new JButton(" Show example ");
        expExampleButton.setBackground(Color.white);
        expExampleButton.setFont(Constant.font);
        String groupByModule = "Analysis results grouped by analysis modules";
        JRadioButton groupByModuleButton = new JRadioButton(groupByModule);
        groupByModuleButton.setBackground(Color.white);
        groupByModuleButton.setFont(Constant.font);
        groupByModuleButton.setActionCommand(groupByModule);
        JButton modExampleButton = new JButton(" Show example ");
        modExampleButton.setBackground(Color.white);
        modExampleButton.setFont(Constant.font);
        ButtonGroup group = new ButtonGroup();
        group.add(groupByExpButton);
        group.add(groupByModuleButton);
        this.gba.add(formatPane, groupByExpButton, 0, 0, 1, 1, 1, 1, 1, 17, 1, 1, 1, 1);
        this.gba.add(formatPane, expExampleButton, 1, 0, 1, 1, 0, 0, 1, 17, 1, 1, 1, 1);
        this.gba.add(formatPane, groupByModuleButton, 0, 1, 1, 1, 0, 1, 1, 17, 1, 1, 1, 1);
        this.gba.add(formatPane, modExampleButton, 1, 1, 1, 1, 0, 0, 1, 17, 1, 1, 1, 1);
        JPanel contentPane = new JPanel();
        contentPane.setBackground(Color.white);
        contentPane.setForeground(Color.white);
        contentPane.setLayout(new GridBagLayout());
        contentPane.setBorder(new TitledBorder(new EtchedBorder(), " Contents "));
        contentPane.setForeground(Constant.dark_blue_1);
        JLabel titleLabel = new JLabel("  Report Title");
        titleLabel.setFont(Constant.font);
        this.titleField = new JTextField("  TIGR MIDAS Analysis Report");
        JLabel analystLabel = new JLabel("  Analyst");
        analystLabel.setFont(Constant.font);
        this.analystField = new JTextField();
        JLabel generalInfoLabel = new JLabel("  General Information");
        generalInfoLabel.setFont(Constant.font);
        JCheckBox generalInfoCheckBox = new JCheckBox("MIDAS version, analysis start and stop time, project file name, etc.", true);
        generalInfoCheckBox.setBackground(Color.white);
        generalInfoCheckBox.setEnabled(false);
        JLabel paramLabel = new JLabel("  Parameter Settings");
        paramLabel.setFont(Constant.font);
        JCheckBox paramCheckBox = new JCheckBox("Parameters for all operation steps", true);
        paramCheckBox.setBackground(Color.white);
        paramCheckBox.setEnabled(false);
        JLabel graphOptionLable = new JLabel("  Analysis Results");
        graphOptionLable.setFont(Constant.font);
        this.graphOptionTable = new JTable(new GraphOptionModel());
        this.graphOptionTable.setPreferredScrollableViewportSize(new Dimension(750, 200));
        JScrollPane graphOptionPane = new JScrollPane(this.graphOptionTable);
        this.gba.add(contentPane, titleLabel, 0, 0, 1, 1, 1, 1, 1, 13, 2, 2, 2, 2);
        this.gba.add(contentPane, this.titleField, 1, 0, 1, 1, 1, 1, 1, 13, 2, 2, 2, 2);
        this.gba.add(contentPane, analystLabel, 0, 1, 1, 1, 1, 1, 1, 13, 2, 2, 2, 2);
        this.gba.add(contentPane, this.analystField, 1, 1, 1, 1, 1, 1, 1, 13, 2, 2, 2, 2);
        this.gba.add(contentPane, generalInfoLabel, 0, 2, 1, 1, 1, 1, 1, 13, 2, 2, 2, 2);
        this.gba.add(contentPane, generalInfoCheckBox, 1, 2, 1, 1, 1, 1, 1, 13, 2, 2, 2, 2);
        this.gba.add(contentPane, paramLabel, 0, 3, 1, 1, 1, 1, 1, 13, 2, 2, 2, 2);
        this.gba.add(contentPane, paramCheckBox, 1, 3, 1, 1, 1, 1, 1, 13, 2, 2, 2, 2);
        this.gba.add(contentPane, graphOptionLable, 0, 4, 1, 1, 1, 1, 1, 13, 2, 2, 2, 2);
        this.gba.add(contentPane, graphOptionPane, 1, 4, 1, 1, 1, 1, 1, 13, 2, 2, 2, 2);
        JPanel signaturePane = new JPanel();
        signaturePane.setBackground(Color.white);
        signaturePane.setForeground(Color.white);
        signaturePane.setPreferredSize(new Dimension(500, 65));
        signaturePane.setBorder(new TitledBorder(new EtchedBorder(), " Signature "));
        signaturePane.setForeground(Constant.dark_blue_1);
        JCheckBox sigCheckBox = new JCheckBox(" Add signature watermark to the report ", true);
        sigCheckBox.setBackground(Color.white);
        sigCheckBox.setFont(Constant.font);
        signaturePane.add(sigCheckBox);
        this.examplePane = new JPanel();
        this.examplePane.setBackground(Color.white);
        this.examplePane.setForeground(Color.white);
        this.examplePane.setPreferredSize(new Dimension(500, 300));
        this.examplePane.setBorder(new TitledBorder(new EtchedBorder(), " Example & Description "));
        this.examplePane.setForeground(Constant.dark_blue_1);
        JPanel controlPane = new JPanel();
        controlPane.setBackground(Color.white);
        controlPane.setForeground(Color.white);
        this.okButton = new JButton(" OK ");
        this.cancelButton = new JButton(" Cancel ");
        this.okButton.addActionListener(new EventListener());
        this.cancelButton.addActionListener(new EventListener());
        controlPane.add(this.okButton);
        controlPane.add(this.cancelButton);
        oPane.setLayout(new GridBagLayout());
        oPane.setBackground(Color.white);
        this.gba.add(oPane, contentPane, 0, 0, 1, 1, 1, 0, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
        this.gba.add(oPane, this.examplePane, 0, 1, 1, 1, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
        this.gba.add(oPane, controlPane, 0, 2, 1, 1, 1, 0, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
        return oPane;
    }

    public void updateExamplePane(int graphCode) {
        this.examplePane.setLayout(new BorderLayout());
        switch (graphCode) {
            case 99901: {
                this.examplePane.removeAll();
                this.examplePane.add((Component)new StatusImagePane(INTENSITY_Image), "Center");
                break;
            }
            case 99902: {
                this.examplePane.removeAll();
                this.examplePane.add((Component)new StatusImagePane(LOG2_INTENSITY_Image), "Center");
                break;
            }
            case 99903: {
                this.examplePane.removeAll();
                this.examplePane.add((Component)new StatusImagePane(RI_Image), "Center");
                break;
            }
            case 99904: {
                this.examplePane.removeAll();
                this.examplePane.add((Component)new StatusImagePane(HISTOGRAM_Image), "Center");
                break;
            }
            case 99905: {
                this.examplePane.removeAll();
                this.examplePane.add((Component)new StatusImagePane(BOX_Image), "Center");
                break;
            }
            case 99906: {
                this.examplePane.removeAll();
                this.examplePane.add((Component)new StatusImagePane(RR_Image), "Center");
                break;
            }
            case 33: {
                this.examplePane.removeAll();
                this.examplePane.add((Component)new StatusImagePane(SAM_Image), "Center");
            }
        }
        this.examplePane.validate();
    }

    public static void main(String[] args) {
        Project proj = new Project();
        proj.setFlow("1>11>13>33>100");
        PdfFormatOptions pdfFormatOptions = new PdfFormatOptions(proj);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class GraphOptionModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{"Operation", "Intensity Plot", "log2-Intensity Plot", "R-I Plot", "Histogram Plot", "Box Plot", "Flip-dye Diagnostic Plot", "SAM Plot"};
        private Object[][] data;
        private boolean[][] editability;

        public GraphOptionModel() {
            this.data = new Object[PdfFormatOptions.this.flowCodeList.size()][this.columnNames.length];
            this.editability = new boolean[PdfFormatOptions.this.flowCodeList.size()][this.columnNames.length];
            Object[] codeArray = PdfFormatOptions.this.flowCodeList.toArray();
            int i = 0;
            while (i < PdfFormatOptions.this.flowCodeList.size()) {
                this.data[i][0] = PdfFormatOptions.this.flowNameList.get(i).toString();
                int j = 1;
                while (j < this.columnNames.length) {
                    this.editability[i][j] = this.setIfEditable(Integer.parseInt(codeArray[i].toString()), j + 99900);
                    this.data[i][j] = new Boolean(this.editability[i][j]);
                    ++j;
                }
                ++i;
            }
        }

        private boolean setIfEditable(int operationCode, int graphCode) {
            switch (operationCode) {
                case 0: {
                    switch (graphCode) {
                        case 99901: {
                            return true;
                        }
                        case 99902: {
                            return true;
                        }
                        case 99903: {
                            return true;
                        }
                        case 99904: {
                            return true;
                        }
                        case 99906: {
                            return false;
                        }
                        case 99905: {
                            return true;
                        }
                        case 99907: {
                            return false;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (graphCode) {
                        case 99901: {
                            return true;
                        }
                        case 99902: {
                            return true;
                        }
                        case 99903: {
                            return true;
                        }
                        case 99904: {
                            return true;
                        }
                        case 99906: {
                            return false;
                        }
                        case 99905: {
                            return true;
                        }
                        case 99907: {
                            return false;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (graphCode) {
                        case 99901: {
                            return true;
                        }
                        case 99902: {
                            return true;
                        }
                        case 99903: {
                            return true;
                        }
                        case 99904: {
                            return true;
                        }
                        case 99906: {
                            return false;
                        }
                        case 99905: {
                            return true;
                        }
                        case 99907: {
                            return false;
                        }
                    }
                    break;
                }
                case 10: {
                    switch (graphCode) {
                        case 99901: {
                            return true;
                        }
                        case 99902: {
                            return true;
                        }
                        case 99903: {
                            return true;
                        }
                        case 99904: {
                            return true;
                        }
                        case 99906: {
                            return false;
                        }
                        case 99905: {
                            return true;
                        }
                        case 99907: {
                            return false;
                        }
                    }
                    break;
                }
                case 11: {
                    switch (graphCode) {
                        case 99901: {
                            return true;
                        }
                        case 99902: {
                            return true;
                        }
                        case 99903: {
                            return true;
                        }
                        case 99904: {
                            return true;
                        }
                        case 99906: {
                            return false;
                        }
                        case 99905: {
                            return true;
                        }
                        case 99907: {
                            return false;
                        }
                    }
                    break;
                }
                case 12: {
                    switch (graphCode) {
                        case 99901: {
                            return true;
                        }
                        case 99902: {
                            return true;
                        }
                        case 99903: {
                            return true;
                        }
                        case 99904: {
                            return true;
                        }
                        case 99906: {
                            return false;
                        }
                        case 99905: {
                            return true;
                        }
                        case 99907: {
                            return false;
                        }
                    }
                    break;
                }
                case 13: {
                    switch (graphCode) {
                        case 99901: {
                            return true;
                        }
                        case 99902: {
                            return true;
                        }
                        case 99903: {
                            return true;
                        }
                        case 99904: {
                            return true;
                        }
                        case 99906: {
                            return false;
                        }
                        case 99905: {
                            return true;
                        }
                        case 99907: {
                            return false;
                        }
                    }
                    break;
                }
                case 14: {
                    switch (graphCode) {
                        case 99901: {
                            return true;
                        }
                        case 99902: {
                            return true;
                        }
                        case 99903: {
                            return true;
                        }
                        case 99904: {
                            return true;
                        }
                        case 99906: {
                            return false;
                        }
                        case 99905: {
                            return true;
                        }
                        case 99907: {
                            return false;
                        }
                    }
                    break;
                }
                case 15: {
                    switch (graphCode) {
                        case 99901: {
                            return true;
                        }
                        case 99902: {
                            return true;
                        }
                        case 99903: {
                            return true;
                        }
                        case 99904: {
                            return true;
                        }
                        case 99906: {
                            return false;
                        }
                        case 99905: {
                            return true;
                        }
                        case 99907: {
                            return false;
                        }
                    }
                    break;
                }
                case 16: {
                    switch (graphCode) {
                        case 99901: {
                            return true;
                        }
                        case 99902: {
                            return true;
                        }
                        case 99903: {
                            return true;
                        }
                        case 99904: {
                            return true;
                        }
                        case 99906: {
                            return false;
                        }
                        case 99905: {
                            return true;
                        }
                        case 99907: {
                            return false;
                        }
                    }
                    break;
                }
                case 20: {
                    switch (graphCode) {
                        case 99901: {
                            return true;
                        }
                        case 99902: {
                            return true;
                        }
                        case 99903: {
                            return true;
                        }
                        case 99904: {
                            return true;
                        }
                        case 99906: {
                            return false;
                        }
                        case 99905: {
                            return true;
                        }
                        case 99907: {
                            return false;
                        }
                    }
                    break;
                }
                case 30: {
                    switch (graphCode) {
                        case 99901: {
                            return true;
                        }
                        case 99902: {
                            return true;
                        }
                        case 99903: {
                            return true;
                        }
                        case 99904: {
                            return true;
                        }
                        case 99906: {
                            return false;
                        }
                        case 99905: {
                            return true;
                        }
                        case 99907: {
                            return false;
                        }
                    }
                    break;
                }
                case 31: {
                    switch (graphCode) {
                        case 99901: {
                            return true;
                        }
                        case 99902: {
                            return true;
                        }
                        case 99903: {
                            return true;
                        }
                        case 99904: {
                            return true;
                        }
                        case 99906: {
                            return false;
                        }
                        case 99905: {
                            return true;
                        }
                        case 99907: {
                            return false;
                        }
                    }
                    break;
                }
                case 32: {
                    switch (graphCode) {
                        case 99901: {
                            return true;
                        }
                        case 99902: {
                            return true;
                        }
                        case 99903: {
                            return true;
                        }
                        case 99904: {
                            return false;
                        }
                        case 99906: {
                            return false;
                        }
                        case 99905: {
                            return true;
                        }
                        case 99907: {
                            return false;
                        }
                    }
                    break;
                }
                case 33: {
                    switch (graphCode) {
                        case 99901: {
                            return true;
                        }
                        case 99902: {
                            return true;
                        }
                        case 99903: {
                            return true;
                        }
                        case 99904: {
                            return false;
                        }
                        case 99906: {
                            return false;
                        }
                        case 99905: {
                            return false;
                        }
                        case 99907: {
                            return true;
                        }
                    }
                    break;
                }
                case 40: {
                    switch (graphCode) {
                        case 99901: {
                            return true;
                        }
                        case 99902: {
                            return true;
                        }
                        case 99903: {
                            return true;
                        }
                        case 99904: {
                            return true;
                        }
                        case 99906: {
                            return true;
                        }
                        case 99905: {
                            return true;
                        }
                        case 99907: {
                            return false;
                        }
                    }
                    break;
                }
                case 41: {
                    switch (graphCode) {
                        case 99901: {
                            return true;
                        }
                        case 99902: {
                            return true;
                        }
                        case 99903: {
                            return true;
                        }
                        case 99904: {
                            return true;
                        }
                        case 99906: {
                            return false;
                        }
                        case 99905: {
                            return true;
                        }
                        case 99907: {
                            return false;
                        }
                    }
                    break;
                }
                case 100: {
                    switch (graphCode) {
                        case 99901: {
                            return false;
                        }
                        case 99902: {
                            return false;
                        }
                        case 99903: {
                            return false;
                        }
                        case 99904: {
                            return false;
                        }
                        case 99906: {
                            return false;
                        }
                        case 99905: {
                            return false;
                        }
                        case 99907: {
                            return false;
                        }
                    }
                    break;
                }
                default: {
                    return false;
                }
            }
            return false;
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.data.length;
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public Object getValueAt(int row, int col) {
            return this.data[row][col];
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public boolean isCellEditable(int row, int col) {
            if (col < 1) {
                return false;
            }
            return this.editability[row][col];
        }

        public void setValueAt(Object value, int row, int col) {
            boolean DEBUG = true;
            this.data[row][col] = value;
            this.fireTableCellUpdated(row, col);
            if (this.getColumnName(col).equals("Intensity Plot")) {
                PdfFormatOptions.this.updateExamplePane(99901);
            } else if (this.getColumnName(col).equals("log2-Intensity Plot")) {
                PdfFormatOptions.this.updateExamplePane(99902);
            } else if (this.getColumnName(col).equals("R-I Plot")) {
                PdfFormatOptions.this.updateExamplePane(99903);
            } else if (this.getColumnName(col).equals("Histogram Plot")) {
                PdfFormatOptions.this.updateExamplePane(99904);
            } else if (this.getColumnName(col).equals("Box Plot")) {
                PdfFormatOptions.this.updateExamplePane(99905);
            } else if (this.getColumnName(col).equals("Flip-dye Diagnostic Plot")) {
                PdfFormatOptions.this.updateExamplePane(99906);
            } else if (this.getColumnName(col).equals("SAM Plot")) {
                PdfFormatOptions.this.updateExamplePane(33);
            } else {
                System.out.println("No sample plot to show!");
            }
        }
    }

    class EventListener
    implements ActionListener {
        EventListener() {
        }

        public void actionPerformed(ActionEvent event) {
            Object source = event.getSource();
            if (source == PdfFormatOptions.this.okButton) {
                int i = 0;
                while (i < PdfFormatOptions.this.flowCodeList.size()) {
                    ArrayList<Integer> graphCodeList = new ArrayList<Integer>();
                    int j = 1;
                    while (j < PdfFormatOptions.this.graphOptionTable.getColumnCount()) {
                        if (((Boolean)PdfFormatOptions.this.graphOptionTable.getModel().getValueAt(i, j)).booleanValue()) {
                            graphCodeList.add(new Integer(j + 99900));
                        }
                        ++j;
                    }
                    PdfFormatOptions.this.pdfControl.put("title", PdfFormatOptions.this.titleField.getText());
                    PdfFormatOptions.this.pdfControl.put("analyst", PdfFormatOptions.this.analystField.getText());
                    PdfFormatOptions.this.pdfControl.put(PdfFormatOptions.this.flowCodeList.get(i), graphCodeList);
                    ++i;
                }
                PdfFormatOptions.this.proj.setPdfControl(PdfFormatOptions.this.pdfControl);
                PdfFormatOptions.this.dispose();
            } else if (source == PdfFormatOptions.this.cancelButton) {
                PdfFormatOptions.this.dispose();
            }
        }
    }
}

