/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.report;

import com.lowagie.text.Annotation;
import com.lowagie.text.Cell;
import com.lowagie.text.Chunk;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Phrase;
import com.lowagie.text.Section;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Image;
import java.net.URL;
import java.util.Hashtable;
import java.util.List;
import org.tigr.midas.graph.plot.BoxPlot;
import org.tigr.midas.graph.plot.HistogramPlot;
import org.tigr.midas.graph.plot.IntensityPlot;
import org.tigr.midas.graph.plot.LogIntensityPlot;
import org.tigr.midas.graph.plot.Plot;
import org.tigr.midas.graph.plot.RIPlot;
import org.tigr.midas.graph.plot.RatioRatioPlot;
import org.tigr.midas.graph.plot.SAMPlot;
import org.tigr.midas.report.PdfItem;
import org.tigr.midas.util.CodeBook;

public class TableItem
extends PdfItem {
    Font fontC10 = FontFactory.getFont((String)"Courier", (float)10.0f, (int)0, (Color)Color.black);
    Font fontC8 = FontFactory.getFont((String)"Courier", (float)8.0f, (int)0, (Color)Color.black);
    private PdfWriter writer;
    private Table table;
    private com.lowagie.text.Image[] graphImg;
    private String[] graphAnnot;
    private String handleText;
    private Color handleColor;
    static /* synthetic */ Class class$org$tigr$midas$report$TableItem;

    public TableItem(PdfWriter writer, Hashtable ht, List graphCodeList) {
        this.writer = writer;
        this.graphImg = new com.lowagie.text.Image[graphCodeList.size()];
        this.graphAnnot = new String[graphCodeList.size()];
        this.anouncer(ht.get("identity"));
        try {
            int i = 0;
            while (i < graphCodeList.size()) {
                int graphCode = Integer.parseInt(graphCodeList.get(i).toString());
                String graphName = (String)ht.get(CodeBook.lookup(graphCode));
                switch (graphCode) {
                    case 99901: {
                        System.out.println("          - Drawing Intensity plot");
                        Plot thePlot = new IntensityPlot(graphName);
                        this.graphImg[i] = com.lowagie.text.Image.getInstance((Image)thePlot.getImage(), null);
                        this.graphAnnot[i] = thePlot.getPlotFacts();
                        break;
                    }
                    case 99902: {
                        System.out.println("          - Drawing Log2-Intensity plot");
                        Plot thePlot = new LogIntensityPlot(graphName);
                        this.graphImg[i] = com.lowagie.text.Image.getInstance((Image)thePlot.getImage(), null);
                        this.graphAnnot[i] = thePlot.getPlotFacts();
                        break;
                    }
                    case 99903: {
                        System.out.println("          - Drawing RI plot");
                        Plot thePlot = new RIPlot(graphName);
                        this.graphImg[i] = com.lowagie.text.Image.getInstance((Image)thePlot.getImage(), null);
                        this.graphAnnot[i] = thePlot.getPlotFacts();
                        break;
                    }
                    case 99904: {
                        System.out.println("          - Drawing Z score Histogram plot");
                        Plot thePlot = new HistogramPlot(graphName);
                        this.graphImg[i] = com.lowagie.text.Image.getInstance((Image)thePlot.getImage(), null);
                        this.graphAnnot[i] = thePlot.getPlotFacts();
                        break;
                    }
                    case 99905: {
                        System.out.println("          - Drawing Box plot");
                        Plot thePlot = new BoxPlot(graphName);
                        this.graphImg[i] = com.lowagie.text.Image.getInstance((Image)thePlot.getImage(), null);
                        this.graphAnnot[i] = thePlot.getPlotFacts();
                        break;
                    }
                    case 99906: {
                        System.out.println("          - Drawing Flip-dye Diagnostic plot");
                        Plot thePlot = new RatioRatioPlot(graphName);
                        this.graphImg[i] = com.lowagie.text.Image.getInstance((Image)thePlot.getImage(), null);
                        this.graphAnnot[i] = thePlot.getPlotFacts();
                        break;
                    }
                    case 99907: {
                        System.out.println("          - Drawing SAM plot -- " + graphName);
                        Plot thePlot = new SAMPlot(graphName);
                        this.graphImg[i] = com.lowagie.text.Image.getInstance((Image)thePlot.getImage(), null);
                        this.graphAnnot[i] = thePlot.getPlotFacts();
                    }
                }
                ++i;
            }
            this.table = new Table(4);
            int graphNumber = graphCodeList.size();
            int graphRowSpan = graphNumber / 3 + 1;
            int[] headerwidths = new int[]{10, 30, 30, 30};
            this.table.setWidths(headerwidths);
            this.table.setSpacing(2.0f);
            this.table.setOffset(-1.0f);
            Cell cell = new Cell();
            cell.add((Object)this.handle(this.handleText, 12));
            cell.setBorder(0);
            cell.setBackgroundColor(this.handleColor);
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(1);
            cell.setRowspan(graphRowSpan + 1);
            this.table.addCell(cell);
            com.lowagie.text.Image annotImage = com.lowagie.text.Image.getInstance((URL)(class$org$tigr$midas$report$TableItem == null ? (class$org$tigr$midas$report$TableItem = TableItem.class$("org.tigr.midas.report.TableItem")) : class$org$tigr$midas$report$TableItem).getClassLoader().getResource("org/tigr/midas/images/pencilpaper.gif"));
            annotImage.scalePercent(90.0f);
            annotImage.setAlignment(0);
            int i2 = 0;
            while (i2 < this.graphImg.length) {
                cell = new Cell();
                cell.setBorder(0);
                this.graphImg[i2].setAnnotation(new Annotation("About this graph:", this.graphAnnot[i2], 0.0f, 0.0f, 0.0f, 0.0f));
                cell.add((Object)this.graphImg[i2]);
                cell.setHorizontalAlignment(0);
                cell.setRowspan(1);
                cell.setColspan(1);
                this.table.addCell(cell);
                ++i2;
            }
            int i3 = 0;
            while (i3 < graphRowSpan * 3 - graphNumber) {
                cell = new Cell();
                cell.setBorder(0);
                cell.setBackgroundColor(Color.white);
                cell.setHorizontalAlignment(1);
                cell.setRowspan(1);
                cell.setColspan(1);
                this.table.addCell(cell);
                ++i3;
            }
            cell = new Cell();
            cell.setBorder(1);
            cell.setRowspan(1);
            cell.setColspan(3);
            String notes = "About this analysis module:";
            cell.add((Object)new Phrase(11.0f, new Chunk(notes, this.fontC10)));
            String[] moduleNotes = (String[])ht.get("module_notes");
            int i4 = 0;
            while (i4 < moduleNotes.length) {
                if (ht.get(moduleNotes[i4]) instanceof String[][]) {
                    notes = "\r  - " + this.paddings(moduleNotes[i4], 30);
                    String[][] ss = (String[][])ht.get(moduleNotes[i4]);
                    cell.add((Object)new Phrase(11.0f, new Chunk(notes, this.fontC10)));
                    Table nestedTable = this.nestedTable(ss, 12);
                    nestedTable.setBorderWidth(1.0f);
                    nestedTable.setWidth(95.0f);
                } else {
                    notes = "\r  - " + moduleNotes[i4] + ht.get(moduleNotes[i4]).toString();
                    cell.add((Object)new Phrase(11.0f, new Chunk(notes, this.fontC10)));
                }
                ++i4;
            }
            this.table.addCell(cell);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private com.lowagie.text.Image handle(String text, int fontSize) {
        try {
            BaseFont bf = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)false);
            float width = bf.getWidthPoint(text, (float)fontSize);
            PdfTemplate template = this.writer.getDirectContent().createTemplate(20.0f, 20.0f);
            template.beginText();
            template.setRGBColorFillF(1.0f, 1.0f, 1.0f);
            template.setFontAndSize(bf, (float)fontSize);
            template.setTextMatrix(0.0f, 2.0f);
            template.showText(text);
            template.endText();
            template.setWidth(width);
            template.setHeight((float)(fontSize + 2));
            com.lowagie.text.Image img = com.lowagie.text.Image.getInstance((PdfTemplate)template);
            img.setRotationDegrees(90.0f);
            return img;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private void anouncer(Object identity) {
        try {
            switch (Integer.parseInt(identity.toString())) {
                case 0: {
                    this.handleText = "Raw Data ";
                    this.handleColor = new Color(0, 100, 100);
                    break;
                }
                case 1: {
                    this.handleText = "Raw Data ";
                    this.handleColor = new Color(0, 100, 100);
                    break;
                }
                case 2: {
                    this.handleText = "Raw Data ";
                    this.handleColor = new Color(0, 100, 100);
                    break;
                }
                case 12: {
                    this.handleText = "Total Intensity Normalization ";
                    this.handleColor = new Color(240, 90, 10);
                    break;
                }
                case 11: {
                    this.handleText = "LOWESS Normalization ";
                    this.handleColor = new Color(0, 20, 150);
                    break;
                }
                case 15: {
                    this.handleText = "Iterative Linear Regression Normalization ";
                    this.handleColor = new Color(150, 0, 100);
                    break;
                }
                case 14: {
                    this.handleText = "Iterative Log-Mean Centering Normalization ";
                    this.handleColor = new Color(150, 60, 0);
                    break;
                }
                case 13: {
                    this.handleText = "Standard Deviation Regularization ";
                    this.handleColor = new Color(150, 150, 0);
                    break;
                }
                case 16: {
                    this.handleText = "Ratio Statistics Normalization ";
                    this.handleColor = new Color(70, 150, 70);
                    break;
                }
                case 10: {
                    this.handleText = "Low Intensity Filtering ";
                    this.handleColor = new Color(255, 30, 60);
                    break;
                }
                case 20: {
                    this.handleText = "Slice Analysis";
                    this.handleColor = new Color(85, 95, 140);
                    break;
                }
                case 30: {
                    this.handleText = "In-Slide Replicates Analysis ";
                    this.handleColor = new Color(85, 140, 105);
                    break;
                }
                case 32: {
                    this.handleText = "Cross-Slide Replicates T-test ";
                    this.handleColor = new Color(100, 10, 10);
                    break;
                }
                case 33: {
                    this.handleText = "Cross-Slide One-Class SAM ";
                    this.handleColor = new Color(184, 18, 167);
                    break;
                }
                case 40: {
                    this.handleText = "Flip-dye Consistency Checking ";
                    this.handleColor = new Color(20, 60, 120);
                    break;
                }
                case 41: {
                    this.handleText = "MAANOVA ";
                    this.handleColor = new Color(120, 90, 20);
                    break;
                }
                case 100: {
                    this.handleText = "Final Outputs ";
                    this.handleColor = new Color(105, 20, 120);
                }
            }
        }
        catch (Exception de) {
            de.printStackTrace();
        }
    }

    protected void mountTo(Section section) {
        this.table.setWidth(94.0f);
        section.add((Object)this.table);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

