/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.util;

public class ProgramRunner
extends Thread {
    protected String applProg;
    protected String applName;
    protected Runtime rtime;
    protected Process proc;
    protected boolean running;
    protected boolean needWait;

    public ProgramRunner() {
        this("", "");
    }

    public ProgramRunner(String name) {
        this("", name);
    }

    public ProgramRunner(String appl, String name) {
        this.applProg = new String(appl);
        this.applName = new String(name);
        this.running = false;
        this.needWait = true;
    }

    public void run() {
        try {
            this.rtime = Runtime.getRuntime();
            this.proc = this.rtime.exec(this.applProg + " " + this.applName);
            this.running = true;
            if (this.needWait && this.proc.waitFor() >= 0) {
                this.running = false;
            }
        }
        catch (Exception exc) {
            this.running = false;
            System.out.println("Error: " + exc.getMessage());
        }
    }

    public void setWaitMode(boolean wait) {
        this.needWait = wait;
    }

    public void terminate() {
        this.proc.destroy();
        this.running = false;
    }

    public void setApplicationProgram(String appl) {
        this.applProg = appl;
    }

    public void setApplicationName(String name) {
        this.applName = name;
    }

    public boolean isRunning() {
        return this.running;
    }
}

