/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.util.swing;

import java.awt.Toolkit;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class DecimalNumberField
extends JTextField {
    private Toolkit toolkit = Toolkit.getDefaultToolkit();
    private NumberFormat decimalFormatter = NumberFormat.getNumberInstance(Locale.US);

    public DecimalNumberField(float value, int columns) {
        super(columns);
        this.setValue(value);
    }

    public float getValue() {
        float retVal = 0.0f;
        try {
            retVal = this.decimalFormatter.parse(this.getText()).floatValue();
        }
        catch (ParseException e) {
            this.toolkit.beep();
        }
        return retVal;
    }

    public void setValue(float value) {
        this.setText(this.decimalFormatter.format(value));
    }

    protected Document createDefaultModel() {
        return new DecimalNumberDocument();
    }

    protected class DecimalNumberDocument
    extends PlainDocument {
        protected DecimalNumberDocument() {
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            char[] source = str.toCharArray();
            char[] result = new char[source.length];
            int j = 0;
            int i = 0;
            while (i < result.length) {
                if (Character.isDigit(source[i]) || source[i] == '.') {
                    result[j++] = source[i];
                } else {
                    DecimalNumberField.this.toolkit.beep();
                }
                ++i;
            }
            super.insertString(offs, new String(result, 0, j), a);
        }
    }
}

