/*
 * Decompiled with CFR 0.152.
 */
package ExpDesigner;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;

public class ArrowFactory {
    public Polygon createPolyArrow(int x1, int y1, int x2, int y2) {
        return this.createPolyArrow(x1, y1, x2, y2, 10, 45.0, 20, 0, 0);
    }

    public Polygon createPolyArrow(int x1, int y1, int x2, int y2, int width, double theta, int branchLength, int tailBuffer, int headBuffer) {
        return this.createPolyArrow(x1, y1, x2, y2, width, theta, branchLength, tailBuffer, headBuffer, 0);
    }

    public Polygon createPolyArrow(int x1, int y1, int x2, int y2, int width, double theta, int branchLength, int tailBuffer, int headBuffer, int portBuffer) {
        int nPoints = 7;
        int[] xPoints = new int[nPoints];
        int[] yPoints = new int[nPoints];
        int dx = x2 - x1;
        int dy = y2 - y1;
        double primeTheta = Math.toDegrees(Math.atan((double)(-dy) / (double)dx));
        if (dx != 0) {
            double slope = dy / dx;
        } else {
            double slope = Double.POSITIVE_INFINITY;
        }
        if (dx >= 0 && dy <= 0) {
            x1 += (int)(this.cos(primeTheta) * (double)tailBuffer);
            y1 -= (int)(this.sin(primeTheta) * (double)tailBuffer);
            x2 -= (int)(this.cos(primeTheta) * (double)headBuffer);
            y2 += (int)(this.sin(primeTheta) * (double)headBuffer);
            int tipLength = (int)(this.cos(theta) * (double)branchLength);
            int x3 = (x2 -= (int)(this.cos(90.0 - primeTheta) * (double)portBuffer)) - (int)(this.cos(primeTheta) * (double)tipLength);
            int y3 = (y2 -= (int)(this.sin(90.0 - primeTheta) * (double)portBuffer)) + (int)(this.sin(primeTheta) * (double)tipLength);
            xPoints[0] = (x1 -= (int)(this.cos(90.0 - primeTheta) * (double)portBuffer)) - (int)(this.cos(90.0 - primeTheta) * (double)width);
            yPoints[0] = (y1 -= (int)(this.sin(90.0 - primeTheta) * (double)portBuffer)) - (int)(this.sin(90.0 - primeTheta) * (double)width);
            xPoints[1] = x3 - (int)(this.cos(90.0 - primeTheta) * (double)width);
            yPoints[1] = y3 - (int)(this.sin(90.0 - primeTheta) * (double)width);
            xPoints[2] = x2 - (int)(this.cos(primeTheta - theta) * (double)branchLength);
            yPoints[2] = y2 + (int)(this.sin(primeTheta - theta) * (double)branchLength);
            xPoints[3] = x2;
            yPoints[3] = y2;
            xPoints[4] = x2 - (int)(this.sin(90.0 - (primeTheta + theta)) * (double)branchLength);
            yPoints[4] = y2 + (int)(this.cos(90.0 - (primeTheta + theta)) * (double)branchLength);
            xPoints[5] = x3 + (int)(this.cos(90.0 - primeTheta) * (double)width);
            yPoints[5] = y3 + (int)(this.sin(90.0 - primeTheta) * (double)width);
            xPoints[6] = x1 + (int)(this.cos(90.0 - primeTheta) * (double)width);
            yPoints[6] = y1 + (int)(this.sin(90.0 - primeTheta) * (double)width);
        } else if (dx <= 0 && dy <= 0) {
            x1 -= (int)(this.cos(primeTheta) * (double)tailBuffer);
            y1 += (int)(this.sin(primeTheta) * (double)tailBuffer);
            x2 += (int)(this.cos(primeTheta) * (double)headBuffer);
            y2 -= (int)(this.sin(primeTheta) * (double)headBuffer);
            int tipLength = (int)(this.cos(theta) * (double)branchLength);
            int x3 = (x2 += (int)(this.cos(90.0 - primeTheta) * (double)portBuffer)) + (int)(this.cos(primeTheta) * (double)tipLength);
            int y3 = (y2 += (int)(this.sin(90.0 - primeTheta) * (double)portBuffer)) - (int)(this.sin(primeTheta) * (double)tipLength);
            xPoints[0] = (x1 += (int)(this.cos(90.0 - primeTheta) * (double)portBuffer)) - (int)(this.cos(90.0 - primeTheta) * (double)width);
            yPoints[0] = (y1 += (int)(this.sin(90.0 - primeTheta) * (double)portBuffer)) - (int)(this.sin(90.0 - primeTheta) * (double)width);
            xPoints[1] = x3 - (int)(this.cos(90.0 - primeTheta) * (double)width);
            yPoints[1] = y3 - (int)(this.sin(90.0 - primeTheta) * (double)width);
            xPoints[2] = x2 + (int)(this.sin(90.0 - (primeTheta + theta)) * (double)branchLength);
            yPoints[2] = y2 - (int)(this.cos(90.0 - (primeTheta + theta)) * (double)branchLength);
            xPoints[3] = x2;
            yPoints[3] = y2;
            xPoints[4] = x2 + (int)(this.cos(primeTheta - theta) * (double)branchLength);
            yPoints[4] = y2 - (int)(this.sin(primeTheta - theta) * (double)branchLength);
            xPoints[5] = x3 + (int)(this.cos(90.0 - primeTheta) * (double)width);
            yPoints[5] = y3 + (int)(this.sin(90.0 - primeTheta) * (double)width);
            xPoints[6] = x1 + (int)(this.cos(90.0 - primeTheta) * (double)width);
            yPoints[6] = y1 + (int)(this.sin(90.0 - primeTheta) * (double)width);
        } else if (dx < 0 && dy >= 0) {
            x1 -= (int)(this.cos(primeTheta) * (double)tailBuffer);
            y1 += (int)(this.sin(primeTheta) * (double)tailBuffer);
            x2 += (int)(this.cos(primeTheta) * (double)headBuffer);
            y2 -= (int)(this.sin(primeTheta) * (double)headBuffer);
            int tipLength = (int)(this.cos(theta) * (double)branchLength);
            int x3 = (x2 += (int)(this.cos(90.0 - primeTheta) * (double)portBuffer)) + (int)(this.cos(primeTheta) * (double)tipLength);
            int y3 = (y2 += (int)(this.sin(90.0 - primeTheta) * (double)portBuffer)) - (int)(this.sin(primeTheta) * (double)tipLength);
            xPoints[0] = (x1 += (int)(this.cos(90.0 - primeTheta) * (double)portBuffer)) - (int)(this.cos(90.0 - primeTheta) * (double)width);
            yPoints[0] = (y1 += (int)(this.sin(90.0 - primeTheta) * (double)portBuffer)) - (int)(this.sin(90.0 - primeTheta) * (double)width);
            xPoints[1] = x3 - (int)(this.cos(90.0 - primeTheta) * (double)width);
            yPoints[1] = y3 - (int)(this.sin(90.0 - primeTheta) * (double)width);
            xPoints[2] = x2 + (int)(this.sin(90.0 - (primeTheta + theta)) * (double)branchLength);
            yPoints[2] = y2 - (int)(this.cos(90.0 - (primeTheta + theta)) * (double)branchLength);
            xPoints[3] = x2;
            yPoints[3] = y2;
            xPoints[4] = x2 + (int)(this.cos(primeTheta - theta) * (double)branchLength);
            yPoints[4] = y2 - (int)(this.sin(primeTheta - theta) * (double)branchLength);
            xPoints[5] = x3 + (int)(this.cos(90.0 - primeTheta) * (double)width);
            yPoints[5] = y3 + (int)(this.sin(90.0 - primeTheta) * (double)width);
            xPoints[6] = x1 + (int)(this.cos(90.0 - primeTheta) * (double)width);
            yPoints[6] = y1 + (int)(this.sin(90.0 - primeTheta) * (double)width);
        } else {
            x1 += (int)(this.cos(primeTheta) * (double)tailBuffer);
            y1 -= (int)(this.sin(primeTheta) * (double)tailBuffer);
            x2 -= (int)(this.cos(primeTheta) * (double)headBuffer);
            y2 += (int)(this.sin(primeTheta) * (double)headBuffer);
            int tipLength = (int)(this.cos(theta) * (double)branchLength);
            int x3 = (x2 -= (int)(this.cos(90.0 - primeTheta) * (double)portBuffer)) - (int)(this.cos(primeTheta) * (double)tipLength);
            int y3 = (y2 -= (int)(this.sin(90.0 - primeTheta) * (double)portBuffer)) + (int)(this.sin(primeTheta) * (double)tipLength);
            xPoints[0] = (x1 -= (int)(this.cos(90.0 - primeTheta) * (double)portBuffer)) - (int)(this.cos(90.0 - primeTheta) * (double)width);
            yPoints[0] = (y1 -= (int)(this.sin(90.0 - primeTheta) * (double)portBuffer)) - (int)(this.sin(90.0 - primeTheta) * (double)width);
            xPoints[1] = x3 - (int)(this.cos(90.0 - primeTheta) * (double)width);
            yPoints[1] = y3 - (int)(this.sin(90.0 - primeTheta) * (double)width);
            xPoints[2] = x2 - (int)(this.cos(primeTheta - theta) * (double)branchLength);
            yPoints[2] = y2 + (int)(this.sin(primeTheta - theta) * (double)branchLength);
            xPoints[3] = x2;
            yPoints[3] = y2;
            xPoints[4] = x2 - (int)(this.sin(90.0 - (primeTheta + theta)) * (double)branchLength);
            yPoints[4] = y2 + (int)(this.cos(90.0 - (primeTheta + theta)) * (double)branchLength);
            xPoints[5] = x3 + (int)(this.cos(90.0 - primeTheta) * (double)width);
            yPoints[5] = y3 + (int)(this.sin(90.0 - primeTheta) * (double)width);
            xPoints[6] = x1 + (int)(this.cos(90.0 - primeTheta) * (double)width);
            yPoints[6] = y1 + (int)(this.sin(90.0 - primeTheta) * (double)width);
        }
        return new Polygon(xPoints, yPoints, nPoints);
    }

    public Point[] createLineArrow(int x1, int y1, int x2, int y2) {
        return this.createLineArrow(x1, y1, x2, y2, 30.0, 10, 0, 0);
    }

    public Point[] createLineArrow(int x1, int y1, int x2, int y2, double theta, int branchLength, int tailBuffer, int headBuffer) {
        int y4;
        int x4;
        int y3;
        int x3;
        int dx = x2 - x1;
        int dy = y2 - y1;
        double primeTheta = Math.toDegrees(Math.atan((double)(-dy) / (double)dx));
        if (dx != 0) {
            double slope = dy / dx;
        } else {
            double slope = Double.POSITIVE_INFINITY;
        }
        if (dx >= 0 && dy <= 0) {
            x1 += (int)(this.cos(primeTheta) * (double)tailBuffer);
            y1 -= (int)(this.sin(primeTheta) * (double)tailBuffer);
            x3 = (x2 -= (int)(this.cos(primeTheta) * (double)headBuffer)) - (int)(this.cos(primeTheta - theta) * (double)branchLength);
            y3 = (y2 += (int)(this.sin(primeTheta) * (double)headBuffer)) + (int)(this.sin(primeTheta - theta) * (double)branchLength);
            x4 = x2 - (int)(this.cos(primeTheta + theta) * (double)branchLength);
            y4 = y2 + (int)(this.sin(primeTheta + theta) * (double)branchLength);
        } else if (dx <= 0 && dy <= 0) {
            x1 -= (int)(this.cos(primeTheta) * (double)tailBuffer);
            y1 += (int)(this.sin(primeTheta) * (double)tailBuffer);
            x3 = (x2 += (int)(this.cos(primeTheta) * (double)headBuffer)) + (int)(this.cos(primeTheta - theta) * (double)branchLength);
            y3 = (y2 -= (int)(this.sin(primeTheta) * (double)headBuffer)) - (int)(this.sin(primeTheta - theta) * (double)branchLength);
            x4 = x2 + (int)(this.cos(primeTheta + theta) * (double)branchLength);
            y4 = y2 - (int)(this.sin(primeTheta + theta) * (double)branchLength);
        } else if (dx <= 0 && dy >= 0) {
            x1 -= (int)(this.cos(primeTheta) * (double)tailBuffer);
            y1 += (int)(this.sin(primeTheta) * (double)tailBuffer);
            x3 = (x2 += (int)(this.cos(primeTheta) * (double)headBuffer)) + (int)(this.cos(primeTheta - theta) * (double)branchLength);
            y3 = (y2 -= (int)(this.sin(primeTheta) * (double)headBuffer)) - (int)(this.sin(primeTheta - theta) * (double)branchLength);
            x4 = x2 + (int)(this.cos(primeTheta + theta) * (double)branchLength);
            y4 = y2 - (int)(this.sin(primeTheta + theta) * (double)branchLength);
        } else {
            x1 += (int)(this.cos(primeTheta) * (double)tailBuffer);
            y1 -= (int)(this.sin(primeTheta) * (double)tailBuffer);
            x3 = (x2 -= (int)(this.cos(primeTheta) * (double)headBuffer)) - (int)(this.cos(primeTheta - theta) * (double)branchLength);
            y3 = (y2 += (int)(this.sin(primeTheta) * (double)headBuffer)) + (int)(this.sin(primeTheta - theta) * (double)branchLength);
            x4 = x2 - (int)(this.cos(primeTheta + theta) * (double)branchLength);
            y4 = y2 + (int)(this.sin(primeTheta + theta) * (double)branchLength);
        }
        Point[] points = new Point[]{new Point(x1, y1), new Point(x2, y2), new Point(x3, y3), new Point(x4, y4)};
        return points;
    }

    public void drawPolyArrow(Graphics g, Polygon p) {
        g.drawPolygon(p);
    }

    public void drawLineArrow(Graphics g, Point[] p) {
        g.drawLine(p[0].x, p[0].y, p[1].x, p[1].y);
        g.drawLine(p[1].x, p[1].y, p[2].x, p[2].y);
        g.drawLine(p[1].x, p[1].y, p[3].x, p[3].y);
    }

    private double sin(double theta) {
        return Math.sin(theta / 180.0 * Math.PI);
    }

    private double cos(double theta) {
        return Math.cos(theta / 180.0 * Math.PI);
    }
}

