/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.graph.vrp;

import drasys.or.graph.GraphI;
import drasys.or.graph.PropertiesI;
import drasys.or.graph.VertexI;
import drasys.or.graph.VertexNotFoundException;
import drasys.or.graph.tsp.ImproveI;
import drasys.or.graph.vrp.VRPBase;
import drasys.or.graph.vrp.VRPError;
import drasys.or.util.Array;

public abstract class ConstructBase
extends VRPBase {
    ImproveI _improve;
    protected boolean[] _selected = null;

    public ConstructBase() {
        this._improve = null;
    }

    public ConstructBase(ImproveI improveI) {
        this._improve = improveI;
    }

    public boolean isSelected(VertexI vertexI) {
        if (this._selected == null) {
            return true;
        }
        return this._selected[vertexI.getIndex()];
    }

    public void selectVertex(Object object, boolean bl) throws VertexNotFoundException {
        if (this._graph == null) {
            throw new VRPError("The graph is not set.");
        }
        VertexI vertexI = this._graph.getVertex(object);
        if (vertexI == null) {
            throw new VertexNotFoundException();
        }
        if (this._selected == null) {
            this._selected = new boolean[this._graph.sizeOfVertices()];
            int n = 0;
            while (n < this._selected.length) {
                this._selected[n] = true;
                ++n;
            }
        }
        this._selected[vertexI.getIndex()] = bl;
    }

    public void selectVertex(boolean bl) {
        if (bl) {
            this._selected = null;
            return;
        }
        if (this._graph == null) {
            throw new VRPError("The graph is not set.");
        }
        if (this._selected == null) {
            this._selected = Array.resize(this._graph.sizeOfVertices(), this._selected, true);
        }
    }

    public void selectVertex(boolean[] blArray) {
        if (blArray == null) {
            this._selected = null;
            return;
        }
        if (this._graph == null) {
            throw new VRPError("The graph is not set.");
        }
        if (blArray.length != this._graph.sizeOfVertices()) {
            throw new VRPError("The size of the select array  must equal the number of vertices in the graph.");
        }
        this._selected = new boolean[this._graph.sizeOfVertices()];
        int n = 0;
        while (n < this._selected.length) {
            this._selected[n] = blArray[n];
            ++n;
        }
    }

    public void setEdgeKey(Object object) {
        super.setEdgeKey(object);
        if (this._improve != null) {
            this._improve.setEdgeKey(object);
        }
    }

    public void setGraph(GraphI graphI) {
        super.setGraph(graphI);
        if (this._improve != null) {
            this._improve.setGraph(graphI);
        }
        if (graphI == null) {
            this._selected = null;
        }
    }

    public void setProperties(PropertiesI propertiesI) {
        super.setProperties(propertiesI);
        if (this._improve != null) {
            this._improve.setProperties(propertiesI);
        }
    }

    public int sizeOfSelected() {
        return this._graph == null ? 0 : (this._selected == null ? this._graph.sizeOfVertices() : Array.count(this._selected.length, this._selected, 0, 1, true));
    }
}

