/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.linear.algebra;

import drasys.or.linear.SingularException;
import drasys.or.linear.algebra.AlgebraError;
import drasys.or.linear.algebra.AlgebraException;
import drasys.or.linear.algebra.LUDecompositionI;
import drasys.or.matrix.ContiguousVector;
import drasys.or.matrix.DenseMatrix;
import drasys.or.matrix.DenseVector;
import drasys.or.matrix.MatrixI;
import drasys.or.matrix.VectorI;
import java.io.Serializable;

public class CroutPivot
implements LUDecompositionI,
Serializable {
    double _d;
    int[] _idx = null;
    double[][] _a = null;

    public CroutPivot() {
    }

    public CroutPivot(MatrixI matrixI) throws AlgebraException, SingularException {
        this.decompose(matrixI);
    }

    public double computeDeterminate() throws AlgebraException {
        if (this._a == null) {
            throw new AlgebraError("No matrix has been decomposed.");
        }
        double d = this._d;
        int n = 0;
        while (n < this._a.length) {
            d *= this._a[n][n];
            ++n;
        }
        return d;
    }

    public DenseMatrix computeInverse() throws AlgebraException {
        DenseMatrix denseMatrix = new DenseMatrix(this._a.length, this._a.length);
        this.computeInverse(denseMatrix);
        return denseMatrix;
    }

    public MatrixI computeInverse(MatrixI matrixI) throws AlgebraException {
        if (this._a == null) {
            throw new AlgebraError("No matrix has been decomposed.");
        }
        int n = this._a.length;
        DenseVector denseVector = new DenseVector(n);
        DenseVector denseVector2 = new DenseVector(n);
        int n2 = 0;
        while (n2 < n) {
            denseVector.setElementAt(n2, 1.0);
            matrixI.setColumn(n2, this.solveEquations(denseVector, denseVector2));
            denseVector.setElementAt(n2, 0.0);
            ++n2;
        }
        return matrixI;
    }

    public void decompose(MatrixI matrixI) throws AlgebraException, SingularException {
        int n;
        double d;
        double[] dArray;
        this._a = matrixI.getArray();
        int n2 = matrixI.sizeOfRows();
        this._idx = new int[n2];
        double[] dArray2 = new double[n2];
        int n3 = 0;
        this._d = 1.0;
        int n4 = 0;
        while (n4 < n2) {
            dArray = this._a[n4];
            d = 0.0;
            n = 0;
            while (n < n2) {
                double d2 = Math.abs(dArray[n]);
                if (d2 > d) {
                    d = d2;
                }
                ++n;
            }
            if (d == 0.0) {
                throw new SingularException();
            }
            dArray2[n4] = 1.0 / d;
            ++n4;
        }
        n = 0;
        while (n < n2) {
            double d3;
            int n5;
            double d4;
            dArray = this._a[n];
            n4 = 0;
            while (n4 < n) {
                double[] dArray3 = this._a[n4];
                d4 = dArray3[n];
                n5 = 0;
                while (n5 < n4) {
                    d4 -= dArray3[n5] * this._a[n5][n];
                    ++n5;
                }
                dArray3[n] = d4;
                ++n4;
            }
            d = 0.0;
            n4 = n;
            while (n4 < n2) {
                double[] dArray4 = this._a[n4];
                d4 = dArray4[n];
                n5 = 0;
                while (n5 < n) {
                    d4 -= dArray4[n5] * this._a[n5][n];
                    ++n5;
                }
                dArray4[n] = d4;
                d3 = dArray2[n4] * Math.abs(d4);
                if (d3 >= d) {
                    d = d3;
                    n3 = n4;
                }
                ++n4;
            }
            if (n != n3) {
                n5 = 0;
                while (n5 < n2) {
                    d3 = this._a[n3][n5];
                    this._a[n3][n5] = dArray[n5];
                    dArray[n5] = d3;
                    ++n5;
                }
                this._d = -this._d;
                dArray2[n3] = dArray2[n];
            }
            this._idx[n] = n3;
            if (dArray[n] == 0.0) {
                throw new SingularException();
            }
            if (n != n2 - 1) {
                d3 = 1.0 / dArray[n];
                n4 = n + 1;
                while (n4 < n2) {
                    double[] dArray5 = this._a[n4];
                    int n6 = n;
                    dArray5[n6] = dArray5[n6] * d3;
                    ++n4;
                }
            }
            ++n;
        }
    }

    public DenseMatrix getL() {
        DenseMatrix denseMatrix = new DenseMatrix(this._a.length, this._a.length);
        this.getL(denseMatrix);
        return denseMatrix;
    }

    public MatrixI getL(MatrixI matrixI) {
        int n = this._a.length;
        int n2 = 0;
        while (n2 < n) {
            matrixI.setElementAt(n2, n2, 1.0);
            int n3 = 0;
            while (n3 < n2) {
                matrixI.setElementAt(n2, n3, this._a[n2][n3]);
                ++n3;
            }
            ++n2;
        }
        return matrixI;
    }

    public int[] getRowPermutations() {
        return this._idx;
    }

    public DenseMatrix getU() {
        DenseMatrix denseMatrix = new DenseMatrix(this._a.length, this._a.length);
        this.getU(denseMatrix);
        return denseMatrix;
    }

    public MatrixI getU(MatrixI matrixI) {
        int n = this._a.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2;
            while (n3 < n) {
                matrixI.setElementAt(n2, n3, this._a[n2][n3]);
                ++n3;
            }
            ++n2;
        }
        return matrixI;
    }

    public DenseVector solveEquations(VectorI vectorI) throws AlgebraException {
        DenseVector denseVector = new DenseVector(vectorI.size());
        this.solveEquations(vectorI, denseVector);
        return denseVector;
    }

    public VectorI solveEquations(VectorI vectorI, VectorI vectorI2) throws AlgebraException {
        int n;
        double[] dArray;
        double d;
        if (this._a == null) {
            throw new AlgebraException("No matrix has been decomposed.");
        }
        double[] dArray2 = vectorI.getArray();
        int n2 = -1;
        int n3 = this._a.length;
        int n4 = 0;
        while (n4 < n3) {
            int n5 = this._idx[n4];
            d = dArray2[n5];
            dArray2[n5] = dArray2[n4];
            if (n2 != -1) {
                dArray = this._a[n4];
                n = n2;
                while (n <= n4 - 1) {
                    d -= dArray[n] * dArray2[n];
                    ++n;
                }
            } else if (d != 0.0) {
                n2 = n4;
            }
            dArray2[n4] = d;
            ++n4;
        }
        n4 = n3 - 1;
        while (n4 >= 0) {
            d = dArray2[n4];
            dArray = this._a[n4];
            n = n4 + 1;
            while (n < n3) {
                d -= dArray[n] * dArray2[n];
                ++n;
            }
            dArray2[n4] = d / dArray[n4];
            --n4;
        }
        vectorI2.setElements(new ContiguousVector(dArray2, true));
        return vectorI2;
    }
}

