/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.matrix;

import drasys.or.matrix.ArrayMatrix;
import drasys.or.matrix.MatrixElementI;
import drasys.or.matrix.MatrixError;
import drasys.or.matrix.MatrixI;
import drasys.or.matrix.VectorElementI;
import drasys.or.matrix.VectorI;
import drasys.or.util.Array;
import java.util.Enumeration;

public class RowArrayMatrix
extends ArrayMatrix {
    int _capacityOfColumns = 0;

    public RowArrayMatrix(int n, int n2) {
        super(n, n2);
        this._capacityOfColumns = n2;
        this._values = new double[n][];
    }

    public RowArrayMatrix(int n, int n2, int n3, int n4) {
        super(n, n2);
        this._capacityOfColumns = this._sizeOfColumns;
        this._values = new double[n3][];
    }

    public RowArrayMatrix(MatrixI matrixI) {
        super(matrixI.sizeOfRows(), matrixI.sizeOfColumns());
        this._capacityOfColumns = this._sizeOfColumns;
        this._values = new double[this._sizeOfRows][];
        int n = 0;
        while (n < this._sizeOfRows) {
            this._values[n] = new double[this._capacityOfColumns];
            ++n;
        }
        Enumeration enumeration = matrixI.elements();
        while (enumeration.hasMoreElements()) {
            MatrixElementI matrixElementI = (MatrixElementI)enumeration.nextElement();
            int n2 = matrixElementI.getRowIndex();
            double[] dArray = this._values[n2];
            if (dArray == null) {
                this._values[n2] = new double[this._capacityOfColumns];
                dArray = this._values[n2];
            }
            dArray[matrixElementI.getColumnIndex()] = matrixElementI.getValue();
        }
    }

    public RowArrayMatrix(VectorI vectorI) {
        super(vectorI.size(), vectorI.size());
        this._capacityOfColumns = this._sizeOfColumns;
        this._values = new double[this._sizeOfRows][];
        Enumeration enumeration = vectorI.elements();
        while (enumeration.hasMoreElements()) {
            VectorElementI vectorElementI = (VectorElementI)enumeration.nextElement();
            double[] dArray = this._values[vectorElementI.getIndex()];
            if (dArray == null) {
                double[] dArray2 = new double[this._capacityOfColumns];
                this._values[vectorElementI.getIndex()] = dArray2;
                dArray = dArray2;
            }
            dArray[vectorElementI.getIndex()] = vectorElementI.getValue();
        }
    }

    public RowArrayMatrix(double[][] dArray) {
        this(dArray, false);
    }

    public RowArrayMatrix(double[][] dArray, boolean bl) {
        super(dArray);
        this._capacityOfColumns = this._sizeOfColumns;
        if (bl) {
            this._values = dArray;
            int n = 0;
            while (n < this._sizeOfRows) {
                if (dArray[n] == null || dArray[n].length != this._sizeOfColumns) {
                    throw new MatrixError("All rows must be the non-null and the same length");
                }
                ++n;
            }
        } else {
            this._values = new double[this._sizeOfRows][];
            int n = 0;
            while (n < this._sizeOfRows) {
                double[] dArray2 = dArray[n];
                if (dArray2 != null) {
                    this._values[n] = new double[this._capacityOfColumns];
                    double[] dArray3 = this._values[n];
                    Array.copy(dArray2.length, dArray3, 0, 1, dArray2, 0, 1);
                }
                ++n;
            }
        }
    }

    public void addColumn(VectorI vectorI) {
        if (this._sizeOfColumns >= this.capacityOfColumns()) {
            this.setCapacity(this._sizeOfRows, 2 * this._sizeOfColumns);
        }
        int n = this._sizeOfColumns;
        this.setSize(this._sizeOfRows, this._sizeOfColumns + 1);
        if (vectorI == null) {
            return;
        }
        double[] dArray = null;
        Enumeration enumeration = vectorI.elements();
        while (enumeration.hasMoreElements()) {
            VectorElementI vectorElementI = (VectorElementI)enumeration.nextElement();
            int n2 = vectorElementI.getIndex();
            dArray = this._values[n2];
            if (dArray == null) {
                this._values[n2] = new double[this._capacityOfColumns];
                dArray = this._values[n2];
            }
            dArray[n] = vectorElementI.getValue();
        }
    }

    public void addRow(VectorI vectorI) {
        if (this._sizeOfRows >= this.capacityOfRows()) {
            this.setCapacity(2 * this._sizeOfRows, this._sizeOfColumns);
        }
        int n = this._sizeOfRows;
        this.setSize(this._sizeOfRows + 1, this._sizeOfColumns);
        if (vectorI == null) {
            return;
        }
        double[] dArray = null;
        Enumeration enumeration = vectorI.elements();
        while (enumeration.hasMoreElements()) {
            VectorElementI vectorElementI = (VectorElementI)enumeration.nextElement();
            int n2 = vectorElementI.getIndex();
            if (dArray == null) {
                this._values[n] = new double[this._capacityOfColumns];
                dArray = this._values[n];
            }
            dArray[n2] = vectorElementI.getValue();
        }
    }

    public int capacityOfColumns() {
        return this._capacityOfColumns;
    }

    public int capacityOfRows() {
        return this._values.length;
    }

    public Enumeration columnElements(int n) {
        if (n < 0 || n >= this._sizeOfColumns) {
            throw new IndexOutOfBoundsException("Column=" + n + ", sizeOfColumns=" + this._sizeOfColumns);
        }
        return new ColumnEnum(n);
    }

    public double elementAt(int n, int n2) {
        if (n < 0 || n >= this._sizeOfRows) {
            throw new IndexOutOfBoundsException("Row=" + n + ", sizeOfRows=" + this._sizeOfRows);
        }
        if (n2 < 0 || n2 >= this._sizeOfColumns) {
            throw new IndexOutOfBoundsException("Column=" + n2 + ", sizeOfColumns=" + this._sizeOfColumns);
        }
        double[] dArray = this._values[n];
        return dArray == null ? 0.0 : dArray[n2];
    }

    public Enumeration elements() {
        return new Enum();
    }

    public double[][] getArray() {
        double[][] dArray = new double[this._sizeOfRows][this._sizeOfColumns];
        int n = 0;
        while (n < this._sizeOfRows) {
            double[] dArray2 = this._values[n];
            if (dArray2 != null) {
                Array.copy(this._sizeOfRows, dArray[n], 0, 1, dArray2, 0, 1);
            }
            ++n;
        }
        return dArray;
    }

    public boolean isColumnMajor() {
        return false;
    }

    public boolean isNull(int n, int n2) {
        if (n < 0 || n >= this._sizeOfRows) {
            throw new IndexOutOfBoundsException("Row=" + n + ", sizeOfRows=" + this._sizeOfRows);
        }
        if (n2 < 0 || n2 >= this._sizeOfColumns) {
            throw new IndexOutOfBoundsException("Column=" + n2 + ", sizeOfColumns=" + this._sizeOfColumns);
        }
        return this._values[n] == null;
    }

    public boolean isRowMajor() {
        return true;
    }

    public Enumeration rowElements(int n) {
        if (n < 0 || n >= this._sizeOfRows) {
            throw new IndexOutOfBoundsException("Row=" + n + ", sizeOfRows=" + this._sizeOfRows);
        }
        return new RowEnum(n);
    }

    public void setCapacity(int n, int n2) {
        if (n > this.capacityOfRows()) {
            this._values = Array.resize(n, this._values);
        }
        if (n2 > this._capacityOfColumns) {
            int n3 = 0;
            while (n3 < this._sizeOfRows) {
                double[] dArray = this._values[n3];
                if (dArray != null) {
                    this._values[n3] = Array.resize(n2, dArray);
                }
                ++n3;
            }
        }
        this._capacityOfColumns = n2;
    }

    public void setElementAt(int n, int n2, double d) {
        if (n < 0 || n >= this._sizeOfRows) {
            throw new IndexOutOfBoundsException("Row=" + n + ", sizeOfRows=" + this._sizeOfRows);
        }
        if (n2 < 0 || n2 >= this._sizeOfColumns) {
            throw new IndexOutOfBoundsException("Column=" + n2 + ", sizeOfColumns=" + this._sizeOfColumns);
        }
        double[] dArray = this._values[n];
        if (dArray == null) {
            this._values[n] = new double[this._capacityOfColumns];
            dArray = this._values[n];
        }
        dArray[n2] = d;
    }

    public void setSize(int n, int n2) {
        int n3;
        if (n >= this.capacityOfRows() || n2 >= this.capacityOfColumns()) {
            this.setCapacity(n, n2);
        }
        if (n < this._sizeOfRows) {
            n3 = n;
            while (n3 < this._sizeOfRows) {
                this._values[n3] = null;
                ++n3;
            }
        }
        this._sizeOfRows = n;
        if (n2 > this._sizeOfColumns) {
            n3 = n2 - this._sizeOfColumns;
            if (n3 == 1) {
                int n4 = 0;
                while (n4 < this._sizeOfRows) {
                    double[] dArray = this._values[n4];
                    if (dArray != null) {
                        dArray[this._sizeOfColumns] = 0.0;
                    }
                    ++n4;
                }
            } else {
                int n5 = 0;
                while (n5 < this._sizeOfRows) {
                    double[] dArray = this._values[n5];
                    if (dArray != null) {
                        Array.copy(n3, dArray, this._sizeOfColumns, 1, 0.0);
                    }
                    ++n5;
                }
            }
        }
        this._sizeOfColumns = n2;
    }

    public int sizeOfElements() {
        int n = 0;
        int n2 = 0;
        while (n2 < this._sizeOfRows) {
            if (this._values[n2] != null) {
                n += this._sizeOfColumns;
            }
            ++n2;
        }
        return n;
    }

    public double sum(int n, int n2, int n3, int n4) {
        int n5 = n4 - n3;
        if (n5 < 1) {
            return 0.0;
        }
        double d = 0.0;
        while (n < n2) {
            double[] dArray = this._values[n];
            if (dArray == null) continue;
            d += Array.sum(n5, dArray, n3, 1);
            ++n;
        }
        return d;
    }

    public double sumOfSquaredDifferences(int n, int n2, int n3, int n4, double d) {
        int n5 = n4 - n3;
        if (n5 < 1) {
            return 0.0;
        }
        double d2 = 0.0;
        int n6 = 0;
        while (n < n2) {
            double[] dArray = this._values[n];
            if (dArray == null) {
                n6 += n5;
                continue;
            }
            d2 += Array.sumOfSquaredDifferences(n5, dArray, n3, 1, d);
            ++n;
        }
        if (d != 0.0) {
            d2 += (double)n6 * d * d;
        }
        return d2;
    }

    public double sumOfSquares(int n, int n2, int n3, int n4) {
        int n5 = n4 - n3;
        if (n5 < 1) {
            return 0.0;
        }
        double d = 0.0;
        while (n < n2) {
            double[] dArray = this._values[n];
            if (dArray == null) continue;
            d += Array.sumOfSquares(n5, dArray, n3, 1);
            ++n;
        }
        return d;
    }

    private class Enum
    implements Enumeration,
    MatrixElementI {
        int _i = 0;
        int _j = 0;
        double[] _row = null;
        int _mi;
        int _mj;
        double _mvalue;
        double[] _mrow;

        Enum() {
            while (this._i < RowArrayMatrix.this._sizeOfRows && (this._row = RowArrayMatrix.this._values[this._i]) == null) {
                ++this._i;
            }
        }

        public int getColumnIndex() {
            return this._mj;
        }

        public int getRowIndex() {
            return this._mi;
        }

        public double getValue() {
            return this._mvalue;
        }

        public boolean hasMoreElements() {
            return this._row != null;
        }

        public Object nextElement() {
            if (this._row == null) {
                return null;
            }
            this._mi = this._i++;
            this._mj = this._j;
            this._mrow = this._row;
            this._mvalue = this._row[this._j++];
            if (this._j >= RowArrayMatrix.this._sizeOfColumns) {
                this._row = null;
                this._j = 0;
                while (this._i < RowArrayMatrix.this._sizeOfRows && (this._row = RowArrayMatrix.this._values[this._i]) == null) {
                    ++this._i;
                }
            }
            return this;
        }

        public void setValue(double d) {
            this._mrow[this._mj] = this._mvalue = d;
        }
    }

    private class RowEnum
    implements Enumeration,
    MatrixElementI {
        int _j = 0;
        double[] _row = null;
        int _mi;
        int _mj;
        double _mvalue;
        double[] _mrow;

        RowEnum(int n) {
            this._mi = n;
            this._row = RowArrayMatrix.this._values[n];
            this._mrow = this._row;
        }

        public int getColumnIndex() {
            return this._mj;
        }

        public int getRowIndex() {
            return this._mi;
        }

        public double getValue() {
            return this._mvalue;
        }

        public boolean hasMoreElements() {
            return this._row != null;
        }

        public Object nextElement() {
            if (this._row == null) {
                return null;
            }
            this._mj = this._j;
            this._mvalue = this._row[this._j++];
            if (this._j >= RowArrayMatrix.this._sizeOfColumns) {
                this._row = null;
            }
            return this;
        }

        public void setValue(double d) {
            this._mrow[this._mj] = this._mvalue = d;
        }
    }

    private class ColumnEnum
    implements Enumeration,
    MatrixElementI {
        int _i = 0;
        double[] _row = null;
        int _mi;
        int _mj;
        double _mvalue;
        double[] _mrow;

        ColumnEnum(int n) {
            this._mj = n;
            while (this._i < RowArrayMatrix.this._sizeOfRows && (this._row = RowArrayMatrix.this._values[this._i]) == null) {
                ++this._i;
            }
        }

        public int getColumnIndex() {
            return this._mj;
        }

        public int getRowIndex() {
            return this._mi;
        }

        public double getValue() {
            return this._mvalue;
        }

        public boolean hasMoreElements() {
            return this._row != null;
        }

        public Object nextElement() {
            if (this._row == null) {
                return null;
            }
            this._mi = this._i++;
            this._mrow = this._row;
            this._mvalue = this._row[this._mj];
            this._row = null;
            while (this._i < RowArrayMatrix.this._sizeOfRows && (this._row = RowArrayMatrix.this._values[this._i]) == null) {
                ++this._i;
            }
            return this;
        }

        public void setValue(double d) {
            this._mrow[this._mj] = this._mvalue = d;
        }
    }
}

