/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.matrix.complex;

import drasys.or.Complex;
import drasys.or.ComplexI;
import drasys.or.matrix.complex.ColumnMajorMatrix;
import drasys.or.matrix.complex.ContiguousMatrix;
import drasys.or.matrix.complex.DenseVector;
import drasys.or.matrix.complex.MatrixElementI;
import drasys.or.matrix.complex.MatrixI;
import drasys.or.matrix.complex.VectorElementI;
import drasys.or.matrix.complex.VectorI;
import drasys.or.util.Array;
import drasys.or.util.ComplexArray;
import java.util.Enumeration;

public class RowMajorMatrix
extends ContiguousMatrix {
    public RowMajorMatrix(int n, int n2) {
        super(n, n2, n, n2);
    }

    public RowMajorMatrix(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
    }

    public RowMajorMatrix(MatrixI matrixI) {
        super(matrixI);
        if (matrixI instanceof RowMajorMatrix) {
            RowMajorMatrix rowMajorMatrix = (RowMajorMatrix)matrixI;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (n < this._sizeOfRows) {
                ComplexArray.copy(this._sizeOfColumns, this._values, n2, 1, rowMajorMatrix._values, n3, 1);
                ++n;
                n2 += this._capacityOfColumns;
                n3 += rowMajorMatrix._capacityOfColumns;
            }
        } else if (matrixI instanceof ColumnMajorMatrix) {
            ColumnMajorMatrix columnMajorMatrix = (ColumnMajorMatrix)matrixI;
            int n = 0;
            int n4 = 0;
            int n5 = 0;
            while (n < this._sizeOfRows) {
                ComplexArray.copy(this._sizeOfColumns, this._values, n4, 1, columnMajorMatrix._values, n5, columnMajorMatrix._capacityOfColumns);
                ++n;
                n4 += this._capacityOfColumns;
                ++n5;
            }
        } else {
            Enumeration enumeration = matrixI.elements();
            while (enumeration.hasMoreElements()) {
                MatrixElementI matrixElementI = (MatrixElementI)enumeration.nextElement();
                this.setElementAt(matrixElementI.getRowIndex(), matrixElementI.getColumnIndex(), matrixElementI.getValue());
            }
        }
    }

    public RowMajorMatrix(VectorI vectorI) {
        super(vectorI);
    }

    public RowMajorMatrix(double[][] dArray) {
        super(dArray);
        int n = 0;
        int n2 = 0;
        while (n < this._sizeOfRows) {
            double[] dArray2 = dArray[n];
            if (dArray2 != null) {
                ComplexArray.copy(dArray2.length / 2, this._values, n2, 1, dArray2, 0, 1);
            }
            ++n;
            n2 += this._capacityOfColumns;
        }
    }

    public RowMajorMatrix(double[][] dArray, double[][] dArray2) {
        super(dArray, dArray2);
        int n = 2 * this._capacityOfColumns;
        int n2 = 0;
        int n3 = 0;
        while (n2 < this._sizeOfRows) {
            double[] dArray3;
            double[] dArray4 = dArray == null ? null : dArray[n2];
            double[] dArray5 = dArray3 = dArray2 == null ? null : dArray2[n2];
            if (dArray4 != null) {
                Array.copy(dArray4.length, this._values, n3, 2, dArray4, 0, 1);
            }
            if (dArray3 != null) {
                Array.copy(dArray3.length, this._values, n3 + 1, 2, dArray3, 0, 1);
            }
            ++n2;
            n3 += n;
        }
    }

    public void addColumn(VectorI vectorI) {
        int n = this._sizeOfColumns;
        this.setSize(this._sizeOfRows, this._sizeOfColumns + 1);
        if (vectorI == null) {
            return;
        }
        if (vectorI instanceof DenseVector) {
            DenseVector denseVector = (DenseVector)vectorI;
            int n2 = Math.min(vectorI.size(), this._sizeOfRows);
            ComplexArray.copy(n2, this._values, this._sizeOfColumns - 1, this._capacityOfRows, denseVector._values, 0, 1);
        } else {
            Enumeration enumeration = vectorI.elements();
            while (enumeration.hasMoreElements()) {
                VectorElementI vectorElementI = (VectorElementI)enumeration.nextElement();
                int n3 = vectorElementI.getIndex();
                if (n3 >= this._sizeOfRows) continue;
                this.setElementAt(n3, n, vectorElementI.getValue());
            }
        }
    }

    public void addRow(VectorI vectorI) {
        int n = this._sizeOfRows;
        this.setSize(this._sizeOfRows + 1, this._sizeOfColumns);
        if (vectorI == null) {
            return;
        }
        if (vectorI instanceof DenseVector) {
            DenseVector denseVector = (DenseVector)vectorI;
            int n2 = Math.min(vectorI.size(), this._sizeOfColumns);
            ComplexArray.copy(n2, this._values, n * this._capacityOfColumns, 1, denseVector._values, 0, 1);
        } else {
            Enumeration enumeration = vectorI.elements();
            while (enumeration.hasMoreElements()) {
                VectorElementI vectorElementI = (VectorElementI)enumeration.nextElement();
                int n3 = vectorElementI.getIndex();
                if (n3 >= this._sizeOfColumns) continue;
                this.setElementAt(n, n3, vectorElementI.getValue());
            }
        }
    }

    public Enumeration columnElements(int n) {
        if (n < 0 || n >= this._sizeOfColumns) {
            throw new IndexOutOfBoundsException("Column=" + n + ", sizeOfColumns=" + this._sizeOfColumns);
        }
        return new ColumnEnum(n);
    }

    public Complex elementAt(int n, int n2) {
        if (n < 0 || n >= this._sizeOfRows) {
            throw new IndexOutOfBoundsException("Row=" + n + ", sizeOfRows=" + this._sizeOfRows);
        }
        if (n2 < 0 || n2 >= this._sizeOfColumns) {
            throw new IndexOutOfBoundsException("Column=" + n2 + ", sizeOfColumns=" + this._sizeOfColumns);
        }
        int n3 = 2 * (n2 + this._capacityOfColumns * n);
        return new Complex(this._values[n3], this._values[n3 + 1]);
    }

    public Complex elementAt(int n, int n2, Complex complex) {
        if (n < 0 || n >= this._sizeOfRows) {
            throw new IndexOutOfBoundsException("Row=" + n + ", sizeOfRows=" + this._sizeOfRows);
        }
        if (n2 < 0 || n2 >= this._sizeOfColumns) {
            throw new IndexOutOfBoundsException("Column=" + n2 + ", sizeOfColumns=" + this._sizeOfColumns);
        }
        int n3 = 2 * (n2 + this._capacityOfColumns * n);
        if (complex == null) {
            return new Complex(this._values[n3], this._values[n3 + 1]);
        }
        complex.real = this._values[n3];
        complex.imag = this._values[n3 + 1];
        return complex;
    }

    public Enumeration elements() {
        return new Enum();
    }

    public double[][] getArray() {
        double[][] dArray = new double[this._sizeOfRows][this._sizeOfColumns * 2];
        int n = 0;
        int n2 = 0;
        while (n < dArray.length) {
            double[] dArray2 = dArray[n];
            ComplexArray.copy(this._sizeOfColumns, dArray2, 0, 1, this._values, n2, 1);
            ++n;
            n2 += this._capacityOfColumns;
        }
        return dArray;
    }

    public int getColumnIncrement() {
        return 1;
    }

    public int getOffset(int n, int n2) {
        if (n < 0 || n >= this._sizeOfRows) {
            throw new IndexOutOfBoundsException("Row=" + n + ", sizeOfRows=" + this._sizeOfRows);
        }
        if (n2 < 0 || n2 >= this._sizeOfColumns) {
            throw new IndexOutOfBoundsException("Column=" + n2 + ", sizeOfColumns=" + this._sizeOfColumns);
        }
        return n * this._capacityOfColumns + n2;
    }

    public int getRowIncrement() {
        return this._capacityOfColumns;
    }

    public boolean isColumnMajor() {
        return false;
    }

    public boolean isRowMajor() {
        return true;
    }

    public Enumeration rowElements(int n) {
        if (n < 0 || n >= this._sizeOfRows) {
            throw new IndexOutOfBoundsException("Row=" + n + ", sizeOfRows=" + this._sizeOfRows);
        }
        return new RowEnum(n);
    }

    public void setCapacity(int n, int n2) {
        if (n <= this._capacityOfRows && n2 <= this._capacityOfColumns) {
            return;
        }
        double[] dArray = new double[n * n2];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n3 < this._sizeOfRows) {
            ComplexArray.copy(this._sizeOfColumns, dArray, n5, 1, this._values, n4, 1);
            ++n3;
            n4 += this._capacityOfColumns;
            n5 += n2;
        }
        this._values = dArray;
        this._capacityOfRows = n;
        this._capacityOfColumns = n2;
    }

    public void setElementAt(int n, int n2, ComplexI complexI) {
        if (n < 0 || n >= this._sizeOfRows) {
            throw new IndexOutOfBoundsException("Row=" + n + ", sizeOfRows=" + this._sizeOfRows);
        }
        if (n2 < 0 || n2 >= this._sizeOfColumns) {
            throw new IndexOutOfBoundsException("Column=" + n2 + ", sizeOfColumns=" + this._sizeOfColumns);
        }
        int n3 = 2 * (n2 + this._capacityOfColumns * n);
        this._values[n3] = complexI.getReal();
        this._values[n3 + 1] = complexI.getImag();
    }

    public void setSize(int n, int n2) {
        Complex complex = new Complex();
        if (n > this._capacityOfRows || n2 > this._capacityOfColumns) {
            this.setCapacity(n, n2);
        }
        int n3 = this._sizeOfRows;
        int n4 = this._sizeOfRows * this._capacityOfColumns;
        while (n3 < n) {
            ComplexArray.copy(n2, this._values, n4, 1, (ComplexI)complex);
            ++n3;
            n4 += this._capacityOfColumns;
        }
        if (n2 > this._sizeOfColumns) {
            int n5 = n2 - this._sizeOfColumns;
            int n6 = 0;
            int n7 = this._sizeOfColumns;
            while (n6 < this._sizeOfRows) {
                ComplexArray.copy(n5, this._values, n7, 1, (ComplexI)complex);
                ++n6;
                n7 += this._capacityOfColumns;
            }
        }
        this._sizeOfRows = n;
        this._sizeOfColumns = n2;
    }

    private class Enum
    implements Enumeration,
    MatrixElementI,
    ComplexI {
        int _row = 0;
        int _coef = 0;
        int _column = 0;
        int _mrow;
        int _mcol;
        double _mreal;
        double _mimag;

        Enum() {
        }

        public int getColumnIndex() {
            return this._mcol;
        }

        public double getImag() {
            return this._mimag;
        }

        public double getReal() {
            return this._mreal;
        }

        public int getRowIndex() {
            return this._mrow;
        }

        public ComplexI getValue() {
            return this;
        }

        public boolean hasMoreElements() {
            return this._row < RowMajorMatrix.this._sizeOfRows;
        }

        public Object nextElement() {
            if (this._row >= RowMajorMatrix.this._sizeOfRows) {
                return null;
            }
            this._mrow = this._row++;
            this._mcol = this._column++;
            this._mreal = RowMajorMatrix.this._values[this._coef++];
            this._mimag = RowMajorMatrix.this._values[this._coef++];
            if (this._column >= RowMajorMatrix.this._sizeOfColumns) {
                this._coef = 2 * this._row * RowMajorMatrix.this._capacityOfColumns;
                this._column = 0;
            }
            return this;
        }

        public void setValue(ComplexI complexI) {
            this._mreal = complexI.getReal();
            this._mimag = complexI.getImag();
            RowMajorMatrix.this.setElementAt(this._mrow, this._mcol, complexI);
        }
    }

    private class RowEnum
    implements Enumeration,
    MatrixElementI,
    ComplexI {
        int _row = 0;
        int _coef = 0;
        int _column = 0;
        int _mcol;
        double _mreal;
        double _mimag;

        public RowEnum(int n) {
            this._row = n;
            this._coef = this._row * RowMajorMatrix.this._capacityOfColumns;
        }

        public int getColumnIndex() {
            return this._mcol;
        }

        public double getImag() {
            return this._mimag;
        }

        public double getReal() {
            return this._mreal;
        }

        public int getRowIndex() {
            return this._row;
        }

        public ComplexI getValue() {
            return this;
        }

        public boolean hasMoreElements() {
            return this._column < RowMajorMatrix.this._sizeOfColumns;
        }

        public Object nextElement() {
            if (this._column >= RowMajorMatrix.this._sizeOfColumns) {
                return null;
            }
            this._mcol = this._column++;
            this._mreal = RowMajorMatrix.this._values[this._coef++];
            this._mimag = RowMajorMatrix.this._values[this._coef++];
            return this;
        }

        public void setValue(ComplexI complexI) {
            this._mreal = complexI.getReal();
            this._mimag = complexI.getImag();
            RowMajorMatrix.this.setElementAt(this._row, this._mcol, complexI);
        }
    }

    class ColumnEnum
    implements Enumeration,
    MatrixElementI,
    ComplexI {
        int _row = 0;
        int _coef = 0;
        int _column = 0;
        int _mrow;
        double _mreal;
        double _mimag;

        public ColumnEnum(int n) {
            this._coef = this._column = n;
        }

        public int getColumnIndex() {
            return this._column;
        }

        public double getImag() {
            return this._mimag;
        }

        public double getReal() {
            return this._mreal;
        }

        public int getRowIndex() {
            return this._mrow;
        }

        public ComplexI getValue() {
            return this;
        }

        public boolean hasMoreElements() {
            return this._row < RowMajorMatrix.this._sizeOfRows;
        }

        public Object nextElement() {
            if (this._row >= RowMajorMatrix.this._sizeOfRows) {
                return null;
            }
            this._mrow = this._row++;
            this._mreal = RowMajorMatrix.this._values[this._coef];
            this._mimag = RowMajorMatrix.this._values[this._coef];
            this._coef += 2 * RowMajorMatrix.this._capacityOfColumns;
            return this;
        }

        public void setValue(ComplexI complexI) {
            this._mreal = complexI.getReal();
            this._mimag = complexI.getImag();
            RowMajorMatrix.this.setElementAt(this._mrow, this._column, complexI);
        }
    }
}

