/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.core.data.seqdoc;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import org.biolegato.core.data.seqdoc.SeqDocListener;
import org.biolegato.core.data.sequence.Sequence;
import org.biolegato.core.data.sequence.SequenceListener;
import org.biolegato.core.main.BLMain;

public class SeqDoc
implements SequenceListener,
Transferable {
    private final LinkedList<Sequence> lines = new LinkedList();
    private final LinkedList<SeqDocListener> listeners = new LinkedList();
    public static final DataFlavor seqDocFlavour = new DataFlavor(SeqDoc.class, "BioLegato sequence document");

    public SeqDoc() {
    }

    public SeqDoc(Sequence[] sequenceList) {
        for (Sequence seq : sequenceList) {
            this.addSequence(this.getLineCount(), seq);
        }
    }

    public boolean insert(int x, int y, String string) {
        return this.lines.get(y).insertField("sequence", x, string);
    }

    public boolean insert(int x, int y, Sequence[] sequences) {
        Object split = null;
        String splitStr = "";
        boolean result = false;
        if (sequences != null && sequences.length > 0 && y >= 0 && (y <= this.getLineCount() || this.getLineCount() <= 0)) {
            for (int count = 0; count < sequences.length; ++count) {
                result = count + y < this.getLineCount() ? this.insert(x, y + count, sequences[count].get("sequence").toString()) | result : this.addSequence(this.getLineCount(), sequences[count]) | result;
            }
        } else if (sequences == null || sequences.length <= 0) {
            BLMain.error("Invalid sequence parameter", "SeqDoc.insert(int, Sequence[])");
        } else if (y < 0 || y > this.getLineCount()) {
            BLMain.error("Invalid Y-offset", "SeqDoc.insert(int, Sequence[])");
        }
        return result;
    }

    public boolean delete(int x, int y, int w) {
        String data = this.getLineText(y);
        if (x >= 0 && x < data.length()) {
            data = x + w >= data.length() ? data.substring(0, x) : data.substring(0, x) + data.substring(x + w);
            this.lines.get(y).put("sequence", (Object)data);
        }
        return true;
    }

    public boolean delete(int x, int y, int w, int h) {
        String data = "";
        boolean result = false;
        if (!this.lines.isEmpty() && this.getLineCount() > 0 && y >= 0 && y + h < this.getLineCount() && x >= 0) {
            for (int count = 0; count <= h; ++count) {
                result |= this.delete(x, y + count, w);
            }
        }
        return result;
    }

    public boolean addSequence(int y, Sequence seq) {
        this.lines.add(y, seq);
        seq.addListener(this);
        for (SeqDocListener listener : this.listeners) {
            listener.sequenceAdded(this, y, seq);
        }
        return true;
    }

    public boolean removeSequence(int lineNumber) {
        boolean result = false;
        if (this.getLineCount() > lineNumber && lineNumber >= 0) {
            Sequence removed = this.lines.remove(lineNumber);
            String text = removed.get("sequence").toString();
            int length = text.length();
            removed.removeListener(this);
            for (SeqDocListener listener : this.listeners) {
                listener.sequenceRemoved(this, lineNumber, removed);
            }
            result = true;
        }
        return result;
    }

    public void removeSequences(int[] lineNumbers) {
        Arrays.sort(lineNumbers);
        if (!this.lines.isEmpty()) {
            for (int count = lineNumbers.length - 1; count >= 0; --count) {
                this.removeSequence(lineNumbers[count]);
            }
        }
    }

    public Sequence getLine(int y) {
        return y >= 0 && y < this.getLineCount() ? this.lines.get(y) : null;
    }

    private String getLineText(int y) {
        Sequence line = this.getLine(y);
        return line != null ? line.get("sequence").toString() : "";
    }

    public int getLineLength(int y) {
        return this.getLineText(y).length();
    }

    public int getLineCount() {
        return this.lines.size();
    }

    public int getLongestLine() {
        int lineLength = 0;
        for (int count = 0; count < this.getLineCount(); ++count) {
            lineLength = Math.max(lineLength, this.getLineLength(count));
        }
        return lineLength;
    }

    public int indexOf(Sequence seq) {
        return this.lines.indexOf(seq);
    }

    public void addListener(SeqDocListener listener) {
        this.listeners.add(listener);
    }

    public void sequenceChanged(Sequence sequence, String key) {
        for (SeqDocListener listener : this.listeners) {
            listener.sequenceChanged(this, this.lines.indexOf(sequence), sequence, key);
        }
    }

    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{seqDocFlavour, DataFlavor.stringFlavor};
    }

    public boolean isDataFlavorSupported(DataFlavor flavour) {
        boolean result = false;
        DataFlavor[] test = this.getTransferDataFlavors();
        for (int count = 0; count < test.length && !result; ++count) {
            result = flavour.equals(test[count]);
        }
        return result;
    }

    public Object getTransferData(DataFlavor flavour) throws UnsupportedFlavorException, IOException {
        Object result = this;
        if (!this.isDataFlavorSupported(flavour)) {
            throw new UnsupportedFlavorException(flavour);
        }
        if (DataFlavor.stringFlavor.equals(flavour)) {
            result = this.toString();
        }
        return result;
    }

    public String toString() {
        String result = "";
        for (Sequence seq : this.lines) {
            if (!result.equals("")) {
                result = result + "\n";
            }
            result = result + seq.get("sequence");
        }
        return result;
    }

    public Sequence[] toArray() {
        return this.lines.toArray(new Sequence[0]);
    }

    protected void finalize() {
        for (Sequence seq : this.lines) {
            seq.removeListener(this);
        }
        this.lines.clear();
    }
}

