/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.core.data.sequence;

import java.awt.datatransfer.DataFlavor;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import org.biolegato.core.data.sequence.SequenceListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sequence
extends Hashtable<String, Object>
implements Cloneable {
    private final LinkedList<SequenceListener> listeners = new LinkedList();
    private static int maxGroup = 1;
    public static final DataFlavor sequenceFlavour = new DataFlavor(Sequence.class, "Raw BioLegato sequence");
    private static final Hashtable<Integer, LinkedList<Sequence>> group2seq = new Hashtable();
    private static final Hashtable<String, Object> defaults = new Hashtable<String, Object>(){
        private static final long serialVersionUID = 7526472295622777006L;
        {
            super.put("name", "New Sequence");
            super.put("direction", Direction.FROM5TO3);
            super.put("strandedness", Strandedness.SINGLE);
            super.put("topology", Topology.LINEAR);
            super.put("type", Type.DNA);
            super.put("protect_align", Boolean.FALSE);
            super.put("protect_ambig", Boolean.TRUE);
            super.put("protect_unambig", Boolean.TRUE);
        }
    };
    private static final long serialVersionUID = 7526472295622777024L;

    public Sequence() {
        this("");
    }

    public Sequence(String string) {
        if (string != null) {
            this.put("sequence", (Object)string);
        }
        this.detectType();
        super.put("modified", Boolean.FALSE);
    }

    public Sequence(Map<String, Object> data) {
        this(data.containsKey("sequence") ? data.get("sequence").toString() : "");
        for (String key : data.keySet()) {
            this.put(key, data.get(key));
        }
        super.put("modified", Boolean.FALSE);
    }

    public void addListener(SequenceListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(SequenceListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Object get(Object key) {
        String skey = key.toString().toLowerCase();
        return this.containsKey(skey) ? super.get(skey) : Sequence.getDefault(skey);
    }

    @Override
    public Object put(String key, Object value) {
        if (key == null) {
            throw new NullPointerException("Cannot call Sequence.setField(" + key + "," + value + ")");
        }
        if (value == null) {
            value = Sequence.getDefault(key);
        }
        key = key.toLowerCase();
        super.put("modified", Boolean.TRUE);
        super.put(key, value);
        for (SequenceListener listener : this.listeners) {
            listener.sequenceChanged(this, key);
        }
        return value;
    }

    public boolean insertField(String field, int column, String string) {
        String current = this.get(field).toString();
        if (column > 0 && column < current.length()) {
            this.put(field, (Object)(current.substring(0, column) + string + current.substring(column)));
        } else if (column >= current.length()) {
            this.put(field, (Object)(current + string));
        } else {
            this.put(field, (Object)(string + current));
        }
        return true;
    }

    public static Object getDefault(String key) {
        return defaults.containsKey(key = key.toLowerCase()) ? defaults.get(key) : "";
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer("--- SEQUENCE DATA ---");
        for (String key : this.keySet()) {
            result.append("\t" + key + "=" + this.get(key) + "\n");
        }
        return result.toString();
    }

    public Sequence subseq(int start) {
        Sequence split = (Sequence)this.clone();
        if (start <= split.get("sequence").toString().length()) {
            split.put("sequence", (Object)split.get("sequence").toString().substring(start));
        } else {
            split.put("sequence", (Object)"");
        }
        return split;
    }

    public Sequence subseq(int start, int end) {
        int length = end - start;
        Sequence split = this.subseq(start);
        if (length >= 0 && length <= split.get("sequence").toString().length()) {
            split.put("sequence", (Object)split.get("sequence").toString().substring(0, length));
        }
        return split;
    }

    @Override
    public Object clone() {
        return new Sequence(this);
    }

    private void detectType() {
        Type result = Type.DNA;
        if (this.containsKey("sequence")) {
            String data = this.get("sequence").toString().toUpperCase().trim();
            if (data.indexOf(85) >= 0) {
                result = Type.RNA;
            } else if (data.indexOf(70) >= 0 || data.indexOf(69) >= 0 || data.indexOf(74) >= 0 || data.indexOf(76) >= 0 || data.indexOf(79) >= 0 || data.indexOf(81) >= 0 || data.indexOf(88) >= 0 || data.indexOf(90) >= 0) {
                result = Type.PROTEIN;
            }
            this.put("type", (Object)result);
        }
    }

    public CharacterClass charType(char test) {
        CharacterClass type = CharacterClass.ALIGNMENT;
        if (Type.DNA.equals(this.get("type")) || Type.RNA.equals(this.get("type"))) {
            switch (test) {
                case 'B': 
                case 'D': 
                case 'H': 
                case 'I': 
                case 'K': 
                case 'M': 
                case 'N': 
                case 'R': 
                case 'S': 
                case 'V': 
                case 'W': 
                case 'Y': 
                case 'b': 
                case 'd': 
                case 'h': 
                case 'i': 
                case 'k': 
                case 'm': 
                case 'n': 
                case 'r': 
                case 's': 
                case 'v': 
                case 'w': 
                case 'y': {
                    type = CharacterClass.AMBIGUOUS;
                    break;
                }
                case 'A': 
                case 'C': 
                case 'G': 
                case 'T': 
                case 'U': 
                case 'a': 
                case 'c': 
                case 'g': 
                case 't': 
                case 'u': {
                    type = CharacterClass.UNAMBIGUOUS;
                    break;
                }
                default: {
                    type = CharacterClass.ALIGNMENT;
                    break;
                }
            }
        } else if (Type.PROTEIN.equals(this.get("type"))) {
            switch (test) {
                case '*': 
                case 'B': 
                case 'X': 
                case 'Z': 
                case 'b': 
                case 'x': 
                case 'z': {
                    type = CharacterClass.AMBIGUOUS;
                    break;
                }
                case 'A': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'V': 
                case 'W': 
                case 'Y': 
                case 'a': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'v': 
                case 'w': 
                case 'y': {
                    type = CharacterClass.UNAMBIGUOUS;
                    break;
                }
                default: {
                    type = CharacterClass.ALIGNMENT;
                }
            }
        }
        return type;
    }

    public static void group(Sequence[] sequences) {
        LinkedList<Sequence> add = new LinkedList<Sequence>();
        for (Sequence seq : sequences) {
            Sequence.ungroup(new Sequence[]{seq});
            seq.put("group", (Object)new Integer(maxGroup));
            add.add(seq);
        }
        group2seq.put(new Integer(maxGroup), add);
        ++maxGroup;
    }

    public static void ungroup(Sequence[] sequences) {
        for (Sequence seq : sequences) {
            if (!(seq.get("group") instanceof Integer)) continue;
            Integer groupNumber = (Integer)seq.get("group");
            LinkedList<Sequence> group = Sequence.getgroup(groupNumber);
            group.remove(seq);
            if (group.isEmpty()) {
                while (maxGroup > 1 && maxGroup < group2seq.size() && group2seq.get(maxGroup - 1).isEmpty()) {
                    --maxGroup;
                }
                group2seq.remove(groupNumber);
            }
            seq.put("group", (Object)null);
        }
    }

    public static LinkedList<Sequence> getgroup(Integer groupNumber) {
        LinkedList<Sequence> group = null;
        group = groupNumber != null && group2seq.containsKey(groupNumber) ? group2seq.get(groupNumber) : new LinkedList<Sequence>();
        return group;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CharacterClass {
        ALIGNMENT,
        AMBIGUOUS,
        UNAMBIGUOUS;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Strandedness {
        SINGLE{

            public String toString() {
                return "Single stranded";
            }
        }
        ,
        DOUBLE{

            public String toString() {
                return "Double stranded";
            }
        }
        ,
        MIXED{

            public String toString() {
                return "Mixed strandedness";
            }
        };

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Topology {
        LINEAR{

            public String toString() {
                return "Linear";
            }
        }
        ,
        CIRCULAR{

            public String toString() {
                return "Circular";
            }
        };

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        FROM3TO5{

            public String toString() {
                return "From 3' to 5'";
            }
        }
        ,
        FROM5TO3{

            public String toString() {
                return "From 5' to 3'";
            }
        };

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        DNA{

            public String toString() {
                return "DNA";
            }
        }
        ,
        RNA{

            public String toString() {
                return "RNA";
            }
        }
        ,
        PROTEIN{

            public String toString() {
                return "Protein";
            }
        }
        ,
        MASK{

            public String toString() {
                return "Colour mask";
            }
        }
        ,
        TEXT{

            public String toString() {
                return "Text";
            }
        };

    }
}

