package embl.ebi.trace;

import java.io.*;
/**
A useful set of routines for handling tagged records as found in
ABI format DNA sequence trace files.
@see ABIChromatogram
*/

public class TaggedRecord {
	
	private String tagName;
	private int tagNum, eNum, arrayLength, dataRecord, cryptic;
	private short dataType, eLength;
	private char[] tagArray;
	
	public TaggedRecord() {}
	public TaggedRecord(DataInput IN) throws IOException {
		read(IN);
}
	public void read(DataInput filterIN) throws IOException {
		int i;
		char[] tagArray = new char[4];
		for (i=0;i<4;i++) {
		tagArray[i] += (char) (filterIN.readUnsignedByte());
	}
		tagName = new String(tagArray);
		tagNum = filterIN.readInt();
		dataType = filterIN.readShort();
		eLength = filterIN.readShort();
		eNum = filterIN.readInt();
		arrayLength = filterIN.readInt();
		dataRecord = filterIN.readInt();
		cryptic = filterIN.readInt();
		
	}
	public String getTagName() {
		return tagName;
	}
	public int getTagNum() {
		return tagNum;
	}
	public short getDataType() {
		return dataType;
	}
	public int getElementLength() {
		return eLength;
	}
	public int getElementNumber() {
		return eNum;
	}
	public int getArrayLength() {
		return arrayLength;
	}
	public int getDataRecord() {
		return dataRecord;
	}
 
}
