package nsdb;


/**
* nsdb/NucFeatureWriterOperations.java .
* Generated by the IDL-to-Java compiler (portable), version "3.1"
* from corba/nsdb_write.idl
* Tuesday, March 7, 2006 12:49:18 PM GMT
*/

public interface NucFeatureWriterOperations  extends nsdb.NucFeatureOperations
{

  /**
       * Set the key, location and qualifiers of this NucFeature
       * @parm key The new feature key
       * @parm location The new feature location
       * @raises InvalidKey if the given key is not a possible EMBL key.
       * @raises LocationParse If the location string is not a valid location.
       * @raises type::IndexOutOfRange If any part of the location is out
       *   of range for the sequence.
       * @raises type::InvalidRelation if one of the qualifiers in this
       *   feature cannot be associated with the given feature key.
       * @raises QualifierParse if the format of any the qualifiers is not
       *   appropriate for a Qualifier with the given name.  For
       *   example the value part of /codon_start qualifier must be a number: 1,
       *   2 or 3.  Also thrown if a qualifier has value when it should not or
       *   vice versa.
       * @raises InvalidQualifier if the name of the Qualifier is not a
       *   valid embl qualifier name.
       * @raises ReadOnlyException If this Feature cannot be changed.
       * @raises OutOfDate If the key has changed since the time given by
       *   datestamp.
       */
  void set (nsdb.Datestamp datestamp, String key, String location, nsdb.NucFeaturePackage.Qualifier[] qualifier_list) throws nsdb.InvalidKey, nsdb.LocationParse, type.IndexOutOfRange, type.InvalidRelation, nsdb.QualifierParse, nsdb.InvalidQualifier, nsdb.OutOfDate, nsdb.ReadOnlyException;

  /**
       * Set the key of this NucFeature
       * @parm key The new feature key
       * @raises InvalidKey if the given key is not a possible EMBL key.
       * @raises type::InvalidRelation if one of the qualifiers in this
       *   feature cannot be associated with the given feature key.
       * @raises OutOfDate If the key has changed since the time given by
       *   datestamp.
       */
  void setKey (nsdb.Datestamp datestamp, String key) throws nsdb.InvalidKey, type.InvalidRelation, nsdb.OutOfDate, nsdb.ReadOnlyException;

  /**
       * Set the location of this NucFeature
       * @parm location The new feature location
       * @raises LocationParse If the location string is not a valid location.
       * @raises type::IndexOutOfRange If any part of the location is out
       *   of range for the sequence.
       * @raises OutOfDate If the location has changed since the time given by
       *   datestamp.
       */
  void setLocation (nsdb.Datestamp datestamp, String location) throws nsdb.LocationParse, type.IndexOutOfRange, nsdb.OutOfDate, nsdb.ReadOnlyException;

  /**
       * Set the qualifiers of this feature, replacing the current qualifiers.
       * @raises InvalidRelationException if this Feature cannot
       *   contain one of the given qualifiers.
       * @raises QualifierParse if the format of any the qualifiers is not
       *   appropriate for a Qualifier with the given name.  For
       *   example the value part of /codon_start qualifier must be a number: 1,
       *   2 or 3.  Also thrown if a qualifier has value when it should not or
       *   vice versa.
       * @raises InvalidQualifier if the name of the Qualifier is not a
       *   valid embl qualifier name.
       * @raises OutOfDate if any of the qualifiers has changed since the time
       *   given by datestamp.
       */
  void setQualifiers (nsdb.Datestamp datestamp, nsdb.NucFeaturePackage.Qualifier[] qualifier_list) throws type.InvalidRelation, nsdb.QualifierParse, nsdb.InvalidQualifier, nsdb.OutOfDate, nsdb.ReadOnlyException;

  /**
       * Add the given Qualifier to this Feature.  If this Feature contains a
       * Qualifier with the same name as the new Qualifier it will be replaced.
       * @parm qualifier The new qualifier to add.
       * @raises InvalidRelationException if this Feature cannot
       *   contain the given Qualifier.
       * @raises QualifierParse if the format of the qualifier is not
       *   appropriate for a Qualifier with the given name.  For
       *   example the value part of /codon_start qualifier must be a number: 1,
       *   2 or 3.  Also thrown if a qualifier has value when it should not or
       *   vice versa.
       * @raises InvalidQualifier if the name of the Qualifier is not a
       *   valid embl qualifier name.
       * @raises OutOfDate if there is a an existing qualifier with the same
       *   name as the argument qualifier and it has changed since the time
       *   given by datestamp.
       */
  void setQualifier (nsdb.Datestamp datestamp, nsdb.NucFeaturePackage.Qualifier qualifier) throws type.InvalidRelation, nsdb.QualifierParse, nsdb.InvalidQualifier, nsdb.OutOfDate, nsdb.ReadOnlyException;

  /**
       * Remove the Qualifier with the given name.  If there is no Qualifier
       * with that name, then return immediately.
       * @parm name The Qualifier name to look for.
       * @raises OutOfDate if there is a an existing qualifier with the same
       *   name as the argument name and it has changed since the time given by
       *   the datestamp.
       */
  void removeQualiferByName (nsdb.Datestamp datestamp, String name) throws type.InvalidRelation, nsdb.OutOfDate, nsdb.ReadOnlyException;

  /**
       * Return a Datestamp that will be passed to the set methods on the
       * EmblSeqWriter methods and NucFeatureWriter methods.  The object that is
       * returned represents the time when the feature was last changed (the
       * last time the key, location or qualifiers changed).
       */
  nsdb.Datestamp getDatestamp ();
} // interface NucFeatureWriterOperations
