/* RangeVector.java
 *
 * created: Thu Oct 29 1998
 *
 * This file is part of Artemis
 * 
 * Copyright (C) 1998,1999,2000  Genome Research Limited
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Header: /cvsroot/pathsoft/artemis/uk/ac/sanger/artemis/io/RangeVector.java,v 1.2 2005/07/27 08:24:17 tjc Exp $
 */

package uk.ac.sanger.artemis.io;

import java.util.Vector;

/**
 *  This class implements a Vector of Range objects.
 *
 *  @author Kim Rutherford
 *  @version $Id: RangeVector.java,v 1.2 2005/07/27 08:24:17 tjc Exp $
 *
 **/

public class RangeVector extends Vector
{

  /**
   *  Create a new vector of Range objects.
   **/
  public RangeVector() 
  {
  }

  /**
   *  Create a new vector of Range objects containing just the given Range.
   **/
  public RangeVector(final Range range) 
  {
    add (range);
  }


  /**
  *  Reverse this RangeVector in place.
  **/
  public void reverse()
  {
    for(int i = 0 ; i < size () / 2 ; ++i) 
    {
      final int swap_position = size () - i - 1;
      final Object tmp = elementAt(i);
      setElementAt(elementAt(swap_position), i);
      setElementAt(tmp, swap_position);
    }
  }
  
}


