/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.biolegato.core.data.seqdoc.undo;

import org.biolegato.core.data.seqdoc.SeqDoc;

/**
 * This object is used to undo a deletion of text to a SeqDoc object.
 *
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class UndoDelete implements Undoable {

    /**
     * The line number the deletion ocurred
     */
    private int lineNumber;
    /**
     * The offset of the start of the insert.
     */
    private int offset;
    /**
     * The text deleted.
     */
    private String text;
    /**
     * The data container to associate the UndoInsert with.
     */
    private SeqDoc data;

    /**
     * Creates a new UndoDelete object for undoing text deletions.
     *
     * @param data the document to attach the object to.
     * @param offset the offset of the deletion.
     * @param text the text deleted.
     */
    public UndoDelete (SeqDoc data, int lineNumber, int offset, String text) {
        this.data = data;
        this.offset = offset;
        this.text = text;
        this.lineNumber = lineNumber;
    }

    /**
     * Undoes the text deletion.
     *
     * @return an redo event for the text deletion.
     */
    public Undoable undo () {
        // inserts the deleted text
        data.insert(lineNumber, offset, text);
        
        // returns an object for redoing the undone text deletion.
        return new UndoInsert(data, offset, text.length());
    }

}
