package org.biolegato.ezmenu.variables;

/*
 * BLTextField.java
 *
 * Created on June 16, 2008, 2:08 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.biolegato.core.main.BLMain;

/**
 * A wrapper class used to abstract text fields within command windows.
 *
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class GDEFileChooser extends GDEVariable implements ActionListener {

    /**
     * The current selected filename label (used for user feedback).
     */
    private JTextField currentFilenameLabel = new JTextField(20);
    /**
     * The window to obtain the canvas data from.
     */
    private BLMain window = null;
    /**
     * Stores the description of what the file to choose is used for.
     */
    private String description;

    /**
     * Creates a new instance of GDETempFile.
     *
     * @param data the data to create the temporary file variable with.
     */
    public GDEFileChooser (java.util.Map data) {
        super(data);

        if (data.containsKey("description")) {
            description = data.get("description").toString() + ":";
        }
        if (data.containsKey("window") && data.get("window") instanceof org.biolegato.core.main.BLMain) {
            window = ((org.biolegato.core.main.BLMain) data.get("window"));
        }
    }

    /**
     * Gets the current filename corresponding to this variable
     * If the file does not exists, then this function creates a file to
     * use for IO and writes any initial contents
     *
     * @return the filename to use for command line substitution.
     */
    public Object getValue () {
        return currentFilenameLabel.getText();
    }

    /**
     * Returns the type name
     * @return "tempfile"
     */
    public static String getType () {
        return "file_chooser";
    }

    /**
     * Used for displaying the plugin.
     *
     * @return the panel to display the plugin on.
     */
    @Override
    public java.awt.Container display () {
	JButton pickFile = new JButton("Choose file...");
        pickFile.addActionListener(this);


        Box databox = new Box(BoxLayout.LINE_AXIS);
        databox.add(new JLabel(description));
        databox.add(currentFilenameLabel);
        databox.add(pickFile);
        return databox;
    }

    /**
     * Handle the choose file button
     *
     * @param e ignored because there is only one widget calling this method.
     */
    public void actionPerformed (ActionEvent e) {
        JFileChooser openDialog = new JFileChooser();
        openDialog.setCurrentDirectory(new File(System.getProperty(
                "user.dir")));
        openDialog.setAcceptAllFileFilterUsed(true);
        
        // if a file is selected, open it
        if (openDialog.showOpenDialog(window) ==
            JFileChooser.APPROVE_OPTION &&
            openDialog.getSelectedFile() != null &&
            openDialog.getSelectedFile().exists() &&
            openDialog.getSelectedFile().isFile()) {
            currentFilenameLabel.setText(openDialog.getSelectedFile().getPath());
        }
    }

}
