package org.biolegato.ezmenu.variables;

/*
 * BLVariable.java
 *
 * Created on June 12, 2008, 3:26 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */
import org.biolegato.core.plugintypes.MenuType;
import org.biolegato.core.plugins.PluginLoader;
import org.biolegato.core.plugins.PluginWrapper;

/**
 * A superclass used to abstract variables for creating command windows.
 *
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public abstract class GDEVariable {

    /**
     * the name of the widget
     */
    private String name;

    /**
     * Creates a new instance of GDEVariable (used to add the name to the variable).
     *
     * @param data the data to construct the variable with
     */
    public GDEVariable (java.util.Map data) {
        if (data.containsKey("name")) {
            name = data.get("name").toString().trim();
        } else {
            org.biolegato.core.main.BLMain.error("Field is missing a variable name", "BLVariable constructor");
            name = "";
        }
    }

    /**
     * Returns the name of the variable.
     *
     * @return the name of the variable
     */
    public String getName () {
        return name;
    }

    /**
     * Returns the value of the variable.
     *
     * @return the value of the variable
     */
    public abstract Object getValue ();

    /**
     * Returns the name of this type of variable.
     *
     * @return the name of the variable type
     */
    public static String getType () {
        return "none";
    }

    /**
     * Used for displaying/initalizing the variable.
     *
     * @return the panel to display the variable on
     */
    public java.awt.Container display () {
        return null;
    }

    /**
     * Used to create BioLegato variables.
     *
     * @param data the data to create the variable with
     * @return the crated variable
     */
    public final static GDEVariable createVariable (java.util.Map data) {
        String type = null;
        GDEVariable result = null;

        if (data.containsKey("type")) {
            type = data.get("type").toString().trim();
            if ("slider".equalsIgnoreCase(type)) {
                result = new GDESlider(data);
            } else if ("choice_menu".equalsIgnoreCase(type)) {
                result = new GDEComboBox(data);
            } else if ("choice_list".equalsIgnoreCase(type)) {
                org.biolegato.core.main.BLMain.warning("Using deprecated menu widget \"choice_list\"");
                result = new GDEChoiceList(data);
            } else if ("chooser".equalsIgnoreCase(type)) {
                result = new GDEChooser(data);
            } else if ("text".equalsIgnoreCase(type)) {
                result = new GDETextField(data);
            } else if ("file_chooser".equalsIgnoreCase(type)) {
                result = new GDEFileChooser(data);
            } else if (type != null) {
                for (PluginWrapper plugin : PluginLoader.getPlugins(GDEVariable.class)) {
                    if (type.equalsIgnoreCase("" + plugin.smethod("getType"))) {
                        result = (GDEVariable) plugin.create(new Class[] {java.util.Map.class}, new Object[] {data});
                    }
                }
            }
        }
        if (result == null) {
            org.biolegato.core.main.BLMain.error("Invalid variable type: " + type + " (check your plugin directory, properties file, and menu files for possible errors)", MenuType.class.getCanonicalName() + ".createVariable");
            result = new GDEVariable(data) {

                public Object getValue () {
                    return "";
                }

            };
        }
        return result;
    }

}
