/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.biolegato.gdesupport.canvas.colour;

import org.biolegato.gdesupport.canvas.BLTextArea;
import java.awt.Color;
import java.awt.Graphics;
import org.biolegato.core.data.sequence.Sequence;

/**
 * A colour map class that will give support for GDE style colour schemes
 *
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class GDECharColourMap extends MonochromeColourMap {

    /**
     * Creates a new instance of GDECharColourMap
     */
    public GDECharColourMap() {
    }

    /**
     * Draws a sequence mapping the appropriate colours to each character rendered
     *
     * @param ta the textarea to use for obtaining metrics from.
     * @param gfx the graphics object to draw the string to.
     * @param xstart the x co-ordinate to start drawing from.
     * @param ystart the y co-ordinate to start drawing from.
     * @param seq the sequence to draw.
     */
    @Override
    public void regularDrawString(BLTextArea ta, Graphics gfx, int xstart, int ystart, Sequence seq) {
        char[] stringArray = seq.getField("sequence").toString().toCharArray();
        Color fgCurrent = foreground;

        if (seq.getField("mask") instanceof ColourMap) {
            ((ColourMap)seq.getField("mask")).regularDrawString(ta, gfx, xstart, ystart, seq);
        } else {
            for (char character : stringArray) {
                if (Sequence.Type.DNA.equals(seq.getField("type")) || Sequence.Type.RNA.equals(seq.getField("type"))) {
                    switch (character) {
                        case 'A': case 'a':
                            fgCurrent = colour1;
                            break;
                        case 'B': case 'D': case 'H': case 'I': case 'K': case 'N': case 'M': case 'R': case 'S': case 'V': case 'W': case 'Y':
                        case 'b': case 'd': case 'h': case 'i': case 'k': case 'n': case 'm': case 'r': case 's': case 'v': case 'w': case 'y':
                            fgCurrent = colour2;
                            break;
                        case 'C': case 'c':
                            fgCurrent = colour3;
                            break;
                        case 'G': case 'g':
                            fgCurrent = colour4;
                            break;
                        case 'T': case 't': case 'U': case 'u':
                            fgCurrent = colour5;
                            break;
                        case 'X':
                            character = 'N';
                            fgCurrent = colour2;
                            break;
                        case 'x':
                            character = 'n';
                            fgCurrent = colour2;
                            break;
                        default:
                            character = '-';
                            fgCurrent = neutralColour;
                            break;
                    }
                } else if (Sequence.Type.PROTEIN.equals(seq.getField("type"))) {
                    switch (character) {
                        case 'A': case 'G': case 'O': case 'P': case 'S': case 'T':
                        case 'a': case 'g': case 'o': case 'p': case 's': case 't':
                            fgCurrent = colour6;
                            break;
                        case 'B': case 'D': case 'E': case 'N': case 'Q': case 'Z':
                        case 'b': case 'd': case 'e': case 'n': case 'q': case 'z':
                            fgCurrent = colour4;
                            break;
                        case 'C': case 'c':
                            fgCurrent = colour1;
                            break;
                        case 'F': case 'W': case 'Y':
                        case 'f': case 'w': case 'y':
                            fgCurrent = colour3;
                            break;
                        case 'H': case 'K': case 'R':
                        case 'h': case 'k': case 'r':
                            fgCurrent = colour7;
                            break;
			case 'I': case 'J': case 'L': case 'M': case 'V':
                        case 'i': case 'j': case 'l': case 'm': case 'v':
                            fgCurrent = colour5;
                            break;
                        case 'X': case '*': case 'x':
                            fgCurrent = colour2;
                            break;
                        default:
                            fgCurrent = neutralColour;
                            break;
                    }
                } else {
                    fgCurrent = foreground;
                }
                drawString(ta, gfx, xstart, ystart, "" + character, fgCurrent, background);
                xstart += ta.columnSize();
            }
        }
    }
}
