/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.biolegato.gdesupport.canvas.colour;

import org.biolegato.gdesupport.canvas.BLTextArea;
import java.awt.Color;
import java.awt.Graphics;
import org.biolegato.core.data.sequence.Sequence;

/**
 * A colour map class that will give support for GDE colour masks
 * 
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class PositionColourMap extends ColourMap {
    /**
     * The array of colours corresponding to positions for the mask.
     */
    private Color[] colourArray = new Color[0];
    /**
     * Whether or not to skip over dashes when applying the colour mask.
     */
    private boolean skipdash = false;

    /**
     * Creates a new instance of GDEColourMaskMap.
     *
     * @param name the name of the colour mask.
     * @param colourArray the array of colour selections to use for the mask.
     * @param skipdash whether or not to skip over dashes when applying the colour mask.
     */
    public PositionColourMap (String name, Color[] colourArray, boolean skipdash) {
        this.colourArray = colourArray;
        this.skipdash = skipdash;
        setName(name);
    }

    /**
     * Draws a sequence mapping the appropriate colours to each character rendered
     *
     * @param ta the textarea to use for obtaining metrics from.
     * @param gfx the graphics object to draw the string to.
     * @param xstart the x co-ordinate to start drawing from.
     * @param ystart the y co-ordinate to start drawing from.
     * @param seq the sequence to draw.
     */
    @Override
    public void regularDrawString(BLTextArea ta, Graphics gfx, int xstart, int ystart, Sequence seq) {
        int count = 0;
        char[] stringArray = seq.getField("sequence").toString().toCharArray();

        for (count = 0; count < stringArray.length; count++) {
            if ((!skipdash || seq.charType(stringArray[count]) != Sequence.CharacterClass.ALIGNMENT) && count < colourArray.length) {
                drawString(ta, gfx, xstart, ystart, "" + stringArray[count], colourArray[count], background);
            } else {
                drawString(ta, gfx, xstart, ystart, "" + stringArray[count], foreground, background);
            }
            xstart += ta.columnSize();
        }
    }
}
