package org.biolegato.gdesupport.canvas.colourmask;

import org.biolegato.gdesupport.canvas.colour.*;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.LinkedList;
import org.biolegato.core.main.BLMain;
import org.biolegato.gdesupport.canvas.colour.PositionColourMap;

/**
 * Used to select colour masks.
 *
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class GDEColourMaskFile extends ColourMaskReader {
    /**
     * Creates a new instance of GDEColourMaskFile
     */
    public GDEColourMaskFile() {
    }

    /**
     * Reads and parses a colour mask file.
     *
     * @param file the file to read.
     * @return an array of colour masks defined by the file.
     */
    public ColourMap[] readColourMapFile(File file) {
	int number = 1;
	int length = 0;
	Color addColour = null;
	String name = "";
	boolean stopSequence = false;
	boolean nodash = false;
	BufferedReader reader = null;
	PositionColourMap mask = null;
	LinkedList<Color> colourList = new LinkedList<Color>();
	LinkedList<ColourMap> colourMapList = new LinkedList<ColourMap>();
	String line = "";
	
	if (file != null && file.exists() && file.isFile()) {
	    try {
		reader = new BufferedReader(new FileReader(file.getPath()));
		do {
		    line = reader.readLine();
		    if (line != null) {
			line = line.trim().toLowerCase();
			if (line.startsWith("name:")) {
			    name = line.substring(line.indexOf("name:") + 5);
			} else if (line.startsWith("length:")) {
			    try {
				length = Integer.parseInt(line.substring(line.indexOf("length:") + 7));
			    } catch (Throwable nfe) {
				nfe.printStackTrace();
			    }
			} else if (line.startsWith("nodash:")) {
			    nodash = true;
			} else if (!"".equals(name) && line.toLowerCase().startsWith("start:")) {
			    stopSequence = false;
			    while (!stopSequence && length > 0 && line != null) {
				line = reader.readLine();
				addColour = null;
				if (line != null) {
				    line = line.trim().toLowerCase();
				    if ("1".equals(line)) {
					addColour = ColourMap.colour1;
				    } else if ("2".equals(line)) {
					addColour = ColourMap.colour2;
				    } else if ("3".equals(line)) {
					addColour = ColourMap.colour3;
				    } else if ("4".equals(line)) {
					addColour = ColourMap.colour4;
				    } else if ("5".equals(line)) {
					addColour = ColourMap.colour5;
				    } else if ("6".equals(line)) {
					addColour = ColourMap.colour6;
				    } else if ("7".equals(line)) {
					addColour = ColourMap.colour7;
				    } else if ("8".equals(line)) {
					addColour = ColourMap.colour8;
				    } else if ("9".equals(line)) {
					addColour = ColourMap.colour9;
				    } else if ("10".equals(line)) {
					addColour = ColourMap.colour10;
				    } else if ("11".equals(line)) {
					addColour = ColourMap.colour11;
				    } else if ("12".equals(line)) {
					addColour = ColourMap.colour12;
				    } else if ("13".equals(line)) {
					addColour = ColourMap.colour13;
				    } else if ("14".equals(line)) {
					addColour = ColourMap.colour14;
				    } else if ("15".equals(line)) {
					addColour = ColourMap.colour15;
				    } else if (line.toLowerCase().startsWith("name:") || line.toLowerCase().startsWith("length:")
				    || line.toLowerCase().startsWith("nodash:") || line.toLowerCase().startsWith("start:")) {
					stopSequence = true;
				    }
				    if (addColour != null) {
					colourList.add(addColour);
					length--;
				    }
				}
			    }
			    if (length != 0) {
				BLMain.error("Reached end of file before end of colour", "GDEColourMaskColourMap");
			    }
			    // handle duplicae names
			    number = 1;
			    mask = new PositionColourMap(name, colourList.toArray(new Color[0]), nodash);
			    
			    // add the map to the list
			    colourMapList.add(mask);
			    colourList.clear();
			    
			    // reset values for next pass
			    nodash = false;
			    name = "";
			} else if ("".equals(name) && line.toLowerCase().startsWith("start:")) {
			    BLMain.error("Unnamed colour mask", "GDEColourMaskColourMap");
			}
		    }
		} while (line != null);
	    } catch (Throwable exception) {
		exception.printStackTrace();
	    }
	} else {
	    BLMain.error("Invalid colour map file", "GDEColourMaskColourMap");
	}
	
	return colourMapList.toArray(new ColourMap[0]);
    }

    @Override
    public boolean accept (File f) {
        return true;
    }

    @Override
    public String getDescription () {
        return "GDE colour mask file";
    }
   
}