/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.biolegato.gdesupport.canvas.colourmask;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import org.biolegato.gdesupport.canvas.colour.ColourMap;

/**
 * The menu item to handle importing colour masks
 *
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class ImportFileAction extends Box implements ActionListener {
    /**
     * The window to associate the import with.
     */
    private JDialog window;
    /**
     * The combobox to use for selecting imported colour masks from.
     */
    private JComboBox combobox;
    /**
     * The list of all colour masks loaded in the system.
     */
    protected static Hashtable<String, ColourMap> colourMasks = new Hashtable<String, ColourMap>();
    /**
     * Used for serialization purposes.
     */
    private static final long serialVersionUID = 7526472295622777037L;

    /**
     * Creates a new ImportFileAction object.
     *
     * @param window the window to associate the import with.
     * @param defaultMask the default mask for the combobox.
     */
    public ImportFileAction(JDialog window, final Object defaultMask) {
	super(BoxLayout.LINE_AXIS);

        // set class parameters
	this.combobox = new JComboBox(colourMasks.keySet().toArray());
        this.window = window;

        // add the currently loaded masks combobox
        this.combobox.setSelectedItem(defaultMask);
	add(this.combobox);

        // add the import file button
        JButton importButton = new JButton("Import file...");
        importButton.addActionListener(this);
	add(importButton);
    }

    /**
     * Performs all of the import file functionality.
     *
     * @param e is ignored by this function.
     */
    public void actionPerformed (ActionEvent e) {
        int number = 0;                                 // number to append to duplicate masks
        JFileChooser openDialog = new JFileChooser();   // the JFileChooser for selecting the file to import.
        ColourMap[] importMasks = null;                 // the colour masks that were imported.

        // set the parameters for the open file dialog box
        openDialog.setCurrentDirectory(new File(System.getProperty("user.dir")));
        openDialog.setAcceptAllFileFilterUsed(true);

        // if a file is selected, open it
        if (openDialog.showOpenDialog(window) == JFileChooser.APPROVE_OPTION && openDialog.getSelectedFile() != null
                && openDialog.getSelectedFile().exists() && openDialog.getSelectedFile().isFile()) {
            if (openDialog.getFileFilter() != null && openDialog.getFileFilter() instanceof ColourMaskReader) {
                importMasks = ((ColourMaskReader)openDialog.getFileFilter()).readColourMapFile(openDialog.getSelectedFile());
            }
            for (ColourMap mask : importMasks) {
                if (colourMasks.contains(mask.getName())) {
                    while (colourMasks.contains(mask.getName() + " (" + number + ")")) {
                        number++;
                    }
                    mask.setName(mask.getName() + " (" + number + ")");
                }
                combobox.addItem(mask.getName());
                colourMasks.put(mask.getName(), mask);
            }
        }
    }

    /**
     * Returns the current selected colour mask for the sequence.
     *
     * @return the currently selected colour mask for the sequence.
     */
    public Object getSelectedItem() {
	return combobox.getSelectedItem();
    }
}
