/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.biolegato.gdesupport.canvas.selections;

/**
 * Used to store information about the curent text selected for a given line
 * in a document.
 * 
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class LineSelection {

    /**
     * The start position of the line selected
     */
    private int start;
    /**
     * The end position of the line selected
     */
    private int end;

    /**
     * Creates a new instance of LineSelection.
     *
     * @param start the start point of the line selection
     * @param end the end point of the line selection
     */
    public LineSelection (int start, int end) {
        this.start = start;
        this.end = end;
    }

    /**
     * Obtain the start point of the selection
     * NOTE: this is the minimum of start and end
     *
     * @return the start position of the line's selection
     */
    public int getStart () {
        return Math.min(start, end);
    }

    /**
     * Obtain the start point of the selection
     * NOTE: this is the maximum of start and end
     *
     * @return the start position of the line's selection
     */
    public int getEnd () {
        return Math.max(start, end);
    }

    /**
     * Tests for an empty selection.
     *
     * @return true if the selection is empty
     */
    public boolean isEmpty () {
        return (start == end);
    }

}
