/*
 * SelectionListener.java
 *
 * Created on June 26, 2009, 1:03 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.biolegato.gdesupport.canvas.selections;

/**
 * Communicates changes to a selection object.
 *
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public interface SelectionListener {
    
    /**
     * Notifies a listener that the selection start has been moved.
     *
     * @param oldx the old X co-ordinate to start the selection from.
     * @param oldy the old Y co-ordinate to start the selection from.
     * @param newx the new X co-ordinate the selection has been moved to.
     * @param newy the new Y co-ordinate the selection has been moved to.
     */
    public void selectionMoved(int oldx, int oldy, int newx, int newy);
    
    /**
     * Notifies a listener that the selection stretched.
     *
     * @param oldx the old X co-ordinate the selection was stretched to.
     * @param oldy the old Y co-ordinate the selection was stretched to.
     * @param newx the new X co-ordinate the selection has been stretched to.
     * @param newy the new Y co-ordinate the selection has been stretched to.
     */
    public void selectionStretched(int oldx, int oldy, int newx, int newy);
}
