/*
 * SequenceListener.java
 *
 * Created on June 9, 2009, 2:52 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.biolegato.core.data.sequence;

import org.biolegato.core.data.seqdoc.*;

/**
 * This listener received change events from sequences.
 * <p>A change event occurs when a field within a Sequence object is modified.</p>
 *
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public interface SequenceListener {
    /**
     * This method is called when a field in a sequence is modified.
     *
     * @param sequence the sequence which was modified.
     * @param key the key of the modified field within the sequence.
     */
    public void sequenceChanged(Sequence sequence, String key);
}
