/*
 * UndoChangePosition.java
 *
 * Created on February 1, 2010, 2:08 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.biolegato.gdesupport.canvas.undo;

import org.biolegato.gdesupport.canvas.textarea.BLTextArea;
import org.biolegato.gdesupport.canvas.textarea.GDETextArea;
import org.biolegato.gdesupport.canvas.textarea.UndoableGDETextArea;

/**
 * This object handles undoing caret position changes within a GDETextArea.
 *
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class UndoChangePosition implements Undoable {
    /**
     * The original X-coordinate of the caret
     */
    private int x;
    /**
     * The original Y-coordinate of the caret
     */
    private int y;
    /**
     * The source of the caret position change
     */
    private UndoableGDETextArea source;

    /** Creates a new instance of UndoChangePosition */
    public UndoChangePosition(final UndoableGDETextArea source, final int x, final int y) {
	this.x = x;
	this.y = y;
	this.source = source;
    }

    /**
     * Undoes the changing of caret position
     *
     * @return an object which can redo the undone operation.
     */
    public Undoable undo() {
	return source.uchangePosition(x, y);
    }

}
